# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from ._enums import *

__all__ = [
    'AutoNamingArgs',
    'CreateOnlyTagArgs',
    'ProviderAssumeRoleArgs',
    'ProviderDefaultTagsArgs',
    'ProviderEndpointArgs',
    'ProviderIgnoreTagsArgs',
    'TagArgs',
]

@pulumi.input_type
class AutoNamingArgs:
    def __init__(__self__, *,
                 max_length: Optional[pulumi.Input[int]] = None,
                 min_length: Optional[pulumi.Input[int]] = None,
                 property_name: Optional[pulumi.Input[str]] = None):
        """
        Auto-naming specification for the resource.
        :param pulumi.Input[int] max_length: The maximum length of the name.
        :param pulumi.Input[int] min_length: The minimum length of the name.
        :param pulumi.Input[str] property_name: The name of the property in the Cloud Control payload that is used to set the name of the resource.
        """
        if max_length is not None:
            pulumi.set(__self__, "max_length", max_length)
        if min_length is not None:
            pulumi.set(__self__, "min_length", min_length)
        if property_name is not None:
            pulumi.set(__self__, "property_name", property_name)

    @property
    @pulumi.getter(name="maxLength")
    def max_length(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum length of the name.
        """
        return pulumi.get(self, "max_length")

    @max_length.setter
    def max_length(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_length", value)

    @property
    @pulumi.getter(name="minLength")
    def min_length(self) -> Optional[pulumi.Input[int]]:
        """
        The minimum length of the name.
        """
        return pulumi.get(self, "min_length")

    @min_length.setter
    def min_length(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_length", value)

    @property
    @pulumi.getter(name="propertyName")
    def property_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the property in the Cloud Control payload that is used to set the name of the resource.
        """
        return pulumi.get(self, "property_name")

    @property_name.setter
    def property_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "property_name", value)


@pulumi.input_type
class CreateOnlyTagArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        A set of tags to apply to the resource.
        :param pulumi.Input[str] key: The key name of the tag
        :param pulumi.Input[str] value: The value of the tag
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[str]:
        """
        The key name of the tag
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        The value of the tag
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class ProviderAssumeRoleArgs:
    def __init__(__self__, *,
                 duration_seconds: Optional[pulumi.Input[int]] = None,
                 external_id: Optional[pulumi.Input[str]] = None,
                 policy: Optional[pulumi.Input[str]] = None,
                 policy_arns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 role_arn: Optional[pulumi.Input[str]] = None,
                 session_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 transitive_tag_keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The configuration for a Provider to assume a role.
        :param pulumi.Input[int] duration_seconds: Number of seconds to restrict the assume role session duration.
        :param pulumi.Input[str] external_id: External identifier to use when assuming the role.
        :param pulumi.Input[str] policy: IAM Policy JSON describing further restricting permissions for the IAM Role being assumed.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] policy_arns: Set of Amazon Resource Names (ARNs) of IAM Policies describing further restricting permissions for the role.
        :param pulumi.Input[str] role_arn: Amazon Resource Name (ARN) of the IAM Role to assume.
        :param pulumi.Input[str] session_name: Session name to use when assuming the role.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Map of assume role session tags.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] transitive_tag_keys: A list of keys for session tags that you want to set as transitive. If you set a tag key as transitive, the corresponding key and value passes to subsequent sessions in a role chain.
        """
        if duration_seconds is not None:
            pulumi.set(__self__, "duration_seconds", duration_seconds)
        if external_id is not None:
            pulumi.set(__self__, "external_id", external_id)
        if policy is not None:
            pulumi.set(__self__, "policy", policy)
        if policy_arns is not None:
            pulumi.set(__self__, "policy_arns", policy_arns)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)
        if session_name is not None:
            pulumi.set(__self__, "session_name", session_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if transitive_tag_keys is not None:
            pulumi.set(__self__, "transitive_tag_keys", transitive_tag_keys)

    @property
    @pulumi.getter(name="durationSeconds")
    def duration_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        Number of seconds to restrict the assume role session duration.
        """
        return pulumi.get(self, "duration_seconds")

    @duration_seconds.setter
    def duration_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "duration_seconds", value)

    @property
    @pulumi.getter(name="externalId")
    def external_id(self) -> Optional[pulumi.Input[str]]:
        """
        External identifier to use when assuming the role.
        """
        return pulumi.get(self, "external_id")

    @external_id.setter
    def external_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "external_id", value)

    @property
    @pulumi.getter
    def policy(self) -> Optional[pulumi.Input[str]]:
        """
        IAM Policy JSON describing further restricting permissions for the IAM Role being assumed.
        """
        return pulumi.get(self, "policy")

    @policy.setter
    def policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy", value)

    @property
    @pulumi.getter(name="policyArns")
    def policy_arns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Set of Amazon Resource Names (ARNs) of IAM Policies describing further restricting permissions for the role.
        """
        return pulumi.get(self, "policy_arns")

    @policy_arns.setter
    def policy_arns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "policy_arns", value)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[pulumi.Input[str]]:
        """
        Amazon Resource Name (ARN) of the IAM Role to assume.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role_arn", value)

    @property
    @pulumi.getter(name="sessionName")
    def session_name(self) -> Optional[pulumi.Input[str]]:
        """
        Session name to use when assuming the role.
        """
        return pulumi.get(self, "session_name")

    @session_name.setter
    def session_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "session_name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Map of assume role session tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="transitiveTagKeys")
    def transitive_tag_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of keys for session tags that you want to set as transitive. If you set a tag key as transitive, the corresponding key and value passes to subsequent sessions in a role chain.
        """
        return pulumi.get(self, "transitive_tag_keys")

    @transitive_tag_keys.setter
    def transitive_tag_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "transitive_tag_keys", value)


@pulumi.input_type
class ProviderDefaultTagsArgs:
    def __init__(__self__, *,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        The configuration with resource tag settings to apply across all resources handled by this provider. This is designed to replace redundant per-resource `tags` configurations. Provider tags can be overridden with new values, but not excluded from specific resources. To override provider tag values, use the `tags` argument within a resource to configure new tag values for matching keys.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A group of tags to set across all resources.
        """
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A group of tags to set across all resources.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class ProviderEndpointArgs:
    def __init__(__self__, *,
                 cloudcontrol: Optional[pulumi.Input[str]] = None,
                 cloudformation: Optional[pulumi.Input[str]] = None,
                 ec2: Optional[pulumi.Input[str]] = None,
                 ssm: Optional[pulumi.Input[str]] = None,
                 sts: Optional[pulumi.Input[str]] = None):
        """
        The configuration for for customizing service endpoints.
        :param pulumi.Input[str] cloudcontrol: Override the default endpoint for AWS CloudControl
        :param pulumi.Input[str] cloudformation: Override the default endpoint for AWS CloudFormation
        :param pulumi.Input[str] ec2: Override the default endpoint for AWS Elastic Compute Cloud (EC2)
        :param pulumi.Input[str] ssm: Override the default endpoint for AWS Systems Manager
        :param pulumi.Input[str] sts: Override the default endpoint for AWS Security Token Service (STS)
        """
        if cloudcontrol is not None:
            pulumi.set(__self__, "cloudcontrol", cloudcontrol)
        if cloudformation is not None:
            pulumi.set(__self__, "cloudformation", cloudformation)
        if ec2 is not None:
            pulumi.set(__self__, "ec2", ec2)
        if ssm is not None:
            pulumi.set(__self__, "ssm", ssm)
        if sts is not None:
            pulumi.set(__self__, "sts", sts)

    @property
    @pulumi.getter
    def cloudcontrol(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for AWS CloudControl
        """
        return pulumi.get(self, "cloudcontrol")

    @cloudcontrol.setter
    def cloudcontrol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cloudcontrol", value)

    @property
    @pulumi.getter
    def cloudformation(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for AWS CloudFormation
        """
        return pulumi.get(self, "cloudformation")

    @cloudformation.setter
    def cloudformation(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cloudformation", value)

    @property
    @pulumi.getter
    def ec2(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for AWS Elastic Compute Cloud (EC2)
        """
        return pulumi.get(self, "ec2")

    @ec2.setter
    def ec2(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ec2", value)

    @property
    @pulumi.getter
    def ssm(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for AWS Systems Manager
        """
        return pulumi.get(self, "ssm")

    @ssm.setter
    def ssm(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ssm", value)

    @property
    @pulumi.getter
    def sts(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for AWS Security Token Service (STS)
        """
        return pulumi.get(self, "sts")

    @sts.setter
    def sts(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sts", value)


@pulumi.input_type
class ProviderIgnoreTagsArgs:
    def __init__(__self__, *,
                 key_prefixes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The configuration with resource tag settings to ignore across all resources handled by this provider (except any individual service tag resources such as `ec2.Tag`) for situations where external systems are managing certain resource tags.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] key_prefixes: List of exact resource tag keys to ignore across all resources handled by this provider. This configuration prevents Pulumi from returning the tag in any `tags` attributes and displaying any configuration difference for the tag value. If any resource configuration still has this tag key configured in the `tags` argument, it will display a perpetual difference until the tag is removed from the argument or `ignoreChanges` is also used.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] keys: List of resource tag key prefixes to ignore across all resources handled by this provider. This configuration prevents Pulumi from returning any tag key matching the prefixes in any `tags` attributes and displaying any configuration difference for those tag values. If any resource configuration still has a tag matching one of the prefixes configured in the `tags` argument, it will display a perpetual difference until the tag is removed from the argument or `ignoreChanges` is also used.
        """
        if key_prefixes is not None:
            pulumi.set(__self__, "key_prefixes", key_prefixes)
        if keys is not None:
            pulumi.set(__self__, "keys", keys)

    @property
    @pulumi.getter(name="keyPrefixes")
    def key_prefixes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of exact resource tag keys to ignore across all resources handled by this provider. This configuration prevents Pulumi from returning the tag in any `tags` attributes and displaying any configuration difference for the tag value. If any resource configuration still has this tag key configured in the `tags` argument, it will display a perpetual difference until the tag is removed from the argument or `ignoreChanges` is also used.
        """
        return pulumi.get(self, "key_prefixes")

    @key_prefixes.setter
    def key_prefixes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "key_prefixes", value)

    @property
    @pulumi.getter
    def keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of resource tag key prefixes to ignore across all resources handled by this provider. This configuration prevents Pulumi from returning any tag key matching the prefixes in any `tags` attributes and displaying any configuration difference for those tag values. If any resource configuration still has a tag matching one of the prefixes configured in the `tags` argument, it will display a perpetual difference until the tag is removed from the argument or `ignoreChanges` is also used.
        """
        return pulumi.get(self, "keys")

    @keys.setter
    def keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "keys", value)


@pulumi.input_type
class TagArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        A set of tags to apply to the resource.
        :param pulumi.Input[str] key: The key name of the tag
        :param pulumi.Input[str] value: The value of the tag
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[str]:
        """
        The key name of the tag
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        The value of the tag
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


