<p align="center">
	<img src="https://raw.githubusercontent.com/DeepRegNet/DeepReg/main/docs/asset/deepreg_logo_purple.svg" alt="deepreg_logo" title="DeepReg" width="200" />
</p>

# DeepReg

<table align="center">
  <tr>
    <td align="left">
      <b>Package</b>
    </td>
    <td align="center">
      <a href="https://pypi.python.org/pypi/DeepReg/">
        <img src="https://img.shields.io/pypi/v/deepreg.svg" alt="PyPI Version">
      </a>
      <a href="https://pepy.tech/project/deepreg">
        <img src="https://static.pepy.tech/personalized-badge/deepreg?period=total&units=none&left_color=grey&right_color=orange&left_text=Downloads" alt="PyPI downloads">
      </a>
    </td>
  </tr>
  <tr>
    <td align="left">
      <b>Docs</b>
    </td>
    <td align="center">
      <a href="https://deepreg.readthedocs.io/en/latest/?badge=latest">
        <img src="https://readthedocs.org/projects/deepreg/badge/?version=latest" alt="Documentation Status">
      </a>
      <a href="https://opensource.org/licenses/Apache-2.0">
        <img src="https://img.shields.io/badge/License-Apache%202.0-blue.svg" alt="License">
      </a>
    </td>
  </tr>
  <tr>
    <td align="left">
      <b>Build</b>
    </td>
    <td align="center">
      <a href="https://travis-ci.com/DeepRegNet/DeepReg">
        <img src="https://travis-ci.com/DeepRegNet/DeepReg.svg?branch=main" alt="Build Status">
      </a>
    </td>
  </tr>
  <tr>
    <td align="left">
      <b>Code</b>
    </td>
    <td align="center">
      <a href="https://github.com/psf/black">
        <img src="https://img.shields.io/badge/code%20style-black-000000.svg" alt="Cod Style">
      </a>
      <a href="https://codecov.io/github/DeepRegNet/DeepReg">
        <img src="https://codecov.io/gh/DeepRegNet/DeepReg/branch/main/graph/badge.svg" alt="Coverage Status">
      </a>
    </td>
  </tr>
  <tr>
    <td align="left">
      <b>Papers</b>
    </td>
    <td align="center">
      <a href="https://joss.theoj.org/papers/7e6de472bc82a70d7618e23f618960b3">
        <img src="https://joss.theoj.org/papers/7e6de472bc82a70d7618e23f618960b3/status.svg" alt="JOSS Paper">
      </a>
    </td>
  </tr>
</table>

**DeepReg is a freely available, community-supported open-source toolkit for research
and education in medical image registration using deep learning.**

- TensorFlow 2-based for efficient training and rapid deployment;
- Implementing major unsupervised and weakly-supervised algorithms, with their
  combinations and variants;
- Focusing on growing and diverse clinical applications, with all DeepReg Demos using
  open-accessible data;
- Simple built-in command line tools requiring minimal programming and scripting;
- Open, permissible and research-and-education-driven, under the Apache 2.0 license.

---

## Getting Started

- [DeepReg.Net](http://deepreg.net/)
- [Documentation, Tutorials, and Quick Start](https://deepreg.readthedocs.io/)
- [Medical Image Registration Demos using DeepReg](https://deepreg.readthedocs.io/en/latest/demo/introduction.html)
- [Issue Tracker](https://github.com/DeepRegNet/DeepReg/issues/new/choose)

## Contributing

Get involved, and help make DeepReg better! We want your help - **Really**.

**Being a contributor doesn't just mean writing code.** Equally important to the
open-source process is writing or proof-reading documentation, suggesting or
implementing tests, or giving feedback about the project. You might see the errors and
assumptions that have been glossed over. If you can write any code at all, you can
contribute code to open-source. We are constantly trying out new skills, making
mistakes, and learning from those mistakes. That's how we all improve, and we are happy
to help others learn with us.

### Code of Conduct

This project is released with a
[Code of Conduct](https://github.com/DeepRegNet/DeepReg/blob/main/docs/CODE_OF_CONDUCT.md).
By participating in this project, you agree to abide by its terms.

### Where Should I Start?

For guidance on making a contribution to DeepReg, see our
[Contribution Guidelines](https://deepreg.readthedocs.io/en/latest/contributing/code.html).

Have a registration application with openly accessible data? Consider
[contributing a DeepReg Demo](https://deepreg.readthedocs.io/en/latest/contributing/demo.html).

## MICCAI 2020 Educational Challenge

Our [MICCAI Educational Challenge](https://miccai-sb.github.io/materials.html)
submission on DeepReg is an Award Winner!

Check it out
[here](https://github.com/DeepRegNet/DeepReg/blob/main/docs/Intro_to_Medical_Image_Registration.ipynb) -
you can also
[![Open In Colab](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/github/DeepRegNet/DeepReg/blob/main/docs/Intro_to_Medical_Image_Registration.ipynb)

## Citing DeepReg

DeepReg is research software, made by a
[team of academic researchers](https://deepreg.readthedocs.io/en/latest/#contributors).
Citations and use of our software help us justify the effort which has gone into, and
will keep going into, maintaining and growing this project.

If you have used DeepReg in your research, please consider citing us:

> Fu _et al._, (2020). DeepReg: a deep learning toolkit for medical image registration.
> _Journal of Open Source Software_, **5**(55), 2705,
> https://doi.org/10.21105/joss.02705

Or with BibTex:

```
@article{Fu2020,
  doi = {10.21105/joss.02705},
  url = {https://doi.org/10.21105/joss.02705},
  year = {2020},
  publisher = {The Open Journal},
  volume = {5},
  number = {55},
  pages = {2705},
  author = {Yunguan Fu and Nina Montaña Brown and Shaheer U. Saeed and Adrià Casamitjana and Zachary M. C. Baum and Rémi Delaunay and Qianye Yang and Alexander Grimwood and Zhe Min and Stefano B. Blumberg and Juan Eugenio Iglesias and Dean C. Barratt and Ester Bonmati and Daniel C. Alexander and Matthew J. Clarkson and Tom Vercauteren and Yipeng Hu},
  title = {DeepReg: a deep learning toolkit for medical image registration},
  journal = {Journal of Open Source Software}
}
```
