import * as iot from '@aws-cdk/aws-iot-alpha';
import { CommonActionProps } from './common-action-props';
/**
 * Configuration properties of an action for CloudWatch metric.
 */
export interface CloudWatchPutMetricActionProps extends CommonActionProps {
    /**
     * The CloudWatch metric name.
     *
     * Supports substitution templates.
     * @see https://docs.aws.amazon.com/iot/latest/developerguide/iot-substitution-templates.html
     */
    readonly metricName: string;
    /**
     * The CloudWatch metric namespace name.
     *
     * Supports substitution templates.
     * @see https://docs.aws.amazon.com/iot/latest/developerguide/iot-substitution-templates.html
     */
    readonly metricNamespace: string;
    /**
     * A string that contains the timestamp, expressed in seconds in Unix epoch time.
     *
     * Supports substitution templates.
     * @see https://docs.aws.amazon.com/iot/latest/developerguide/iot-substitution-templates.html
     *
     * @default - none -- Defaults to the current Unix epoch time.
     */
    readonly metricTimestamp?: string;
    /**
     * The metric unit supported by CloudWatch.
     *
     * Supports substitution templates.
     * @see https://docs.aws.amazon.com/iot/latest/developerguide/iot-substitution-templates.html
     */
    readonly metricUnit: string;
    /**
     * A string that contains the CloudWatch metric value.
     *
     * Supports substitution templates.
     * @see https://docs.aws.amazon.com/iot/latest/developerguide/iot-substitution-templates.html
     */
    readonly metricValue: string;
}
/**
 * The action to capture an Amazon CloudWatch metric.
 */
export declare class CloudWatchPutMetricAction implements iot.IAction {
    private readonly props;
    constructor(props: CloudWatchPutMetricActionProps);
    bind(rule: iot.ITopicRule): iot.ActionConfig;
}
