import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface TeamConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/buildkite/r/team#default_member_role Team#default_member_role}
    */
    readonly defaultMemberRole: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/buildkite/r/team#default_team Team#default_team}
    */
    readonly defaultTeam: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/buildkite/r/team#description Team#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/buildkite/r/team#members_can_create_pipelines Team#members_can_create_pipelines}
    */
    readonly membersCanCreatePipelines?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/buildkite/r/team#name Team#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/buildkite/r/team#privacy Team#privacy}
    */
    readonly privacy: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/buildkite/r/team buildkite_team}
*/
export declare class Team extends cdktf.TerraformResource {
    static readonly tfResourceType = "buildkite_team";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/buildkite/r/team buildkite_team} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options TeamConfig
    */
    constructor(scope: Construct, id: string, config: TeamConfig);
    private _defaultMemberRole?;
    get defaultMemberRole(): string;
    set defaultMemberRole(value: string);
    get defaultMemberRoleInput(): string | undefined;
    private _defaultTeam?;
    get defaultTeam(): boolean | cdktf.IResolvable;
    set defaultTeam(value: boolean | cdktf.IResolvable);
    get defaultTeamInput(): boolean | cdktf.IResolvable | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get id(): string;
    private _membersCanCreatePipelines?;
    get membersCanCreatePipelines(): boolean | cdktf.IResolvable;
    set membersCanCreatePipelines(value: boolean | cdktf.IResolvable);
    resetMembersCanCreatePipelines(): void;
    get membersCanCreatePipelinesInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _privacy?;
    get privacy(): string;
    set privacy(value: string);
    get privacyInput(): string | undefined;
    get slug(): string;
    get uuid(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=team.d.ts.map