import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface TeamMemberConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/buildkite/r/team_member#role TeamMember#role}
    */
    readonly role: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/buildkite/r/team_member#team_id TeamMember#team_id}
    */
    readonly teamId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/buildkite/r/team_member#user_id TeamMember#user_id}
    */
    readonly userId: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/buildkite/r/team_member buildkite_team_member}
*/
export declare class TeamMember extends cdktf.TerraformResource {
    static readonly tfResourceType = "buildkite_team_member";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/buildkite/r/team_member buildkite_team_member} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options TeamMemberConfig
    */
    constructor(scope: Construct, id: string, config: TeamMemberConfig);
    get id(): string;
    private _role?;
    get role(): string;
    set role(value: string);
    get roleInput(): string | undefined;
    private _teamId?;
    get teamId(): string;
    set teamId(value: string);
    get teamIdInput(): string | undefined;
    private _userId?;
    get userId(): string;
    set userId(value: string);
    get userIdInput(): string | undefined;
    get uuid(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=team-member.d.ts.map