"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Pipeline = exports.PipelineProviderSettingsOutputReference = exports.pipelineProviderSettingsToTerraform = exports.pipelineTeamToTerraform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function pipelineTeamToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        access_level: cdktf.stringToTerraform(struct.accessLevel),
        slug: cdktf.stringToTerraform(struct.slug),
    };
}
exports.pipelineTeamToTerraform = pipelineTeamToTerraform;
function pipelineProviderSettingsToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        build_branches: cdktf.booleanToTerraform(struct.buildBranches),
        build_pull_request_forks: cdktf.booleanToTerraform(struct.buildPullRequestForks),
        build_pull_request_labels_changed: cdktf.booleanToTerraform(struct.buildPullRequestLabelsChanged),
        build_pull_request_ready_for_review: cdktf.booleanToTerraform(struct.buildPullRequestReadyForReview),
        build_pull_requests: cdktf.booleanToTerraform(struct.buildPullRequests),
        build_tags: cdktf.booleanToTerraform(struct.buildTags),
        cancel_deleted_branch_builds: cdktf.booleanToTerraform(struct.cancelDeletedBranchBuilds),
        filter_condition: cdktf.stringToTerraform(struct.filterCondition),
        filter_enabled: cdktf.booleanToTerraform(struct.filterEnabled),
        prefix_pull_request_fork_branch_names: cdktf.booleanToTerraform(struct.prefixPullRequestForkBranchNames),
        publish_blocked_as_pending: cdktf.booleanToTerraform(struct.publishBlockedAsPending),
        publish_commit_status: cdktf.booleanToTerraform(struct.publishCommitStatus),
        publish_commit_status_per_step: cdktf.booleanToTerraform(struct.publishCommitStatusPerStep),
        pull_request_branch_filter_configuration: cdktf.stringToTerraform(struct.pullRequestBranchFilterConfiguration),
        pull_request_branch_filter_enabled: cdktf.booleanToTerraform(struct.pullRequestBranchFilterEnabled),
        separate_pull_request_statuses: cdktf.booleanToTerraform(struct.separatePullRequestStatuses),
        skip_pull_request_builds_for_existing_commits: cdktf.booleanToTerraform(struct.skipPullRequestBuildsForExistingCommits),
        trigger_mode: cdktf.stringToTerraform(struct.triggerMode),
    };
}
exports.pipelineProviderSettingsToTerraform = pipelineProviderSettingsToTerraform;
class PipelineProviderSettingsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._buildBranches !== undefined) {
            hasAnyValues = true;
            internalValueResult.buildBranches = this._buildBranches;
        }
        if (this._buildPullRequestForks !== undefined) {
            hasAnyValues = true;
            internalValueResult.buildPullRequestForks = this._buildPullRequestForks;
        }
        if (this._buildPullRequestLabelsChanged !== undefined) {
            hasAnyValues = true;
            internalValueResult.buildPullRequestLabelsChanged = this._buildPullRequestLabelsChanged;
        }
        if (this._buildPullRequestReadyForReview !== undefined) {
            hasAnyValues = true;
            internalValueResult.buildPullRequestReadyForReview = this._buildPullRequestReadyForReview;
        }
        if (this._buildPullRequests !== undefined) {
            hasAnyValues = true;
            internalValueResult.buildPullRequests = this._buildPullRequests;
        }
        if (this._buildTags !== undefined) {
            hasAnyValues = true;
            internalValueResult.buildTags = this._buildTags;
        }
        if (this._cancelDeletedBranchBuilds !== undefined) {
            hasAnyValues = true;
            internalValueResult.cancelDeletedBranchBuilds = this._cancelDeletedBranchBuilds;
        }
        if (this._filterCondition !== undefined) {
            hasAnyValues = true;
            internalValueResult.filterCondition = this._filterCondition;
        }
        if (this._filterEnabled !== undefined) {
            hasAnyValues = true;
            internalValueResult.filterEnabled = this._filterEnabled;
        }
        if (this._prefixPullRequestForkBranchNames !== undefined) {
            hasAnyValues = true;
            internalValueResult.prefixPullRequestForkBranchNames = this._prefixPullRequestForkBranchNames;
        }
        if (this._publishBlockedAsPending !== undefined) {
            hasAnyValues = true;
            internalValueResult.publishBlockedAsPending = this._publishBlockedAsPending;
        }
        if (this._publishCommitStatus !== undefined) {
            hasAnyValues = true;
            internalValueResult.publishCommitStatus = this._publishCommitStatus;
        }
        if (this._publishCommitStatusPerStep !== undefined) {
            hasAnyValues = true;
            internalValueResult.publishCommitStatusPerStep = this._publishCommitStatusPerStep;
        }
        if (this._pullRequestBranchFilterConfiguration !== undefined) {
            hasAnyValues = true;
            internalValueResult.pullRequestBranchFilterConfiguration = this._pullRequestBranchFilterConfiguration;
        }
        if (this._pullRequestBranchFilterEnabled !== undefined) {
            hasAnyValues = true;
            internalValueResult.pullRequestBranchFilterEnabled = this._pullRequestBranchFilterEnabled;
        }
        if (this._separatePullRequestStatuses !== undefined) {
            hasAnyValues = true;
            internalValueResult.separatePullRequestStatuses = this._separatePullRequestStatuses;
        }
        if (this._skipPullRequestBuildsForExistingCommits !== undefined) {
            hasAnyValues = true;
            internalValueResult.skipPullRequestBuildsForExistingCommits = this._skipPullRequestBuildsForExistingCommits;
        }
        if (this._triggerMode !== undefined) {
            hasAnyValues = true;
            internalValueResult.triggerMode = this._triggerMode;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._buildBranches = undefined;
            this._buildPullRequestForks = undefined;
            this._buildPullRequestLabelsChanged = undefined;
            this._buildPullRequestReadyForReview = undefined;
            this._buildPullRequests = undefined;
            this._buildTags = undefined;
            this._cancelDeletedBranchBuilds = undefined;
            this._filterCondition = undefined;
            this._filterEnabled = undefined;
            this._prefixPullRequestForkBranchNames = undefined;
            this._publishBlockedAsPending = undefined;
            this._publishCommitStatus = undefined;
            this._publishCommitStatusPerStep = undefined;
            this._pullRequestBranchFilterConfiguration = undefined;
            this._pullRequestBranchFilterEnabled = undefined;
            this._separatePullRequestStatuses = undefined;
            this._skipPullRequestBuildsForExistingCommits = undefined;
            this._triggerMode = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._buildBranches = value.buildBranches;
            this._buildPullRequestForks = value.buildPullRequestForks;
            this._buildPullRequestLabelsChanged = value.buildPullRequestLabelsChanged;
            this._buildPullRequestReadyForReview = value.buildPullRequestReadyForReview;
            this._buildPullRequests = value.buildPullRequests;
            this._buildTags = value.buildTags;
            this._cancelDeletedBranchBuilds = value.cancelDeletedBranchBuilds;
            this._filterCondition = value.filterCondition;
            this._filterEnabled = value.filterEnabled;
            this._prefixPullRequestForkBranchNames = value.prefixPullRequestForkBranchNames;
            this._publishBlockedAsPending = value.publishBlockedAsPending;
            this._publishCommitStatus = value.publishCommitStatus;
            this._publishCommitStatusPerStep = value.publishCommitStatusPerStep;
            this._pullRequestBranchFilterConfiguration = value.pullRequestBranchFilterConfiguration;
            this._pullRequestBranchFilterEnabled = value.pullRequestBranchFilterEnabled;
            this._separatePullRequestStatuses = value.separatePullRequestStatuses;
            this._skipPullRequestBuildsForExistingCommits = value.skipPullRequestBuildsForExistingCommits;
            this._triggerMode = value.triggerMode;
        }
    }
    get buildBranches() {
        return this.getBooleanAttribute('build_branches');
    }
    set buildBranches(value) {
        this._buildBranches = value;
    }
    resetBuildBranches() {
        this._buildBranches = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get buildBranchesInput() {
        return this._buildBranches;
    }
    get buildPullRequestForks() {
        return this.getBooleanAttribute('build_pull_request_forks');
    }
    set buildPullRequestForks(value) {
        this._buildPullRequestForks = value;
    }
    resetBuildPullRequestForks() {
        this._buildPullRequestForks = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get buildPullRequestForksInput() {
        return this._buildPullRequestForks;
    }
    get buildPullRequestLabelsChanged() {
        return this.getBooleanAttribute('build_pull_request_labels_changed');
    }
    set buildPullRequestLabelsChanged(value) {
        this._buildPullRequestLabelsChanged = value;
    }
    resetBuildPullRequestLabelsChanged() {
        this._buildPullRequestLabelsChanged = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get buildPullRequestLabelsChangedInput() {
        return this._buildPullRequestLabelsChanged;
    }
    get buildPullRequestReadyForReview() {
        return this.getBooleanAttribute('build_pull_request_ready_for_review');
    }
    set buildPullRequestReadyForReview(value) {
        this._buildPullRequestReadyForReview = value;
    }
    resetBuildPullRequestReadyForReview() {
        this._buildPullRequestReadyForReview = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get buildPullRequestReadyForReviewInput() {
        return this._buildPullRequestReadyForReview;
    }
    get buildPullRequests() {
        return this.getBooleanAttribute('build_pull_requests');
    }
    set buildPullRequests(value) {
        this._buildPullRequests = value;
    }
    resetBuildPullRequests() {
        this._buildPullRequests = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get buildPullRequestsInput() {
        return this._buildPullRequests;
    }
    get buildTags() {
        return this.getBooleanAttribute('build_tags');
    }
    set buildTags(value) {
        this._buildTags = value;
    }
    resetBuildTags() {
        this._buildTags = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get buildTagsInput() {
        return this._buildTags;
    }
    get cancelDeletedBranchBuilds() {
        return this.getBooleanAttribute('cancel_deleted_branch_builds');
    }
    set cancelDeletedBranchBuilds(value) {
        this._cancelDeletedBranchBuilds = value;
    }
    resetCancelDeletedBranchBuilds() {
        this._cancelDeletedBranchBuilds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cancelDeletedBranchBuildsInput() {
        return this._cancelDeletedBranchBuilds;
    }
    get filterCondition() {
        return this.getStringAttribute('filter_condition');
    }
    set filterCondition(value) {
        this._filterCondition = value;
    }
    resetFilterCondition() {
        this._filterCondition = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get filterConditionInput() {
        return this._filterCondition;
    }
    get filterEnabled() {
        return this.getBooleanAttribute('filter_enabled');
    }
    set filterEnabled(value) {
        this._filterEnabled = value;
    }
    resetFilterEnabled() {
        this._filterEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get filterEnabledInput() {
        return this._filterEnabled;
    }
    get prefixPullRequestForkBranchNames() {
        return this.getBooleanAttribute('prefix_pull_request_fork_branch_names');
    }
    set prefixPullRequestForkBranchNames(value) {
        this._prefixPullRequestForkBranchNames = value;
    }
    resetPrefixPullRequestForkBranchNames() {
        this._prefixPullRequestForkBranchNames = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get prefixPullRequestForkBranchNamesInput() {
        return this._prefixPullRequestForkBranchNames;
    }
    get publishBlockedAsPending() {
        return this.getBooleanAttribute('publish_blocked_as_pending');
    }
    set publishBlockedAsPending(value) {
        this._publishBlockedAsPending = value;
    }
    resetPublishBlockedAsPending() {
        this._publishBlockedAsPending = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get publishBlockedAsPendingInput() {
        return this._publishBlockedAsPending;
    }
    get publishCommitStatus() {
        return this.getBooleanAttribute('publish_commit_status');
    }
    set publishCommitStatus(value) {
        this._publishCommitStatus = value;
    }
    resetPublishCommitStatus() {
        this._publishCommitStatus = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get publishCommitStatusInput() {
        return this._publishCommitStatus;
    }
    get publishCommitStatusPerStep() {
        return this.getBooleanAttribute('publish_commit_status_per_step');
    }
    set publishCommitStatusPerStep(value) {
        this._publishCommitStatusPerStep = value;
    }
    resetPublishCommitStatusPerStep() {
        this._publishCommitStatusPerStep = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get publishCommitStatusPerStepInput() {
        return this._publishCommitStatusPerStep;
    }
    get pullRequestBranchFilterConfiguration() {
        return this.getStringAttribute('pull_request_branch_filter_configuration');
    }
    set pullRequestBranchFilterConfiguration(value) {
        this._pullRequestBranchFilterConfiguration = value;
    }
    resetPullRequestBranchFilterConfiguration() {
        this._pullRequestBranchFilterConfiguration = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get pullRequestBranchFilterConfigurationInput() {
        return this._pullRequestBranchFilterConfiguration;
    }
    get pullRequestBranchFilterEnabled() {
        return this.getBooleanAttribute('pull_request_branch_filter_enabled');
    }
    set pullRequestBranchFilterEnabled(value) {
        this._pullRequestBranchFilterEnabled = value;
    }
    resetPullRequestBranchFilterEnabled() {
        this._pullRequestBranchFilterEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get pullRequestBranchFilterEnabledInput() {
        return this._pullRequestBranchFilterEnabled;
    }
    get separatePullRequestStatuses() {
        return this.getBooleanAttribute('separate_pull_request_statuses');
    }
    set separatePullRequestStatuses(value) {
        this._separatePullRequestStatuses = value;
    }
    resetSeparatePullRequestStatuses() {
        this._separatePullRequestStatuses = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get separatePullRequestStatusesInput() {
        return this._separatePullRequestStatuses;
    }
    get skipPullRequestBuildsForExistingCommits() {
        return this.getBooleanAttribute('skip_pull_request_builds_for_existing_commits');
    }
    set skipPullRequestBuildsForExistingCommits(value) {
        this._skipPullRequestBuildsForExistingCommits = value;
    }
    resetSkipPullRequestBuildsForExistingCommits() {
        this._skipPullRequestBuildsForExistingCommits = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get skipPullRequestBuildsForExistingCommitsInput() {
        return this._skipPullRequestBuildsForExistingCommits;
    }
    get triggerMode() {
        return this.getStringAttribute('trigger_mode');
    }
    set triggerMode(value) {
        this._triggerMode = value;
    }
    resetTriggerMode() {
        this._triggerMode = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get triggerModeInput() {
        return this._triggerMode;
    }
}
exports.PipelineProviderSettingsOutputReference = PipelineProviderSettingsOutputReference;
_a = JSII_RTTI_SYMBOL_1;
PipelineProviderSettingsOutputReference[_a] = { fqn: "buildkite_buildkite.PipelineProviderSettingsOutputReference", version: "0.0.0" };
/**
* Represents a {@link https://www.terraform.io/docs/providers/buildkite/r/pipeline buildkite_pipeline}
*/
class Pipeline extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/buildkite/r/pipeline buildkite_pipeline} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options PipelineConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'buildkite_pipeline',
            terraformGeneratorMetadata: {
                providerName: 'buildkite',
                providerVersion: '0.9.0',
                providerVersionConstraint: '~> 0.9.0'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        // provider_settings - computed: false, optional: true, required: false
        this._providerSettings = new PipelineProviderSettingsOutputReference(this, "provider_settings");
        this._allowRebuilds = config.allowRebuilds;
        this._branchConfiguration = config.branchConfiguration;
        this._cancelIntermediateBuilds = config.cancelIntermediateBuilds;
        this._cancelIntermediateBuildsBranchFilter = config.cancelIntermediateBuildsBranchFilter;
        this._clusterId = config.clusterId;
        this._defaultBranch = config.defaultBranch;
        this._description = config.description;
        this._name = config.name;
        this._repository = config.repository;
        this._skipIntermediateBuilds = config.skipIntermediateBuilds;
        this._skipIntermediateBuildsBranchFilter = config.skipIntermediateBuildsBranchFilter;
        this._steps = config.steps;
        this._tags = config.tags;
        this._team = config.team;
        this._providerSettings.internalValue = config.providerSettings;
    }
    get allowRebuilds() {
        return this.getBooleanAttribute('allow_rebuilds');
    }
    set allowRebuilds(value) {
        this._allowRebuilds = value;
    }
    resetAllowRebuilds() {
        this._allowRebuilds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get allowRebuildsInput() {
        return this._allowRebuilds;
    }
    // badge_url - computed: true, optional: false, required: false
    get badgeUrl() {
        return this.getStringAttribute('badge_url');
    }
    get branchConfiguration() {
        return this.getStringAttribute('branch_configuration');
    }
    set branchConfiguration(value) {
        this._branchConfiguration = value;
    }
    resetBranchConfiguration() {
        this._branchConfiguration = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get branchConfigurationInput() {
        return this._branchConfiguration;
    }
    get cancelIntermediateBuilds() {
        return this.getBooleanAttribute('cancel_intermediate_builds');
    }
    set cancelIntermediateBuilds(value) {
        this._cancelIntermediateBuilds = value;
    }
    resetCancelIntermediateBuilds() {
        this._cancelIntermediateBuilds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cancelIntermediateBuildsInput() {
        return this._cancelIntermediateBuilds;
    }
    get cancelIntermediateBuildsBranchFilter() {
        return this.getStringAttribute('cancel_intermediate_builds_branch_filter');
    }
    set cancelIntermediateBuildsBranchFilter(value) {
        this._cancelIntermediateBuildsBranchFilter = value;
    }
    resetCancelIntermediateBuildsBranchFilter() {
        this._cancelIntermediateBuildsBranchFilter = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cancelIntermediateBuildsBranchFilterInput() {
        return this._cancelIntermediateBuildsBranchFilter;
    }
    get clusterId() {
        return this.getStringAttribute('cluster_id');
    }
    set clusterId(value) {
        this._clusterId = value;
    }
    resetClusterId() {
        this._clusterId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get clusterIdInput() {
        return this._clusterId;
    }
    get defaultBranch() {
        return this.getStringAttribute('default_branch');
    }
    set defaultBranch(value) {
        this._defaultBranch = value;
    }
    resetDefaultBranch() {
        this._defaultBranch = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get defaultBranchInput() {
        return this._defaultBranch;
    }
    get description() {
        return this.getStringAttribute('description');
    }
    set description(value) {
        this._description = value;
    }
    resetDescription() {
        this._description = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get descriptionInput() {
        return this._description;
    }
    // id - computed: true, optional: true, required: false
    get id() {
        return this.getStringAttribute('id');
    }
    get name() {
        return this.getStringAttribute('name');
    }
    set name(value) {
        this._name = value;
    }
    // Temporarily expose input value. Use with caution.
    get nameInput() {
        return this._name;
    }
    get repository() {
        return this.getStringAttribute('repository');
    }
    set repository(value) {
        this._repository = value;
    }
    // Temporarily expose input value. Use with caution.
    get repositoryInput() {
        return this._repository;
    }
    get skipIntermediateBuilds() {
        return this.getBooleanAttribute('skip_intermediate_builds');
    }
    set skipIntermediateBuilds(value) {
        this._skipIntermediateBuilds = value;
    }
    resetSkipIntermediateBuilds() {
        this._skipIntermediateBuilds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get skipIntermediateBuildsInput() {
        return this._skipIntermediateBuilds;
    }
    get skipIntermediateBuildsBranchFilter() {
        return this.getStringAttribute('skip_intermediate_builds_branch_filter');
    }
    set skipIntermediateBuildsBranchFilter(value) {
        this._skipIntermediateBuildsBranchFilter = value;
    }
    resetSkipIntermediateBuildsBranchFilter() {
        this._skipIntermediateBuildsBranchFilter = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get skipIntermediateBuildsBranchFilterInput() {
        return this._skipIntermediateBuildsBranchFilter;
    }
    // slug - computed: true, optional: false, required: false
    get slug() {
        return this.getStringAttribute('slug');
    }
    get steps() {
        return this.getStringAttribute('steps');
    }
    set steps(value) {
        this._steps = value;
    }
    // Temporarily expose input value. Use with caution.
    get stepsInput() {
        return this._steps;
    }
    get tags() {
        return cdktf.Fn.tolist(this.getListAttribute('tags'));
    }
    set tags(value) {
        this._tags = value;
    }
    resetTags() {
        this._tags = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tagsInput() {
        return this._tags;
    }
    get team() {
        // Getting the computed value is not yet implemented
        return cdktf.Token.asAny(cdktf.Fn.tolist(this.interpolationForAttribute('team')));
    }
    set team(value) {
        this._team = value;
    }
    resetTeam() {
        this._team = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get teamInput() {
        return this._team;
    }
    // webhook_url - computed: true, optional: false, required: false
    get webhookUrl() {
        return this.getStringAttribute('webhook_url');
    }
    get providerSettings() {
        return this._providerSettings;
    }
    putProviderSettings(value) {
        this._providerSettings.internalValue = value;
    }
    resetProviderSettings() {
        this._providerSettings.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get providerSettingsInput() {
        return this._providerSettings.internalValue;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            allow_rebuilds: cdktf.booleanToTerraform(this._allowRebuilds),
            branch_configuration: cdktf.stringToTerraform(this._branchConfiguration),
            cancel_intermediate_builds: cdktf.booleanToTerraform(this._cancelIntermediateBuilds),
            cancel_intermediate_builds_branch_filter: cdktf.stringToTerraform(this._cancelIntermediateBuildsBranchFilter),
            cluster_id: cdktf.stringToTerraform(this._clusterId),
            default_branch: cdktf.stringToTerraform(this._defaultBranch),
            description: cdktf.stringToTerraform(this._description),
            name: cdktf.stringToTerraform(this._name),
            repository: cdktf.stringToTerraform(this._repository),
            skip_intermediate_builds: cdktf.booleanToTerraform(this._skipIntermediateBuilds),
            skip_intermediate_builds_branch_filter: cdktf.stringToTerraform(this._skipIntermediateBuildsBranchFilter),
            steps: cdktf.stringToTerraform(this._steps),
            tags: cdktf.listMapper(cdktf.stringToTerraform)(this._tags),
            team: cdktf.listMapper(pipelineTeamToTerraform)(this._team),
            provider_settings: pipelineProviderSettingsToTerraform(this._providerSettings.internalValue),
        };
    }
}
exports.Pipeline = Pipeline;
_b = JSII_RTTI_SYMBOL_1;
Pipeline[_b] = { fqn: "buildkite_buildkite.Pipeline", version: "0.0.0" };
// =================
// STATIC PROPERTIES
// =================
Pipeline.tfResourceType = "buildkite_pipeline";
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicGlwZWxpbmUuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJwaXBlbGluZS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUlBLCtCQUErQjtBQStFL0IsU0FBZ0IsdUJBQXVCLENBQUMsTUFBeUM7SUFDL0UsSUFBSSxDQUFDLEtBQUssQ0FBQyxVQUFVLENBQUMsTUFBTSxDQUFDLElBQUksS0FBSyxDQUFDLFlBQVksQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLEVBQUU7UUFBRSxPQUFPLE1BQU0sQ0FBQztLQUFFO0lBQzVGLElBQUksS0FBSyxDQUFDLGdCQUFnQixDQUFDLE1BQU0sQ0FBQyxFQUFFO1FBQ2xDLE1BQU0sSUFBSSxLQUFLLENBQUMsb0hBQW9ILENBQUMsQ0FBQztLQUN2STtJQUNELE9BQU87UUFDTCxZQUFZLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLE1BQU8sQ0FBQyxXQUFXLENBQUM7UUFDMUQsSUFBSSxFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxNQUFPLENBQUMsSUFBSSxDQUFDO0tBQzVDLENBQUE7QUFDSCxDQUFDO0FBVEQsMERBU0M7QUE2RUQsU0FBZ0IsbUNBQW1DLENBQUMsTUFBMkU7SUFDN0gsSUFBSSxDQUFDLEtBQUssQ0FBQyxVQUFVLENBQUMsTUFBTSxDQUFDLElBQUksS0FBSyxDQUFDLFlBQVksQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLEVBQUU7UUFBRSxPQUFPLE1BQU0sQ0FBQztLQUFFO0lBQzVGLElBQUksS0FBSyxDQUFDLGdCQUFnQixDQUFDLE1BQU0sQ0FBQyxFQUFFO1FBQ2xDLE1BQU0sSUFBSSxLQUFLLENBQUMsb0hBQW9ILENBQUMsQ0FBQztLQUN2STtJQUNELE9BQU87UUFDTCxjQUFjLEVBQUUsS0FBSyxDQUFDLGtCQUFrQixDQUFDLE1BQU8sQ0FBQyxhQUFhLENBQUM7UUFDL0Qsd0JBQXdCLEVBQUUsS0FBSyxDQUFDLGtCQUFrQixDQUFDLE1BQU8sQ0FBQyxxQkFBcUIsQ0FBQztRQUNqRixpQ0FBaUMsRUFBRSxLQUFLLENBQUMsa0JBQWtCLENBQUMsTUFBTyxDQUFDLDZCQUE2QixDQUFDO1FBQ2xHLG1DQUFtQyxFQUFFLEtBQUssQ0FBQyxrQkFBa0IsQ0FBQyxNQUFPLENBQUMsOEJBQThCLENBQUM7UUFDckcsbUJBQW1CLEVBQUUsS0FBSyxDQUFDLGtCQUFrQixDQUFDLE1BQU8sQ0FBQyxpQkFBaUIsQ0FBQztRQUN4RSxVQUFVLEVBQUUsS0FBSyxDQUFDLGtCQUFrQixDQUFDLE1BQU8sQ0FBQyxTQUFTLENBQUM7UUFDdkQsNEJBQTRCLEVBQUUsS0FBSyxDQUFDLGtCQUFrQixDQUFDLE1BQU8sQ0FBQyx5QkFBeUIsQ0FBQztRQUN6RixnQkFBZ0IsRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsTUFBTyxDQUFDLGVBQWUsQ0FBQztRQUNsRSxjQUFjLEVBQUUsS0FBSyxDQUFDLGtCQUFrQixDQUFDLE1BQU8sQ0FBQyxhQUFhLENBQUM7UUFDL0QscUNBQXFDLEVBQUUsS0FBSyxDQUFDLGtCQUFrQixDQUFDLE1BQU8sQ0FBQyxnQ0FBZ0MsQ0FBQztRQUN6RywwQkFBMEIsRUFBRSxLQUFLLENBQUMsa0JBQWtCLENBQUMsTUFBTyxDQUFDLHVCQUF1QixDQUFDO1FBQ3JGLHFCQUFxQixFQUFFLEtBQUssQ0FBQyxrQkFBa0IsQ0FBQyxNQUFPLENBQUMsbUJBQW1CLENBQUM7UUFDNUUsOEJBQThCLEVBQUUsS0FBSyxDQUFDLGtCQUFrQixDQUFDLE1BQU8sQ0FBQywwQkFBMEIsQ0FBQztRQUM1Rix3Q0FBd0MsRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsTUFBTyxDQUFDLG9DQUFvQyxDQUFDO1FBQy9HLGtDQUFrQyxFQUFFLEtBQUssQ0FBQyxrQkFBa0IsQ0FBQyxNQUFPLENBQUMsOEJBQThCLENBQUM7UUFDcEcsOEJBQThCLEVBQUUsS0FBSyxDQUFDLGtCQUFrQixDQUFDLE1BQU8sQ0FBQywyQkFBMkIsQ0FBQztRQUM3Riw2Q0FBNkMsRUFBRSxLQUFLLENBQUMsa0JBQWtCLENBQUMsTUFBTyxDQUFDLHVDQUF1QyxDQUFDO1FBQ3hILFlBQVksRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsTUFBTyxDQUFDLFdBQVcsQ0FBQztLQUMzRCxDQUFBO0FBQ0gsQ0FBQztBQXpCRCxrRkF5QkM7QUFFRCxNQUFhLHVDQUF3QyxTQUFRLEtBQUssQ0FBQyxhQUFhO0lBRzlFOzs7TUFHRTtJQUNGLFlBQW1CLGlCQUE2QyxFQUFFLGtCQUEwQjtRQUMxRixLQUFLLENBQUMsaUJBQWlCLEVBQUUsa0JBQWtCLEVBQUUsS0FBSyxFQUFFLENBQUMsQ0FBQyxDQUFDO1FBUGpELGtCQUFhLEdBQUcsS0FBSyxDQUFDO0lBUTlCLENBQUM7SUFFRCxJQUFXLGFBQWE7UUFDdEIsSUFBSSxZQUFZLEdBQUcsSUFBSSxDQUFDLGFBQWEsQ0FBQztRQUN0QyxNQUFNLG1CQUFtQixHQUFRLEVBQUUsQ0FBQztRQUNwQyxJQUFJLElBQUksQ0FBQyxjQUFjLEtBQUssU0FBUyxFQUFFO1lBQ3JDLFlBQVksR0FBRyxJQUFJLENBQUM7WUFDcEIsbUJBQW1CLENBQUMsYUFBYSxHQUFHLElBQUksQ0FBQyxjQUFjLENBQUM7U0FDekQ7UUFDRCxJQUFJLElBQUksQ0FBQyxzQkFBc0IsS0FBSyxTQUFTLEVBQUU7WUFDN0MsWUFBWSxHQUFHLElBQUksQ0FBQztZQUNwQixtQkFBbUIsQ0FBQyxxQkFBcUIsR0FBRyxJQUFJLENBQUMsc0JBQXNCLENBQUM7U0FDekU7UUFDRCxJQUFJLElBQUksQ0FBQyw4QkFBOEIsS0FBSyxTQUFTLEVBQUU7WUFDckQsWUFBWSxHQUFHLElBQUksQ0FBQztZQUNwQixtQkFBbUIsQ0FBQyw2QkFBNkIsR0FBRyxJQUFJLENBQUMsOEJBQThCLENBQUM7U0FDekY7UUFDRCxJQUFJLElBQUksQ0FBQywrQkFBK0IsS0FBSyxTQUFTLEVBQUU7WUFDdEQsWUFBWSxHQUFHLElBQUksQ0FBQztZQUNwQixtQkFBbUIsQ0FBQyw4QkFBOEIsR0FBRyxJQUFJLENBQUMsK0JBQStCLENBQUM7U0FDM0Y7UUFDRCxJQUFJLElBQUksQ0FBQyxrQkFBa0IsS0FBSyxTQUFTLEVBQUU7WUFDekMsWUFBWSxHQUFHLElBQUksQ0FBQztZQUNwQixtQkFBbUIsQ0FBQyxpQkFBaUIsR0FBRyxJQUFJLENBQUMsa0JBQWtCLENBQUM7U0FDakU7UUFDRCxJQUFJLElBQUksQ0FBQyxVQUFVLEtBQUssU0FBUyxFQUFFO1lBQ2pDLFlBQVksR0FBRyxJQUFJLENBQUM7WUFDcEIsbUJBQW1CLENBQUMsU0FBUyxHQUFHLElBQUksQ0FBQyxVQUFVLENBQUM7U0FDakQ7UUFDRCxJQUFJLElBQUksQ0FBQywwQkFBMEIsS0FBSyxTQUFTLEVBQUU7WUFDakQsWUFBWSxHQUFHLElBQUksQ0FBQztZQUNwQixtQkFBbUIsQ0FBQyx5QkFBeUIsR0FBRyxJQUFJLENBQUMsMEJBQTBCLENBQUM7U0FDakY7UUFDRCxJQUFJLElBQUksQ0FBQyxnQkFBZ0IsS0FBSyxTQUFTLEVBQUU7WUFDdkMsWUFBWSxHQUFHLElBQUksQ0FBQztZQUNwQixtQkFBbUIsQ0FBQyxlQUFlLEdBQUcsSUFBSSxDQUFDLGdCQUFnQixDQUFDO1NBQzdEO1FBQ0QsSUFBSSxJQUFJLENBQUMsY0FBYyxLQUFLLFNBQVMsRUFBRTtZQUNyQyxZQUFZLEdBQUcsSUFBSSxDQUFDO1lBQ3BCLG1CQUFtQixDQUFDLGFBQWEsR0FBRyxJQUFJLENBQUMsY0FBYyxDQUFDO1NBQ3pEO1FBQ0QsSUFBSSxJQUFJLENBQUMsaUNBQWlDLEtBQUssU0FBUyxFQUFFO1lBQ3hELFlBQVksR0FBRyxJQUFJLENBQUM7WUFDcEIsbUJBQW1CLENBQUMsZ0NBQWdDLEdBQUcsSUFBSSxDQUFDLGlDQUFpQyxDQUFDO1NBQy9GO1FBQ0QsSUFBSSxJQUFJLENBQUMsd0JBQXdCLEtBQUssU0FBUyxFQUFFO1lBQy9DLFlBQVksR0FBRyxJQUFJLENBQUM7WUFDcEIsbUJBQW1CLENBQUMsdUJBQXVCLEdBQUcsSUFBSSxDQUFDLHdCQUF3QixDQUFDO1NBQzdFO1FBQ0QsSUFBSSxJQUFJLENBQUMsb0JBQW9CLEtBQUssU0FBUyxFQUFFO1lBQzNDLFlBQVksR0FBRyxJQUFJLENBQUM7WUFDcEIsbUJBQW1CLENBQUMsbUJBQW1CLEdBQUcsSUFBSSxDQUFDLG9CQUFvQixDQUFDO1NBQ3JFO1FBQ0QsSUFBSSxJQUFJLENBQUMsMkJBQTJCLEtBQUssU0FBUyxFQUFFO1lBQ2xELFlBQVksR0FBRyxJQUFJLENBQUM7WUFDcEIsbUJBQW1CLENBQUMsMEJBQTBCLEdBQUcsSUFBSSxDQUFDLDJCQUEyQixDQUFDO1NBQ25GO1FBQ0QsSUFBSSxJQUFJLENBQUMscUNBQXFDLEtBQUssU0FBUyxFQUFFO1lBQzVELFlBQVksR0FBRyxJQUFJLENBQUM7WUFDcEIsbUJBQW1CLENBQUMsb0NBQW9DLEdBQUcsSUFBSSxDQUFDLHFDQUFxQyxDQUFDO1NBQ3ZHO1FBQ0QsSUFBSSxJQUFJLENBQUMsK0JBQStCLEtBQUssU0FBUyxFQUFFO1lBQ3RELFlBQVksR0FBRyxJQUFJLENBQUM7WUFDcEIsbUJBQW1CLENBQUMsOEJBQThCLEdBQUcsSUFBSSxDQUFDLCtCQUErQixDQUFDO1NBQzNGO1FBQ0QsSUFBSSxJQUFJLENBQUMsNEJBQTRCLEtBQUssU0FBUyxFQUFFO1lBQ25ELFlBQVksR0FBRyxJQUFJLENBQUM7WUFDcEIsbUJBQW1CLENBQUMsMkJBQTJCLEdBQUcsSUFBSSxDQUFDLDRCQUE0QixDQUFDO1NBQ3JGO1FBQ0QsSUFBSSxJQUFJLENBQUMsd0NBQXdDLEtBQUssU0FBUyxFQUFFO1lBQy9ELFlBQVksR0FBRyxJQUFJLENBQUM7WUFDcEIsbUJBQW1CLENBQUMsdUNBQXVDLEdBQUcsSUFBSSxDQUFDLHdDQUF3QyxDQUFDO1NBQzdHO1FBQ0QsSUFBSSxJQUFJLENBQUMsWUFBWSxLQUFLLFNBQVMsRUFBRTtZQUNuQyxZQUFZLEdBQUcsSUFBSSxDQUFDO1lBQ3BCLG1CQUFtQixDQUFDLFdBQVcsR0FBRyxJQUFJLENBQUMsWUFBWSxDQUFDO1NBQ3JEO1FBQ0QsT0FBTyxZQUFZLENBQUMsQ0FBQyxDQUFDLG1CQUFtQixDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUM7SUFDeEQsQ0FBQztJQUVELElBQVcsYUFBYSxDQUFDLEtBQTJDO1FBQ2xFLElBQUksS0FBSyxLQUFLLFNBQVMsRUFBRTtZQUN2QixJQUFJLENBQUMsYUFBYSxHQUFHLEtBQUssQ0FBQztZQUMzQixJQUFJLENBQUMsY0FBYyxHQUFHLFNBQVMsQ0FBQztZQUNoQyxJQUFJLENBQUMsc0JBQXNCLEdBQUcsU0FBUyxDQUFDO1lBQ3hDLElBQUksQ0FBQyw4QkFBOEIsR0FBRyxTQUFTLENBQUM7WUFDaEQsSUFBSSxDQUFDLCtCQUErQixHQUFHLFNBQVMsQ0FBQztZQUNqRCxJQUFJLENBQUMsa0JBQWtCLEdBQUcsU0FBUyxDQUFDO1lBQ3BDLElBQUksQ0FBQyxVQUFVLEdBQUcsU0FBUyxDQUFDO1lBQzVCLElBQUksQ0FBQywwQkFBMEIsR0FBRyxTQUFTLENBQUM7WUFDNUMsSUFBSSxDQUFDLGdCQUFnQixHQUFHLFNBQVMsQ0FBQztZQUNsQyxJQUFJLENBQUMsY0FBYyxHQUFHLFNBQVMsQ0FBQztZQUNoQyxJQUFJLENBQUMsaUNBQWlDLEdBQUcsU0FBUyxDQUFDO1lBQ25ELElBQUksQ0FBQyx3QkFBd0IsR0FBRyxTQUFTLENBQUM7WUFDMUMsSUFBSSxDQUFDLG9CQUFvQixHQUFHLFNBQVMsQ0FBQztZQUN0QyxJQUFJLENBQUMsMkJBQTJCLEdBQUcsU0FBUyxDQUFDO1lBQzdDLElBQUksQ0FBQyxxQ0FBcUMsR0FBRyxTQUFTLENBQUM7WUFDdkQsSUFBSSxDQUFDLCtCQUErQixHQUFHLFNBQVMsQ0FBQztZQUNqRCxJQUFJLENBQUMsNEJBQTRCLEdBQUcsU0FBUyxDQUFDO1lBQzlDLElBQUksQ0FBQyx3Q0FBd0MsR0FBRyxTQUFTLENBQUM7WUFDMUQsSUFBSSxDQUFDLFlBQVksR0FBRyxTQUFTLENBQUM7U0FDL0I7YUFDSTtZQUNILElBQUksQ0FBQyxhQUFhLEdBQUcsTUFBTSxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsQ0FBQyxNQUFNLEtBQUssQ0FBQyxDQUFDO1lBQ3JELElBQUksQ0FBQyxjQUFjLEdBQUcsS0FBSyxDQUFDLGFBQWEsQ0FBQztZQUMxQyxJQUFJLENBQUMsc0JBQXNCLEdBQUcsS0FBSyxDQUFDLHFCQUFxQixDQUFDO1lBQzFELElBQUksQ0FBQyw4QkFBOEIsR0FBRyxLQUFLLENBQUMsNkJBQTZCLENBQUM7WUFDMUUsSUFBSSxDQUFDLCtCQUErQixHQUFHLEtBQUssQ0FBQyw4QkFBOEIsQ0FBQztZQUM1RSxJQUFJLENBQUMsa0JBQWtCLEdBQUcsS0FBSyxDQUFDLGlCQUFpQixDQUFDO1lBQ2xELElBQUksQ0FBQyxVQUFVLEdBQUcsS0FBSyxDQUFDLFNBQVMsQ0FBQztZQUNsQyxJQUFJLENBQUMsMEJBQTBCLEdBQUcsS0FBSyxDQUFDLHlCQUF5QixDQUFDO1lBQ2xFLElBQUksQ0FBQyxnQkFBZ0IsR0FBRyxLQUFLLENBQUMsZUFBZSxDQUFDO1lBQzlDLElBQUksQ0FBQyxjQUFjLEdBQUcsS0FBSyxDQUFDLGFBQWEsQ0FBQztZQUMxQyxJQUFJLENBQUMsaUNBQWlDLEdBQUcsS0FBSyxDQUFDLGdDQUFnQyxDQUFDO1lBQ2hGLElBQUksQ0FBQyx3QkFBd0IsR0FBRyxLQUFLLENBQUMsdUJBQXVCLENBQUM7WUFDOUQsSUFBSSxDQUFDLG9CQUFvQixHQUFHLEtBQUssQ0FBQyxtQkFBbUIsQ0FBQztZQUN0RCxJQUFJLENBQUMsMkJBQTJCLEdBQUcsS0FBSyxDQUFDLDBCQUEwQixDQUFDO1lBQ3BFLElBQUksQ0FBQyxxQ0FBcUMsR0FBRyxLQUFLLENBQUMsb0NBQW9DLENBQUM7WUFDeEYsSUFBSSxDQUFDLCtCQUErQixHQUFHLEtBQUssQ0FBQyw4QkFBOEIsQ0FBQztZQUM1RSxJQUFJLENBQUMsNEJBQTRCLEdBQUcsS0FBSyxDQUFDLDJCQUEyQixDQUFDO1lBQ3RFLElBQUksQ0FBQyx3Q0FBd0MsR0FBRyxLQUFLLENBQUMsdUNBQXVDLENBQUM7WUFDOUYsSUFBSSxDQUFDLFlBQVksR0FBRyxLQUFLLENBQUMsV0FBVyxDQUFDO1NBQ3ZDO0lBQ0gsQ0FBQztJQUlELElBQVcsYUFBYTtRQUN0QixPQUFPLElBQUksQ0FBQyxtQkFBbUIsQ0FBQyxnQkFBZ0IsQ0FBQyxDQUFDO0lBQ3BELENBQUM7SUFDRCxJQUFXLGFBQWEsQ0FBQyxLQUFrQztRQUN6RCxJQUFJLENBQUMsY0FBYyxHQUFHLEtBQUssQ0FBQztJQUM5QixDQUFDO0lBQ00sa0JBQWtCO1FBQ3ZCLElBQUksQ0FBQyxjQUFjLEdBQUcsU0FBUyxDQUFDO0lBQ2xDLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxrQkFBa0I7UUFDM0IsT0FBTyxJQUFJLENBQUMsY0FBYyxDQUFDO0lBQzdCLENBQUM7SUFJRCxJQUFXLHFCQUFxQjtRQUM5QixPQUFPLElBQUksQ0FBQyxtQkFBbUIsQ0FBQywwQkFBMEIsQ0FBQyxDQUFDO0lBQzlELENBQUM7SUFDRCxJQUFXLHFCQUFxQixDQUFDLEtBQWtDO1FBQ2pFLElBQUksQ0FBQyxzQkFBc0IsR0FBRyxLQUFLLENBQUM7SUFDdEMsQ0FBQztJQUNNLDBCQUEwQjtRQUMvQixJQUFJLENBQUMsc0JBQXNCLEdBQUcsU0FBUyxDQUFDO0lBQzFDLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVywwQkFBMEI7UUFDbkMsT0FBTyxJQUFJLENBQUMsc0JBQXNCLENBQUM7SUFDckMsQ0FBQztJQUlELElBQVcsNkJBQTZCO1FBQ3RDLE9BQU8sSUFBSSxDQUFDLG1CQUFtQixDQUFDLG1DQUFtQyxDQUFDLENBQUM7SUFDdkUsQ0FBQztJQUNELElBQVcsNkJBQTZCLENBQUMsS0FBa0M7UUFDekUsSUFBSSxDQUFDLDhCQUE4QixHQUFHLEtBQUssQ0FBQztJQUM5QyxDQUFDO0lBQ00sa0NBQWtDO1FBQ3ZDLElBQUksQ0FBQyw4QkFBOEIsR0FBRyxTQUFTLENBQUM7SUFDbEQsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLGtDQUFrQztRQUMzQyxPQUFPLElBQUksQ0FBQyw4QkFBOEIsQ0FBQztJQUM3QyxDQUFDO0lBSUQsSUFBVyw4QkFBOEI7UUFDdkMsT0FBTyxJQUFJLENBQUMsbUJBQW1CLENBQUMscUNBQXFDLENBQUMsQ0FBQztJQUN6RSxDQUFDO0lBQ0QsSUFBVyw4QkFBOEIsQ0FBQyxLQUFrQztRQUMxRSxJQUFJLENBQUMsK0JBQStCLEdBQUcsS0FBSyxDQUFDO0lBQy9DLENBQUM7SUFDTSxtQ0FBbUM7UUFDeEMsSUFBSSxDQUFDLCtCQUErQixHQUFHLFNBQVMsQ0FBQztJQUNuRCxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsbUNBQW1DO1FBQzVDLE9BQU8sSUFBSSxDQUFDLCtCQUErQixDQUFDO0lBQzlDLENBQUM7SUFJRCxJQUFXLGlCQUFpQjtRQUMxQixPQUFPLElBQUksQ0FBQyxtQkFBbUIsQ0FBQyxxQkFBcUIsQ0FBQyxDQUFDO0lBQ3pELENBQUM7SUFDRCxJQUFXLGlCQUFpQixDQUFDLEtBQWtDO1FBQzdELElBQUksQ0FBQyxrQkFBa0IsR0FBRyxLQUFLLENBQUM7SUFDbEMsQ0FBQztJQUNNLHNCQUFzQjtRQUMzQixJQUFJLENBQUMsa0JBQWtCLEdBQUcsU0FBUyxDQUFDO0lBQ3RDLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxzQkFBc0I7UUFDL0IsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUM7SUFDakMsQ0FBQztJQUlELElBQVcsU0FBUztRQUNsQixPQUFPLElBQUksQ0FBQyxtQkFBbUIsQ0FBQyxZQUFZLENBQUMsQ0FBQztJQUNoRCxDQUFDO0lBQ0QsSUFBVyxTQUFTLENBQUMsS0FBa0M7UUFDckQsSUFBSSxDQUFDLFVBQVUsR0FBRyxLQUFLLENBQUM7SUFDMUIsQ0FBQztJQUNNLGNBQWM7UUFDbkIsSUFBSSxDQUFDLFVBQVUsR0FBRyxTQUFTLENBQUM7SUFDOUIsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLGNBQWM7UUFDdkIsT0FBTyxJQUFJLENBQUMsVUFBVSxDQUFDO0lBQ3pCLENBQUM7SUFJRCxJQUFXLHlCQUF5QjtRQUNsQyxPQUFPLElBQUksQ0FBQyxtQkFBbUIsQ0FBQyw4QkFBOEIsQ0FBQyxDQUFDO0lBQ2xFLENBQUM7SUFDRCxJQUFXLHlCQUF5QixDQUFDLEtBQWtDO1FBQ3JFLElBQUksQ0FBQywwQkFBMEIsR0FBRyxLQUFLLENBQUM7SUFDMUMsQ0FBQztJQUNNLDhCQUE4QjtRQUNuQyxJQUFJLENBQUMsMEJBQTBCLEdBQUcsU0FBUyxDQUFDO0lBQzlDLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyw4QkFBOEI7UUFDdkMsT0FBTyxJQUFJLENBQUMsMEJBQTBCLENBQUM7SUFDekMsQ0FBQztJQUlELElBQVcsZUFBZTtRQUN4QixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxrQkFBa0IsQ0FBQyxDQUFDO0lBQ3JELENBQUM7SUFDRCxJQUFXLGVBQWUsQ0FBQyxLQUFhO1FBQ3RDLElBQUksQ0FBQyxnQkFBZ0IsR0FBRyxLQUFLLENBQUM7SUFDaEMsQ0FBQztJQUNNLG9CQUFvQjtRQUN6QixJQUFJLENBQUMsZ0JBQWdCLEdBQUcsU0FBUyxDQUFDO0lBQ3BDLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxvQkFBb0I7UUFDN0IsT0FBTyxJQUFJLENBQUMsZ0JBQWdCLENBQUM7SUFDL0IsQ0FBQztJQUlELElBQVcsYUFBYTtRQUN0QixPQUFPLElBQUksQ0FBQyxtQkFBbUIsQ0FBQyxnQkFBZ0IsQ0FBQyxDQUFDO0lBQ3BELENBQUM7SUFDRCxJQUFXLGFBQWEsQ0FBQyxLQUFrQztRQUN6RCxJQUFJLENBQUMsY0FBYyxHQUFHLEtBQUssQ0FBQztJQUM5QixDQUFDO0lBQ00sa0JBQWtCO1FBQ3ZCLElBQUksQ0FBQyxjQUFjLEdBQUcsU0FBUyxDQUFDO0lBQ2xDLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxrQkFBa0I7UUFDM0IsT0FBTyxJQUFJLENBQUMsY0FBYyxDQUFDO0lBQzdCLENBQUM7SUFJRCxJQUFXLGdDQUFnQztRQUN6QyxPQUFPLElBQUksQ0FBQyxtQkFBbUIsQ0FBQyx1Q0FBdUMsQ0FBQyxDQUFDO0lBQzNFLENBQUM7SUFDRCxJQUFXLGdDQUFnQyxDQUFDLEtBQWtDO1FBQzVFLElBQUksQ0FBQyxpQ0FBaUMsR0FBRyxLQUFLLENBQUM7SUFDakQsQ0FBQztJQUNNLHFDQUFxQztRQUMxQyxJQUFJLENBQUMsaUNBQWlDLEdBQUcsU0FBUyxDQUFDO0lBQ3JELENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxxQ0FBcUM7UUFDOUMsT0FBTyxJQUFJLENBQUMsaUNBQWlDLENBQUM7SUFDaEQsQ0FBQztJQUlELElBQVcsdUJBQXVCO1FBQ2hDLE9BQU8sSUFBSSxDQUFDLG1CQUFtQixDQUFDLDRCQUE0QixDQUFDLENBQUM7SUFDaEUsQ0FBQztJQUNELElBQVcsdUJBQXVCLENBQUMsS0FBa0M7UUFDbkUsSUFBSSxDQUFDLHdCQUF3QixHQUFHLEtBQUssQ0FBQztJQUN4QyxDQUFDO0lBQ00sNEJBQTRCO1FBQ2pDLElBQUksQ0FBQyx3QkFBd0IsR0FBRyxTQUFTLENBQUM7SUFDNUMsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLDRCQUE0QjtRQUNyQyxPQUFPLElBQUksQ0FBQyx3QkFBd0IsQ0FBQztJQUN2QyxDQUFDO0lBSUQsSUFBVyxtQkFBbUI7UUFDNUIsT0FBTyxJQUFJLENBQUMsbUJBQW1CLENBQUMsdUJBQXVCLENBQUMsQ0FBQztJQUMzRCxDQUFDO0lBQ0QsSUFBVyxtQkFBbUIsQ0FBQyxLQUFrQztRQUMvRCxJQUFJLENBQUMsb0JBQW9CLEdBQUcsS0FBSyxDQUFDO0lBQ3BDLENBQUM7SUFDTSx3QkFBd0I7UUFDN0IsSUFBSSxDQUFDLG9CQUFvQixHQUFHLFNBQVMsQ0FBQztJQUN4QyxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsd0JBQXdCO1FBQ2pDLE9BQU8sSUFBSSxDQUFDLG9CQUFvQixDQUFDO0lBQ25DLENBQUM7SUFJRCxJQUFXLDBCQUEwQjtRQUNuQyxPQUFPLElBQUksQ0FBQyxtQkFBbUIsQ0FBQyxnQ0FBZ0MsQ0FBQyxDQUFDO0lBQ3BFLENBQUM7SUFDRCxJQUFXLDBCQUEwQixDQUFDLEtBQWtDO1FBQ3RFLElBQUksQ0FBQywyQkFBMkIsR0FBRyxLQUFLLENBQUM7SUFDM0MsQ0FBQztJQUNNLCtCQUErQjtRQUNwQyxJQUFJLENBQUMsMkJBQTJCLEdBQUcsU0FBUyxDQUFDO0lBQy9DLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVywrQkFBK0I7UUFDeEMsT0FBTyxJQUFJLENBQUMsMkJBQTJCLENBQUM7SUFDMUMsQ0FBQztJQUlELElBQVcsb0NBQW9DO1FBQzdDLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLDBDQUEwQyxDQUFDLENBQUM7SUFDN0UsQ0FBQztJQUNELElBQVcsb0NBQW9DLENBQUMsS0FBYTtRQUMzRCxJQUFJLENBQUMscUNBQXFDLEdBQUcsS0FBSyxDQUFDO0lBQ3JELENBQUM7SUFDTSx5Q0FBeUM7UUFDOUMsSUFBSSxDQUFDLHFDQUFxQyxHQUFHLFNBQVMsQ0FBQztJQUN6RCxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcseUNBQXlDO1FBQ2xELE9BQU8sSUFBSSxDQUFDLHFDQUFxQyxDQUFDO0lBQ3BELENBQUM7SUFJRCxJQUFXLDhCQUE4QjtRQUN2QyxPQUFPLElBQUksQ0FBQyxtQkFBbUIsQ0FBQyxvQ0FBb0MsQ0FBQyxDQUFDO0lBQ3hFLENBQUM7SUFDRCxJQUFXLDhCQUE4QixDQUFDLEtBQWtDO1FBQzFFLElBQUksQ0FBQywrQkFBK0IsR0FBRyxLQUFLLENBQUM7SUFDL0MsQ0FBQztJQUNNLG1DQUFtQztRQUN4QyxJQUFJLENBQUMsK0JBQStCLEdBQUcsU0FBUyxDQUFDO0lBQ25ELENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxtQ0FBbUM7UUFDNUMsT0FBTyxJQUFJLENBQUMsK0JBQStCLENBQUM7SUFDOUMsQ0FBQztJQUlELElBQVcsMkJBQTJCO1FBQ3BDLE9BQU8sSUFBSSxDQUFDLG1CQUFtQixDQUFDLGdDQUFnQyxDQUFDLENBQUM7SUFDcEUsQ0FBQztJQUNELElBQVcsMkJBQTJCLENBQUMsS0FBa0M7UUFDdkUsSUFBSSxDQUFDLDRCQUE0QixHQUFHLEtBQUssQ0FBQztJQUM1QyxDQUFDO0lBQ00sZ0NBQWdDO1FBQ3JDLElBQUksQ0FBQyw0QkFBNEIsR0FBRyxTQUFTLENBQUM7SUFDaEQsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLGdDQUFnQztRQUN6QyxPQUFPLElBQUksQ0FBQyw0QkFBNEIsQ0FBQztJQUMzQyxDQUFDO0lBSUQsSUFBVyx1Q0FBdUM7UUFDaEQsT0FBTyxJQUFJLENBQUMsbUJBQW1CLENBQUMsK0NBQStDLENBQUMsQ0FBQztJQUNuRixDQUFDO0lBQ0QsSUFBVyx1Q0FBdUMsQ0FBQyxLQUFrQztRQUNuRixJQUFJLENBQUMsd0NBQXdDLEdBQUcsS0FBSyxDQUFDO0lBQ3hELENBQUM7SUFDTSw0Q0FBNEM7UUFDakQsSUFBSSxDQUFDLHdDQUF3QyxHQUFHLFNBQVMsQ0FBQztJQUM1RCxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsNENBQTRDO1FBQ3JELE9BQU8sSUFBSSxDQUFDLHdDQUF3QyxDQUFDO0lBQ3ZELENBQUM7SUFJRCxJQUFXLFdBQVc7UUFDcEIsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsY0FBYyxDQUFDLENBQUM7SUFDakQsQ0FBQztJQUNELElBQVcsV0FBVyxDQUFDLEtBQWE7UUFDbEMsSUFBSSxDQUFDLFlBQVksR0FBRyxLQUFLLENBQUM7SUFDNUIsQ0FBQztJQUNNLGdCQUFnQjtRQUNyQixJQUFJLENBQUMsWUFBWSxHQUFHLFNBQVMsQ0FBQztJQUNoQyxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsZ0JBQWdCO1FBQ3pCLE9BQU8sSUFBSSxDQUFDLFlBQVksQ0FBQztJQUMzQixDQUFDOztBQXBhSCwwRkFxYUM7OztBQUVEOztFQUVFO0FBQ0YsTUFBYSxRQUFTLFNBQVEsS0FBSyxDQUFDLGlCQUFpQjtJQU9uRCxjQUFjO0lBQ2QsY0FBYztJQUNkLGNBQWM7SUFFZDs7Ozs7O01BTUU7SUFDRixZQUFtQixLQUFnQixFQUFFLEVBQVUsRUFBRSxNQUFzQjtRQUNyRSxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRTtZQUNmLHFCQUFxQixFQUFFLG9CQUFvQjtZQUMzQywwQkFBMEIsRUFBRTtnQkFDMUIsWUFBWSxFQUFFLFdBQVc7Z0JBQ3pCLGVBQWUsRUFBRSxPQUFPO2dCQUN4Qix5QkFBeUIsRUFBRSxVQUFVO2FBQ3RDO1lBQ0QsUUFBUSxFQUFFLE1BQU0sQ0FBQyxRQUFRO1lBQ3pCLFNBQVMsRUFBRSxNQUFNLENBQUMsU0FBUztZQUMzQixLQUFLLEVBQUUsTUFBTSxDQUFDLEtBQUs7WUFDbkIsU0FBUyxFQUFFLE1BQU0sQ0FBQyxTQUFTO1NBQzVCLENBQUMsQ0FBQztRQWtRTCx1RUFBdUU7UUFDL0Qsc0JBQWlCLEdBQUcsSUFBSSx1Q0FBdUMsQ0FBQyxJQUFJLEVBQUUsbUJBQW1CLENBQUMsQ0FBQztRQWxRakcsSUFBSSxDQUFDLGNBQWMsR0FBRyxNQUFNLENBQUMsYUFBYSxDQUFDO1FBQzNDLElBQUksQ0FBQyxvQkFBb0IsR0FBRyxNQUFNLENBQUMsbUJBQW1CLENBQUM7UUFDdkQsSUFBSSxDQUFDLHlCQUF5QixHQUFHLE1BQU0sQ0FBQyx3QkFBd0IsQ0FBQztRQUNqRSxJQUFJLENBQUMscUNBQXFDLEdBQUcsTUFBTSxDQUFDLG9DQUFvQyxDQUFDO1FBQ3pGLElBQUksQ0FBQyxVQUFVLEdBQUcsTUFBTSxDQUFDLFNBQVMsQ0FBQztRQUNuQyxJQUFJLENBQUMsY0FBYyxHQUFHLE1BQU0sQ0FBQyxhQUFhLENBQUM7UUFDM0MsSUFBSSxDQUFDLFlBQVksR0FBRyxNQUFNLENBQUMsV0FBVyxDQUFDO1FBQ3ZDLElBQUksQ0FBQyxLQUFLLEdBQUcsTUFBTSxDQUFDLElBQUksQ0FBQztRQUN6QixJQUFJLENBQUMsV0FBVyxHQUFHLE1BQU0sQ0FBQyxVQUFVLENBQUM7UUFDckMsSUFBSSxDQUFDLHVCQUF1QixHQUFHLE1BQU0sQ0FBQyxzQkFBc0IsQ0FBQztRQUM3RCxJQUFJLENBQUMsbUNBQW1DLEdBQUcsTUFBTSxDQUFDLGtDQUFrQyxDQUFDO1FBQ3JGLElBQUksQ0FBQyxNQUFNLEdBQUcsTUFBTSxDQUFDLEtBQUssQ0FBQztRQUMzQixJQUFJLENBQUMsS0FBSyxHQUFHLE1BQU0sQ0FBQyxJQUFJLENBQUM7UUFDekIsSUFBSSxDQUFDLEtBQUssR0FBRyxNQUFNLENBQUMsSUFBSSxDQUFDO1FBQ3pCLElBQUksQ0FBQyxpQkFBaUIsQ0FBQyxhQUFhLEdBQUcsTUFBTSxDQUFDLGdCQUFnQixDQUFDO0lBQ2pFLENBQUM7SUFRRCxJQUFXLGFBQWE7UUFDdEIsT0FBTyxJQUFJLENBQUMsbUJBQW1CLENBQUMsZ0JBQWdCLENBQUMsQ0FBQztJQUNwRCxDQUFDO0lBQ0QsSUFBVyxhQUFhLENBQUMsS0FBa0M7UUFDekQsSUFBSSxDQUFDLGNBQWMsR0FBRyxLQUFLLENBQUM7SUFDOUIsQ0FBQztJQUNNLGtCQUFrQjtRQUN2QixJQUFJLENBQUMsY0FBYyxHQUFHLFNBQVMsQ0FBQztJQUNsQyxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsa0JBQWtCO1FBQzNCLE9BQU8sSUFBSSxDQUFDLGNBQWMsQ0FBQztJQUM3QixDQUFDO0lBRUQsK0RBQStEO0lBQy9ELElBQVcsUUFBUTtRQUNqQixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxXQUFXLENBQUMsQ0FBQztJQUM5QyxDQUFDO0lBSUQsSUFBVyxtQkFBbUI7UUFDNUIsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsc0JBQXNCLENBQUMsQ0FBQztJQUN6RCxDQUFDO0lBQ0QsSUFBVyxtQkFBbUIsQ0FBQyxLQUFhO1FBQzFDLElBQUksQ0FBQyxvQkFBb0IsR0FBRyxLQUFLLENBQUM7SUFDcEMsQ0FBQztJQUNNLHdCQUF3QjtRQUM3QixJQUFJLENBQUMsb0JBQW9CLEdBQUcsU0FBUyxDQUFDO0lBQ3hDLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyx3QkFBd0I7UUFDakMsT0FBTyxJQUFJLENBQUMsb0JBQW9CLENBQUM7SUFDbkMsQ0FBQztJQUlELElBQVcsd0JBQXdCO1FBQ2pDLE9BQU8sSUFBSSxDQUFDLG1CQUFtQixDQUFDLDRCQUE0QixDQUFDLENBQUM7SUFDaEUsQ0FBQztJQUNELElBQVcsd0JBQXdCLENBQUMsS0FBa0M7UUFDcEUsSUFBSSxDQUFDLHlCQUF5QixHQUFHLEtBQUssQ0FBQztJQUN6QyxDQUFDO0lBQ00sNkJBQTZCO1FBQ2xDLElBQUksQ0FBQyx5QkFBeUIsR0FBRyxTQUFTLENBQUM7SUFDN0MsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLDZCQUE2QjtRQUN0QyxPQUFPLElBQUksQ0FBQyx5QkFBeUIsQ0FBQztJQUN4QyxDQUFDO0lBSUQsSUFBVyxvQ0FBb0M7UUFDN0MsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsMENBQTBDLENBQUMsQ0FBQztJQUM3RSxDQUFDO0lBQ0QsSUFBVyxvQ0FBb0MsQ0FBQyxLQUFhO1FBQzNELElBQUksQ0FBQyxxQ0FBcUMsR0FBRyxLQUFLLENBQUM7SUFDckQsQ0FBQztJQUNNLHlDQUF5QztRQUM5QyxJQUFJLENBQUMscUNBQXFDLEdBQUcsU0FBUyxDQUFDO0lBQ3pELENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyx5Q0FBeUM7UUFDbEQsT0FBTyxJQUFJLENBQUMscUNBQXFDLENBQUM7SUFDcEQsQ0FBQztJQUlELElBQVcsU0FBUztRQUNsQixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxZQUFZLENBQUMsQ0FBQztJQUMvQyxDQUFDO0lBQ0QsSUFBVyxTQUFTLENBQUMsS0FBYTtRQUNoQyxJQUFJLENBQUMsVUFBVSxHQUFHLEtBQUssQ0FBQztJQUMxQixDQUFDO0lBQ00sY0FBYztRQUNuQixJQUFJLENBQUMsVUFBVSxHQUFHLFNBQVMsQ0FBQztJQUM5QixDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsY0FBYztRQUN2QixPQUFPLElBQUksQ0FBQyxVQUFVLENBQUM7SUFDekIsQ0FBQztJQUlELElBQVcsYUFBYTtRQUN0QixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxnQkFBZ0IsQ0FBQyxDQUFDO0lBQ25ELENBQUM7SUFDRCxJQUFXLGFBQWEsQ0FBQyxLQUFhO1FBQ3BDLElBQUksQ0FBQyxjQUFjLEdBQUcsS0FBSyxDQUFDO0lBQzlCLENBQUM7SUFDTSxrQkFBa0I7UUFDdkIsSUFBSSxDQUFDLGNBQWMsR0FBRyxTQUFTLENBQUM7SUFDbEMsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLGtCQUFrQjtRQUMzQixPQUFPLElBQUksQ0FBQyxjQUFjLENBQUM7SUFDN0IsQ0FBQztJQUlELElBQVcsV0FBVztRQUNwQixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxhQUFhLENBQUMsQ0FBQztJQUNoRCxDQUFDO0lBQ0QsSUFBVyxXQUFXLENBQUMsS0FBYTtRQUNsQyxJQUFJLENBQUMsWUFBWSxHQUFHLEtBQUssQ0FBQztJQUM1QixDQUFDO0lBQ00sZ0JBQWdCO1FBQ3JCLElBQUksQ0FBQyxZQUFZLEdBQUcsU0FBUyxDQUFDO0lBQ2hDLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxnQkFBZ0I7UUFDekIsT0FBTyxJQUFJLENBQUMsWUFBWSxDQUFDO0lBQzNCLENBQUM7SUFFRCx1REFBdUQ7SUFDdkQsSUFBVyxFQUFFO1FBQ1gsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsSUFBSSxDQUFDLENBQUM7SUFDdkMsQ0FBQztJQUlELElBQVcsSUFBSTtRQUNiLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLE1BQU0sQ0FBQyxDQUFDO0lBQ3pDLENBQUM7SUFDRCxJQUFXLElBQUksQ0FBQyxLQUFhO1FBQzNCLElBQUksQ0FBQyxLQUFLLEdBQUcsS0FBSyxDQUFDO0lBQ3JCLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxTQUFTO1FBQ2xCLE9BQU8sSUFBSSxDQUFDLEtBQUssQ0FBQztJQUNwQixDQUFDO0lBSUQsSUFBVyxVQUFVO1FBQ25CLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLFlBQVksQ0FBQyxDQUFDO0lBQy9DLENBQUM7SUFDRCxJQUFXLFVBQVUsQ0FBQyxLQUFhO1FBQ2pDLElBQUksQ0FBQyxXQUFXLEdBQUcsS0FBSyxDQUFDO0lBQzNCLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxlQUFlO1FBQ3hCLE9BQU8sSUFBSSxDQUFDLFdBQVcsQ0FBQztJQUMxQixDQUFDO0lBSUQsSUFBVyxzQkFBc0I7UUFDL0IsT0FBTyxJQUFJLENBQUMsbUJBQW1CLENBQUMsMEJBQTBCLENBQUMsQ0FBQztJQUM5RCxDQUFDO0lBQ0QsSUFBVyxzQkFBc0IsQ0FBQyxLQUFrQztRQUNsRSxJQUFJLENBQUMsdUJBQXVCLEdBQUcsS0FBSyxDQUFDO0lBQ3ZDLENBQUM7SUFDTSwyQkFBMkI7UUFDaEMsSUFBSSxDQUFDLHVCQUF1QixHQUFHLFNBQVMsQ0FBQztJQUMzQyxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsMkJBQTJCO1FBQ3BDLE9BQU8sSUFBSSxDQUFDLHVCQUF1QixDQUFDO0lBQ3RDLENBQUM7SUFJRCxJQUFXLGtDQUFrQztRQUMzQyxPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyx3Q0FBd0MsQ0FBQyxDQUFDO0lBQzNFLENBQUM7SUFDRCxJQUFXLGtDQUFrQyxDQUFDLEtBQWE7UUFDekQsSUFBSSxDQUFDLG1DQUFtQyxHQUFHLEtBQUssQ0FBQztJQUNuRCxDQUFDO0lBQ00sdUNBQXVDO1FBQzVDLElBQUksQ0FBQyxtQ0FBbUMsR0FBRyxTQUFTLENBQUM7SUFDdkQsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLHVDQUF1QztRQUNoRCxPQUFPLElBQUksQ0FBQyxtQ0FBbUMsQ0FBQztJQUNsRCxDQUFDO0lBRUQsMERBQTBEO0lBQzFELElBQVcsSUFBSTtRQUNiLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLE1BQU0sQ0FBQyxDQUFDO0lBQ3pDLENBQUM7SUFJRCxJQUFXLEtBQUs7UUFDZCxPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxPQUFPLENBQUMsQ0FBQztJQUMxQyxDQUFDO0lBQ0QsSUFBVyxLQUFLLENBQUMsS0FBYTtRQUM1QixJQUFJLENBQUMsTUFBTSxHQUFHLEtBQUssQ0FBQztJQUN0QixDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsVUFBVTtRQUNuQixPQUFPLElBQUksQ0FBQyxNQUFNLENBQUM7SUFDckIsQ0FBQztJQUlELElBQVcsSUFBSTtRQUNiLE9BQU8sS0FBSyxDQUFDLEVBQUUsQ0FBQyxNQUFNLENBQUMsSUFBSSxDQUFDLGdCQUFnQixDQUFDLE1BQU0sQ0FBQyxDQUFDLENBQUM7SUFDeEQsQ0FBQztJQUNELElBQVcsSUFBSSxDQUFDLEtBQWU7UUFDN0IsSUFBSSxDQUFDLEtBQUssR0FBRyxLQUFLLENBQUM7SUFDckIsQ0FBQztJQUNNLFNBQVM7UUFDZCxJQUFJLENBQUMsS0FBSyxHQUFHLFNBQVMsQ0FBQztJQUN6QixDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsU0FBUztRQUNsQixPQUFPLElBQUksQ0FBQyxLQUFLLENBQUM7SUFDcEIsQ0FBQztJQUlELElBQVcsSUFBSTtRQUNiLG9EQUFvRDtRQUNwRCxPQUFPLEtBQUssQ0FBQyxLQUFLLENBQUMsS0FBSyxDQUFDLEtBQUssQ0FBQyxFQUFFLENBQUMsTUFBTSxDQUFDLElBQUksQ0FBQyx5QkFBeUIsQ0FBQyxNQUFNLENBQUMsQ0FBQyxDQUFDLENBQUM7SUFDcEYsQ0FBQztJQUNELElBQVcsSUFBSSxDQUFDLEtBQXlDO1FBQ3ZELElBQUksQ0FBQyxLQUFLLEdBQUcsS0FBSyxDQUFDO0lBQ3JCLENBQUM7SUFDTSxTQUFTO1FBQ2QsSUFBSSxDQUFDLEtBQUssR0FBRyxTQUFTLENBQUM7SUFDekIsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLFNBQVM7UUFDbEIsT0FBTyxJQUFJLENBQUMsS0FBSyxDQUFDO0lBQ3BCLENBQUM7SUFFRCxpRUFBaUU7SUFDakUsSUFBVyxVQUFVO1FBQ25CLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLGFBQWEsQ0FBQyxDQUFDO0lBQ2hELENBQUM7SUFJRCxJQUFXLGdCQUFnQjtRQUN6QixPQUFPLElBQUksQ0FBQyxpQkFBaUIsQ0FBQztJQUNoQyxDQUFDO0lBQ00sbUJBQW1CLENBQUMsS0FBK0I7UUFDeEQsSUFBSSxDQUFDLGlCQUFpQixDQUFDLGFBQWEsR0FBRyxLQUFLLENBQUM7SUFDL0MsQ0FBQztJQUNNLHFCQUFxQjtRQUMxQixJQUFJLENBQUMsaUJBQWlCLENBQUMsYUFBYSxHQUFHLFNBQVMsQ0FBQztJQUNuRCxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcscUJBQXFCO1FBQzlCLE9BQU8sSUFBSSxDQUFDLGlCQUFpQixDQUFDLGFBQWEsQ0FBQztJQUM5QyxDQUFDO0lBRUQsWUFBWTtJQUNaLFlBQVk7SUFDWixZQUFZO0lBRUYsb0JBQW9CO1FBQzVCLE9BQU87WUFDTCxjQUFjLEVBQUUsS0FBSyxDQUFDLGtCQUFrQixDQUFDLElBQUksQ0FBQyxjQUFjLENBQUM7WUFDN0Qsb0JBQW9CLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLElBQUksQ0FBQyxvQkFBb0IsQ0FBQztZQUN4RSwwQkFBMEIsRUFBRSxLQUFLLENBQUMsa0JBQWtCLENBQUMsSUFBSSxDQUFDLHlCQUF5QixDQUFDO1lBQ3BGLHdDQUF3QyxFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxJQUFJLENBQUMscUNBQXFDLENBQUM7WUFDN0csVUFBVSxFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxJQUFJLENBQUMsVUFBVSxDQUFDO1lBQ3BELGNBQWMsRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsSUFBSSxDQUFDLGNBQWMsQ0FBQztZQUM1RCxXQUFXLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLElBQUksQ0FBQyxZQUFZLENBQUM7WUFDdkQsSUFBSSxFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDO1lBQ3pDLFVBQVUsRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsSUFBSSxDQUFDLFdBQVcsQ0FBQztZQUNyRCx3QkFBd0IsRUFBRSxLQUFLLENBQUMsa0JBQWtCLENBQUMsSUFBSSxDQUFDLHVCQUF1QixDQUFDO1lBQ2hGLHNDQUFzQyxFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxJQUFJLENBQUMsbUNBQW1DLENBQUM7WUFDekcsS0FBSyxFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxJQUFJLENBQUMsTUFBTSxDQUFDO1lBQzNDLElBQUksRUFBRSxLQUFLLENBQUMsVUFBVSxDQUFDLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUM7WUFDM0QsSUFBSSxFQUFFLEtBQUssQ0FBQyxVQUFVLENBQUMsdUJBQXVCLENBQUMsQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDO1lBQzNELGlCQUFpQixFQUFFLG1DQUFtQyxDQUFDLElBQUksQ0FBQyxpQkFBaUIsQ0FBQyxhQUFhLENBQUM7U0FDN0YsQ0FBQztJQUNKLENBQUM7O0FBdFVILDRCQXVVQzs7O0FBclVDLG9CQUFvQjtBQUNwQixvQkFBb0I7QUFDcEIsb0JBQW9CO0FBQ0csdUJBQWMsR0FBRyxvQkFBb0IsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbIi8vIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9idWlsZGtpdGUvci9waXBlbGluZVxuLy8gZ2VuZXJhdGVkIGZyb20gdGVycmFmb3JtIHJlc291cmNlIHNjaGVtYVxuXG5pbXBvcnQgeyBDb25zdHJ1Y3QgfSBmcm9tICdjb25zdHJ1Y3RzJztcbmltcG9ydCAqIGFzIGNka3RmIGZyb20gJ2Nka3RmJztcblxuLy8gQ29uZmlndXJhdGlvblxuXG5leHBvcnQgaW50ZXJmYWNlIFBpcGVsaW5lQ29uZmlnIGV4dGVuZHMgY2RrdGYuVGVycmFmb3JtTWV0YUFyZ3VtZW50cyB7XG4gIC8qKlxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL2J1aWxka2l0ZS9yL3BpcGVsaW5lI2FsbG93X3JlYnVpbGRzIFBpcGVsaW5lI2FsbG93X3JlYnVpbGRzfVxuICAqL1xuICByZWFkb25seSBhbGxvd1JlYnVpbGRzPzogYm9vbGVhbiB8IGNka3RmLklSZXNvbHZhYmxlO1xuICAvKipcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9idWlsZGtpdGUvci9waXBlbGluZSNicmFuY2hfY29uZmlndXJhdGlvbiBQaXBlbGluZSNicmFuY2hfY29uZmlndXJhdGlvbn1cbiAgKi9cbiAgcmVhZG9ubHkgYnJhbmNoQ29uZmlndXJhdGlvbj86IHN0cmluZztcbiAgLyoqXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvYnVpbGRraXRlL3IvcGlwZWxpbmUjY2FuY2VsX2ludGVybWVkaWF0ZV9idWlsZHMgUGlwZWxpbmUjY2FuY2VsX2ludGVybWVkaWF0ZV9idWlsZHN9XG4gICovXG4gIHJlYWRvbmx5IGNhbmNlbEludGVybWVkaWF0ZUJ1aWxkcz86IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZTtcbiAgLyoqXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvYnVpbGRraXRlL3IvcGlwZWxpbmUjY2FuY2VsX2ludGVybWVkaWF0ZV9idWlsZHNfYnJhbmNoX2ZpbHRlciBQaXBlbGluZSNjYW5jZWxfaW50ZXJtZWRpYXRlX2J1aWxkc19icmFuY2hfZmlsdGVyfVxuICAqL1xuICByZWFkb25seSBjYW5jZWxJbnRlcm1lZGlhdGVCdWlsZHNCcmFuY2hGaWx0ZXI/OiBzdHJpbmc7XG4gIC8qKlxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL2J1aWxka2l0ZS9yL3BpcGVsaW5lI2NsdXN0ZXJfaWQgUGlwZWxpbmUjY2x1c3Rlcl9pZH1cbiAgKi9cbiAgcmVhZG9ubHkgY2x1c3RlcklkPzogc3RyaW5nO1xuICAvKipcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9idWlsZGtpdGUvci9waXBlbGluZSNkZWZhdWx0X2JyYW5jaCBQaXBlbGluZSNkZWZhdWx0X2JyYW5jaH1cbiAgKi9cbiAgcmVhZG9ubHkgZGVmYXVsdEJyYW5jaD86IHN0cmluZztcbiAgLyoqXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvYnVpbGRraXRlL3IvcGlwZWxpbmUjZGVzY3JpcHRpb24gUGlwZWxpbmUjZGVzY3JpcHRpb259XG4gICovXG4gIHJlYWRvbmx5IGRlc2NyaXB0aW9uPzogc3RyaW5nO1xuICAvKipcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9idWlsZGtpdGUvci9waXBlbGluZSNuYW1lIFBpcGVsaW5lI25hbWV9XG4gICovXG4gIHJlYWRvbmx5IG5hbWU6IHN0cmluZztcbiAgLyoqXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvYnVpbGRraXRlL3IvcGlwZWxpbmUjcmVwb3NpdG9yeSBQaXBlbGluZSNyZXBvc2l0b3J5fVxuICAqL1xuICByZWFkb25seSByZXBvc2l0b3J5OiBzdHJpbmc7XG4gIC8qKlxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL2J1aWxka2l0ZS9yL3BpcGVsaW5lI3NraXBfaW50ZXJtZWRpYXRlX2J1aWxkcyBQaXBlbGluZSNza2lwX2ludGVybWVkaWF0ZV9idWlsZHN9XG4gICovXG4gIHJlYWRvbmx5IHNraXBJbnRlcm1lZGlhdGVCdWlsZHM/OiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGU7XG4gIC8qKlxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL2J1aWxka2l0ZS9yL3BpcGVsaW5lI3NraXBfaW50ZXJtZWRpYXRlX2J1aWxkc19icmFuY2hfZmlsdGVyIFBpcGVsaW5lI3NraXBfaW50ZXJtZWRpYXRlX2J1aWxkc19icmFuY2hfZmlsdGVyfVxuICAqL1xuICByZWFkb25seSBza2lwSW50ZXJtZWRpYXRlQnVpbGRzQnJhbmNoRmlsdGVyPzogc3RyaW5nO1xuICAvKipcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9idWlsZGtpdGUvci9waXBlbGluZSNzdGVwcyBQaXBlbGluZSNzdGVwc31cbiAgKi9cbiAgcmVhZG9ubHkgc3RlcHM6IHN0cmluZztcbiAgLyoqXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvYnVpbGRraXRlL3IvcGlwZWxpbmUjdGFncyBQaXBlbGluZSN0YWdzfVxuICAqL1xuICByZWFkb25seSB0YWdzPzogc3RyaW5nW107XG4gIC8qKlxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL2J1aWxka2l0ZS9yL3BpcGVsaW5lI3RlYW0gUGlwZWxpbmUjdGVhbX1cbiAgKi9cbiAgcmVhZG9ubHkgdGVhbT86IFBpcGVsaW5lVGVhbVtdIHwgY2RrdGYuSVJlc29sdmFibGU7XG4gIC8qKlxuICAqIHByb3ZpZGVyX3NldHRpbmdzIGJsb2NrXG4gICogXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvYnVpbGRraXRlL3IvcGlwZWxpbmUjcHJvdmlkZXJfc2V0dGluZ3MgUGlwZWxpbmUjcHJvdmlkZXJfc2V0dGluZ3N9XG4gICovXG4gIHJlYWRvbmx5IHByb3ZpZGVyU2V0dGluZ3M/OiBQaXBlbGluZVByb3ZpZGVyU2V0dGluZ3M7XG59XG5leHBvcnQgaW50ZXJmYWNlIFBpcGVsaW5lVGVhbSB7XG4gIC8qKlxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL2J1aWxka2l0ZS9yL3BpcGVsaW5lI2FjY2Vzc19sZXZlbCBQaXBlbGluZSNhY2Nlc3NfbGV2ZWx9XG4gICovXG4gIHJlYWRvbmx5IGFjY2Vzc0xldmVsPzogc3RyaW5nO1xuICAvKipcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9idWlsZGtpdGUvci9waXBlbGluZSNzbHVnIFBpcGVsaW5lI3NsdWd9XG4gICovXG4gIHJlYWRvbmx5IHNsdWc/OiBzdHJpbmc7XG59XG5cbmV4cG9ydCBmdW5jdGlvbiBwaXBlbGluZVRlYW1Ub1RlcnJhZm9ybShzdHJ1Y3Q/OiBQaXBlbGluZVRlYW0gfCBjZGt0Zi5JUmVzb2x2YWJsZSk6IGFueSB7XG4gIGlmICghY2RrdGYuY2FuSW5zcGVjdChzdHJ1Y3QpIHx8IGNka3RmLlRva2VuaXphdGlvbi5pc1Jlc29sdmFibGUoc3RydWN0KSkgeyByZXR1cm4gc3RydWN0OyB9XG4gIGlmIChjZGt0Zi5pc0NvbXBsZXhFbGVtZW50KHN0cnVjdCkpIHtcbiAgICB0aHJvdyBuZXcgRXJyb3IoXCJBIGNvbXBsZXggZWxlbWVudCB3YXMgdXNlZCBhcyBjb25maWd1cmF0aW9uLCB0aGlzIGlzIG5vdCBzdXBwb3J0ZWQ6IGh0dHBzOi8vY2RrLnRmL2NvbXBsZXgtb2JqZWN0LWFzLWNvbmZpZ3VyYXRpb25cIik7XG4gIH1cbiAgcmV0dXJuIHtcbiAgICBhY2Nlc3NfbGV2ZWw6IGNka3RmLnN0cmluZ1RvVGVycmFmb3JtKHN0cnVjdCEuYWNjZXNzTGV2ZWwpLFxuICAgIHNsdWc6IGNka3RmLnN0cmluZ1RvVGVycmFmb3JtKHN0cnVjdCEuc2x1ZyksXG4gIH1cbn1cblxuZXhwb3J0IGludGVyZmFjZSBQaXBlbGluZVByb3ZpZGVyU2V0dGluZ3Mge1xuICAvKipcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9idWlsZGtpdGUvci9waXBlbGluZSNidWlsZF9icmFuY2hlcyBQaXBlbGluZSNidWlsZF9icmFuY2hlc31cbiAgKi9cbiAgcmVhZG9ubHkgYnVpbGRCcmFuY2hlcz86IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZTtcbiAgLyoqXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvYnVpbGRraXRlL3IvcGlwZWxpbmUjYnVpbGRfcHVsbF9yZXF1ZXN0X2ZvcmtzIFBpcGVsaW5lI2J1aWxkX3B1bGxfcmVxdWVzdF9mb3Jrc31cbiAgKi9cbiAgcmVhZG9ubHkgYnVpbGRQdWxsUmVxdWVzdEZvcmtzPzogYm9vbGVhbiB8IGNka3RmLklSZXNvbHZhYmxlO1xuICAvKipcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9idWlsZGtpdGUvci9waXBlbGluZSNidWlsZF9wdWxsX3JlcXVlc3RfbGFiZWxzX2NoYW5nZWQgUGlwZWxpbmUjYnVpbGRfcHVsbF9yZXF1ZXN0X2xhYmVsc19jaGFuZ2VkfVxuICAqL1xuICByZWFkb25seSBidWlsZFB1bGxSZXF1ZXN0TGFiZWxzQ2hhbmdlZD86IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZTtcbiAgLyoqXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvYnVpbGRraXRlL3IvcGlwZWxpbmUjYnVpbGRfcHVsbF9yZXF1ZXN0X3JlYWR5X2Zvcl9yZXZpZXcgUGlwZWxpbmUjYnVpbGRfcHVsbF9yZXF1ZXN0X3JlYWR5X2Zvcl9yZXZpZXd9XG4gICovXG4gIHJlYWRvbmx5IGJ1aWxkUHVsbFJlcXVlc3RSZWFkeUZvclJldmlldz86IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZTtcbiAgLyoqXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvYnVpbGRraXRlL3IvcGlwZWxpbmUjYnVpbGRfcHVsbF9yZXF1ZXN0cyBQaXBlbGluZSNidWlsZF9wdWxsX3JlcXVlc3RzfVxuICAqL1xuICByZWFkb25seSBidWlsZFB1bGxSZXF1ZXN0cz86IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZTtcbiAgLyoqXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvYnVpbGRraXRlL3IvcGlwZWxpbmUjYnVpbGRfdGFncyBQaXBlbGluZSNidWlsZF90YWdzfVxuICAqL1xuICByZWFkb25seSBidWlsZFRhZ3M/OiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGU7XG4gIC8qKlxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL2J1aWxka2l0ZS9yL3BpcGVsaW5lI2NhbmNlbF9kZWxldGVkX2JyYW5jaF9idWlsZHMgUGlwZWxpbmUjY2FuY2VsX2RlbGV0ZWRfYnJhbmNoX2J1aWxkc31cbiAgKi9cbiAgcmVhZG9ubHkgY2FuY2VsRGVsZXRlZEJyYW5jaEJ1aWxkcz86IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZTtcbiAgLyoqXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvYnVpbGRraXRlL3IvcGlwZWxpbmUjZmlsdGVyX2NvbmRpdGlvbiBQaXBlbGluZSNmaWx0ZXJfY29uZGl0aW9ufVxuICAqL1xuICByZWFkb25seSBmaWx0ZXJDb25kaXRpb24/OiBzdHJpbmc7XG4gIC8qKlxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL2J1aWxka2l0ZS9yL3BpcGVsaW5lI2ZpbHRlcl9lbmFibGVkIFBpcGVsaW5lI2ZpbHRlcl9lbmFibGVkfVxuICAqL1xuICByZWFkb25seSBmaWx0ZXJFbmFibGVkPzogYm9vbGVhbiB8IGNka3RmLklSZXNvbHZhYmxlO1xuICAvKipcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9idWlsZGtpdGUvci9waXBlbGluZSNwcmVmaXhfcHVsbF9yZXF1ZXN0X2ZvcmtfYnJhbmNoX25hbWVzIFBpcGVsaW5lI3ByZWZpeF9wdWxsX3JlcXVlc3RfZm9ya19icmFuY2hfbmFtZXN9XG4gICovXG4gIHJlYWRvbmx5IHByZWZpeFB1bGxSZXF1ZXN0Rm9ya0JyYW5jaE5hbWVzPzogYm9vbGVhbiB8IGNka3RmLklSZXNvbHZhYmxlO1xuICAvKipcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9idWlsZGtpdGUvci9waXBlbGluZSNwdWJsaXNoX2Jsb2NrZWRfYXNfcGVuZGluZyBQaXBlbGluZSNwdWJsaXNoX2Jsb2NrZWRfYXNfcGVuZGluZ31cbiAgKi9cbiAgcmVhZG9ubHkgcHVibGlzaEJsb2NrZWRBc1BlbmRpbmc/OiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGU7XG4gIC8qKlxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL2J1aWxka2l0ZS9yL3BpcGVsaW5lI3B1Ymxpc2hfY29tbWl0X3N0YXR1cyBQaXBlbGluZSNwdWJsaXNoX2NvbW1pdF9zdGF0dXN9XG4gICovXG4gIHJlYWRvbmx5IHB1Ymxpc2hDb21taXRTdGF0dXM/OiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGU7XG4gIC8qKlxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL2J1aWxka2l0ZS9yL3BpcGVsaW5lI3B1Ymxpc2hfY29tbWl0X3N0YXR1c19wZXJfc3RlcCBQaXBlbGluZSNwdWJsaXNoX2NvbW1pdF9zdGF0dXNfcGVyX3N0ZXB9XG4gICovXG4gIHJlYWRvbmx5IHB1Ymxpc2hDb21taXRTdGF0dXNQZXJTdGVwPzogYm9vbGVhbiB8IGNka3RmLklSZXNvbHZhYmxlO1xuICAvKipcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9idWlsZGtpdGUvci9waXBlbGluZSNwdWxsX3JlcXVlc3RfYnJhbmNoX2ZpbHRlcl9jb25maWd1cmF0aW9uIFBpcGVsaW5lI3B1bGxfcmVxdWVzdF9icmFuY2hfZmlsdGVyX2NvbmZpZ3VyYXRpb259XG4gICovXG4gIHJlYWRvbmx5IHB1bGxSZXF1ZXN0QnJhbmNoRmlsdGVyQ29uZmlndXJhdGlvbj86IHN0cmluZztcbiAgLyoqXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvYnVpbGRraXRlL3IvcGlwZWxpbmUjcHVsbF9yZXF1ZXN0X2JyYW5jaF9maWx0ZXJfZW5hYmxlZCBQaXBlbGluZSNwdWxsX3JlcXVlc3RfYnJhbmNoX2ZpbHRlcl9lbmFibGVkfVxuICAqL1xuICByZWFkb25seSBwdWxsUmVxdWVzdEJyYW5jaEZpbHRlckVuYWJsZWQ/OiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGU7XG4gIC8qKlxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL2J1aWxka2l0ZS9yL3BpcGVsaW5lI3NlcGFyYXRlX3B1bGxfcmVxdWVzdF9zdGF0dXNlcyBQaXBlbGluZSNzZXBhcmF0ZV9wdWxsX3JlcXVlc3Rfc3RhdHVzZXN9XG4gICovXG4gIHJlYWRvbmx5IHNlcGFyYXRlUHVsbFJlcXVlc3RTdGF0dXNlcz86IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZTtcbiAgLyoqXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvYnVpbGRraXRlL3IvcGlwZWxpbmUjc2tpcF9wdWxsX3JlcXVlc3RfYnVpbGRzX2Zvcl9leGlzdGluZ19jb21taXRzIFBpcGVsaW5lI3NraXBfcHVsbF9yZXF1ZXN0X2J1aWxkc19mb3JfZXhpc3RpbmdfY29tbWl0c31cbiAgKi9cbiAgcmVhZG9ubHkgc2tpcFB1bGxSZXF1ZXN0QnVpbGRzRm9yRXhpc3RpbmdDb21taXRzPzogYm9vbGVhbiB8IGNka3RmLklSZXNvbHZhYmxlO1xuICAvKipcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9idWlsZGtpdGUvci9waXBlbGluZSN0cmlnZ2VyX21vZGUgUGlwZWxpbmUjdHJpZ2dlcl9tb2RlfVxuICAqL1xuICByZWFkb25seSB0cmlnZ2VyTW9kZT86IHN0cmluZztcbn1cblxuZXhwb3J0IGZ1bmN0aW9uIHBpcGVsaW5lUHJvdmlkZXJTZXR0aW5nc1RvVGVycmFmb3JtKHN0cnVjdD86IFBpcGVsaW5lUHJvdmlkZXJTZXR0aW5nc091dHB1dFJlZmVyZW5jZSB8IFBpcGVsaW5lUHJvdmlkZXJTZXR0aW5ncyk6IGFueSB7XG4gIGlmICghY2RrdGYuY2FuSW5zcGVjdChzdHJ1Y3QpIHx8IGNka3RmLlRva2VuaXphdGlvbi5pc1Jlc29sdmFibGUoc3RydWN0KSkgeyByZXR1cm4gc3RydWN0OyB9XG4gIGlmIChjZGt0Zi5pc0NvbXBsZXhFbGVtZW50KHN0cnVjdCkpIHtcbiAgICB0aHJvdyBuZXcgRXJyb3IoXCJBIGNvbXBsZXggZWxlbWVudCB3YXMgdXNlZCBhcyBjb25maWd1cmF0aW9uLCB0aGlzIGlzIG5vdCBzdXBwb3J0ZWQ6IGh0dHBzOi8vY2RrLnRmL2NvbXBsZXgtb2JqZWN0LWFzLWNvbmZpZ3VyYXRpb25cIik7XG4gIH1cbiAgcmV0dXJuIHtcbiAgICBidWlsZF9icmFuY2hlczogY2RrdGYuYm9vbGVhblRvVGVycmFmb3JtKHN0cnVjdCEuYnVpbGRCcmFuY2hlcyksXG4gICAgYnVpbGRfcHVsbF9yZXF1ZXN0X2ZvcmtzOiBjZGt0Zi5ib29sZWFuVG9UZXJyYWZvcm0oc3RydWN0IS5idWlsZFB1bGxSZXF1ZXN0Rm9ya3MpLFxuICAgIGJ1aWxkX3B1bGxfcmVxdWVzdF9sYWJlbHNfY2hhbmdlZDogY2RrdGYuYm9vbGVhblRvVGVycmFmb3JtKHN0cnVjdCEuYnVpbGRQdWxsUmVxdWVzdExhYmVsc0NoYW5nZWQpLFxuICAgIGJ1aWxkX3B1bGxfcmVxdWVzdF9yZWFkeV9mb3JfcmV2aWV3OiBjZGt0Zi5ib29sZWFuVG9UZXJyYWZvcm0oc3RydWN0IS5idWlsZFB1bGxSZXF1ZXN0UmVhZHlGb3JSZXZpZXcpLFxuICAgIGJ1aWxkX3B1bGxfcmVxdWVzdHM6IGNka3RmLmJvb2xlYW5Ub1RlcnJhZm9ybShzdHJ1Y3QhLmJ1aWxkUHVsbFJlcXVlc3RzKSxcbiAgICBidWlsZF90YWdzOiBjZGt0Zi5ib29sZWFuVG9UZXJyYWZvcm0oc3RydWN0IS5idWlsZFRhZ3MpLFxuICAgIGNhbmNlbF9kZWxldGVkX2JyYW5jaF9idWlsZHM6IGNka3RmLmJvb2xlYW5Ub1RlcnJhZm9ybShzdHJ1Y3QhLmNhbmNlbERlbGV0ZWRCcmFuY2hCdWlsZHMpLFxuICAgIGZpbHRlcl9jb25kaXRpb246IGNka3RmLnN0cmluZ1RvVGVycmFmb3JtKHN0cnVjdCEuZmlsdGVyQ29uZGl0aW9uKSxcbiAgICBmaWx0ZXJfZW5hYmxlZDogY2RrdGYuYm9vbGVhblRvVGVycmFmb3JtKHN0cnVjdCEuZmlsdGVyRW5hYmxlZCksXG4gICAgcHJlZml4X3B1bGxfcmVxdWVzdF9mb3JrX2JyYW5jaF9uYW1lczogY2RrdGYuYm9vbGVhblRvVGVycmFmb3JtKHN0cnVjdCEucHJlZml4UHVsbFJlcXVlc3RGb3JrQnJhbmNoTmFtZXMpLFxuICAgIHB1Ymxpc2hfYmxvY2tlZF9hc19wZW5kaW5nOiBjZGt0Zi5ib29sZWFuVG9UZXJyYWZvcm0oc3RydWN0IS5wdWJsaXNoQmxvY2tlZEFzUGVuZGluZyksXG4gICAgcHVibGlzaF9jb21taXRfc3RhdHVzOiBjZGt0Zi5ib29sZWFuVG9UZXJyYWZvcm0oc3RydWN0IS5wdWJsaXNoQ29tbWl0U3RhdHVzKSxcbiAgICBwdWJsaXNoX2NvbW1pdF9zdGF0dXNfcGVyX3N0ZXA6IGNka3RmLmJvb2xlYW5Ub1RlcnJhZm9ybShzdHJ1Y3QhLnB1Ymxpc2hDb21taXRTdGF0dXNQZXJTdGVwKSxcbiAgICBwdWxsX3JlcXVlc3RfYnJhbmNoX2ZpbHRlcl9jb25maWd1cmF0aW9uOiBjZGt0Zi5zdHJpbmdUb1RlcnJhZm9ybShzdHJ1Y3QhLnB1bGxSZXF1ZXN0QnJhbmNoRmlsdGVyQ29uZmlndXJhdGlvbiksXG4gICAgcHVsbF9yZXF1ZXN0X2JyYW5jaF9maWx0ZXJfZW5hYmxlZDogY2RrdGYuYm9vbGVhblRvVGVycmFmb3JtKHN0cnVjdCEucHVsbFJlcXVlc3RCcmFuY2hGaWx0ZXJFbmFibGVkKSxcbiAgICBzZXBhcmF0ZV9wdWxsX3JlcXVlc3Rfc3RhdHVzZXM6IGNka3RmLmJvb2xlYW5Ub1RlcnJhZm9ybShzdHJ1Y3QhLnNlcGFyYXRlUHVsbFJlcXVlc3RTdGF0dXNlcyksXG4gICAgc2tpcF9wdWxsX3JlcXVlc3RfYnVpbGRzX2Zvcl9leGlzdGluZ19jb21taXRzOiBjZGt0Zi5ib29sZWFuVG9UZXJyYWZvcm0oc3RydWN0IS5za2lwUHVsbFJlcXVlc3RCdWlsZHNGb3JFeGlzdGluZ0NvbW1pdHMpLFxuICAgIHRyaWdnZXJfbW9kZTogY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0oc3RydWN0IS50cmlnZ2VyTW9kZSksXG4gIH1cbn1cblxuZXhwb3J0IGNsYXNzIFBpcGVsaW5lUHJvdmlkZXJTZXR0aW5nc091dHB1dFJlZmVyZW5jZSBleHRlbmRzIGNka3RmLkNvbXBsZXhPYmplY3Qge1xuICBwcml2YXRlIGlzRW1wdHlPYmplY3QgPSBmYWxzZTtcblxuICAvKipcbiAgKiBAcGFyYW0gdGVycmFmb3JtUmVzb3VyY2UgVGhlIHBhcmVudCByZXNvdXJjZVxuICAqIEBwYXJhbSB0ZXJyYWZvcm1BdHRyaWJ1dGUgVGhlIGF0dHJpYnV0ZSBvbiB0aGUgcGFyZW50IHJlc291cmNlIHRoaXMgY2xhc3MgaXMgcmVmZXJlbmNpbmdcbiAgKi9cbiAgcHVibGljIGNvbnN0cnVjdG9yKHRlcnJhZm9ybVJlc291cmNlOiBjZGt0Zi5JSW50ZXJwb2xhdGluZ1BhcmVudCwgdGVycmFmb3JtQXR0cmlidXRlOiBzdHJpbmcpIHtcbiAgICBzdXBlcih0ZXJyYWZvcm1SZXNvdXJjZSwgdGVycmFmb3JtQXR0cmlidXRlLCBmYWxzZSwgMCk7XG4gIH1cblxuICBwdWJsaWMgZ2V0IGludGVybmFsVmFsdWUoKTogUGlwZWxpbmVQcm92aWRlclNldHRpbmdzIHwgdW5kZWZpbmVkIHtcbiAgICBsZXQgaGFzQW55VmFsdWVzID0gdGhpcy5pc0VtcHR5T2JqZWN0O1xuICAgIGNvbnN0IGludGVybmFsVmFsdWVSZXN1bHQ6IGFueSA9IHt9O1xuICAgIGlmICh0aGlzLl9idWlsZEJyYW5jaGVzICE9PSB1bmRlZmluZWQpIHtcbiAgICAgIGhhc0FueVZhbHVlcyA9IHRydWU7XG4gICAgICBpbnRlcm5hbFZhbHVlUmVzdWx0LmJ1aWxkQnJhbmNoZXMgPSB0aGlzLl9idWlsZEJyYW5jaGVzO1xuICAgIH1cbiAgICBpZiAodGhpcy5fYnVpbGRQdWxsUmVxdWVzdEZvcmtzICE9PSB1bmRlZmluZWQpIHtcbiAgICAgIGhhc0FueVZhbHVlcyA9IHRydWU7XG4gICAgICBpbnRlcm5hbFZhbHVlUmVzdWx0LmJ1aWxkUHVsbFJlcXVlc3RGb3JrcyA9IHRoaXMuX2J1aWxkUHVsbFJlcXVlc3RGb3JrcztcbiAgICB9XG4gICAgaWYgKHRoaXMuX2J1aWxkUHVsbFJlcXVlc3RMYWJlbHNDaGFuZ2VkICE9PSB1bmRlZmluZWQpIHtcbiAgICAgIGhhc0FueVZhbHVlcyA9IHRydWU7XG4gICAgICBpbnRlcm5hbFZhbHVlUmVzdWx0LmJ1aWxkUHVsbFJlcXVlc3RMYWJlbHNDaGFuZ2VkID0gdGhpcy5fYnVpbGRQdWxsUmVxdWVzdExhYmVsc0NoYW5nZWQ7XG4gICAgfVxuICAgIGlmICh0aGlzLl9idWlsZFB1bGxSZXF1ZXN0UmVhZHlGb3JSZXZpZXcgIT09IHVuZGVmaW5lZCkge1xuICAgICAgaGFzQW55VmFsdWVzID0gdHJ1ZTtcbiAgICAgIGludGVybmFsVmFsdWVSZXN1bHQuYnVpbGRQdWxsUmVxdWVzdFJlYWR5Rm9yUmV2aWV3ID0gdGhpcy5fYnVpbGRQdWxsUmVxdWVzdFJlYWR5Rm9yUmV2aWV3O1xuICAgIH1cbiAgICBpZiAodGhpcy5fYnVpbGRQdWxsUmVxdWVzdHMgIT09IHVuZGVmaW5lZCkge1xuICAgICAgaGFzQW55VmFsdWVzID0gdHJ1ZTtcbiAgICAgIGludGVybmFsVmFsdWVSZXN1bHQuYnVpbGRQdWxsUmVxdWVzdHMgPSB0aGlzLl9idWlsZFB1bGxSZXF1ZXN0cztcbiAgICB9XG4gICAgaWYgKHRoaXMuX2J1aWxkVGFncyAhPT0gdW5kZWZpbmVkKSB7XG4gICAgICBoYXNBbnlWYWx1ZXMgPSB0cnVlO1xuICAgICAgaW50ZXJuYWxWYWx1ZVJlc3VsdC5idWlsZFRhZ3MgPSB0aGlzLl9idWlsZFRhZ3M7XG4gICAgfVxuICAgIGlmICh0aGlzLl9jYW5jZWxEZWxldGVkQnJhbmNoQnVpbGRzICE9PSB1bmRlZmluZWQpIHtcbiAgICAgIGhhc0FueVZhbHVlcyA9IHRydWU7XG4gICAgICBpbnRlcm5hbFZhbHVlUmVzdWx0LmNhbmNlbERlbGV0ZWRCcmFuY2hCdWlsZHMgPSB0aGlzLl9jYW5jZWxEZWxldGVkQnJhbmNoQnVpbGRzO1xuICAgIH1cbiAgICBpZiAodGhpcy5fZmlsdGVyQ29uZGl0aW9uICE9PSB1bmRlZmluZWQpIHtcbiAgICAgIGhhc0FueVZhbHVlcyA9IHRydWU7XG4gICAgICBpbnRlcm5hbFZhbHVlUmVzdWx0LmZpbHRlckNvbmRpdGlvbiA9IHRoaXMuX2ZpbHRlckNvbmRpdGlvbjtcbiAgICB9XG4gICAgaWYgKHRoaXMuX2ZpbHRlckVuYWJsZWQgIT09IHVuZGVmaW5lZCkge1xuICAgICAgaGFzQW55VmFsdWVzID0gdHJ1ZTtcbiAgICAgIGludGVybmFsVmFsdWVSZXN1bHQuZmlsdGVyRW5hYmxlZCA9IHRoaXMuX2ZpbHRlckVuYWJsZWQ7XG4gICAgfVxuICAgIGlmICh0aGlzLl9wcmVmaXhQdWxsUmVxdWVzdEZvcmtCcmFuY2hOYW1lcyAhPT0gdW5kZWZpbmVkKSB7XG4gICAgICBoYXNBbnlWYWx1ZXMgPSB0cnVlO1xuICAgICAgaW50ZXJuYWxWYWx1ZVJlc3VsdC5wcmVmaXhQdWxsUmVxdWVzdEZvcmtCcmFuY2hOYW1lcyA9IHRoaXMuX3ByZWZpeFB1bGxSZXF1ZXN0Rm9ya0JyYW5jaE5hbWVzO1xuICAgIH1cbiAgICBpZiAodGhpcy5fcHVibGlzaEJsb2NrZWRBc1BlbmRpbmcgIT09IHVuZGVmaW5lZCkge1xuICAgICAgaGFzQW55VmFsdWVzID0gdHJ1ZTtcbiAgICAgIGludGVybmFsVmFsdWVSZXN1bHQucHVibGlzaEJsb2NrZWRBc1BlbmRpbmcgPSB0aGlzLl9wdWJsaXNoQmxvY2tlZEFzUGVuZGluZztcbiAgICB9XG4gICAgaWYgKHRoaXMuX3B1Ymxpc2hDb21taXRTdGF0dXMgIT09IHVuZGVmaW5lZCkge1xuICAgICAgaGFzQW55VmFsdWVzID0gdHJ1ZTtcbiAgICAgIGludGVybmFsVmFsdWVSZXN1bHQucHVibGlzaENvbW1pdFN0YXR1cyA9IHRoaXMuX3B1Ymxpc2hDb21taXRTdGF0dXM7XG4gICAgfVxuICAgIGlmICh0aGlzLl9wdWJsaXNoQ29tbWl0U3RhdHVzUGVyU3RlcCAhPT0gdW5kZWZpbmVkKSB7XG4gICAgICBoYXNBbnlWYWx1ZXMgPSB0cnVlO1xuICAgICAgaW50ZXJuYWxWYWx1ZVJlc3VsdC5wdWJsaXNoQ29tbWl0U3RhdHVzUGVyU3RlcCA9IHRoaXMuX3B1Ymxpc2hDb21taXRTdGF0dXNQZXJTdGVwO1xuICAgIH1cbiAgICBpZiAodGhpcy5fcHVsbFJlcXVlc3RCcmFuY2hGaWx0ZXJDb25maWd1cmF0aW9uICE9PSB1bmRlZmluZWQpIHtcbiAgICAgIGhhc0FueVZhbHVlcyA9IHRydWU7XG4gICAgICBpbnRlcm5hbFZhbHVlUmVzdWx0LnB1bGxSZXF1ZXN0QnJhbmNoRmlsdGVyQ29uZmlndXJhdGlvbiA9IHRoaXMuX3B1bGxSZXF1ZXN0QnJhbmNoRmlsdGVyQ29uZmlndXJhdGlvbjtcbiAgICB9XG4gICAgaWYgKHRoaXMuX3B1bGxSZXF1ZXN0QnJhbmNoRmlsdGVyRW5hYmxlZCAhPT0gdW5kZWZpbmVkKSB7XG4gICAgICBoYXNBbnlWYWx1ZXMgPSB0cnVlO1xuICAgICAgaW50ZXJuYWxWYWx1ZVJlc3VsdC5wdWxsUmVxdWVzdEJyYW5jaEZpbHRlckVuYWJsZWQgPSB0aGlzLl9wdWxsUmVxdWVzdEJyYW5jaEZpbHRlckVuYWJsZWQ7XG4gICAgfVxuICAgIGlmICh0aGlzLl9zZXBhcmF0ZVB1bGxSZXF1ZXN0U3RhdHVzZXMgIT09IHVuZGVmaW5lZCkge1xuICAgICAgaGFzQW55VmFsdWVzID0gdHJ1ZTtcbiAgICAgIGludGVybmFsVmFsdWVSZXN1bHQuc2VwYXJhdGVQdWxsUmVxdWVzdFN0YXR1c2VzID0gdGhpcy5fc2VwYXJhdGVQdWxsUmVxdWVzdFN0YXR1c2VzO1xuICAgIH1cbiAgICBpZiAodGhpcy5fc2tpcFB1bGxSZXF1ZXN0QnVpbGRzRm9yRXhpc3RpbmdDb21taXRzICE9PSB1bmRlZmluZWQpIHtcbiAgICAgIGhhc0FueVZhbHVlcyA9IHRydWU7XG4gICAgICBpbnRlcm5hbFZhbHVlUmVzdWx0LnNraXBQdWxsUmVxdWVzdEJ1aWxkc0ZvckV4aXN0aW5nQ29tbWl0cyA9IHRoaXMuX3NraXBQdWxsUmVxdWVzdEJ1aWxkc0ZvckV4aXN0aW5nQ29tbWl0cztcbiAgICB9XG4gICAgaWYgKHRoaXMuX3RyaWdnZXJNb2RlICE9PSB1bmRlZmluZWQpIHtcbiAgICAgIGhhc0FueVZhbHVlcyA9IHRydWU7XG4gICAgICBpbnRlcm5hbFZhbHVlUmVzdWx0LnRyaWdnZXJNb2RlID0gdGhpcy5fdHJpZ2dlck1vZGU7XG4gICAgfVxuICAgIHJldHVybiBoYXNBbnlWYWx1ZXMgPyBpbnRlcm5hbFZhbHVlUmVzdWx0IDogdW5kZWZpbmVkO1xuICB9XG5cbiAgcHVibGljIHNldCBpbnRlcm5hbFZhbHVlKHZhbHVlOiBQaXBlbGluZVByb3ZpZGVyU2V0dGluZ3MgfCB1bmRlZmluZWQpIHtcbiAgICBpZiAodmFsdWUgPT09IHVuZGVmaW5lZCkge1xuICAgICAgdGhpcy5pc0VtcHR5T2JqZWN0ID0gZmFsc2U7XG4gICAgICB0aGlzLl9idWlsZEJyYW5jaGVzID0gdW5kZWZpbmVkO1xuICAgICAgdGhpcy5fYnVpbGRQdWxsUmVxdWVzdEZvcmtzID0gdW5kZWZpbmVkO1xuICAgICAgdGhpcy5fYnVpbGRQdWxsUmVxdWVzdExhYmVsc0NoYW5nZWQgPSB1bmRlZmluZWQ7XG4gICAgICB0aGlzLl9idWlsZFB1bGxSZXF1ZXN0UmVhZHlGb3JSZXZpZXcgPSB1bmRlZmluZWQ7XG4gICAgICB0aGlzLl9idWlsZFB1bGxSZXF1ZXN0cyA9IHVuZGVmaW5lZDtcbiAgICAgIHRoaXMuX2J1aWxkVGFncyA9IHVuZGVmaW5lZDtcbiAgICAgIHRoaXMuX2NhbmNlbERlbGV0ZWRCcmFuY2hCdWlsZHMgPSB1bmRlZmluZWQ7XG4gICAgICB0aGlzLl9maWx0ZXJDb25kaXRpb24gPSB1bmRlZmluZWQ7XG4gICAgICB0aGlzLl9maWx0ZXJFbmFibGVkID0gdW5kZWZpbmVkO1xuICAgICAgdGhpcy5fcHJlZml4UHVsbFJlcXVlc3RGb3JrQnJhbmNoTmFtZXMgPSB1bmRlZmluZWQ7XG4gICAgICB0aGlzLl9wdWJsaXNoQmxvY2tlZEFzUGVuZGluZyA9IHVuZGVmaW5lZDtcbiAgICAgIHRoaXMuX3B1Ymxpc2hDb21taXRTdGF0dXMgPSB1bmRlZmluZWQ7XG4gICAgICB0aGlzLl9wdWJsaXNoQ29tbWl0U3RhdHVzUGVyU3RlcCA9IHVuZGVmaW5lZDtcbiAgICAgIHRoaXMuX3B1bGxSZXF1ZXN0QnJhbmNoRmlsdGVyQ29uZmlndXJhdGlvbiA9IHVuZGVmaW5lZDtcbiAgICAgIHRoaXMuX3B1bGxSZXF1ZXN0QnJhbmNoRmlsdGVyRW5hYmxlZCA9IHVuZGVmaW5lZDtcbiAgICAgIHRoaXMuX3NlcGFyYXRlUHVsbFJlcXVlc3RTdGF0dXNlcyA9IHVuZGVmaW5lZDtcbiAgICAgIHRoaXMuX3NraXBQdWxsUmVxdWVzdEJ1aWxkc0ZvckV4aXN0aW5nQ29tbWl0cyA9IHVuZGVmaW5lZDtcbiAgICAgIHRoaXMuX3RyaWdnZXJNb2RlID0gdW5kZWZpbmVkO1xuICAgIH1cbiAgICBlbHNlIHtcbiAgICAgIHRoaXMuaXNFbXB0eU9iamVjdCA9IE9iamVjdC5rZXlzKHZhbHVlKS5sZW5ndGggPT09IDA7XG4gICAgICB0aGlzLl9idWlsZEJyYW5jaGVzID0gdmFsdWUuYnVpbGRCcmFuY2hlcztcbiAgICAgIHRoaXMuX2J1aWxkUHVsbFJlcXVlc3RGb3JrcyA9IHZhbHVlLmJ1aWxkUHVsbFJlcXVlc3RGb3JrcztcbiAgICAgIHRoaXMuX2J1aWxkUHVsbFJlcXVlc3RMYWJlbHNDaGFuZ2VkID0gdmFsdWUuYnVpbGRQdWxsUmVxdWVzdExhYmVsc0NoYW5nZWQ7XG4gICAgICB0aGlzLl9idWlsZFB1bGxSZXF1ZXN0UmVhZHlGb3JSZXZpZXcgPSB2YWx1ZS5idWlsZFB1bGxSZXF1ZXN0UmVhZHlGb3JSZXZpZXc7XG4gICAgICB0aGlzLl9idWlsZFB1bGxSZXF1ZXN0cyA9IHZhbHVlLmJ1aWxkUHVsbFJlcXVlc3RzO1xuICAgICAgdGhpcy5fYnVpbGRUYWdzID0gdmFsdWUuYnVpbGRUYWdzO1xuICAgICAgdGhpcy5fY2FuY2VsRGVsZXRlZEJyYW5jaEJ1aWxkcyA9IHZhbHVlLmNhbmNlbERlbGV0ZWRCcmFuY2hCdWlsZHM7XG4gICAgICB0aGlzLl9maWx0ZXJDb25kaXRpb24gPSB2YWx1ZS5maWx0ZXJDb25kaXRpb247XG4gICAgICB0aGlzLl9maWx0ZXJFbmFibGVkID0gdmFsdWUuZmlsdGVyRW5hYmxlZDtcbiAgICAgIHRoaXMuX3ByZWZpeFB1bGxSZXF1ZXN0Rm9ya0JyYW5jaE5hbWVzID0gdmFsdWUucHJlZml4UHVsbFJlcXVlc3RGb3JrQnJhbmNoTmFtZXM7XG4gICAgICB0aGlzLl9wdWJsaXNoQmxvY2tlZEFzUGVuZGluZyA9IHZhbHVlLnB1Ymxpc2hCbG9ja2VkQXNQZW5kaW5nO1xuICAgICAgdGhpcy5fcHVibGlzaENvbW1pdFN0YXR1cyA9IHZhbHVlLnB1Ymxpc2hDb21taXRTdGF0dXM7XG4gICAgICB0aGlzLl9wdWJsaXNoQ29tbWl0U3RhdHVzUGVyU3RlcCA9IHZhbHVlLnB1Ymxpc2hDb21taXRTdGF0dXNQZXJTdGVwO1xuICAgICAgdGhpcy5fcHVsbFJlcXVlc3RCcmFuY2hGaWx0ZXJDb25maWd1cmF0aW9uID0gdmFsdWUucHVsbFJlcXVlc3RCcmFuY2hGaWx0ZXJDb25maWd1cmF0aW9uO1xuICAgICAgdGhpcy5fcHVsbFJlcXVlc3RCcmFuY2hGaWx0ZXJFbmFibGVkID0gdmFsdWUucHVsbFJlcXVlc3RCcmFuY2hGaWx0ZXJFbmFibGVkO1xuICAgICAgdGhpcy5fc2VwYXJhdGVQdWxsUmVxdWVzdFN0YXR1c2VzID0gdmFsdWUuc2VwYXJhdGVQdWxsUmVxdWVzdFN0YXR1c2VzO1xuICAgICAgdGhpcy5fc2tpcFB1bGxSZXF1ZXN0QnVpbGRzRm9yRXhpc3RpbmdDb21taXRzID0gdmFsdWUuc2tpcFB1bGxSZXF1ZXN0QnVpbGRzRm9yRXhpc3RpbmdDb21taXRzO1xuICAgICAgdGhpcy5fdHJpZ2dlck1vZGUgPSB2YWx1ZS50cmlnZ2VyTW9kZTtcbiAgICB9XG4gIH1cblxuICAvLyBidWlsZF9icmFuY2hlcyAtIGNvbXB1dGVkOiB0cnVlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2J1aWxkQnJhbmNoZXM/OiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGU7IFxuICBwdWJsaWMgZ2V0IGJ1aWxkQnJhbmNoZXMoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0Qm9vbGVhbkF0dHJpYnV0ZSgnYnVpbGRfYnJhbmNoZXMnKTtcbiAgfVxuICBwdWJsaWMgc2V0IGJ1aWxkQnJhbmNoZXModmFsdWU6IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZSkge1xuICAgIHRoaXMuX2J1aWxkQnJhbmNoZXMgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRCdWlsZEJyYW5jaGVzKCkge1xuICAgIHRoaXMuX2J1aWxkQnJhbmNoZXMgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IGJ1aWxkQnJhbmNoZXNJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fYnVpbGRCcmFuY2hlcztcbiAgfVxuXG4gIC8vIGJ1aWxkX3B1bGxfcmVxdWVzdF9mb3JrcyAtIGNvbXB1dGVkOiB0cnVlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2J1aWxkUHVsbFJlcXVlc3RGb3Jrcz86IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZTsgXG4gIHB1YmxpYyBnZXQgYnVpbGRQdWxsUmVxdWVzdEZvcmtzKCkge1xuICAgIHJldHVybiB0aGlzLmdldEJvb2xlYW5BdHRyaWJ1dGUoJ2J1aWxkX3B1bGxfcmVxdWVzdF9mb3JrcycpO1xuICB9XG4gIHB1YmxpYyBzZXQgYnVpbGRQdWxsUmVxdWVzdEZvcmtzKHZhbHVlOiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGUpIHtcbiAgICB0aGlzLl9idWlsZFB1bGxSZXF1ZXN0Rm9ya3MgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRCdWlsZFB1bGxSZXF1ZXN0Rm9ya3MoKSB7XG4gICAgdGhpcy5fYnVpbGRQdWxsUmVxdWVzdEZvcmtzID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBidWlsZFB1bGxSZXF1ZXN0Rm9ya3NJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fYnVpbGRQdWxsUmVxdWVzdEZvcmtzO1xuICB9XG5cbiAgLy8gYnVpbGRfcHVsbF9yZXF1ZXN0X2xhYmVsc19jaGFuZ2VkIC0gY29tcHV0ZWQ6IHRydWUsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfYnVpbGRQdWxsUmVxdWVzdExhYmVsc0NoYW5nZWQ/OiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGU7IFxuICBwdWJsaWMgZ2V0IGJ1aWxkUHVsbFJlcXVlc3RMYWJlbHNDaGFuZ2VkKCkge1xuICAgIHJldHVybiB0aGlzLmdldEJvb2xlYW5BdHRyaWJ1dGUoJ2J1aWxkX3B1bGxfcmVxdWVzdF9sYWJlbHNfY2hhbmdlZCcpO1xuICB9XG4gIHB1YmxpYyBzZXQgYnVpbGRQdWxsUmVxdWVzdExhYmVsc0NoYW5nZWQodmFsdWU6IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZSkge1xuICAgIHRoaXMuX2J1aWxkUHVsbFJlcXVlc3RMYWJlbHNDaGFuZ2VkID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0QnVpbGRQdWxsUmVxdWVzdExhYmVsc0NoYW5nZWQoKSB7XG4gICAgdGhpcy5fYnVpbGRQdWxsUmVxdWVzdExhYmVsc0NoYW5nZWQgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IGJ1aWxkUHVsbFJlcXVlc3RMYWJlbHNDaGFuZ2VkSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2J1aWxkUHVsbFJlcXVlc3RMYWJlbHNDaGFuZ2VkO1xuICB9XG5cbiAgLy8gYnVpbGRfcHVsbF9yZXF1ZXN0X3JlYWR5X2Zvcl9yZXZpZXcgLSBjb21wdXRlZDogdHJ1ZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9idWlsZFB1bGxSZXF1ZXN0UmVhZHlGb3JSZXZpZXc/OiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGU7IFxuICBwdWJsaWMgZ2V0IGJ1aWxkUHVsbFJlcXVlc3RSZWFkeUZvclJldmlldygpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRCb29sZWFuQXR0cmlidXRlKCdidWlsZF9wdWxsX3JlcXVlc3RfcmVhZHlfZm9yX3JldmlldycpO1xuICB9XG4gIHB1YmxpYyBzZXQgYnVpbGRQdWxsUmVxdWVzdFJlYWR5Rm9yUmV2aWV3KHZhbHVlOiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGUpIHtcbiAgICB0aGlzLl9idWlsZFB1bGxSZXF1ZXN0UmVhZHlGb3JSZXZpZXcgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRCdWlsZFB1bGxSZXF1ZXN0UmVhZHlGb3JSZXZpZXcoKSB7XG4gICAgdGhpcy5fYnVpbGRQdWxsUmVxdWVzdFJlYWR5Rm9yUmV2aWV3ID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBidWlsZFB1bGxSZXF1ZXN0UmVhZHlGb3JSZXZpZXdJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fYnVpbGRQdWxsUmVxdWVzdFJlYWR5Rm9yUmV2aWV3O1xuICB9XG5cbiAgLy8gYnVpbGRfcHVsbF9yZXF1ZXN0cyAtIGNvbXB1dGVkOiB0cnVlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2J1aWxkUHVsbFJlcXVlc3RzPzogYm9vbGVhbiB8IGNka3RmLklSZXNvbHZhYmxlOyBcbiAgcHVibGljIGdldCBidWlsZFB1bGxSZXF1ZXN0cygpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRCb29sZWFuQXR0cmlidXRlKCdidWlsZF9wdWxsX3JlcXVlc3RzJyk7XG4gIH1cbiAgcHVibGljIHNldCBidWlsZFB1bGxSZXF1ZXN0cyh2YWx1ZTogYm9vbGVhbiB8IGNka3RmLklSZXNvbHZhYmxlKSB7XG4gICAgdGhpcy5fYnVpbGRQdWxsUmVxdWVzdHMgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRCdWlsZFB1bGxSZXF1ZXN0cygpIHtcbiAgICB0aGlzLl9idWlsZFB1bGxSZXF1ZXN0cyA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgYnVpbGRQdWxsUmVxdWVzdHNJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fYnVpbGRQdWxsUmVxdWVzdHM7XG4gIH1cblxuICAvLyBidWlsZF90YWdzIC0gY29tcHV0ZWQ6IHRydWUsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfYnVpbGRUYWdzPzogYm9vbGVhbiB8IGNka3RmLklSZXNvbHZhYmxlOyBcbiAgcHVibGljIGdldCBidWlsZFRhZ3MoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0Qm9vbGVhbkF0dHJpYnV0ZSgnYnVpbGRfdGFncycpO1xuICB9XG4gIHB1YmxpYyBzZXQgYnVpbGRUYWdzKHZhbHVlOiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGUpIHtcbiAgICB0aGlzLl9idWlsZFRhZ3MgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRCdWlsZFRhZ3MoKSB7XG4gICAgdGhpcy5fYnVpbGRUYWdzID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBidWlsZFRhZ3NJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fYnVpbGRUYWdzO1xuICB9XG5cbiAgLy8gY2FuY2VsX2RlbGV0ZWRfYnJhbmNoX2J1aWxkcyAtIGNvbXB1dGVkOiB0cnVlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2NhbmNlbERlbGV0ZWRCcmFuY2hCdWlsZHM/OiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGU7IFxuICBwdWJsaWMgZ2V0IGNhbmNlbERlbGV0ZWRCcmFuY2hCdWlsZHMoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0Qm9vbGVhbkF0dHJpYnV0ZSgnY2FuY2VsX2RlbGV0ZWRfYnJhbmNoX2J1aWxkcycpO1xuICB9XG4gIHB1YmxpYyBzZXQgY2FuY2VsRGVsZXRlZEJyYW5jaEJ1aWxkcyh2YWx1ZTogYm9vbGVhbiB8IGNka3RmLklSZXNvbHZhYmxlKSB7XG4gICAgdGhpcy5fY2FuY2VsRGVsZXRlZEJyYW5jaEJ1aWxkcyA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldENhbmNlbERlbGV0ZWRCcmFuY2hCdWlsZHMoKSB7XG4gICAgdGhpcy5fY2FuY2VsRGVsZXRlZEJyYW5jaEJ1aWxkcyA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgY2FuY2VsRGVsZXRlZEJyYW5jaEJ1aWxkc0lucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9jYW5jZWxEZWxldGVkQnJhbmNoQnVpbGRzO1xuICB9XG5cbiAgLy8gZmlsdGVyX2NvbmRpdGlvbiAtIGNvbXB1dGVkOiB0cnVlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2ZpbHRlckNvbmRpdGlvbj86IHN0cmluZzsgXG4gIHB1YmxpYyBnZXQgZmlsdGVyQ29uZGl0aW9uKCkge1xuICAgIHJldHVybiB0aGlzLmdldFN0cmluZ0F0dHJpYnV0ZSgnZmlsdGVyX2NvbmRpdGlvbicpO1xuICB9XG4gIHB1YmxpYyBzZXQgZmlsdGVyQ29uZGl0aW9uKHZhbHVlOiBzdHJpbmcpIHtcbiAgICB0aGlzLl9maWx0ZXJDb25kaXRpb24gPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRGaWx0ZXJDb25kaXRpb24oKSB7XG4gICAgdGhpcy5fZmlsdGVyQ29uZGl0aW9uID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBmaWx0ZXJDb25kaXRpb25JbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fZmlsdGVyQ29uZGl0aW9uO1xuICB9XG5cbiAgLy8gZmlsdGVyX2VuYWJsZWQgLSBjb21wdXRlZDogdHJ1ZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9maWx0ZXJFbmFibGVkPzogYm9vbGVhbiB8IGNka3RmLklSZXNvbHZhYmxlOyBcbiAgcHVibGljIGdldCBmaWx0ZXJFbmFibGVkKCkge1xuICAgIHJldHVybiB0aGlzLmdldEJvb2xlYW5BdHRyaWJ1dGUoJ2ZpbHRlcl9lbmFibGVkJyk7XG4gIH1cbiAgcHVibGljIHNldCBmaWx0ZXJFbmFibGVkKHZhbHVlOiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGUpIHtcbiAgICB0aGlzLl9maWx0ZXJFbmFibGVkID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0RmlsdGVyRW5hYmxlZCgpIHtcbiAgICB0aGlzLl9maWx0ZXJFbmFibGVkID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBmaWx0ZXJFbmFibGVkSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2ZpbHRlckVuYWJsZWQ7XG4gIH1cblxuICAvLyBwcmVmaXhfcHVsbF9yZXF1ZXN0X2ZvcmtfYnJhbmNoX25hbWVzIC0gY29tcHV0ZWQ6IHRydWUsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfcHJlZml4UHVsbFJlcXVlc3RGb3JrQnJhbmNoTmFtZXM/OiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGU7IFxuICBwdWJsaWMgZ2V0IHByZWZpeFB1bGxSZXF1ZXN0Rm9ya0JyYW5jaE5hbWVzKCkge1xuICAgIHJldHVybiB0aGlzLmdldEJvb2xlYW5BdHRyaWJ1dGUoJ3ByZWZpeF9wdWxsX3JlcXVlc3RfZm9ya19icmFuY2hfbmFtZXMnKTtcbiAgfVxuICBwdWJsaWMgc2V0IHByZWZpeFB1bGxSZXF1ZXN0Rm9ya0JyYW5jaE5hbWVzKHZhbHVlOiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGUpIHtcbiAgICB0aGlzLl9wcmVmaXhQdWxsUmVxdWVzdEZvcmtCcmFuY2hOYW1lcyA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldFByZWZpeFB1bGxSZXF1ZXN0Rm9ya0JyYW5jaE5hbWVzKCkge1xuICAgIHRoaXMuX3ByZWZpeFB1bGxSZXF1ZXN0Rm9ya0JyYW5jaE5hbWVzID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBwcmVmaXhQdWxsUmVxdWVzdEZvcmtCcmFuY2hOYW1lc0lucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9wcmVmaXhQdWxsUmVxdWVzdEZvcmtCcmFuY2hOYW1lcztcbiAgfVxuXG4gIC8vIHB1Ymxpc2hfYmxvY2tlZF9hc19wZW5kaW5nIC0gY29tcHV0ZWQ6IHRydWUsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfcHVibGlzaEJsb2NrZWRBc1BlbmRpbmc/OiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGU7IFxuICBwdWJsaWMgZ2V0IHB1Ymxpc2hCbG9ja2VkQXNQZW5kaW5nKCkge1xuICAgIHJldHVybiB0aGlzLmdldEJvb2xlYW5BdHRyaWJ1dGUoJ3B1Ymxpc2hfYmxvY2tlZF9hc19wZW5kaW5nJyk7XG4gIH1cbiAgcHVibGljIHNldCBwdWJsaXNoQmxvY2tlZEFzUGVuZGluZyh2YWx1ZTogYm9vbGVhbiB8IGNka3RmLklSZXNvbHZhYmxlKSB7XG4gICAgdGhpcy5fcHVibGlzaEJsb2NrZWRBc1BlbmRpbmcgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRQdWJsaXNoQmxvY2tlZEFzUGVuZGluZygpIHtcbiAgICB0aGlzLl9wdWJsaXNoQmxvY2tlZEFzUGVuZGluZyA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgcHVibGlzaEJsb2NrZWRBc1BlbmRpbmdJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fcHVibGlzaEJsb2NrZWRBc1BlbmRpbmc7XG4gIH1cblxuICAvLyBwdWJsaXNoX2NvbW1pdF9zdGF0dXMgLSBjb21wdXRlZDogdHJ1ZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9wdWJsaXNoQ29tbWl0U3RhdHVzPzogYm9vbGVhbiB8IGNka3RmLklSZXNvbHZhYmxlOyBcbiAgcHVibGljIGdldCBwdWJsaXNoQ29tbWl0U3RhdHVzKCkge1xuICAgIHJldHVybiB0aGlzLmdldEJvb2xlYW5BdHRyaWJ1dGUoJ3B1Ymxpc2hfY29tbWl0X3N0YXR1cycpO1xuICB9XG4gIHB1YmxpYyBzZXQgcHVibGlzaENvbW1pdFN0YXR1cyh2YWx1ZTogYm9vbGVhbiB8IGNka3RmLklSZXNvbHZhYmxlKSB7XG4gICAgdGhpcy5fcHVibGlzaENvbW1pdFN0YXR1cyA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldFB1Ymxpc2hDb21taXRTdGF0dXMoKSB7XG4gICAgdGhpcy5fcHVibGlzaENvbW1pdFN0YXR1cyA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgcHVibGlzaENvbW1pdFN0YXR1c0lucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9wdWJsaXNoQ29tbWl0U3RhdHVzO1xuICB9XG5cbiAgLy8gcHVibGlzaF9jb21taXRfc3RhdHVzX3Blcl9zdGVwIC0gY29tcHV0ZWQ6IHRydWUsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfcHVibGlzaENvbW1pdFN0YXR1c1BlclN0ZXA/OiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGU7IFxuICBwdWJsaWMgZ2V0IHB1Ymxpc2hDb21taXRTdGF0dXNQZXJTdGVwKCkge1xuICAgIHJldHVybiB0aGlzLmdldEJvb2xlYW5BdHRyaWJ1dGUoJ3B1Ymxpc2hfY29tbWl0X3N0YXR1c19wZXJfc3RlcCcpO1xuICB9XG4gIHB1YmxpYyBzZXQgcHVibGlzaENvbW1pdFN0YXR1c1BlclN0ZXAodmFsdWU6IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZSkge1xuICAgIHRoaXMuX3B1Ymxpc2hDb21taXRTdGF0dXNQZXJTdGVwID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0UHVibGlzaENvbW1pdFN0YXR1c1BlclN0ZXAoKSB7XG4gICAgdGhpcy5fcHVibGlzaENvbW1pdFN0YXR1c1BlclN0ZXAgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IHB1Ymxpc2hDb21taXRTdGF0dXNQZXJTdGVwSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX3B1Ymxpc2hDb21taXRTdGF0dXNQZXJTdGVwO1xuICB9XG5cbiAgLy8gcHVsbF9yZXF1ZXN0X2JyYW5jaF9maWx0ZXJfY29uZmlndXJhdGlvbiAtIGNvbXB1dGVkOiB0cnVlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX3B1bGxSZXF1ZXN0QnJhbmNoRmlsdGVyQ29uZmlndXJhdGlvbj86IHN0cmluZzsgXG4gIHB1YmxpYyBnZXQgcHVsbFJlcXVlc3RCcmFuY2hGaWx0ZXJDb25maWd1cmF0aW9uKCkge1xuICAgIHJldHVybiB0aGlzLmdldFN0cmluZ0F0dHJpYnV0ZSgncHVsbF9yZXF1ZXN0X2JyYW5jaF9maWx0ZXJfY29uZmlndXJhdGlvbicpO1xuICB9XG4gIHB1YmxpYyBzZXQgcHVsbFJlcXVlc3RCcmFuY2hGaWx0ZXJDb25maWd1cmF0aW9uKHZhbHVlOiBzdHJpbmcpIHtcbiAgICB0aGlzLl9wdWxsUmVxdWVzdEJyYW5jaEZpbHRlckNvbmZpZ3VyYXRpb24gPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRQdWxsUmVxdWVzdEJyYW5jaEZpbHRlckNvbmZpZ3VyYXRpb24oKSB7XG4gICAgdGhpcy5fcHVsbFJlcXVlc3RCcmFuY2hGaWx0ZXJDb25maWd1cmF0aW9uID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBwdWxsUmVxdWVzdEJyYW5jaEZpbHRlckNvbmZpZ3VyYXRpb25JbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fcHVsbFJlcXVlc3RCcmFuY2hGaWx0ZXJDb25maWd1cmF0aW9uO1xuICB9XG5cbiAgLy8gcHVsbF9yZXF1ZXN0X2JyYW5jaF9maWx0ZXJfZW5hYmxlZCAtIGNvbXB1dGVkOiB0cnVlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX3B1bGxSZXF1ZXN0QnJhbmNoRmlsdGVyRW5hYmxlZD86IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZTsgXG4gIHB1YmxpYyBnZXQgcHVsbFJlcXVlc3RCcmFuY2hGaWx0ZXJFbmFibGVkKCkge1xuICAgIHJldHVybiB0aGlzLmdldEJvb2xlYW5BdHRyaWJ1dGUoJ3B1bGxfcmVxdWVzdF9icmFuY2hfZmlsdGVyX2VuYWJsZWQnKTtcbiAgfVxuICBwdWJsaWMgc2V0IHB1bGxSZXF1ZXN0QnJhbmNoRmlsdGVyRW5hYmxlZCh2YWx1ZTogYm9vbGVhbiB8IGNka3RmLklSZXNvbHZhYmxlKSB7XG4gICAgdGhpcy5fcHVsbFJlcXVlc3RCcmFuY2hGaWx0ZXJFbmFibGVkID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0UHVsbFJlcXVlc3RCcmFuY2hGaWx0ZXJFbmFibGVkKCkge1xuICAgIHRoaXMuX3B1bGxSZXF1ZXN0QnJhbmNoRmlsdGVyRW5hYmxlZCA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgcHVsbFJlcXVlc3RCcmFuY2hGaWx0ZXJFbmFibGVkSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX3B1bGxSZXF1ZXN0QnJhbmNoRmlsdGVyRW5hYmxlZDtcbiAgfVxuXG4gIC8vIHNlcGFyYXRlX3B1bGxfcmVxdWVzdF9zdGF0dXNlcyAtIGNvbXB1dGVkOiB0cnVlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX3NlcGFyYXRlUHVsbFJlcXVlc3RTdGF0dXNlcz86IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZTsgXG4gIHB1YmxpYyBnZXQgc2VwYXJhdGVQdWxsUmVxdWVzdFN0YXR1c2VzKCkge1xuICAgIHJldHVybiB0aGlzLmdldEJvb2xlYW5BdHRyaWJ1dGUoJ3NlcGFyYXRlX3B1bGxfcmVxdWVzdF9zdGF0dXNlcycpO1xuICB9XG4gIHB1YmxpYyBzZXQgc2VwYXJhdGVQdWxsUmVxdWVzdFN0YXR1c2VzKHZhbHVlOiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGUpIHtcbiAgICB0aGlzLl9zZXBhcmF0ZVB1bGxSZXF1ZXN0U3RhdHVzZXMgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRTZXBhcmF0ZVB1bGxSZXF1ZXN0U3RhdHVzZXMoKSB7XG4gICAgdGhpcy5fc2VwYXJhdGVQdWxsUmVxdWVzdFN0YXR1c2VzID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBzZXBhcmF0ZVB1bGxSZXF1ZXN0U3RhdHVzZXNJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fc2VwYXJhdGVQdWxsUmVxdWVzdFN0YXR1c2VzO1xuICB9XG5cbiAgLy8gc2tpcF9wdWxsX3JlcXVlc3RfYnVpbGRzX2Zvcl9leGlzdGluZ19jb21taXRzIC0gY29tcHV0ZWQ6IHRydWUsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfc2tpcFB1bGxSZXF1ZXN0QnVpbGRzRm9yRXhpc3RpbmdDb21taXRzPzogYm9vbGVhbiB8IGNka3RmLklSZXNvbHZhYmxlOyBcbiAgcHVibGljIGdldCBza2lwUHVsbFJlcXVlc3RCdWlsZHNGb3JFeGlzdGluZ0NvbW1pdHMoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0Qm9vbGVhbkF0dHJpYnV0ZSgnc2tpcF9wdWxsX3JlcXVlc3RfYnVpbGRzX2Zvcl9leGlzdGluZ19jb21taXRzJyk7XG4gIH1cbiAgcHVibGljIHNldCBza2lwUHVsbFJlcXVlc3RCdWlsZHNGb3JFeGlzdGluZ0NvbW1pdHModmFsdWU6IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZSkge1xuICAgIHRoaXMuX3NraXBQdWxsUmVxdWVzdEJ1aWxkc0ZvckV4aXN0aW5nQ29tbWl0cyA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldFNraXBQdWxsUmVxdWVzdEJ1aWxkc0ZvckV4aXN0aW5nQ29tbWl0cygpIHtcbiAgICB0aGlzLl9za2lwUHVsbFJlcXVlc3RCdWlsZHNGb3JFeGlzdGluZ0NvbW1pdHMgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IHNraXBQdWxsUmVxdWVzdEJ1aWxkc0ZvckV4aXN0aW5nQ29tbWl0c0lucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9za2lwUHVsbFJlcXVlc3RCdWlsZHNGb3JFeGlzdGluZ0NvbW1pdHM7XG4gIH1cblxuICAvLyB0cmlnZ2VyX21vZGUgLSBjb21wdXRlZDogdHJ1ZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF90cmlnZ2VyTW9kZT86IHN0cmluZzsgXG4gIHB1YmxpYyBnZXQgdHJpZ2dlck1vZGUoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0U3RyaW5nQXR0cmlidXRlKCd0cmlnZ2VyX21vZGUnKTtcbiAgfVxuICBwdWJsaWMgc2V0IHRyaWdnZXJNb2RlKHZhbHVlOiBzdHJpbmcpIHtcbiAgICB0aGlzLl90cmlnZ2VyTW9kZSA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldFRyaWdnZXJNb2RlKCkge1xuICAgIHRoaXMuX3RyaWdnZXJNb2RlID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCB0cmlnZ2VyTW9kZUlucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl90cmlnZ2VyTW9kZTtcbiAgfVxufVxuXG4vKipcbiogUmVwcmVzZW50cyBhIHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvYnVpbGRraXRlL3IvcGlwZWxpbmUgYnVpbGRraXRlX3BpcGVsaW5lfVxuKi9cbmV4cG9ydCBjbGFzcyBQaXBlbGluZSBleHRlbmRzIGNka3RmLlRlcnJhZm9ybVJlc291cmNlIHtcblxuICAvLyA9PT09PT09PT09PT09PT09PVxuICAvLyBTVEFUSUMgUFJPUEVSVElFU1xuICAvLyA9PT09PT09PT09PT09PT09PVxuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IHRmUmVzb3VyY2VUeXBlID0gXCJidWlsZGtpdGVfcGlwZWxpbmVcIjtcblxuICAvLyA9PT09PT09PT09PVxuICAvLyBJTklUSUFMSVpFUlxuICAvLyA9PT09PT09PT09PVxuXG4gIC8qKlxuICAqIENyZWF0ZSBhIG5ldyB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL2J1aWxka2l0ZS9yL3BpcGVsaW5lIGJ1aWxka2l0ZV9waXBlbGluZX0gUmVzb3VyY2VcbiAgKlxuICAqIEBwYXJhbSBzY29wZSBUaGUgc2NvcGUgaW4gd2hpY2ggdG8gZGVmaW5lIHRoaXMgY29uc3RydWN0XG4gICogQHBhcmFtIGlkIFRoZSBzY29wZWQgY29uc3RydWN0IElELiBNdXN0IGJlIHVuaXF1ZSBhbW9uZ3N0IHNpYmxpbmdzIGluIHRoZSBzYW1lIHNjb3BlXG4gICogQHBhcmFtIG9wdGlvbnMgUGlwZWxpbmVDb25maWdcbiAgKi9cbiAgcHVibGljIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIGNvbmZpZzogUGlwZWxpbmVDb25maWcpIHtcbiAgICBzdXBlcihzY29wZSwgaWQsIHtcbiAgICAgIHRlcnJhZm9ybVJlc291cmNlVHlwZTogJ2J1aWxka2l0ZV9waXBlbGluZScsXG4gICAgICB0ZXJyYWZvcm1HZW5lcmF0b3JNZXRhZGF0YToge1xuICAgICAgICBwcm92aWRlck5hbWU6ICdidWlsZGtpdGUnLFxuICAgICAgICBwcm92aWRlclZlcnNpb246ICcwLjkuMCcsXG4gICAgICAgIHByb3ZpZGVyVmVyc2lvbkNvbnN0cmFpbnQ6ICd+PiAwLjkuMCdcbiAgICAgIH0sXG4gICAgICBwcm92aWRlcjogY29uZmlnLnByb3ZpZGVyLFxuICAgICAgZGVwZW5kc09uOiBjb25maWcuZGVwZW5kc09uLFxuICAgICAgY291bnQ6IGNvbmZpZy5jb3VudCxcbiAgICAgIGxpZmVjeWNsZTogY29uZmlnLmxpZmVjeWNsZVxuICAgIH0pO1xuICAgIHRoaXMuX2FsbG93UmVidWlsZHMgPSBjb25maWcuYWxsb3dSZWJ1aWxkcztcbiAgICB0aGlzLl9icmFuY2hDb25maWd1cmF0aW9uID0gY29uZmlnLmJyYW5jaENvbmZpZ3VyYXRpb247XG4gICAgdGhpcy5fY2FuY2VsSW50ZXJtZWRpYXRlQnVpbGRzID0gY29uZmlnLmNhbmNlbEludGVybWVkaWF0ZUJ1aWxkcztcbiAgICB0aGlzLl9jYW5jZWxJbnRlcm1lZGlhdGVCdWlsZHNCcmFuY2hGaWx0ZXIgPSBjb25maWcuY2FuY2VsSW50ZXJtZWRpYXRlQnVpbGRzQnJhbmNoRmlsdGVyO1xuICAgIHRoaXMuX2NsdXN0ZXJJZCA9IGNvbmZpZy5jbHVzdGVySWQ7XG4gICAgdGhpcy5fZGVmYXVsdEJyYW5jaCA9IGNvbmZpZy5kZWZhdWx0QnJhbmNoO1xuICAgIHRoaXMuX2Rlc2NyaXB0aW9uID0gY29uZmlnLmRlc2NyaXB0aW9uO1xuICAgIHRoaXMuX25hbWUgPSBjb25maWcubmFtZTtcbiAgICB0aGlzLl9yZXBvc2l0b3J5ID0gY29uZmlnLnJlcG9zaXRvcnk7XG4gICAgdGhpcy5fc2tpcEludGVybWVkaWF0ZUJ1aWxkcyA9IGNvbmZpZy5za2lwSW50ZXJtZWRpYXRlQnVpbGRzO1xuICAgIHRoaXMuX3NraXBJbnRlcm1lZGlhdGVCdWlsZHNCcmFuY2hGaWx0ZXIgPSBjb25maWcuc2tpcEludGVybWVkaWF0ZUJ1aWxkc0JyYW5jaEZpbHRlcjtcbiAgICB0aGlzLl9zdGVwcyA9IGNvbmZpZy5zdGVwcztcbiAgICB0aGlzLl90YWdzID0gY29uZmlnLnRhZ3M7XG4gICAgdGhpcy5fdGVhbSA9IGNvbmZpZy50ZWFtO1xuICAgIHRoaXMuX3Byb3ZpZGVyU2V0dGluZ3MuaW50ZXJuYWxWYWx1ZSA9IGNvbmZpZy5wcm92aWRlclNldHRpbmdzO1xuICB9XG5cbiAgLy8gPT09PT09PT09PVxuICAvLyBBVFRSSUJVVEVTXG4gIC8vID09PT09PT09PT1cblxuICAvLyBhbGxvd19yZWJ1aWxkcyAtIGNvbXB1dGVkOiB0cnVlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2FsbG93UmVidWlsZHM/OiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGU7IFxuICBwdWJsaWMgZ2V0IGFsbG93UmVidWlsZHMoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0Qm9vbGVhbkF0dHJpYnV0ZSgnYWxsb3dfcmVidWlsZHMnKTtcbiAgfVxuICBwdWJsaWMgc2V0IGFsbG93UmVidWlsZHModmFsdWU6IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZSkge1xuICAgIHRoaXMuX2FsbG93UmVidWlsZHMgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRBbGxvd1JlYnVpbGRzKCkge1xuICAgIHRoaXMuX2FsbG93UmVidWlsZHMgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IGFsbG93UmVidWlsZHNJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fYWxsb3dSZWJ1aWxkcztcbiAgfVxuXG4gIC8vIGJhZGdlX3VybCAtIGNvbXB1dGVkOiB0cnVlLCBvcHRpb25hbDogZmFsc2UsIHJlcXVpcmVkOiBmYWxzZVxuICBwdWJsaWMgZ2V0IGJhZGdlVXJsKCkge1xuICAgIHJldHVybiB0aGlzLmdldFN0cmluZ0F0dHJpYnV0ZSgnYmFkZ2VfdXJsJyk7XG4gIH1cblxuICAvLyBicmFuY2hfY29uZmlndXJhdGlvbiAtIGNvbXB1dGVkOiB0cnVlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2JyYW5jaENvbmZpZ3VyYXRpb24/OiBzdHJpbmc7IFxuICBwdWJsaWMgZ2V0IGJyYW5jaENvbmZpZ3VyYXRpb24oKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0U3RyaW5nQXR0cmlidXRlKCdicmFuY2hfY29uZmlndXJhdGlvbicpO1xuICB9XG4gIHB1YmxpYyBzZXQgYnJhbmNoQ29uZmlndXJhdGlvbih2YWx1ZTogc3RyaW5nKSB7XG4gICAgdGhpcy5fYnJhbmNoQ29uZmlndXJhdGlvbiA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldEJyYW5jaENvbmZpZ3VyYXRpb24oKSB7XG4gICAgdGhpcy5fYnJhbmNoQ29uZmlndXJhdGlvbiA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgYnJhbmNoQ29uZmlndXJhdGlvbklucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9icmFuY2hDb25maWd1cmF0aW9uO1xuICB9XG5cbiAgLy8gY2FuY2VsX2ludGVybWVkaWF0ZV9idWlsZHMgLSBjb21wdXRlZDogdHJ1ZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9jYW5jZWxJbnRlcm1lZGlhdGVCdWlsZHM/OiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGU7IFxuICBwdWJsaWMgZ2V0IGNhbmNlbEludGVybWVkaWF0ZUJ1aWxkcygpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRCb29sZWFuQXR0cmlidXRlKCdjYW5jZWxfaW50ZXJtZWRpYXRlX2J1aWxkcycpO1xuICB9XG4gIHB1YmxpYyBzZXQgY2FuY2VsSW50ZXJtZWRpYXRlQnVpbGRzKHZhbHVlOiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGUpIHtcbiAgICB0aGlzLl9jYW5jZWxJbnRlcm1lZGlhdGVCdWlsZHMgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRDYW5jZWxJbnRlcm1lZGlhdGVCdWlsZHMoKSB7XG4gICAgdGhpcy5fY2FuY2VsSW50ZXJtZWRpYXRlQnVpbGRzID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBjYW5jZWxJbnRlcm1lZGlhdGVCdWlsZHNJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fY2FuY2VsSW50ZXJtZWRpYXRlQnVpbGRzO1xuICB9XG5cbiAgLy8gY2FuY2VsX2ludGVybWVkaWF0ZV9idWlsZHNfYnJhbmNoX2ZpbHRlciAtIGNvbXB1dGVkOiB0cnVlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2NhbmNlbEludGVybWVkaWF0ZUJ1aWxkc0JyYW5jaEZpbHRlcj86IHN0cmluZzsgXG4gIHB1YmxpYyBnZXQgY2FuY2VsSW50ZXJtZWRpYXRlQnVpbGRzQnJhbmNoRmlsdGVyKCkge1xuICAgIHJldHVybiB0aGlzLmdldFN0cmluZ0F0dHJpYnV0ZSgnY2FuY2VsX2ludGVybWVkaWF0ZV9idWlsZHNfYnJhbmNoX2ZpbHRlcicpO1xuICB9XG4gIHB1YmxpYyBzZXQgY2FuY2VsSW50ZXJtZWRpYXRlQnVpbGRzQnJhbmNoRmlsdGVyKHZhbHVlOiBzdHJpbmcpIHtcbiAgICB0aGlzLl9jYW5jZWxJbnRlcm1lZGlhdGVCdWlsZHNCcmFuY2hGaWx0ZXIgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRDYW5jZWxJbnRlcm1lZGlhdGVCdWlsZHNCcmFuY2hGaWx0ZXIoKSB7XG4gICAgdGhpcy5fY2FuY2VsSW50ZXJtZWRpYXRlQnVpbGRzQnJhbmNoRmlsdGVyID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBjYW5jZWxJbnRlcm1lZGlhdGVCdWlsZHNCcmFuY2hGaWx0ZXJJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fY2FuY2VsSW50ZXJtZWRpYXRlQnVpbGRzQnJhbmNoRmlsdGVyO1xuICB9XG5cbiAgLy8gY2x1c3Rlcl9pZCAtIGNvbXB1dGVkOiB0cnVlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2NsdXN0ZXJJZD86IHN0cmluZzsgXG4gIHB1YmxpYyBnZXQgY2x1c3RlcklkKCkge1xuICAgIHJldHVybiB0aGlzLmdldFN0cmluZ0F0dHJpYnV0ZSgnY2x1c3Rlcl9pZCcpO1xuICB9XG4gIHB1YmxpYyBzZXQgY2x1c3RlcklkKHZhbHVlOiBzdHJpbmcpIHtcbiAgICB0aGlzLl9jbHVzdGVySWQgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRDbHVzdGVySWQoKSB7XG4gICAgdGhpcy5fY2x1c3RlcklkID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBjbHVzdGVySWRJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fY2x1c3RlcklkO1xuICB9XG5cbiAgLy8gZGVmYXVsdF9icmFuY2ggLSBjb21wdXRlZDogdHJ1ZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9kZWZhdWx0QnJhbmNoPzogc3RyaW5nOyBcbiAgcHVibGljIGdldCBkZWZhdWx0QnJhbmNoKCkge1xuICAgIHJldHVybiB0aGlzLmdldFN0cmluZ0F0dHJpYnV0ZSgnZGVmYXVsdF9icmFuY2gnKTtcbiAgfVxuICBwdWJsaWMgc2V0IGRlZmF1bHRCcmFuY2godmFsdWU6IHN0cmluZykge1xuICAgIHRoaXMuX2RlZmF1bHRCcmFuY2ggPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXREZWZhdWx0QnJhbmNoKCkge1xuICAgIHRoaXMuX2RlZmF1bHRCcmFuY2ggPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IGRlZmF1bHRCcmFuY2hJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fZGVmYXVsdEJyYW5jaDtcbiAgfVxuXG4gIC8vIGRlc2NyaXB0aW9uIC0gY29tcHV0ZWQ6IHRydWUsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfZGVzY3JpcHRpb24/OiBzdHJpbmc7IFxuICBwdWJsaWMgZ2V0IGRlc2NyaXB0aW9uKCkge1xuICAgIHJldHVybiB0aGlzLmdldFN0cmluZ0F0dHJpYnV0ZSgnZGVzY3JpcHRpb24nKTtcbiAgfVxuICBwdWJsaWMgc2V0IGRlc2NyaXB0aW9uKHZhbHVlOiBzdHJpbmcpIHtcbiAgICB0aGlzLl9kZXNjcmlwdGlvbiA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldERlc2NyaXB0aW9uKCkge1xuICAgIHRoaXMuX2Rlc2NyaXB0aW9uID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBkZXNjcmlwdGlvbklucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9kZXNjcmlwdGlvbjtcbiAgfVxuXG4gIC8vIGlkIC0gY29tcHV0ZWQ6IHRydWUsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHVibGljIGdldCBpZCgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ2lkJyk7XG4gIH1cblxuICAvLyBuYW1lIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogZmFsc2UsIHJlcXVpcmVkOiB0cnVlXG4gIHByaXZhdGUgX25hbWU/OiBzdHJpbmc7IFxuICBwdWJsaWMgZ2V0IG5hbWUoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0U3RyaW5nQXR0cmlidXRlKCduYW1lJyk7XG4gIH1cbiAgcHVibGljIHNldCBuYW1lKHZhbHVlOiBzdHJpbmcpIHtcbiAgICB0aGlzLl9uYW1lID0gdmFsdWU7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IG5hbWVJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fbmFtZTtcbiAgfVxuXG4gIC8vIHJlcG9zaXRvcnkgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiBmYWxzZSwgcmVxdWlyZWQ6IHRydWVcbiAgcHJpdmF0ZSBfcmVwb3NpdG9yeT86IHN0cmluZzsgXG4gIHB1YmxpYyBnZXQgcmVwb3NpdG9yeSgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ3JlcG9zaXRvcnknKTtcbiAgfVxuICBwdWJsaWMgc2V0IHJlcG9zaXRvcnkodmFsdWU6IHN0cmluZykge1xuICAgIHRoaXMuX3JlcG9zaXRvcnkgPSB2YWx1ZTtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgcmVwb3NpdG9yeUlucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9yZXBvc2l0b3J5O1xuICB9XG5cbiAgLy8gc2tpcF9pbnRlcm1lZGlhdGVfYnVpbGRzIC0gY29tcHV0ZWQ6IHRydWUsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfc2tpcEludGVybWVkaWF0ZUJ1aWxkcz86IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZTsgXG4gIHB1YmxpYyBnZXQgc2tpcEludGVybWVkaWF0ZUJ1aWxkcygpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRCb29sZWFuQXR0cmlidXRlKCdza2lwX2ludGVybWVkaWF0ZV9idWlsZHMnKTtcbiAgfVxuICBwdWJsaWMgc2V0IHNraXBJbnRlcm1lZGlhdGVCdWlsZHModmFsdWU6IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZSkge1xuICAgIHRoaXMuX3NraXBJbnRlcm1lZGlhdGVCdWlsZHMgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRTa2lwSW50ZXJtZWRpYXRlQnVpbGRzKCkge1xuICAgIHRoaXMuX3NraXBJbnRlcm1lZGlhdGVCdWlsZHMgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IHNraXBJbnRlcm1lZGlhdGVCdWlsZHNJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fc2tpcEludGVybWVkaWF0ZUJ1aWxkcztcbiAgfVxuXG4gIC8vIHNraXBfaW50ZXJtZWRpYXRlX2J1aWxkc19icmFuY2hfZmlsdGVyIC0gY29tcHV0ZWQ6IHRydWUsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfc2tpcEludGVybWVkaWF0ZUJ1aWxkc0JyYW5jaEZpbHRlcj86IHN0cmluZzsgXG4gIHB1YmxpYyBnZXQgc2tpcEludGVybWVkaWF0ZUJ1aWxkc0JyYW5jaEZpbHRlcigpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ3NraXBfaW50ZXJtZWRpYXRlX2J1aWxkc19icmFuY2hfZmlsdGVyJyk7XG4gIH1cbiAgcHVibGljIHNldCBza2lwSW50ZXJtZWRpYXRlQnVpbGRzQnJhbmNoRmlsdGVyKHZhbHVlOiBzdHJpbmcpIHtcbiAgICB0aGlzLl9za2lwSW50ZXJtZWRpYXRlQnVpbGRzQnJhbmNoRmlsdGVyID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0U2tpcEludGVybWVkaWF0ZUJ1aWxkc0JyYW5jaEZpbHRlcigpIHtcbiAgICB0aGlzLl9za2lwSW50ZXJtZWRpYXRlQnVpbGRzQnJhbmNoRmlsdGVyID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBza2lwSW50ZXJtZWRpYXRlQnVpbGRzQnJhbmNoRmlsdGVySW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX3NraXBJbnRlcm1lZGlhdGVCdWlsZHNCcmFuY2hGaWx0ZXI7XG4gIH1cblxuICAvLyBzbHVnIC0gY29tcHV0ZWQ6IHRydWUsIG9wdGlvbmFsOiBmYWxzZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHB1YmxpYyBnZXQgc2x1ZygpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ3NsdWcnKTtcbiAgfVxuXG4gIC8vIHN0ZXBzIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogZmFsc2UsIHJlcXVpcmVkOiB0cnVlXG4gIHByaXZhdGUgX3N0ZXBzPzogc3RyaW5nOyBcbiAgcHVibGljIGdldCBzdGVwcygpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ3N0ZXBzJyk7XG4gIH1cbiAgcHVibGljIHNldCBzdGVwcyh2YWx1ZTogc3RyaW5nKSB7XG4gICAgdGhpcy5fc3RlcHMgPSB2YWx1ZTtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgc3RlcHNJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fc3RlcHM7XG4gIH1cblxuICAvLyB0YWdzIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX3RhZ3M/OiBzdHJpbmdbXTsgXG4gIHB1YmxpYyBnZXQgdGFncygpIHtcbiAgICByZXR1cm4gY2RrdGYuRm4udG9saXN0KHRoaXMuZ2V0TGlzdEF0dHJpYnV0ZSgndGFncycpKTtcbiAgfVxuICBwdWJsaWMgc2V0IHRhZ3ModmFsdWU6IHN0cmluZ1tdKSB7XG4gICAgdGhpcy5fdGFncyA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldFRhZ3MoKSB7XG4gICAgdGhpcy5fdGFncyA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgdGFnc0lucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl90YWdzO1xuICB9XG5cbiAgLy8gdGVhbSAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF90ZWFtPzogUGlwZWxpbmVUZWFtW10gfCBjZGt0Zi5JUmVzb2x2YWJsZTsgXG4gIHB1YmxpYyBnZXQgdGVhbSgpIHtcbiAgICAvLyBHZXR0aW5nIHRoZSBjb21wdXRlZCB2YWx1ZSBpcyBub3QgeWV0IGltcGxlbWVudGVkXG4gICAgcmV0dXJuIGNka3RmLlRva2VuLmFzQW55KGNka3RmLkZuLnRvbGlzdCh0aGlzLmludGVycG9sYXRpb25Gb3JBdHRyaWJ1dGUoJ3RlYW0nKSkpO1xuICB9XG4gIHB1YmxpYyBzZXQgdGVhbSh2YWx1ZTogUGlwZWxpbmVUZWFtW10gfCBjZGt0Zi5JUmVzb2x2YWJsZSkge1xuICAgIHRoaXMuX3RlYW0gPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRUZWFtKCkge1xuICAgIHRoaXMuX3RlYW0gPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IHRlYW1JbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fdGVhbTtcbiAgfVxuXG4gIC8vIHdlYmhvb2tfdXJsIC0gY29tcHV0ZWQ6IHRydWUsIG9wdGlvbmFsOiBmYWxzZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHB1YmxpYyBnZXQgd2ViaG9va1VybCgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ3dlYmhvb2tfdXJsJyk7XG4gIH1cblxuICAvLyBwcm92aWRlcl9zZXR0aW5ncyAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9wcm92aWRlclNldHRpbmdzID0gbmV3IFBpcGVsaW5lUHJvdmlkZXJTZXR0aW5nc091dHB1dFJlZmVyZW5jZSh0aGlzLCBcInByb3ZpZGVyX3NldHRpbmdzXCIpO1xuICBwdWJsaWMgZ2V0IHByb3ZpZGVyU2V0dGluZ3MoKSB7XG4gICAgcmV0dXJuIHRoaXMuX3Byb3ZpZGVyU2V0dGluZ3M7XG4gIH1cbiAgcHVibGljIHB1dFByb3ZpZGVyU2V0dGluZ3ModmFsdWU6IFBpcGVsaW5lUHJvdmlkZXJTZXR0aW5ncykge1xuICAgIHRoaXMuX3Byb3ZpZGVyU2V0dGluZ3MuaW50ZXJuYWxWYWx1ZSA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldFByb3ZpZGVyU2V0dGluZ3MoKSB7XG4gICAgdGhpcy5fcHJvdmlkZXJTZXR0aW5ncy5pbnRlcm5hbFZhbHVlID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBwcm92aWRlclNldHRpbmdzSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX3Byb3ZpZGVyU2V0dGluZ3MuaW50ZXJuYWxWYWx1ZTtcbiAgfVxuXG4gIC8vID09PT09PT09PVxuICAvLyBTWU5USEVTSVNcbiAgLy8gPT09PT09PT09XG5cbiAgcHJvdGVjdGVkIHN5bnRoZXNpemVBdHRyaWJ1dGVzKCk6IHsgW25hbWU6IHN0cmluZ106IGFueSB9IHtcbiAgICByZXR1cm4ge1xuICAgICAgYWxsb3dfcmVidWlsZHM6IGNka3RmLmJvb2xlYW5Ub1RlcnJhZm9ybSh0aGlzLl9hbGxvd1JlYnVpbGRzKSxcbiAgICAgIGJyYW5jaF9jb25maWd1cmF0aW9uOiBjZGt0Zi5zdHJpbmdUb1RlcnJhZm9ybSh0aGlzLl9icmFuY2hDb25maWd1cmF0aW9uKSxcbiAgICAgIGNhbmNlbF9pbnRlcm1lZGlhdGVfYnVpbGRzOiBjZGt0Zi5ib29sZWFuVG9UZXJyYWZvcm0odGhpcy5fY2FuY2VsSW50ZXJtZWRpYXRlQnVpbGRzKSxcbiAgICAgIGNhbmNlbF9pbnRlcm1lZGlhdGVfYnVpbGRzX2JyYW5jaF9maWx0ZXI6IGNka3RmLnN0cmluZ1RvVGVycmFmb3JtKHRoaXMuX2NhbmNlbEludGVybWVkaWF0ZUJ1aWxkc0JyYW5jaEZpbHRlciksXG4gICAgICBjbHVzdGVyX2lkOiBjZGt0Zi5zdHJpbmdUb1RlcnJhZm9ybSh0aGlzLl9jbHVzdGVySWQpLFxuICAgICAgZGVmYXVsdF9icmFuY2g6IGNka3RmLnN0cmluZ1RvVGVycmFmb3JtKHRoaXMuX2RlZmF1bHRCcmFuY2gpLFxuICAgICAgZGVzY3JpcHRpb246IGNka3RmLnN0cmluZ1RvVGVycmFmb3JtKHRoaXMuX2Rlc2NyaXB0aW9uKSxcbiAgICAgIG5hbWU6IGNka3RmLnN0cmluZ1RvVGVycmFmb3JtKHRoaXMuX25hbWUpLFxuICAgICAgcmVwb3NpdG9yeTogY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0odGhpcy5fcmVwb3NpdG9yeSksXG4gICAgICBza2lwX2ludGVybWVkaWF0ZV9idWlsZHM6IGNka3RmLmJvb2xlYW5Ub1RlcnJhZm9ybSh0aGlzLl9za2lwSW50ZXJtZWRpYXRlQnVpbGRzKSxcbiAgICAgIHNraXBfaW50ZXJtZWRpYXRlX2J1aWxkc19icmFuY2hfZmlsdGVyOiBjZGt0Zi5zdHJpbmdUb1RlcnJhZm9ybSh0aGlzLl9za2lwSW50ZXJtZWRpYXRlQnVpbGRzQnJhbmNoRmlsdGVyKSxcbiAgICAgIHN0ZXBzOiBjZGt0Zi5zdHJpbmdUb1RlcnJhZm9ybSh0aGlzLl9zdGVwcyksXG4gICAgICB0YWdzOiBjZGt0Zi5saXN0TWFwcGVyKGNka3RmLnN0cmluZ1RvVGVycmFmb3JtKSh0aGlzLl90YWdzKSxcbiAgICAgIHRlYW06IGNka3RmLmxpc3RNYXBwZXIocGlwZWxpbmVUZWFtVG9UZXJyYWZvcm0pKHRoaXMuX3RlYW0pLFxuICAgICAgcHJvdmlkZXJfc2V0dGluZ3M6IHBpcGVsaW5lUHJvdmlkZXJTZXR0aW5nc1RvVGVycmFmb3JtKHRoaXMuX3Byb3ZpZGVyU2V0dGluZ3MuaW50ZXJuYWxWYWx1ZSksXG4gICAgfTtcbiAgfVxufVxuIl19