import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface PipelineConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/buildkite/r/pipeline#allow_rebuilds Pipeline#allow_rebuilds}
    */
    readonly allowRebuilds?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/buildkite/r/pipeline#branch_configuration Pipeline#branch_configuration}
    */
    readonly branchConfiguration?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/buildkite/r/pipeline#cancel_intermediate_builds Pipeline#cancel_intermediate_builds}
    */
    readonly cancelIntermediateBuilds?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/buildkite/r/pipeline#cancel_intermediate_builds_branch_filter Pipeline#cancel_intermediate_builds_branch_filter}
    */
    readonly cancelIntermediateBuildsBranchFilter?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/buildkite/r/pipeline#cluster_id Pipeline#cluster_id}
    */
    readonly clusterId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/buildkite/r/pipeline#default_branch Pipeline#default_branch}
    */
    readonly defaultBranch?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/buildkite/r/pipeline#description Pipeline#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/buildkite/r/pipeline#name Pipeline#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/buildkite/r/pipeline#repository Pipeline#repository}
    */
    readonly repository: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/buildkite/r/pipeline#skip_intermediate_builds Pipeline#skip_intermediate_builds}
    */
    readonly skipIntermediateBuilds?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/buildkite/r/pipeline#skip_intermediate_builds_branch_filter Pipeline#skip_intermediate_builds_branch_filter}
    */
    readonly skipIntermediateBuildsBranchFilter?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/buildkite/r/pipeline#steps Pipeline#steps}
    */
    readonly steps: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/buildkite/r/pipeline#tags Pipeline#tags}
    */
    readonly tags?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/buildkite/r/pipeline#team Pipeline#team}
    */
    readonly team?: PipelineTeam[] | cdktf.IResolvable;
    /**
    * provider_settings block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/buildkite/r/pipeline#provider_settings Pipeline#provider_settings}
    */
    readonly providerSettings?: PipelineProviderSettings;
}
export interface PipelineTeam {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/buildkite/r/pipeline#access_level Pipeline#access_level}
    */
    readonly accessLevel?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/buildkite/r/pipeline#slug Pipeline#slug}
    */
    readonly slug?: string;
}
export declare function pipelineTeamToTerraform(struct?: PipelineTeam | cdktf.IResolvable): any;
export interface PipelineProviderSettings {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/buildkite/r/pipeline#build_branches Pipeline#build_branches}
    */
    readonly buildBranches?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/buildkite/r/pipeline#build_pull_request_forks Pipeline#build_pull_request_forks}
    */
    readonly buildPullRequestForks?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/buildkite/r/pipeline#build_pull_request_labels_changed Pipeline#build_pull_request_labels_changed}
    */
    readonly buildPullRequestLabelsChanged?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/buildkite/r/pipeline#build_pull_request_ready_for_review Pipeline#build_pull_request_ready_for_review}
    */
    readonly buildPullRequestReadyForReview?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/buildkite/r/pipeline#build_pull_requests Pipeline#build_pull_requests}
    */
    readonly buildPullRequests?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/buildkite/r/pipeline#build_tags Pipeline#build_tags}
    */
    readonly buildTags?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/buildkite/r/pipeline#cancel_deleted_branch_builds Pipeline#cancel_deleted_branch_builds}
    */
    readonly cancelDeletedBranchBuilds?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/buildkite/r/pipeline#filter_condition Pipeline#filter_condition}
    */
    readonly filterCondition?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/buildkite/r/pipeline#filter_enabled Pipeline#filter_enabled}
    */
    readonly filterEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/buildkite/r/pipeline#prefix_pull_request_fork_branch_names Pipeline#prefix_pull_request_fork_branch_names}
    */
    readonly prefixPullRequestForkBranchNames?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/buildkite/r/pipeline#publish_blocked_as_pending Pipeline#publish_blocked_as_pending}
    */
    readonly publishBlockedAsPending?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/buildkite/r/pipeline#publish_commit_status Pipeline#publish_commit_status}
    */
    readonly publishCommitStatus?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/buildkite/r/pipeline#publish_commit_status_per_step Pipeline#publish_commit_status_per_step}
    */
    readonly publishCommitStatusPerStep?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/buildkite/r/pipeline#pull_request_branch_filter_configuration Pipeline#pull_request_branch_filter_configuration}
    */
    readonly pullRequestBranchFilterConfiguration?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/buildkite/r/pipeline#pull_request_branch_filter_enabled Pipeline#pull_request_branch_filter_enabled}
    */
    readonly pullRequestBranchFilterEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/buildkite/r/pipeline#separate_pull_request_statuses Pipeline#separate_pull_request_statuses}
    */
    readonly separatePullRequestStatuses?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/buildkite/r/pipeline#skip_pull_request_builds_for_existing_commits Pipeline#skip_pull_request_builds_for_existing_commits}
    */
    readonly skipPullRequestBuildsForExistingCommits?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/buildkite/r/pipeline#trigger_mode Pipeline#trigger_mode}
    */
    readonly triggerMode?: string;
}
export declare function pipelineProviderSettingsToTerraform(struct?: PipelineProviderSettingsOutputReference | PipelineProviderSettings): any;
export declare class PipelineProviderSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PipelineProviderSettings | undefined;
    set internalValue(value: PipelineProviderSettings | undefined);
    private _buildBranches?;
    get buildBranches(): boolean | cdktf.IResolvable;
    set buildBranches(value: boolean | cdktf.IResolvable);
    resetBuildBranches(): void;
    get buildBranchesInput(): boolean | cdktf.IResolvable | undefined;
    private _buildPullRequestForks?;
    get buildPullRequestForks(): boolean | cdktf.IResolvable;
    set buildPullRequestForks(value: boolean | cdktf.IResolvable);
    resetBuildPullRequestForks(): void;
    get buildPullRequestForksInput(): boolean | cdktf.IResolvable | undefined;
    private _buildPullRequestLabelsChanged?;
    get buildPullRequestLabelsChanged(): boolean | cdktf.IResolvable;
    set buildPullRequestLabelsChanged(value: boolean | cdktf.IResolvable);
    resetBuildPullRequestLabelsChanged(): void;
    get buildPullRequestLabelsChangedInput(): boolean | cdktf.IResolvable | undefined;
    private _buildPullRequestReadyForReview?;
    get buildPullRequestReadyForReview(): boolean | cdktf.IResolvable;
    set buildPullRequestReadyForReview(value: boolean | cdktf.IResolvable);
    resetBuildPullRequestReadyForReview(): void;
    get buildPullRequestReadyForReviewInput(): boolean | cdktf.IResolvable | undefined;
    private _buildPullRequests?;
    get buildPullRequests(): boolean | cdktf.IResolvable;
    set buildPullRequests(value: boolean | cdktf.IResolvable);
    resetBuildPullRequests(): void;
    get buildPullRequestsInput(): boolean | cdktf.IResolvable | undefined;
    private _buildTags?;
    get buildTags(): boolean | cdktf.IResolvable;
    set buildTags(value: boolean | cdktf.IResolvable);
    resetBuildTags(): void;
    get buildTagsInput(): boolean | cdktf.IResolvable | undefined;
    private _cancelDeletedBranchBuilds?;
    get cancelDeletedBranchBuilds(): boolean | cdktf.IResolvable;
    set cancelDeletedBranchBuilds(value: boolean | cdktf.IResolvable);
    resetCancelDeletedBranchBuilds(): void;
    get cancelDeletedBranchBuildsInput(): boolean | cdktf.IResolvable | undefined;
    private _filterCondition?;
    get filterCondition(): string;
    set filterCondition(value: string);
    resetFilterCondition(): void;
    get filterConditionInput(): string | undefined;
    private _filterEnabled?;
    get filterEnabled(): boolean | cdktf.IResolvable;
    set filterEnabled(value: boolean | cdktf.IResolvable);
    resetFilterEnabled(): void;
    get filterEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _prefixPullRequestForkBranchNames?;
    get prefixPullRequestForkBranchNames(): boolean | cdktf.IResolvable;
    set prefixPullRequestForkBranchNames(value: boolean | cdktf.IResolvable);
    resetPrefixPullRequestForkBranchNames(): void;
    get prefixPullRequestForkBranchNamesInput(): boolean | cdktf.IResolvable | undefined;
    private _publishBlockedAsPending?;
    get publishBlockedAsPending(): boolean | cdktf.IResolvable;
    set publishBlockedAsPending(value: boolean | cdktf.IResolvable);
    resetPublishBlockedAsPending(): void;
    get publishBlockedAsPendingInput(): boolean | cdktf.IResolvable | undefined;
    private _publishCommitStatus?;
    get publishCommitStatus(): boolean | cdktf.IResolvable;
    set publishCommitStatus(value: boolean | cdktf.IResolvable);
    resetPublishCommitStatus(): void;
    get publishCommitStatusInput(): boolean | cdktf.IResolvable | undefined;
    private _publishCommitStatusPerStep?;
    get publishCommitStatusPerStep(): boolean | cdktf.IResolvable;
    set publishCommitStatusPerStep(value: boolean | cdktf.IResolvable);
    resetPublishCommitStatusPerStep(): void;
    get publishCommitStatusPerStepInput(): boolean | cdktf.IResolvable | undefined;
    private _pullRequestBranchFilterConfiguration?;
    get pullRequestBranchFilterConfiguration(): string;
    set pullRequestBranchFilterConfiguration(value: string);
    resetPullRequestBranchFilterConfiguration(): void;
    get pullRequestBranchFilterConfigurationInput(): string | undefined;
    private _pullRequestBranchFilterEnabled?;
    get pullRequestBranchFilterEnabled(): boolean | cdktf.IResolvable;
    set pullRequestBranchFilterEnabled(value: boolean | cdktf.IResolvable);
    resetPullRequestBranchFilterEnabled(): void;
    get pullRequestBranchFilterEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _separatePullRequestStatuses?;
    get separatePullRequestStatuses(): boolean | cdktf.IResolvable;
    set separatePullRequestStatuses(value: boolean | cdktf.IResolvable);
    resetSeparatePullRequestStatuses(): void;
    get separatePullRequestStatusesInput(): boolean | cdktf.IResolvable | undefined;
    private _skipPullRequestBuildsForExistingCommits?;
    get skipPullRequestBuildsForExistingCommits(): boolean | cdktf.IResolvable;
    set skipPullRequestBuildsForExistingCommits(value: boolean | cdktf.IResolvable);
    resetSkipPullRequestBuildsForExistingCommits(): void;
    get skipPullRequestBuildsForExistingCommitsInput(): boolean | cdktf.IResolvable | undefined;
    private _triggerMode?;
    get triggerMode(): string;
    set triggerMode(value: string);
    resetTriggerMode(): void;
    get triggerModeInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/buildkite/r/pipeline buildkite_pipeline}
*/
export declare class Pipeline extends cdktf.TerraformResource {
    static readonly tfResourceType = "buildkite_pipeline";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/buildkite/r/pipeline buildkite_pipeline} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options PipelineConfig
    */
    constructor(scope: Construct, id: string, config: PipelineConfig);
    private _allowRebuilds?;
    get allowRebuilds(): boolean | cdktf.IResolvable;
    set allowRebuilds(value: boolean | cdktf.IResolvable);
    resetAllowRebuilds(): void;
    get allowRebuildsInput(): boolean | cdktf.IResolvable | undefined;
    get badgeUrl(): string;
    private _branchConfiguration?;
    get branchConfiguration(): string;
    set branchConfiguration(value: string);
    resetBranchConfiguration(): void;
    get branchConfigurationInput(): string | undefined;
    private _cancelIntermediateBuilds?;
    get cancelIntermediateBuilds(): boolean | cdktf.IResolvable;
    set cancelIntermediateBuilds(value: boolean | cdktf.IResolvable);
    resetCancelIntermediateBuilds(): void;
    get cancelIntermediateBuildsInput(): boolean | cdktf.IResolvable | undefined;
    private _cancelIntermediateBuildsBranchFilter?;
    get cancelIntermediateBuildsBranchFilter(): string;
    set cancelIntermediateBuildsBranchFilter(value: string);
    resetCancelIntermediateBuildsBranchFilter(): void;
    get cancelIntermediateBuildsBranchFilterInput(): string | undefined;
    private _clusterId?;
    get clusterId(): string;
    set clusterId(value: string);
    resetClusterId(): void;
    get clusterIdInput(): string | undefined;
    private _defaultBranch?;
    get defaultBranch(): string;
    set defaultBranch(value: string);
    resetDefaultBranch(): void;
    get defaultBranchInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _repository?;
    get repository(): string;
    set repository(value: string);
    get repositoryInput(): string | undefined;
    private _skipIntermediateBuilds?;
    get skipIntermediateBuilds(): boolean | cdktf.IResolvable;
    set skipIntermediateBuilds(value: boolean | cdktf.IResolvable);
    resetSkipIntermediateBuilds(): void;
    get skipIntermediateBuildsInput(): boolean | cdktf.IResolvable | undefined;
    private _skipIntermediateBuildsBranchFilter?;
    get skipIntermediateBuildsBranchFilter(): string;
    set skipIntermediateBuildsBranchFilter(value: string);
    resetSkipIntermediateBuildsBranchFilter(): void;
    get skipIntermediateBuildsBranchFilterInput(): string | undefined;
    get slug(): string;
    private _steps?;
    get steps(): string;
    set steps(value: string);
    get stepsInput(): string | undefined;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    private _team?;
    get team(): PipelineTeam[] | cdktf.IResolvable;
    set team(value: PipelineTeam[] | cdktf.IResolvable);
    resetTeam(): void;
    get teamInput(): cdktf.IResolvable | PipelineTeam[] | undefined;
    get webhookUrl(): string;
    private _providerSettings;
    get providerSettings(): PipelineProviderSettingsOutputReference;
    putProviderSettings(value: PipelineProviderSettings): void;
    resetProviderSettings(): void;
    get providerSettingsInput(): PipelineProviderSettings | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=pipeline.d.ts.map