import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface PipelineScheduleConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/buildkite/r/pipeline_schedule#branch PipelineSchedule#branch}
    */
    readonly branch: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/buildkite/r/pipeline_schedule#commit PipelineSchedule#commit}
    */
    readonly commit?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/buildkite/r/pipeline_schedule#cronline PipelineSchedule#cronline}
    */
    readonly cronline: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/buildkite/r/pipeline_schedule#enabled PipelineSchedule#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/buildkite/r/pipeline_schedule#env PipelineSchedule#env}
    */
    readonly env?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/buildkite/r/pipeline_schedule#label PipelineSchedule#label}
    */
    readonly label: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/buildkite/r/pipeline_schedule#message PipelineSchedule#message}
    */
    readonly message?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/buildkite/r/pipeline_schedule#pipeline_id PipelineSchedule#pipeline_id}
    */
    readonly pipelineId: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/buildkite/r/pipeline_schedule buildkite_pipeline_schedule}
*/
export declare class PipelineSchedule extends cdktf.TerraformResource {
    static readonly tfResourceType = "buildkite_pipeline_schedule";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/buildkite/r/pipeline_schedule buildkite_pipeline_schedule} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options PipelineScheduleConfig
    */
    constructor(scope: Construct, id: string, config: PipelineScheduleConfig);
    private _branch?;
    get branch(): string;
    set branch(value: string);
    get branchInput(): string | undefined;
    private _commit?;
    get commit(): string;
    set commit(value: string);
    resetCommit(): void;
    get commitInput(): string | undefined;
    private _cronline?;
    get cronline(): string;
    set cronline(value: string);
    get cronlineInput(): string | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _env?;
    get env(): {
        [key: string]: string;
    };
    set env(value: {
        [key: string]: string;
    });
    resetEnv(): void;
    get envInput(): {
        [key: string]: string;
    } | undefined;
    get id(): string;
    private _label?;
    get label(): string;
    set label(value: string);
    get labelInput(): string | undefined;
    private _message?;
    get message(): string;
    set message(value: string);
    resetMessage(): void;
    get messageInput(): string | undefined;
    private _pipelineId?;
    get pipelineId(): string;
    set pipelineId(value: string);
    get pipelineIdInput(): string | undefined;
    get uuid(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=pipeline-schedule.d.ts.map