import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataBuildkiteTeamConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/buildkite/d/team#slug DataBuildkiteTeam#slug}
    */
    readonly slug: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/buildkite/d/team buildkite_team}
*/
export declare class DataBuildkiteTeam extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "buildkite_team";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/buildkite/d/team buildkite_team} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataBuildkiteTeamConfig
    */
    constructor(scope: Construct, id: string, config: DataBuildkiteTeamConfig);
    get defaultMemberRole(): string;
    get defaultTeam(): cdktf.IResolvable;
    get description(): string;
    get id(): string;
    get membersCanCreatePipelines(): cdktf.IResolvable;
    get name(): string;
    get privacy(): string;
    private _slug?;
    get slug(): string;
    set slug(value: string);
    get slugInput(): string | undefined;
    get uuid(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=data-buildkite-team.d.ts.map