import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataBuildkitePipelineConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/buildkite/d/pipeline#slug DataBuildkitePipeline#slug}
    */
    readonly slug: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/buildkite/d/pipeline buildkite_pipeline}
*/
export declare class DataBuildkitePipeline extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "buildkite_pipeline";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/buildkite/d/pipeline buildkite_pipeline} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataBuildkitePipelineConfig
    */
    constructor(scope: Construct, id: string, config: DataBuildkitePipelineConfig);
    get defaultBranch(): string;
    get description(): string;
    get id(): string;
    get name(): string;
    get repository(): string;
    private _slug?;
    get slug(): string;
    set slug(value: string);
    get slugInput(): string | undefined;
    get webhookUrl(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=data-buildkite-pipeline.d.ts.map