import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface BuildkiteProviderConfig {
    /**
    * API token with GraphQL access and `write_pipelines, read_pipelines` scopes
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/buildkite#api_token BuildkiteProvider#api_token}
    */
    readonly apiToken: string;
    /**
    * The Buildkite organization ID
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/buildkite#organization BuildkiteProvider#organization}
    */
    readonly organization: string;
    /**
    * Alias name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/buildkite#alias BuildkiteProvider#alias}
    */
    readonly alias?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/buildkite buildkite}
*/
export declare class BuildkiteProvider extends cdktf.TerraformProvider {
    static readonly tfResourceType = "buildkite";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/buildkite buildkite} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options BuildkiteProviderConfig
    */
    constructor(scope: Construct, id: string, config: BuildkiteProviderConfig);
    private _apiToken?;
    get apiToken(): string | undefined;
    set apiToken(value: string | undefined);
    get apiTokenInput(): string | undefined;
    private _organization?;
    get organization(): string | undefined;
    set organization(value: string | undefined);
    get organizationInput(): string | undefined;
    private _alias?;
    get alias(): string | undefined;
    set alias(value: string | undefined);
    resetAlias(): void;
    get aliasInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=buildkite-provider.d.ts.map