import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AgentTokenConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/buildkite/r/agent_token#description AgentToken#description}
    */
    readonly description?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/buildkite/r/agent_token buildkite_agent_token}
*/
export declare class AgentToken extends cdktf.TerraformResource {
    static readonly tfResourceType = "buildkite_agent_token";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/buildkite/r/agent_token buildkite_agent_token} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AgentTokenConfig = {}
    */
    constructor(scope: Construct, id: string, config?: AgentTokenConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get id(): string;
    get token(): string;
    get uuid(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=agent-token.d.ts.map