import { FileStatusResult, StatusResult, StatusResultRenamed } from '../../../typings';
/**
 * The StatusSummary is returned as a response to getting `git().status()`
 */
export declare class StatusSummary implements StatusResult {
    not_added: string[];
    conflicted: string[];
    created: string[];
    deleted: string[];
    modified: string[];
    renamed: StatusResultRenamed[];
    /**
     * All files represented as an array of objects containing the `path` and status in `index` and
     * in the `working_dir`.
     */
    files: FileStatusResult[];
    staged: string[];
    /**
     * Number of commits ahead of the tracked branch
     */
    ahead: number;
    /**
     *Number of commits behind the tracked branch
     */
    behind: number;
    /**
     * Name of the current branch
     */
    current: string | null;
    /**
     * Name of the branch being tracked
     */
    tracking: string | null;
    /**
     * Gets whether this StatusSummary represents a clean working branch.
     */
    isClean(): boolean;
}
export declare const parseStatusSummary: (text: string) => StatusResult;
