import * as cdk from '@aws-cdk/core';
import { Component, StringComponentMap } from './index';
/**
 * @stability stable
 */
export declare class ComponentBuilder {
    /**
     * @stability stable
     */
    componentDeps: any[];
    /**
     * @stability stable
     */
    scope: cdk.Construct;
    /**
     * @stability stable
     */
    cacheDir: string;
    /**
     * @stability stable
     */
    pipelineName: string;
    /**
     * @stability stable
     */
    platform: string;
    /**
     * @stability stable
     */
    constructor(scope: cdk.Construct, componentDefs: any[], pipeline_name: string, platform: string);
    /**
     * @stability stable
     */
    createComponentDependenciesMap(): StringComponentMap;
    /**
     * @stability stable
     */
    createComponent(componentConfig: any): Component | undefined;
    /**
     * @stability stable
     */
    assembleComponent(componentConfig: any, basedir: string): any;
    private addDependencyConstants;
    private addPhaseExtensions;
    private checkComponentYaml;
}
