import boto3
import os

as_client= boto3.client('autoscaling')
ec2_res = boto3.resource('ec2')
images = ec2_res.images.filter(Owners=["self"])

def handler(event, context):
    images_list = []

    response = as_client.describe_launch_configurations(
        MaxRecords=100
    )

    if "LaunchConfigurations" in response:
        launch_configs = response["LaunchConfigurations"]
        image_ids = [x["ImageId"] for x in launch_configs]

        print(f"ImageIds: {image_ids}")

        for image in images:
            if not image.image_id in image_ids and \
                has_tag(image, "CreatedBy", "EC2 Image Builder") and \
                has_tag(image, "Name", os.getenv("PIPELINE_NAME")) :
                images_list.append(image)

        candidate_list = [x.image_id for x in images_list]
        print(f"Candidate deregister list: {candidate_list}")

        for image in images_list:
            print(f"Deregistering {image.image_id}")
            image.deregister()


def has_tag(image, key, value):
    tags = [t for t in image.tags if t["Key"] ==  key] if image.tags is not None else []

    if len(tags) > 0 and tags[0]["Value"] == value:
        return True
    
    return False
