# python-exoscale: Python bindings for Exoscale API

[![Actions Status](https://github.com/exoscale/python-exoscale/workflows/CI/badge.svg)](https://github.com/exoscale/python-exoscale/actions?query=workflow%3ACI)

This library allows developpers to use the [Exoscale] cloud platform API with
high-level Python bindings. API documentation and usage examples can be found
at this address: https://exoscale.github.io/python-exoscale

## Development

First create a new virtual environment and run `make installrequirements`.
Then create a configuration file with your **production** user's API keys.
This file may be create for example in `junk/config.toml`. Here is an example:

    default_profile = "prod:you"

    [[profiles]]
    name       = "prod:you"
    api_key    = "EXOxxxx"
    api_secret = "yyyy"

Once this file is created you can run pytest with the following command:

    EXOSCALE_CONFIG_FILE=./junk/config.toml pytest -x -s -vvv tests/*.py

[exoscale]: https://www.exoscale.com/
