"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApiMapping = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_apigatewayv2_1 = require("aws-cdk-lib/aws-apigatewayv2");
/**
 * Create a new API mapping for API Gateway API endpoint.
 * @resource AWS::ApiGatewayV2::ApiMapping
 */
class ApiMapping extends aws_cdk_lib_1.Resource {
    constructor(scope, id, props) {
        var _b;
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_alpha_ApiMappingProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        // defaultStage is present in IHttpStage.
        // However, importing "http" or "websocket" must import "common", but creating dependencies
        // the other way will cause potential cycles.
        // So casting to 'any'
        let stage = (_b = props.stage) !== null && _b !== void 0 ? _b : props.api.defaultStage;
        if (!stage) {
            throw new Error('stage property must be specified');
        }
        if (props.apiMappingKey === '') {
            throw new Error('empty string for api mapping key not allowed');
        }
        const apiMappingProps = {
            apiId: props.api.apiId,
            domainName: props.domainName.name,
            stage: stage.stageName,
            apiMappingKey: props.apiMappingKey,
        };
        const resource = new aws_apigatewayv2_1.CfnApiMapping(this, 'Resource', apiMappingProps);
        // ensure the dependency on the provided stage
        this.node.addDependency(stage);
        this.apiMappingId = resource.ref;
        this.mappingKey = props.apiMappingKey;
        this.domainName = props.domainName;
    }
    /**
     * import from API ID
     */
    static fromApiMappingAttributes(scope, id, attrs) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_alpha_ApiMappingAttributes(attrs);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromApiMappingAttributes);
            }
            throw error;
        }
        class Import extends aws_cdk_lib_1.Resource {
            constructor() {
                super(...arguments);
                this.apiMappingId = attrs.apiMappingId;
            }
        }
        return new Import(scope, id);
    }
}
exports.ApiMapping = ApiMapping;
_a = JSII_RTTI_SYMBOL_1;
ApiMapping[_a] = { fqn: "@aws-cdk/aws-apigatewayv2-alpha.ApiMapping", version: "2.21.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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