"""
The Union-Find decoder [delfosse2017almost]_ maps each element of the syndrome :math:`\\sigma` to an ancilla :math:`v` in a non-connected graph defined on the code lattice. From this starting point, it grows clusters around these ancillas by repeatedly adding a layer of edges and ancillas to existing clusters, until all clusters have an even number of non-trivial syndrome ancillas. Then, it selects a spanning tree :math:`F` for each cluster. 

The leaves of each spanning tree are conditionally peeled in a tail-recursive breadth-first search until all non-trivial syndrome ancillas are paired and linked by a path within :math:`F`, which is the correcting operator :math:`\\mathcal{C}` [delfosse2017linear]_.  The strategy for constructing the clusters turns out to have a strong effect on performance. For instance, the threshold for bitflip noise of a decoder that grows the clusters following a random order is 9.2% [delfosse2017almost]_, while if the clusters are grown in order of cluster size, which we call **Weighted Growth**, the threshold increases to 9.9% [delfosse2017almost]_.

The complexity of the Union-Find decoder is driven by the merging of the clusters. For this, the algorithm uses the Union-Find or disjoint-set data structure [tarjan1975efficiency]_. This data structure contains a set of elements, in this case ancillas on the lattice. The set of elements is represented by a two-level tree. At the root of the tree sits one element chosen arbitrarily; the rest of the elements are linked to the root element. The structure admits two functions: :math:`Find` and :math:`Union`. Given :math:`v` an element from the structure, the function :math:`Find(v)` returns the root element of the tree. This is is used to identify the cluster to which :math:`v` belongs. The second function is :math:`Union(u, v)`, this function merges the sets associated with elements :math:`u` and :math:`v`. This requires pointing all the elements of one of the sets to the root of the other. In order to minimize the number of operations the root of the set with the larger number of elements is chosen as root for the merged set, this is called **Weighted Union**. In this context, :math:`Union` is used when the growth of a cluster requires adding a vertex that belongs to another. 
"""

from . import sim
from . import plot
