# Copyright (C) Martin Singer <martin.singer@web.de>
#
# This file is part of PDF Chain.
#
# PDF Chain is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# PDF Chain is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with PDF Chain.  If not, see <http://www.gnu.org/licenses/>.
#
# Author: Martin Singer

"""
@brief The Main Module.
@details
    This module contains the main function, which starts the application.
@par
    This main function is called by:
    - `__main__.py` module (calling the directory or the zipapp)
    - `bin/pdfchain` startup script (generated by `setup.py`)
"""

import sys
from pdfchain.app import Application as App


def main():
    """ Starting the application. """
    app = App()
    app.run(sys.argv)
