"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.KongEks = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
// import * as kong_core from '../../kong-core/';
const kong_core = require("kong-core");
const index_1 = require("./resources/eks/helm-charts/kong/index");
class KongEks extends constructs_1.Construct {
    /**
       * @summary Constructs a new instance of the KongEks class.
       * @param {cdk.App} scope - represents the scope for all the resources.
       * @param {string} id - this is a a scope-unique id.
       * @param {CloudFrontToApiGatewayToLambdaProps} props - user provided props for the construct.
       * @since 0.1.0
       * @access public
       */
    constructor(scope, id, props) {
        super(scope, id);
        this.clusterDns = `cluster.${props.hostedZoneName}:8005`;
        this.telemetryDns = `telemetry.${props.hostedZoneName}:8006`;
        const control_plane_secretskey = new aws_cdk_lib_1.aws_kms.Key(this, 'CPSecretsKey', {
            enableKeyRotation: true,
        });
        this.controlPlane = new aws_cdk_lib_1.aws_eks.Cluster(this, 'CP', {
            ...props.controlPlaneClusterProps.eksClusterProps,
            secretsEncryptionKey: control_plane_secretskey,
            defaultCapacity: 0,
        });
        const cp_nodegroup = this.controlPlane.addNodegroupCapacity('CpASG', props.controlPlaneNodeProps);
        cp_nodegroup.role.addManagedPolicy(aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName('AmazonSSMManagedInstanceCore'));
        // new EksNodeHandler(this, 'NodeHandler', {
        //   cluster: this.controlPlane,
        //   nodegroup: cp_nodegroup,
        // });
        new kong_core.MetricsServer(this, 'MetricsServer', {
            cluster: this.controlPlane,
        });
        const kong_rds_instance = new kong_core.RdsStack(this, 'KongRds', {
            ...props.rdsProps,
            vpc: this.controlPlane.vpc,
        });
        const kong_pre_requisites_nested_stack = new aws_cdk_lib_1.NestedStack(this, 'KongPreReqsStack');
        new kong_core.AutoScalar(this, 'AutoScalar', {
            cluster: this.controlPlane,
            nodegroup: cp_nodegroup,
            namespace: 'kube-system',
        });
        new kong_core.SecretsManager(kong_pre_requisites_nested_stack, 'SecretsCsi', {
            cluster: this.controlPlane,
        });
        new kong_core.ExternalDns(kong_pre_requisites_nested_stack, 'ExtDns', {
            cluster: this.controlPlane,
        });
        const aws_acm_pca = new kong_core.AcmPca(kong_pre_requisites_nested_stack, 'KongCpCa', {
            hostedZoneName: props.hostedZoneName,
            vpc: this.controlPlane.vpc,
        });
        new kong_core.AwsCertManager(kong_pre_requisites_nested_stack, 'KongCpCertManager', {
            cluster: this.controlPlane,
            clusterIssuerName: kong_core.Tls.KONG_CP_CLUSTER_ISSUER_NAME,
            privateCaArn: aws_acm_pca.privateCaArn,
        });
        this.privateCaArn = aws_acm_pca.privateCaArn;
        const kong_control_plane_nested_stack = new aws_cdk_lib_1.NestedStack(this, 'KongCpNestedStack');
        new index_1.KongControlPlaneEKS(kong_control_plane_nested_stack, 'KongCPHelmInstall', {
            cluster: this.controlPlane,
            rds: kong_rds_instance.kongPostgresSql,
            namespace: props.namespace,
            // nodegroup: cp_nodegroup,
            license_secret_name: props.licenseSecretsName,
            cacertname: kong_core.Tls.KONG_CP_CERTNAME,
            clusterIssuerName: kong_core.Tls.KONG_CP_CLUSTER_ISSUER_NAME,
            // commonname: 'www.dummy.com',
            hostedZoneName: 'kong-cp.internal',
            HelmOptions: props.controlPlaneClusterProps.kongHelmOptions,
            dnsNames: [
                `${props.hostedZoneName}`,
                `admin.${props.hostedZoneName}`,
                this.telemetryDns,
                this.clusterDns,
                `manager.${props.hostedZoneName}`,
            ],
        });
        kong_control_plane_nested_stack.node.addDependency(kong_pre_requisites_nested_stack, kong_rds_instance);
        const telemetry_nested_stack = new aws_cdk_lib_1.NestedStack(this, 'KongTelemetryNestedStack');
        const telemetry_stack = new kong_core.Telemetry(telemetry_nested_stack, 'KongLogging', {
            createPrometheusWorkspace: props.controlPlaneClusterProps.kongTelemetryOptions.createPrometheusWorkspace,
            cluster: this.controlPlane,
            namespace: kong_core.Namespace.TELEMETRY,
            cacertname: kong_core.Tls.ADOT_CERTNAME,
            clusterIssuerName: kong_core.Tls.KONG_CP_CLUSTER_ISSUER_NAME,
            dnsNames: [
                `${props.hostedZoneName}`,
                `admin.${props.hostedZoneName}`,
                this.telemetryDns,
                this.clusterDns,
                `manager.${props.hostedZoneName}`,
            ],
            hostedZoneName: props.hostedZoneName,
        });
        this.prometheusEndpoint = telemetry_stack.prometheusEndpoint;
        telemetry_nested_stack.node.addDependency(kong_pre_requisites_nested_stack);
    }
    ;
}
exports.KongEks = KongEks;
_a = JSII_RTTI_SYMBOL_1;
KongEks[_a] = { fqn: "kong-control-plane.KongEks", version: "3.0.0-dev.6" };
//# sourceMappingURL=data:application/json;base64,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