/*
 * Decompiled with CFR 0.152.
 */
package ro.webdata.parser.xml.dspace.core.wrapper.dc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ro.webdata.parser.xml.dspace.core.leaf.dcValue.DcValue;
import ro.webdata.parser.xml.dspace.core.leaf.dcValue.DcValueParser;
import ro.webdata.parser.xml.dspace.core.wrapper.dc.DcWrapper;

public class DcWrapperParser {
    public static DcWrapper getDcWrapper(Node node) {
        HashMap<String, List<DcValue>> hashMap = new HashMap<String, List<DcValue>>();
        NodeList childNodeList = node.getChildNodes();
        String schemaName = node.getAttributes().getNamedItem("schema").getNodeValue();
        for (int i = 0; i < childNodeList.getLength(); ++i) {
            Node child = childNodeList.item(i);
            String childName = child.getNodeName();
            if (!childName.equals("dcvalue")) continue;
            DcValue dcValue = DcValueParser.getDcValue(child);
            DcWrapperParser.addDcValue(hashMap, dcValue);
        }
        return new DcWrapper(hashMap, schemaName);
    }

    private static void addDcValue(Map<String, List<DcValue>> hashMap, DcValue dcValue) {
        String key = dcValue.getElement().getValue();
        List<DcValue> currentList = DcWrapperParser.generateList(hashMap, key);
        currentList.add(dcValue);
    }

    private static List<DcValue> generateList(Map<String, List<DcValue>> hashMap, String key) {
        List<DcValue> currentList = hashMap.get(key);
        if (currentList == null) {
            ArrayList<DcValue> list = new ArrayList<DcValue>();
            hashMap.put(key, list);
            return list;
        }
        return currentList;
    }
}

