/*
 * Decompiled with CFR 0.152.
 */
package ro.webdata.parser.xml.dspace.core;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;
import ro.webdata.parser.xml.dspace.common.Constants;
import ro.webdata.parser.xml.dspace.core.attribute.DcQualifier;
import ro.webdata.parser.xml.dspace.core.leaf.dcValue.DcValue;
import ro.webdata.parser.xml.dspace.core.wrapper.dc.DcWrapper;
import ro.webdata.parser.xml.dspace.core.wrapper.dc.DcWrapperParser;

public class Parser {
    public static DcWrapper parseDcXmlFile(String filePath) {
        DcWrapper dcWrapper = null;
        File xmlFile = new File(filePath);
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(xmlFile);
            doc.getDocumentElement().normalize();
            Element dcWrapperNode = doc.getDocumentElement();
            dcWrapper = DcWrapperParser.getDcWrapper(dcWrapperNode);
        }
        catch (IOException | ParserConfigurationException | SAXException e2) {
            e2.printStackTrace();
        }
        return dcWrapper;
    }

    public static List<String> getQualifierValues(String mainPath, String[] filesName) {
        HashSet<String> set = new HashSet<String>();
        for (String fileName : filesName) {
            String filePath = mainPath + Constants.FILE_SEPARATOR + fileName + ".xml";
            set.addAll(Parser.getQualifierValues(filePath));
        }
        return new ArrayList<String>(set);
    }

    private static Set<String> getQualifierValues(String filePath) {
        HashSet<String> set = new HashSet<String>();
        DcWrapper dcWrapper = Parser.parseDcXmlFile(filePath);
        Map<String, List<DcValue>> dcValueMap = dcWrapper.getDcValueMap();
        for (Map.Entry<String, List<DcValue>> entry : dcValueMap.entrySet()) {
            List<DcValue> dcValueList = entry.getValue();
            for (DcValue dcValue : dcValueList) {
                DcQualifier qualifier = dcValue.getQualifier();
                set.add(qualifier.getValue());
            }
        }
        return set;
    }
}

