/*
 * Decompiled with CFR 0.152.
 */
package ro.webdata.normalization.timespan.ro.regex;

public class YearRegex {
    private static final String BRACKETS_START = "[\\[\\(]";
    private static final String BRACKETS_END = "[\\]\\)]";
    private static final String PREFIX_CONSTRUCTIONS = "lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]";
    private static final String POSTFIX_CONSTRUCTIONS = "ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]";
    private static final String EXCLUDED_PREFIX = "(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)";
    private static final String EXCLUDED_POSTFIX = "(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))";
    public static final String YEAR_OR_SEPARATOR = "(\\s*(/|sau)\\s*)";
    public static final String YEAR_GROUP_1 = "(?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?";
    public static final String YEAR_GROUP_2 = "(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b";
    public static final String YEAR_GROUP = "(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))";
    public static final String YEAR_NOTATION = "(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?";
    public static final String YEAR = "(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))";
    private static final String YEAR_FIRST_HALF = "((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/2)|(\u00bd)|((prim[a]*[\\. ]+(jum([a\u0103]tate(a)?)?|part))([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))";
    private static final String YEAR_SECOND_HALF = "((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/2)|((a\\s+(doua|(ii[-a]*))[\\. ]+(jum([a\u0103]tate(a)?)?|part)[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))";
    private static final String YEAR_MIDDLE_OF = "((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(jum([a\u0103]tate(a)?)?|(mij[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)|mj\\.)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))";
    private static final String YEAR_FIRST_QUARTER = "((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/4)|(\u00bc)|(([i\u00ee]nc[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\. ]*)(de)?)|(primul\\s+sfert(\\s+a[l]?)?)|(prima treime a))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))";
    private static final String YEAR_SECOND_QUARTER = "((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/4)|(al doile[a]? sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))";
    private static final String YEAR_THIRD_QUARTER = "((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((3/4)|(\u00be)|(al treilea sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))";
    private static final String YEAR_FORTH_QUARTER = "((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((4/4)|((ultimul\\s+sfert)(\\s+(a[l]?|de)*)?)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))";
    public static final String YEAR_OPTIONS = "(?iu)((((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/2)|(\u00bd)|((prim[a]*[\\. ]+(jum([a\u0103]tate(a)?)?|part))([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/2)|((a\\s+(doua|(ii[-a]*))[\\. ]+(jum([a\u0103]tate(a)?)?|part)[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(jum([a\u0103]tate(a)?)?|(mij[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)|mj\\.)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/4)|(\u00bc)|(([i\u00ee]nc[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\. ]*)(de)?)|(primul\\s+sfert(\\s+a[l]?)?)|(prima treime a))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/4)|(al doile[a]? sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((3/4)|(\u00be)|(al treilea sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((4/4)|((ultimul\\s+sfert)(\\s+(a[l]?|de)*)?)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|((?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))))";
    public static final String YEAR_INTERVAL_BASE = "(?iu)(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((?iu)((((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/2)|(\u00bd)|((prim[a]*[\\. ]+(jum([a\u0103]tate(a)?)?|part))([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/2)|((a\\s+(doua|(ii[-a]*))[\\. ]+(jum([a\u0103]tate(a)?)?|part)[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(jum([a\u0103]tate(a)?)?|(mij[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)|mj\\.)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/4)|(\u00bc)|(([i\u00ee]nc[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\. ]*)(de)?)|(primul\\s+sfert(\\s+a[l]?)?)|(prima treime a))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/4)|(al doile[a]? sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((3/4)|(\u00be)|(al treilea sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((4/4)|((ultimul\\s+sfert)(\\s+(a[l]?|de)*)?)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|((?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))))\\s*(?:-|\u2013)\\s*(?iu)((((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/2)|(\u00bd)|((prim[a]*[\\. ]+(jum([a\u0103]tate(a)?)?|part))([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/2)|((a\\s+(doua|(ii[-a]*))[\\. ]+(jum([a\u0103]tate(a)?)?|part)[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(jum([a\u0103]tate(a)?)?|(mij[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)|mj\\.)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/4)|(\u00bc)|(([i\u00ee]nc[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\. ]*)(de)?)|(primul\\s+sfert(\\s+a[l]?)?)|(prima treime a))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/4)|(al doile[a]? sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((3/4)|(\u00be)|(al treilea sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((4/4)|((ultimul\\s+sfert)(\\s+(a[l]?|de)*)?)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|((?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))))";
    public static final String YEAR_INTERVAL_PREFIXED = "(?iu)(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((?:[i\u00ee]ntre|[i\u00ee]n\\s*interval(?:ul|u)?)\\s*(?iu)((((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/2)|(\u00bd)|((prim[a]*[\\. ]+(jum([a\u0103]tate(a)?)?|part))([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/2)|((a\\s+(doua|(ii[-a]*))[\\. ]+(jum([a\u0103]tate(a)?)?|part)[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(jum([a\u0103]tate(a)?)?|(mij[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)|mj\\.)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/4)|(\u00bc)|(([i\u00ee]nc[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\. ]*)(de)?)|(primul\\s+sfert(\\s+a[l]?)?)|(prima treime a))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/4)|(al doile[a]? sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((3/4)|(\u00be)|(al treilea sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((4/4)|((ultimul\\s+sfert)(\\s+(a[l]?|de)*)?)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|((?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))))\\s*(?:-|\u2013|([s\u015f\u0219]i))\\s*(?iu)((((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/2)|(\u00bd)|((prim[a]*[\\. ]+(jum([a\u0103]tate(a)?)?|part))([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/2)|((a\\s+(doua|(ii[-a]*))[\\. ]+(jum([a\u0103]tate(a)?)?|part)[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(jum([a\u0103]tate(a)?)?|(mij[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)|mj\\.)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/4)|(\u00bc)|(([i\u00ee]nc[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\. ]*)(de)?)|(primul\\s+sfert(\\s+a[l]?)?)|(prima treime a))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/4)|(al doile[a]? sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((3/4)|(\u00be)|(al treilea sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((4/4)|((ultimul\\s+sfert)(\\s+(a[l]?|de)*)?)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|((?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))))";
    public static final String YEAR_3_4_DIGITS_SPECIAL_PREFIX = "(anul\\s*\\d{1,2}=)";
    public static final String YEAR_3_4_DIGITS_SPECIAL_INTERVAL = "(?iu)(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(\\d{3,4}(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(\\s*(/|sau)\\s*)\\d{3,4}(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))";
    public static final String UNKNOWN_YEARS = "(([\\[\\(\\]\\)\\?\\!\\d\\\u2026]{5,}))";

    private YearRegex() {
    }
}

