/*
 * Decompiled with CFR 0.152.
 */
package ro.webdata.normalization.timespan.ro.model.timePeriod;

import ro.webdata.normalization.timespan.ro.TimePeriodUtils;
import ro.webdata.normalization.timespan.ro.TimeUtils;
import ro.webdata.normalization.timespan.ro.model.TimePeriodModel;

public class MillenniumModel
extends TimePeriodModel {
    public MillenniumModel(String original, String value, String regex, boolean historicalOnly) {
        this.setMillenniumModel(original, value, regex, historicalOnly);
    }

    public void setMillenniumModel(String original, String value, String regex, boolean historicalOnly) {
        String preparedValue = this.prepareValue(value, regex);
        String[] intervalValues = preparedValue.split("\\s*(?:-|\u2013)\\s*");
        if (intervalValues.length == 2) {
            this.setEra(original, intervalValues[0], intervalValues[1], false);
            Integer endValue = TimePeriodUtils.getEndTime(intervalValues, this.eraStart, false);
            Integer startValue = TimePeriodUtils.getStartTime(intervalValues, this.eraStart, false);
            this.setMillenniumDate(original, endValue, TimeUtils.END_PLACEHOLDER, historicalOnly);
            this.setMillenniumDate(original, startValue, TimeUtils.START_PLACEHOLDER, historicalOnly);
        } else {
            this.setEra(original, value, value, false);
            Integer millenniumValue = TimePeriodUtils.timePeriodToNumber(preparedValue, false);
            this.setMillenniumDate(original, millenniumValue, TimeUtils.END_PLACEHOLDER, historicalOnly);
            this.setMillenniumDate(original, millenniumValue, TimeUtils.START_PLACEHOLDER, historicalOnly);
        }
    }

    private String prepareValue(String value, String regex) {
        if (regex.equals("(?iu)(?:[i\u00ee]ntre|[i\u00ee]n\\s*interval(?:ul|u)?)\\s*(?iu)(((((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/2)|(\u00bd)|((prim[a]*[\\. ]+(jum([a\u0103]tate(a)?)?|part))([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/2)|((a\\s+(doua|(ii[-a]*))[\\. ]+(jum([a\u0103]tate(a)?)?|part)[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(jum([a\u0103]tate(a)?)?|(mij[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)|mj\\.)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/4)|(\u00bc)|(([i\u00ee]nc[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\. ]*)(de)?)|(primul\\s+sfert(\\s+a[l]?)?)|(prima treime a))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/4)|(al doile[a]? sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((3/4)|(\u00be)|(al treilea sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((4/4)|((ultimul\\s+sfert)(\\s+(a[l]?|de)*)?)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?)))|((((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/2)|(\u00bd)|((prim[a]*[\\. ]+(jum([a\u0103]tate(a)?)?|part))([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/2)|((a\\s+(doua|(ii[-a]*))[\\. ]+(jum([a\u0103]tate(a)?)?|part)[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(jum([a\u0103]tate(a)?)?|(mij[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)|mj\\.)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/4)|(\u00bc)|(([i\u00ee]nc[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\. ]*)(de)?)|(primul\\s+sfert(\\s+a[l]?)?)|(prima treime a))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/4)|(al doile[a]? sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((3/4)|(\u00be)|(al treilea sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((4/4)|((ultimul\\s+sfert)(\\s+(a[l]?|de)*)?)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))))\\s*(?:-|\u2013|([s\u015f\u0219]i))\\s*(((?:al[\\.\\s]*)?((((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?)|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?)))|(?iu)(((((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/2)|(\u00bd)|((prim[a]*[\\. ]+(jum([a\u0103]tate(a)?)?|part))([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/2)|((a\\s+(doua|(ii[-a]*))[\\. ]+(jum([a\u0103]tate(a)?)?|part)[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(jum([a\u0103]tate(a)?)?|(mij[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)|mj\\.)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/4)|(\u00bc)|(([i\u00ee]nc[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\. ]*)(de)?)|(primul\\s+sfert(\\s+a[l]?)?)|(prima treime a))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/4)|(al doile[a]? sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((3/4)|(\u00be)|(al treilea sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((4/4)|((ultimul\\s+sfert)(\\s+(a[l]?|de)*)?)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?)))|((((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/2)|(\u00bd)|((prim[a]*[\\. ]+(jum([a\u0103]tate(a)?)?|part))([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/2)|((a\\s+(doua|(ii[-a]*))[\\. ]+(jum([a\u0103]tate(a)?)?|part)[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(jum([a\u0103]tate(a)?)?|(mij[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)|mj\\.)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/4)|(\u00bc)|(([i\u00ee]nc[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\. ]*)(de)?)|(primul\\s+sfert(\\s+a[l]?)?)|(prima treime a))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/4)|(al doile[a]? sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((3/4)|(\u00be)|(al treilea sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((4/4)|((ultimul\\s+sfert)(\\s+(a[l]?|de)*)?)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?)))))")) {
            String preparedValue = value.replaceAll("(?iu)(?:[i\u00ee]ntre|[i\u00ee]n\\s*interval(?:ul|u)?)\\s*", "").replaceAll("(?iu)\\s*(?:-|\u2013|([s\u015f\u0219]i))\\s*", " - ").trim();
            return TimePeriodUtils.sanitizeTimePeriod(preparedValue);
        }
        return TimePeriodUtils.sanitizeTimePeriod(value);
    }

    private void setMillenniumDate(String original, Integer millennium, String position, boolean historicalOnly) {
        if (millennium != null) {
            this.setMillennium(original, millennium, position, historicalOnly);
        }
    }
}

