/*
 * Decompiled with CFR 0.152.
 */
package ro.webdata.normalization.timespan.ro.model.imprecise;

import ro.webdata.normalization.timespan.ro.TimeUtils;
import ro.webdata.normalization.timespan.ro.model.TimePeriodModel;

public class InaccurateYearModel
extends TimePeriodModel {
    private static final String REGEX_NON_DIGIT = "[^\\d]";

    public InaccurateYearModel(String original, String value, boolean historicalOnly) {
        this.setDateModel(original, value, historicalOnly);
    }

    private void setDateModel(String original, String value, boolean historicalOnly) {
        String[] intervalValues = value.split("\\s*(?:-|\u2013)\\s*");
        if (intervalValues.length == 2) {
            this.setEra(original, intervalValues[0], intervalValues[1], true);
            String startValue = TimeUtils.clearChristumNotation(intervalValues[0]);
            String endValue = TimeUtils.clearChristumNotation(intervalValues[1]);
            this.setDate(original, endValue, TimeUtils.END_PLACEHOLDER, historicalOnly);
            this.setDate(original, startValue, TimeUtils.START_PLACEHOLDER, historicalOnly);
        } else {
            this.setEra(original, value, value, true);
            String preparedValue = TimeUtils.clearChristumNotation(value);
            this.setDate(original, preparedValue, TimeUtils.END_PLACEHOLDER, historicalOnly);
            this.setDate(original, preparedValue, TimeUtils.START_PLACEHOLDER, historicalOnly);
        }
    }

    private void setDate(String original, String value, String position, boolean historicalOnly) {
        String year = value.replaceAll(REGEX_NON_DIGIT, "");
        this.setMillennium(original, year, position, historicalOnly);
        this.setCentury(original, year, position, historicalOnly);
        this.setYear(original, year, position, historicalOnly);
    }
}

