/*
 * Decompiled with CFR 0.152.
 */
package ro.webdata.normalization.timespan.ro.model.date;

import ro.webdata.echo.commons.Date;
import ro.webdata.normalization.timespan.ro.TimeUtils;
import ro.webdata.normalization.timespan.ro.model.TimePeriodModel;

public class ShortDateModel
extends TimePeriodModel {
    public ShortDateModel(String original, String value, String order, boolean historicalOnly) {
        this.setDateModel(original, value, order, historicalOnly);
    }

    private void setDateModel(String original, String value, String order, boolean historicalOnly) {
        String[] intervalValues = value.split("\\s*(?:-|\u2013)\\s*");
        if (intervalValues.length == 2) {
            this.setEra(original, intervalValues[0], intervalValues[1], true);
            String endMonth = this.getMonth(intervalValues[0]);
            String endYear = this.getYear(intervalValues[0], intervalValues[1], order, TimeUtils.END_PLACEHOLDER);
            this.setDate(original, endYear, endMonth, order, TimeUtils.END_PLACEHOLDER, historicalOnly);
            String startMonth = this.getMonth(intervalValues[1]);
            String startYear = this.getYear(intervalValues[0], intervalValues[1], order, TimeUtils.START_PLACEHOLDER);
            this.setDate(original, startYear, startMonth, order, TimeUtils.START_PLACEHOLDER, historicalOnly);
        } else {
            this.setEra(original, value, value, true);
            String endMonth = this.getMonth(value);
            String endYear = this.getYear(value, value, order, TimeUtils.END_PLACEHOLDER);
            this.setDate(original, endYear, endMonth, order, TimeUtils.END_PLACEHOLDER, historicalOnly);
            String startMonth = this.getMonth(value);
            String startYear = this.getYear(value, value, order, TimeUtils.START_PLACEHOLDER);
            this.setDate(original, startYear, startMonth, order, TimeUtils.START_PLACEHOLDER, historicalOnly);
        }
    }

    private void setDate(String original, String year, String month, String order, String position, boolean historicalOnly) {
        if (order.equals(TimeUtils.MY_PLACEHOLDER)) {
            this.setMillennium(original, year, position, historicalOnly);
            this.setCentury(original, year, position, historicalOnly);
            this.setYear(original, year, position, historicalOnly);
            this.setMonth(original, month, position, historicalOnly);
        }
    }

    private String getYear(String startDate, String endDate, String order, String position) {
        String[] startValues = this.splitDate(startDate);
        String[] endValues = this.splitDate(endDate);
        if (order.equals(TimeUtils.MY_PLACEHOLDER)) {
            if (position.equals(TimeUtils.START_PLACEHOLDER)) {
                if (startValues.length > 1) {
                    return startValues[1];
                }
                if (startValues[0].length() > 2) {
                    return startValues[0];
                }
                return this.getMonth(startValues[0]).equals("Unknown") ? startValues[0] : endValues[1];
            }
            if (position.equals(TimeUtils.END_PLACEHOLDER)) {
                if (endValues.length > 1) {
                    return endValues[1];
                }
                return endValues[0];
            }
        }
        return null;
    }

    private String getMonth(String date2) {
        String preparedValue = Date.prepareDate(date2);
        String[] values = preparedValue.split("[\\./\\-\\s]+");
        return Date.getMonthName(values[0].trim());
    }

    private String[] splitDate(String date2) {
        String preparedValue = TimeUtils.clearChristumNotation(date2);
        preparedValue = Date.prepareDate(preparedValue);
        return preparedValue.split("[\\./\\-\\s]+");
    }
}

