/*
 * Decompiled with CFR 0.152.
 */
package ro.webdata.normalization.timespan.ro.model.date;

import ro.webdata.echo.commons.Date;
import ro.webdata.normalization.timespan.ro.TimeUtils;
import ro.webdata.normalization.timespan.ro.model.TimePeriodModel;

public class LongDateModel
extends TimePeriodModel {
    private static final String SUFFIX_CENTURY = "s:";
    private static final String SUFFIX_YEAR = "a:";
    private static final String SUFFIX_MONTH = "l:";
    private static final String SUFFIX_DAY = "z:";

    public LongDateModel(String original, String value, boolean historicalOnly) {
        String preparedValue = TimeUtils.clearChristumNotation(value);
        String[] values = preparedValue.split(";");
        this.setEra(value);
        for (String str2 : values) {
            String comparator = str2.toLowerCase();
            if (comparator.contains(SUFFIX_CENTURY)) {
                this.setCentury(str2);
                this.setMillennium(str2);
                continue;
            }
            if (comparator.contains(SUFFIX_YEAR)) {
                this.setYear(str2);
                continue;
            }
            if (comparator.contains(SUFFIX_MONTH)) {
                this.setMonth(str2);
                continue;
            }
            if (!comparator.contains(SUFFIX_DAY)) continue;
            this.setDay(str2);
        }
    }

    private void setEra(String value) {
        String era;
        this.eraStart = era = TimeUtils.getEraName(value);
        this.eraEnd = era;
    }

    private void setMillennium(String centuryValue) {
        String centuryStr = centuryValue.replaceAll(SUFFIX_CENTURY, "").trim();
        try {
            int century = Integer.parseInt(centuryStr);
            int millennium = TimeUtils.centuryToMillennium(century);
            this.millenniumStart = millennium;
            this.millenniumEnd = millennium;
        }
        catch (NumberFormatException e2) {
            e2.printStackTrace();
        }
    }

    private void setCentury(String value) {
        String centuryStr = value.replaceAll(SUFFIX_CENTURY, "").trim();
        try {
            int century = Integer.parseInt(centuryStr);
            this.centuryStart = century;
            this.centuryEnd = century;
        }
        catch (NumberFormatException e2) {
            e2.printStackTrace();
        }
    }

    private void setYear(String value) {
        String yearStr = value.replaceAll(SUFFIX_YEAR, "").trim();
        try {
            int year = Integer.parseInt(yearStr);
            this.yearStart = year;
            this.yearEnd = year;
        }
        catch (NumberFormatException e2) {
            e2.printStackTrace();
        }
    }

    private void setMonth(String value) {
        String month;
        String monthStr = value.replaceAll(SUFFIX_MONTH, "").trim();
        this.monthStart = month = Date.getMonthName(monthStr);
        this.monthEnd = month;
    }

    private void setDay(String value) {
        String dayStr = value.replaceAll(SUFFIX_DAY, "").trim();
        try {
            int day;
            this.dayStart = day = Integer.parseInt(dayStr);
            this.dayEnd = day;
        }
        catch (NumberFormatException e2) {
            e2.printStackTrace();
        }
    }
}

