/*
 * Decompiled with CFR 0.152.
 */
package ro.webdata.normalization.timespan.ro.model.date;

import ro.webdata.echo.commons.Date;
import ro.webdata.normalization.timespan.ro.TimeUtils;
import ro.webdata.normalization.timespan.ro.model.TimePeriodModel;

public class DateModel
extends TimePeriodModel {
    public DateModel(String original, String value, String order, boolean historicalOnly) {
        this.setDateModel(original, value, order, historicalOnly);
    }

    private void setDateModel(String original, String value, String order, boolean historicalOnly) {
        String[] intervalValues = value.split("\\s*(?:-|\u2013)\\s*");
        if (intervalValues.length == 2) {
            this.setEra(original, DateModel.getYear(intervalValues[0], intervalValues[1], order), DateModel.getYear(intervalValues[1], intervalValues[0], order), true);
            this.setDate(original, intervalValues[0], intervalValues[1], order, TimeUtils.END_PLACEHOLDER, historicalOnly);
            this.setDate(original, intervalValues[0], intervalValues[1], order, TimeUtils.START_PLACEHOLDER, historicalOnly);
        } else {
            this.setEra(original, DateModel.getYear(value, value, order), DateModel.getYear(value, value, order), true);
            this.setDate(original, value, value, order, TimeUtils.END_PLACEHOLDER, historicalOnly);
            this.setDate(original, value, value, order, TimeUtils.START_PLACEHOLDER, historicalOnly);
        }
    }

    private void setDate(String original, String startDate, String endDate, String order, String position, boolean historicalOnly) {
        String start = TimeUtils.clearChristumNotation(startDate);
        String end = TimeUtils.clearChristumNotation(endDate);
        String mainDate = position.equals(TimeUtils.START_PLACEHOLDER) ? start : end;
        String secondDate = position.equals(TimeUtils.START_PLACEHOLDER) ? end : start;
        this.setDateTime(original, mainDate, secondDate, order, position, historicalOnly);
    }

    private void setDateTime(String original, String firstDate, String secondDate, String order, String position, boolean historicalOnly) {
        String year = DateModel.getYear(firstDate, secondDate, order);
        String month = DateModel.getMonth(firstDate, secondDate, order);
        String day = DateModel.getDay(firstDate, secondDate, order);
        this.setMillennium(original, year, position, historicalOnly);
        this.setCentury(original, year, position, historicalOnly);
        this.setYear(original, year, position, historicalOnly);
        this.setMonth(original, month, position, historicalOnly);
        this.setDay(original, day, position, historicalOnly);
    }

    private static String getYear(String mainDate, String secondDate, String order) {
        String preparedDate = Date.prepareDate(mainDate);
        String[] values = preparedDate.split("[\\./\\-\\s]+");
        try {
            if (order.equals(TimeUtils.DMY_PLACEHOLDER)) {
                return values.length == 4 ? values[3] : values[2];
            }
            if (order.equals(TimeUtils.YMD_PLACEHOLDER)) {
                return values[0];
            }
        }
        catch (ArrayIndexOutOfBoundsException e2) {
            return DateModel.getYear(secondDate, mainDate, order);
        }
        catch (Exception e3) {
            e3.printStackTrace();
            return null;
        }
        return null;
    }

    private static String getMonth(String mainDate, String secondDate, String order) {
        String preparedDate = Date.prepareDate(mainDate);
        String[] values = preparedDate.split("[\\./\\-\\s]+");
        if (order.equals(TimeUtils.DMY_PLACEHOLDER) || order.equals(TimeUtils.YMD_PLACEHOLDER)) {
            try {
                return Date.getMonthName(values[1].trim());
            }
            catch (ArrayIndexOutOfBoundsException e2) {
                String preparedSecondDate = Date.prepareDate(secondDate);
                String[] secondValues = preparedSecondDate.split("[\\./\\-\\s]+");
                return Date.getMonthName(secondValues[1].trim());
            }
            catch (Exception e3) {
                e3.printStackTrace();
                return null;
            }
        }
        return null;
    }

    private static String getDay(String mainDate, String secondDate, String order) {
        String preparedDate = Date.prepareDate(mainDate);
        String[] values = preparedDate.split("[\\./\\-\\s]+");
        if (order.equals(TimeUtils.DMY_PLACEHOLDER)) {
            return values[0];
        }
        if (order.equals(TimeUtils.YMD_PLACEHOLDER)) {
            return values.length == 4 ? values[3] : values[2];
        }
        return null;
    }
}

