/*
 * Decompiled with CFR 0.152.
 */
package ro.webdata.normalization.timespan.ro.model;

import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import ro.webdata.normalization.timespan.ro.model.DBpediaModel;
import ro.webdata.normalization.timespan.ro.model.TimePeriodModel;

public class TimespanModel {
    private transient String residualValue = "";
    @SerializedName(value="edges")
    private Map<String, DBpediaModel> dbpediaEdges = new HashMap<String, DBpediaModel>();
    @SerializedName(value="periods")
    private Set<DBpediaModel> dbpediaItems = new LinkedHashSet<DBpediaModel>();

    public TimespanModel(TimePeriodModel timePeriod, String[] matchedList, String matchedValue, String matchedType, String residualValue) {
        this.setDbpediaEdges(timePeriod, matchedType, matchedValue);
        this.setDBpediaItems(matchedList, matchedType, matchedValue);
        this.setResidualValue(residualValue);
    }

    public Map<String, DBpediaModel> getDBpediaEdges() {
        return this.dbpediaEdges;
    }

    public Set<DBpediaModel> getDBpediaItems() {
        return this.dbpediaItems;
    }

    public String getResidualValue() {
        return this.residualValue;
    }

    public void setDbpediaEdges(TimePeriodModel timePeriod, String matchedType, String matchedValue) {
        HashMap<String, DBpediaModel> edges = new HashMap<String, DBpediaModel>();
        String startUri = timePeriod.toDBpediaStartUri(matchedType);
        String endUri = timePeriod.toDBpediaEndUri(matchedType);
        if (startUri == null || endUri == null) {
            return;
        }
        DBpediaModel start = new DBpediaModel(startUri, matchedType, matchedValue);
        DBpediaModel end = new DBpediaModel(endUri, matchedType, matchedValue);
        edges.put("start", start);
        edges.put("end", end);
        this.dbpediaEdges = edges;
    }

    public void setDBpediaItems(String[] matchedList, String matchedType, String matchedValue) {
        List list = Arrays.stream(matchedList).map(uri -> new DBpediaModel((String)uri, matchedType, matchedValue)).collect(Collectors.toCollection(ArrayList::new));
        this.dbpediaItems.addAll(list);
    }

    public void setResidualValue(String residualValue) {
        this.residualValue = residualValue;
    }
}

