/*
 * Decompiled with CFR 0.152.
 */
package ro.webdata.normalization.timespan.ro.model;

import java.util.LinkedHashSet;
import java.util.Set;
import ro.webdata.echo.commons.Collection;
import ro.webdata.normalization.timespan.ro.TimeUtils;
import ro.webdata.normalization.timespan.ro.model.DBpediaModel;
import ro.webdata.normalization.timespan.ro.model.TimeModel;

public class TimePeriodModel
extends TimeModel {
    public String toString() {
        LinkedHashSet<String> timePeriodSet = new LinkedHashSet<String>();
        Set<String> millenniumSet = TimePeriodModel.getMillenniumSet(this.eraStart, this.eraEnd, this.millenniumStart, this.millenniumEnd, true);
        Set<String> centurySet = TimePeriodModel.getCenturySet(this.eraStart, this.eraEnd, this.centuryStart, this.centuryEnd, true);
        Set<String> yearSet = TimePeriodModel.getYearSet(this.eraStart, this.eraEnd, this.yearStart, this.yearEnd, false);
        timePeriodSet.addAll(millenniumSet);
        timePeriodSet.addAll(centurySet);
        timePeriodSet.addAll(yearSet);
        return Collection.treeSetToDbpediaString(timePeriodSet);
    }

    public String toDBpediaStartUri(String matchedType) {
        if (matchedType == null) {
            return null;
        }
        switch (matchedType) {
            case "century": {
                return DBpediaModel.prepareUri(this.eraStart, this.centuryStart, matchedType);
            }
            case "millennium": {
                return DBpediaModel.prepareUri(this.eraStart, this.millenniumStart, matchedType);
            }
            case "date": 
            case "year": {
                return DBpediaModel.prepareUri(this.eraStart, this.yearStart, matchedType);
            }
        }
        return null;
    }

    public String toDBpediaEndUri(String matchedType) {
        if (matchedType == null) {
            return null;
        }
        switch (matchedType) {
            case "century": {
                return DBpediaModel.prepareUri(this.eraEnd, this.centuryEnd, matchedType);
            }
            case "millennium": {
                return DBpediaModel.prepareUri(this.eraEnd, this.millenniumEnd, matchedType);
            }
            case "date": 
            case "year": {
                return DBpediaModel.prepareUri(this.eraEnd, this.yearEnd, matchedType);
            }
        }
        return null;
    }

    public static Set<String> getMillenniumSet(String eraStart, String eraEnd, Integer millenniumStart, Integer millenniumEnd, boolean ordinal) {
        return TimePeriodModel.getTimeperiodSet(eraStart, eraEnd, millenniumStart, millenniumEnd, "_millennium", ordinal);
    }

    public static Set<String> getCenturySet(String eraStart, String eraEnd, Integer centuryStart, Integer centuryEnd, boolean ordinal) {
        return TimePeriodModel.getTimeperiodSet(eraStart, eraEnd, centuryStart, centuryEnd, "_century", ordinal);
    }

    public static Set<String> getYearSet(String eraStart, String eraEnd, Integer yearStart, Integer yearEnd, boolean ordinal) {
        return TimePeriodModel.getTimeperiodSet(eraStart, eraEnd, yearStart, yearEnd, "", ordinal);
    }

    public static Set<String> getTimeperiodSet(String eraStart, String eraEnd, Integer start, Integer end, String timePlaceholder, boolean ordinal) {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        if (start != null && end != null) {
            TimePeriodModel.pushSameBc(eraStart, eraEnd, start, end, timePlaceholder, set, ordinal);
            TimePeriodModel.pushSameAd(eraStart, eraEnd, start, end, timePlaceholder, set, ordinal);
            TimePeriodModel.pushBcAd(eraStart, eraEnd, start, end, timePlaceholder, set, ordinal);
            TimePeriodModel.pushAdBc(eraStart, eraEnd, start, end, timePlaceholder, set, ordinal);
        }
        return set;
    }

    private static void pushSameAd(String eraStart, String eraEnd, Integer timeStart, Integer timeEnd, String timePlaceholder, Set<String> timeSet, boolean ordinal) {
        if (eraStart.equals("__AD__") && eraEnd.equals("__AD__")) {
            int start = Math.min(timeStart, timeEnd);
            int end = Math.max(timeStart, timeEnd);
            for (int timePeriod = start; timePeriod <= end; ++timePeriod) {
                String period = ordinal ? TimeUtils.getOrdinal(timePeriod) : String.valueOf(timePeriod);
                String timeDbpedia = period + timePlaceholder;
                timeSet.add(timeDbpedia);
            }
        }
    }

    private static void pushSameBc(String eraStart, String eraEnd, Integer timeStart, Integer timeEnd, String timePlaceholder, Set<String> timeSet, boolean ordinal) {
        if (eraStart.equals("__BC__") && eraEnd.equals("__BC__")) {
            int start = Math.max(timeStart, timeEnd);
            int end = Math.min(timeStart, timeEnd);
            for (int timePeriod = start; timePeriod >= end; --timePeriod) {
                String period = ordinal ? TimeUtils.getOrdinal(timePeriod) : String.valueOf(timePeriod);
                String timeDbpedia = period + timePlaceholder + "_BC";
                timeSet.add(timeDbpedia);
            }
        }
    }

    private static void pushBcAd(String eraStart, String eraEnd, Integer timeStart, Integer timeEnd, String timePlaceholder, Set<String> timeSet, boolean ordinal) {
        if (eraStart.equals("__BC__") && eraEnd.equals("__AD__")) {
            int start = timeStart;
            int end = 1;
            TimePeriodModel.pushSameBc("__BC__", "__BC__", start, end, timePlaceholder, timeSet, ordinal);
            start = 1;
            end = timeEnd;
            TimePeriodModel.pushSameAd("__AD__", "__AD__", start, end, timePlaceholder, timeSet, ordinal);
        }
    }

    private static void pushAdBc(String eraStart, String eraEnd, Integer timeStart, Integer timeEnd, String timePlaceholder, Set<String> timeSet, boolean ordinal) {
        if (eraStart.equals("__AD__") && eraEnd.equals("__BC__")) {
            int start = timeEnd;
            int end = 1;
            TimePeriodModel.pushSameBc("__BC__", "__BC__", start, end, timePlaceholder, timeSet, ordinal);
            start = 1;
            end = timeStart;
            TimePeriodModel.pushSameAd("__AD__", "__AD__", start, end, timePlaceholder, timeSet, ordinal);
        }
    }
}

