/*
 * Decompiled with CFR 0.152.
 */
package ro.webdata.normalization.timespan.ro.model;

import ro.webdata.echo.commons.error.TooBigCenturyException;
import ro.webdata.echo.commons.error.TooBigMillenniumException;
import ro.webdata.echo.commons.error.TooBigYearException;
import ro.webdata.normalization.timespan.ro.TimePeriodUtils;
import ro.webdata.normalization.timespan.ro.TimeUtils;

public class TimeModel {
    protected String eraStart;
    protected String eraEnd;
    protected Integer millenniumStart;
    protected Integer millenniumEnd;
    protected Integer centuryStart;
    protected Integer centuryEnd;
    protected Integer yearStart;
    protected Integer yearEnd;
    protected String monthStart;
    protected String monthEnd;
    protected int dayStart;
    protected int dayEnd;

    protected void setEra(String original, String startValue, String endValue, boolean isDate) {
        boolean hasStartEra = this.hasChristumNotation(startValue);
        boolean hasEndEra = this.hasChristumNotation(endValue);
        if (hasStartEra && hasEndEra) {
            this.eraStart = TimeUtils.getEraName(startValue);
            this.eraEnd = TimeUtils.getEraName(endValue);
        } else if (!hasStartEra && !hasEndEra) {
            Integer start = TimePeriodUtils.timePeriodToNumber(startValue, isDate);
            Integer end = TimePeriodUtils.timePeriodToNumber(endValue, isDate);
            if (start == null || end == null) {
                this.eraStart = "__AD__";
                this.eraEnd = "__AD__";
            } else if (start > end) {
                this.eraStart = "__BC__";
                this.eraEnd = "__BC__";
            } else {
                this.eraStart = "__AD__";
                this.eraEnd = "__AD__";
            }
        } else if (hasStartEra && !hasEndEra) {
            this.eraStart = TimeUtils.getEraName(startValue);
            this.eraEnd = "__AD__";
        } else if (!hasStartEra && hasEndEra) {
            this.eraEnd = TimeUtils.getEraName(endValue);
            Integer start = TimePeriodUtils.timePeriodToNumber(startValue, isDate);
            Integer end = TimePeriodUtils.timePeriodToNumber(endValue, isDate);
            this.eraStart = start == null || end == null ? this.eraEnd : (start > end ? "__BC__" : this.eraEnd);
        }
    }

    protected void setMillennium(String original, String yearStr, String position, boolean historicalOnly) {
        try {
            int year = Integer.parseInt(TimeUtils.clearDate(yearStr));
            if (year > 2014 && this.eraStart.equals("__AD__")) {
                if (historicalOnly) {
                    throw new TooBigMillenniumException("setting millennium from \"" + original + "\"", position, year);
                }
                TooBigMillenniumException.printMessage("setting millennium from \"" + original + "\"", position, year);
            }
            int millennium = TimeUtils.yearToMillennium(year);
            this.setMillennium(original, millennium, position, historicalOnly);
        }
        catch (NumberFormatException | TooBigMillenniumException e2) {
            System.err.println(e2.getMessage());
        }
    }

    protected void setMillennium(String original, Integer millennium, String position, boolean historicalOnly) {
        try {
            if (millennium != null) {
                if (millennium > 3 && this.eraStart.equals("__AD__")) {
                    if (historicalOnly) {
                        this.millenniumStart = null;
                        this.millenniumEnd = null;
                        throw new TooBigMillenniumException("setting millennium from \"" + original + "\"", position, millennium);
                    }
                    TooBigMillenniumException.printMessage("setting millennium from \"" + original + "\"", position, millennium);
                }
                if (position != null) {
                    if (position.equals(TimeUtils.START_PLACEHOLDER)) {
                        this.millenniumStart = millennium;
                    } else if (position.equals(TimeUtils.END_PLACEHOLDER)) {
                        this.millenniumEnd = millennium;
                    }
                }
            }
        }
        catch (TooBigMillenniumException e2) {
            System.err.println(e2.getMessage());
        }
    }

    protected void setCentury(String original, String yearStr, String position, boolean historicalOnly) {
        try {
            int year = Integer.parseInt(TimeUtils.clearDate(yearStr));
            if (year > 2014 && this.eraStart.equals("__AD__")) {
                if (historicalOnly) {
                    throw new TooBigYearException("setting century from \"" + original + "\"", position, year);
                }
                TooBigYearException.printMessage("setting century from \"" + original + "\"", position, year);
            }
            boolean buffer = year % 100 != 0;
            int century = (int)(Math.floor(year / 100) + (double)buffer);
            this.setCentury(original, century, position, historicalOnly);
        }
        catch (NumberFormatException | TooBigYearException e2) {
            System.err.println(e2.getMessage());
        }
    }

    protected void setCentury(String original, Integer century, String position, boolean historicalOnly) {
        try {
            if (century != null) {
                if (century > 21 && this.eraStart.equals("__AD__")) {
                    if (historicalOnly) {
                        this.centuryStart = null;
                        this.centuryEnd = null;
                        throw new TooBigCenturyException("setting century from \"" + original + "\"", position, century);
                    }
                    TooBigCenturyException.printMessage("setting century from \"" + original + "\"", position, century);
                }
                if (position != null) {
                    int millennium = TimeUtils.centuryToMillennium(century);
                    this.setMillennium(original, millennium, position, historicalOnly);
                    if (position.equals(TimeUtils.START_PLACEHOLDER)) {
                        this.centuryStart = century;
                    } else if (position.equals(TimeUtils.END_PLACEHOLDER)) {
                        this.centuryEnd = century;
                    }
                }
            }
        }
        catch (TooBigCenturyException e2) {
            System.err.println(e2.getMessage());
        }
    }

    protected void setYear(String original, String yearStr, String position, boolean historicalOnly) {
        try {
            int year = Integer.parseInt(TimeUtils.clearDate(yearStr));
            if (year > 2014 && this.eraStart.equals("__AD__")) {
                if (historicalOnly) {
                    throw new TooBigYearException("setting year from \"" + original + "\"", position, year);
                }
                TooBigYearException.printMessage("setting year from \"" + original + "\"", position, year);
            }
            if (position.equals(TimeUtils.START_PLACEHOLDER)) {
                this.yearStart = year;
            } else if (position.equals(TimeUtils.END_PLACEHOLDER)) {
                this.yearEnd = year;
            }
        }
        catch (NumberFormatException | TooBigYearException e2) {
            System.err.println(e2.getMessage());
        }
    }

    protected void setMonth(String original, String month, String position, boolean historicalOnly) {
        if (position.equals(TimeUtils.START_PLACEHOLDER)) {
            this.monthStart = month;
        } else if (position.equals(TimeUtils.END_PLACEHOLDER)) {
            this.monthEnd = month;
        }
    }

    protected void setDay(String original, String dayStr, String position, boolean historicalOnly) {
        try {
            int day = Integer.parseInt(dayStr);
            if (position.equals(TimeUtils.START_PLACEHOLDER)) {
                this.dayStart = day;
            } else if (position.equals(TimeUtils.END_PLACEHOLDER)) {
                this.dayEnd = day;
            }
        }
        catch (NumberFormatException e2) {
            System.err.println(e2.getMessage());
        }
    }

    private boolean hasChristumNotation(String value) {
        return value.contains("__BC__") || value.contains("__AD__");
    }
}

