/*
 * Decompiled with CFR 0.152.
 */
package ro.webdata.normalization.timespan.ro.model;

import com.google.gson.annotations.SerializedName;
import ro.webdata.normalization.timespan.ro.TimeUtils;

public class DBpediaModel {
    @SerializedName(value="uri")
    private String uri;
    @SerializedName(value="label")
    private String label;
    @SerializedName(value="matchedValue")
    private String matchedValue;
    @SerializedName(value="matchedType")
    private String matchedType;

    public DBpediaModel(String uri, String matchedType, String matchedValue) {
        if (uri != null) {
            this.uri = uri;
            this.label = uri.replace("https://dbpedia.org/page/", "").replace("_", " ");
            this.matchedValue = matchedValue;
            this.matchedType = matchedType;
        }
    }

    public static String prepareUri(String era, Integer value, String matchedType) {
        if (value == null) {
            return null;
        }
        switch (matchedType) {
            case "century": {
                return "https://dbpedia.org/page/" + TimeUtils.getOrdinal(value) + "_century" + DBpediaModel.getEraSuffix(era);
            }
            case "millennium": {
                return "https://dbpedia.org/page/" + TimeUtils.getOrdinal(value) + "_millennium" + DBpediaModel.getEraSuffix(era);
            }
            case "date": 
            case "year": {
                return "https://dbpedia.org/page/" + String.valueOf(value) + DBpediaModel.getEraSuffix(era);
            }
        }
        return null;
    }

    public String toString() {
        return this.uri;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        DBpediaModel otherModel = (DBpediaModel)other;
        return this.uri.equals(otherModel.uri);
    }

    public int hashCode() {
        return this.uri.hashCode() + this.matchedValue.hashCode();
    }

    private static String getEraSuffix(String value) {
        return value.contains("__BC__") ? "_BC" : "";
    }
}

