/*
 * Decompiled with CFR 0.152.
 */
package ro.webdata.normalization.timespan.ro.model;

import ro.webdata.normalization.timespan.ro.model.TimePeriodModel;

public class AgeModel
extends TimePeriodModel {
    private String age;

    public AgeModel(String original, String age, String regex, boolean historicalOnly) {
        this.age = this.mapAge(age, regex);
        this.setMillennium(original, (Integer)null, null, historicalOnly);
        this.setCentury(original, (Integer)null, null, historicalOnly);
    }

    private String mapAge(String age, String regex) {
        switch (regex) {
            case "(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(aurignacian)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))": {
                return "Aurignacian";
            }
            case "(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(bronz|bronzului|tarzii)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))": {
                return "Bronze_Age";
            }
            case "(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(eneolitic)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))": {
                return "Chalcolithic";
            }
            case "(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(perioada consulatului francez)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))": {
                return "French_Consulate";
            }
            case "(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(hallstatt)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))": {
                return "Hallstatt_culture";
            }
            case "(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(interbelica)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))": {
                return "Interwar_period";
            }
            case "(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((medieval|medievala))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))": {
                return "Middle_Ages";
            }
            case "(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(epipaleolitic)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))": {
                return "Mesolithic";
            }
            case "(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(moderna)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))": {
                return "Modern_history";
            }
            case "(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(neolitic[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))": {
                return "Neolithic";
            }
            case "(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(antoninian[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*|hadrian)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))": {
                return "Nerva\u2013Antonine_dynasty";
            }
            case "(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(pleistocen)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))": {
                return "Pleistocene";
            }
            case "(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(ptolem[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))": {
                return "Ptolemaic_dynasty";
            }
            case "(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(renastere)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))": {
                return "Renaissance";
            }
            case "(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(romana)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))": {
                return "Roman_Empire";
            }
            case "(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(primul razboi mondial)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))": {
                return "World_War_I";
            }
            case "(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(al (doilea|ii-lea) razboi mondial)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))": {
                return "World_War_II";
            }
        }
        return age;
    }
}

