/*
 * Decompiled with CFR 0.152.
 */
package ro.webdata.normalization.timespan.ro.analysis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import ro.webdata.echo.commons.File;
import ro.webdata.parser.xml.lido.core.ParserDAO;
import ro.webdata.parser.xml.lido.core.ParserDAOImpl;
import ro.webdata.parser.xml.lido.core.leaf.descriptiveMetadata.DescriptiveMetadata;
import ro.webdata.parser.xml.lido.core.leaf.displayDate.DisplayDate;
import ro.webdata.parser.xml.lido.core.leaf.event.Event;
import ro.webdata.parser.xml.lido.core.leaf.eventDate.EventDate;
import ro.webdata.parser.xml.lido.core.leaf.lido.Lido;
import ro.webdata.parser.xml.lido.core.set.eventSet.EventSet;
import ro.webdata.parser.xml.lido.core.wrap.lidoWrap.LidoWrap;

public class TimespanAnalysisUtils {
    private static final ParserDAO parserDAO = new ParserDAOImpl();

    private TimespanAnalysisUtils() {
    }

    public static Map<String, List<String>> extractTimespan(String inputPath, String fileName, boolean excludeDemoFiles) {
        HashMap<String, List<String>> timespanMap = new HashMap<String, List<String>>();
        List<String> fileNames = TimespanAnalysisUtils.getFileNames(inputPath, fileName, excludeDemoFiles);
        for (String string : fileNames) {
            TimespanAnalysisUtils.addTimespan(inputPath, string, timespanMap);
        }
        for (Map.Entry entry : timespanMap.entrySet()) {
            Collections.sort((List)entry.getValue());
        }
        return timespanMap;
    }

    public static List<String> consolidateTimespanMap(Map<String, List<String>> timespanMap) {
        ArrayList<String> consolidatedList = new ArrayList<String>();
        for (Map.Entry<String, List<String>> entry : timespanMap.entrySet()) {
            consolidatedList.addAll((Collection<String>)entry.getValue());
        }
        Collections.sort(consolidatedList);
        return consolidatedList;
    }

    public static List<String> getFileNames(String path, final String fileName, boolean excludeDemoFiles) {
        if (fileName == null) {
            return File.getFileNames(path, "xml", excludeDemoFiles);
        }
        return new ArrayList<String>(){
            {
                this.add(fileName);
            }
        };
    }

    private static void addTimespan(String path, String fileName, Map<String, List<String>> timespanMap) {
        String filePath = path + File.FILE_SEPARATOR + fileName;
        TimespanAnalysisUtils.addTimespan(filePath, timespanMap);
    }

    private static void addTimespan(String filePath, Map<String, List<String>> timespanMap) {
        LidoWrap lidoWrap = parserDAO.parseLidoFile(filePath);
        List<Lido> lidoList = lidoWrap.getLidoList();
        for (Lido lido : lidoList) {
            List<DescriptiveMetadata> descriptiveMetadataList = lido.getDescriptiveMetadata();
            for (DescriptiveMetadata descriptiveMetadata : descriptiveMetadataList) {
                List<EventSet> eventSetList = descriptiveMetadata.getEventWrap().getEventSet();
                TimespanAnalysisUtils.addEventDateTimespan(eventSetList, timespanMap);
            }
        }
    }

    private static void addEventDateTimespan(List<EventSet> eventSetList, Map<String, List<String>> timespanMap) {
        for (EventSet eventSet : eventSetList) {
            Event event = eventSet.getEvent();
            EventDate eventDate = event.getEventDate();
            List termList = event.getEventType().getTerm().stream().map(term -> term.getText().trim()).collect(Collectors.toList());
            if (eventDate == null) continue;
            List<DisplayDate> displayDateList = eventDate.getDisplayDate();
            for (DisplayDate displayDate : displayDateList) {
                final String timespan = displayDate.getText().toLowerCase();
                for (String eventType : termList) {
                    if (timespanMap.containsKey(eventType)) {
                        timespanMap.get(eventType).add(timespan);
                        continue;
                    }
                    ArrayList<String> arr = new ArrayList<String>(){
                        {
                            this.add(timespan);
                        }
                    };
                    timespanMap.put(eventType, (List<String>)arr);
                }
            }
        }
    }
}

