/*
 * Decompiled with CFR 0.152.
 */
package ro.webdata.normalization.timespan.ro.analysis;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import ro.webdata.echo.commons.File;
import ro.webdata.echo.commons.Print;
import ro.webdata.normalization.timespan.ro.TimeExpression;
import ro.webdata.normalization.timespan.ro.analysis.AdditionalData;
import ro.webdata.normalization.timespan.ro.analysis.TimespanAnalysisUtils;

public class TimespanAnalysis {
    private static final String OPERATION_END = "----- END -----";
    private static final String OPERATION_START = "----- START -----";

    private TimespanAnalysis() {
    }

    public static void writeDetails(String inputPath, String outputFullPath, boolean excludeDemoFiles, boolean onlyUnique, boolean historicalOnly, boolean sanitize) {
        List<String> fileNames = File.getFileNames(inputPath, "xml", excludeDemoFiles);
        for (String fileName : fileNames) {
            TimespanAnalysis.write(inputPath, outputFullPath, fileName, excludeDemoFiles, onlyUnique, historicalOnly, sanitize);
        }
    }

    public static void write(String inputPath, String outputFullPath, boolean excludeDemoFiles, boolean onlyUnique, boolean historicalOnly, boolean sanitize) {
        TimespanAnalysis.write(inputPath, outputFullPath, null, excludeDemoFiles, onlyUnique, historicalOnly, sanitize);
    }

    public static void writeAdditionalData(String outputFullPath, boolean historicalOnly, boolean sanitize) {
        Print.operation(OPERATION_START, true);
        System.out.println("File: additional data");
        TimespanAnalysis.write(AdditionalData.TIMESPAN_LIST, outputFullPath, true, historicalOnly, sanitize);
        Print.operation(OPERATION_END, true);
    }

    public static void write(String inputPath, String outputFullPath, String fileName, boolean excludeDemoFiles, boolean onlyUnique, boolean historicalOnly, boolean sanitize) {
        Print.operation(OPERATION_START, true);
        System.out.println("File: " + (fileName != null ? fileName : "ALL") + "\n");
        Map<String, List<String>> timespanMap = TimespanAnalysisUtils.extractTimespan(inputPath, fileName, excludeDemoFiles);
        for (Map.Entry<String, List<String>> entry : timespanMap.entrySet()) {
            String path = TimespanAnalysis.prepareOutputPath(outputFullPath, fileName, entry.getKey());
            List<String> list = entry.getValue();
            TimespanAnalysis.write(list, path, onlyUnique, historicalOnly, sanitize);
        }
        String path = TimespanAnalysis.prepareFilePath(outputFullPath, fileName);
        List<String> consolidatedTimespanMap = TimespanAnalysisUtils.consolidateTimespanMap(timespanMap);
        TimespanAnalysis.write(consolidatedTimespanMap, path, onlyUnique, historicalOnly, sanitize);
        Print.operation(OPERATION_END, true);
    }

    private static String prepareOutputPath(String outputFullPath, String fileName, String eventType) {
        String path = fileName != null ? TimespanAnalysis.prepareFilePath(outputFullPath, fileName) : outputFullPath;
        return eventType != null ? TimespanAnalysis.appendFileSuffix(path, eventType) : path;
    }

    private static void write(List<String> initTimespanList, String outputFullPath, boolean onlyUnique, boolean historicalOnly, boolean sanitize) {
        List<String> timespanList = initTimespanList;
        if (onlyUnique) {
            TreeSet<String> set = new TreeSet<String>(timespanList);
            timespanList = new ArrayList<String>(set);
        }
        File.write(timespanList, outputFullPath, false);
        List<String> timeExpressions = TimespanAnalysis.toTimeExpressions(timespanList, historicalOnly, sanitize);
        String csvOutputFullPath = outputFullPath.replaceAll("\\.[a-zA-Z]*", ".csv");
        File.write(timeExpressions, csvOutputFullPath, false);
    }

    private static String appendFileSuffix(String filePath, String suffix) {
        String SUFFIX = suffix == null ? "" : suffix.toLowerCase();
        String newFilePath = filePath.replaceAll("\\.[a-zA-Z]*", "_" + SUFFIX);
        String extension = filePath.replaceAll(".*\\.", "");
        return newFilePath + "." + extension;
    }

    private static List<String> toTimeExpressions(List<String> strTimeExpressions, boolean historicalOnly, boolean sanitize) {
        ArrayList<String> timeExpressions = new ArrayList<String>(){
            {
                this.add(TimeExpression.getHeaders());
            }
        };
        for (String str2 : strTimeExpressions) {
            TimeExpression timeExpression = new TimeExpression(str2, historicalOnly, sanitize);
            timeExpressions.add(timeExpression.toString());
        }
        return timeExpressions;
    }

    private static String prepareFilePath(String outputFullPath, String fileName) {
        if (fileName == null) {
            return outputFullPath;
        }
        String name = fileName.replaceAll("inp-clasate-", "").replaceAll("-2014-02-02.xml", "").replaceAll("-2014-02-03-7.xml", "");
        String path = outputFullPath.substring(0, outputFullPath.lastIndexOf(File.FILE_SEPARATOR) + 1);
        String filePostfix = outputFullPath.substring(outputFullPath.lastIndexOf(File.FILE_SEPARATOR) + 1);
        return path + name + File.FILE_SEPARATOR + filePostfix;
    }
}

