/*
 * Decompiled with CFR 0.152.
 */
package ro.webdata.normalization.timespan.ro.analysis;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ro.webdata.normalization.timespan.ro.TimeSanitizeUtils;

public class LidoXmlAnalysis {
    public static void check(String filePath) {
        String[] list = new String[]{"(?iu)^(-|4/4 sec\\.|17 nov\\. 375\\-9 aug\\. 378 a\\.chr\\.|1884 martie 28/aprilie 09|189-45|al doile afert al s1900|an[ ]?\\d{1,2}[\\?]?|cultura inca sau chachapoya\\?|datat|dinastia xxv|dinastia xxvi \\(dinastia saita\\)|dinastia xxvi \\(perioada saita\\)|dinastia xxvii \\(prima stapanire persana\\)|nesemnat|disparuta din uz si din zona; existenta in muzee|epoca severica tarzie|grupa a iv-a|grupa a v-a|grupa iii|grupa iv|grupa v|la tene|lama de secol xvi/xvii, garda si manerul ulterioare|leat 7208 \\(1699-1700\\)|mai, dni 15, leat 7232|mesiata.*|fev\\. dni 2 leat 7157|iulie 28|iunie 01|iunie 20, leat 7173 \\(1665\\)|iunie, dni 2, leat 7235|august 04|oct\\. 10 dni, leat 1730|octombrie 23, 1777|noiembrie 22|noiembrie 24|perioada lui carol x al frantei|perioada domniei regelui carol al ii-lea|perioada regelui carol al ii-lea|regatul nou\\?|21/2, sc\\.i, a\\.c\\.|21/2; sc i a\\.c\\.|286/5-282/1|286/5-282/1 a\\. chr|15\\(\u2026\\)4|154\\(\u2026\\)|158\\(\u2026\\)|162\\(\\?\\)|16\\[ \\])$", "(?iu)(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(\\d{1,2}\\.\\d{2}(\\.\\d{3,})?|\\d{1,2}\\/\\d{2}(\\/\\d{3,})?|\\d{1,2}\\s+\\d{2}(\\s+\\d{3,})?|\\d{1,2}[, ]+((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)([,\\s]+\\d{3,})?|\\d{1,2}\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?)(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?\\s*(?:-|\u2013)\\s*(\\d{1,2}\\.\\d{1,2}\\.\\d{3,}|\\d{1,2}\\/\\d{2}\\/\\d{3,}|\\d{1,2}\\s+\\d{2}\\s+\\d{3,}|\\d{1,2}[,\\s]+((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)[,\\s]+\\d{3,})(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))", "(?iu)(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(\\d{3,}[-]{1}\\d{2}[-]{1}\\d{1,2}|\\d{3,}[,\\s]+((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)[,\\s]+\\d{1,2})(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?\\s*(?:-|\u2013)\\s*(\\d{3,}[-]{1}\\d{2}[-]{1}\\d{1,2}|\\d{3,}[,\\s]+((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)[,\\s]+\\d{1,2})(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))", "(?iu)^(?!\\s*[\\(\\[]?\\d+[\\)\\]]?\\s*\\s*(?:-|\u2013)\\s*\\s*[\\(\\[]?\\d+[\\)\\]]?\\s*$).*(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(((((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)\\s+\\d{3,})(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?)\\s*(?:-|\u2013)\\s*((((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)\\s+\\d{3,})(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|((((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)\\s+\\d{3,})(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?\\s*(?:-|\u2013)\\s*((((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)\\s+\\d{3,})|\\d{3,})(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?)|(((((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)\\s+\\d{3,})|\\d{3,})(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?\\s*(?:-|\u2013)\\s*(((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)\\s+\\d{3,})(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))", "(?iu)(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(\\d{1,2}\\.\\d{1,2}\\.\\d{3,}|\\d{1,2}\\/\\d{2}\\/\\d{3,}|\\d{1,2}\\s+\\d{2}\\s+\\d{3,}|\\d{1,2}[,\\s]+((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)[,\\s]+\\d{3,})(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))", "(?iu)(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(\\d{3,}[-]{1}\\d{2}[-]{1}\\d{1,2}|\\d{3,}[,\\s]+((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)[,\\s]+\\d{1,2})(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))", "(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)\\s+\\d{3,}(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))", "(?iu)(^s:[\\d]{1,2};a:[\\d]{1,4};l:[\\d]{1,2};z:[\\d]{1,2}$)", "(?iu)(?iu)(((((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/2)|(\u00bd)|((prim[a]*[\\. ]+(jum([a\u0103]tate(a)?)?|part))([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/2)|((a\\s+(doua|(ii[-a]*))[\\. ]+(jum([a\u0103]tate(a)?)?|part)[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(jum([a\u0103]tate(a)?)?|(mij[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)|mj\\.)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/4)|(\u00bc)|(([i\u00ee]nc[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\. ]*)(de)?)|(primul\\s+sfert(\\s+a[l]?)?)|(prima treime a))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/4)|(al doile[a]? sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((3/4)|(\u00be)|(al treilea sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((4/4)|((ultimul\\s+sfert)(\\s+(a[l]?|de)*)?)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?)))|((((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/2)|(\u00bd)|((prim[a]*[\\. ]+(jum([a\u0103]tate(a)?)?|part))([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/2)|((a\\s+(doua|(ii[-a]*))[\\. ]+(jum([a\u0103]tate(a)?)?|part)[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(jum([a\u0103]tate(a)?)?|(mij[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)|mj\\.)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/4)|(\u00bc)|(([i\u00ee]nc[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\. ]*)(de)?)|(primul\\s+sfert(\\s+a[l]?)?)|(prima treime a))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/4)|(al doile[a]? sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((3/4)|(\u00be)|(al treilea sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((4/4)|((ultimul\\s+sfert)(\\s+(a[l]?|de)*)?)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))))\\s*(?:-|\u2013)\\s*((?iu)(((((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/2)|(\u00bd)|((prim[a]*[\\. ]+(jum([a\u0103]tate(a)?)?|part))([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/2)|((a\\s+(doua|(ii[-a]*))[\\. ]+(jum([a\u0103]tate(a)?)?|part)[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(jum([a\u0103]tate(a)?)?|(mij[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)|mj\\.)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/4)|(\u00bc)|(([i\u00ee]nc[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\. ]*)(de)?)|(primul\\s+sfert(\\s+a[l]?)?)|(prima treime a))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/4)|(al doile[a]? sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((3/4)|(\u00be)|(al treilea sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((4/4)|((ultimul\\s+sfert)(\\s+(a[l]?|de)*)?)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?)))|((((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/2)|(\u00bd)|((prim[a]*[\\. ]+(jum([a\u0103]tate(a)?)?|part))([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/2)|((a\\s+(doua|(ii[-a]*))[\\. ]+(jum([a\u0103]tate(a)?)?|part)[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(jum([a\u0103]tate(a)?)?|(mij[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)|mj\\.)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/4)|(\u00bc)|(([i\u00ee]nc[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\. ]*)(de)?)|(primul\\s+sfert(\\s+a[l]?)?)|(prima treime a))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/4)|(al doile[a]? sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((3/4)|(\u00be)|(al treilea sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((4/4)|((ultimul\\s+sfert)(\\s+(a[l]?|de)*)?)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))))|((((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?)|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?)))", "(?iu)(((((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/2)|(\u00bd)|((prim[a]*[\\. ]+(jum([a\u0103]tate(a)?)?|part))([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/2)|((a\\s+(doua|(ii[-a]*))[\\. ]+(jum([a\u0103]tate(a)?)?|part)[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(jum([a\u0103]tate(a)?)?|(mij[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)|mj\\.)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/4)|(\u00bc)|(([i\u00ee]nc[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\. ]*)(de)?)|(primul\\s+sfert(\\s+a[l]?)?)|(prima treime a))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/4)|(al doile[a]? sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((3/4)|(\u00be)|(al treilea sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((4/4)|((ultimul\\s+sfert)(\\s+(a[l]?|de)*)?)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?)))|((((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/2)|(\u00bd)|((prim[a]*[\\. ]+(jum([a\u0103]tate(a)?)?|part))([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/2)|((a\\s+(doua|(ii[-a]*))[\\. ]+(jum([a\u0103]tate(a)?)?|part)[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(jum([a\u0103]tate(a)?)?|(mij[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)|mj\\.)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/4)|(\u00bc)|(([i\u00ee]nc[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\. ]*)(de)?)|(primul\\s+sfert(\\s+a[l]?)?)|(prima treime a))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/4)|(al doile[a]? sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((3/4)|(\u00be)|(al treilea sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((4/4)|((ultimul\\s+sfert)(\\s+(a[l]?|de)*)?)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))))", "(?iu)(?iu)(((((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/2)|(\u00bd)|((prim[a]*[\\. ]+(jum([a\u0103]tate(a)?)?|part))([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/2)|((a\\s+(doua|(ii[-a]*))[\\. ]+(jum([a\u0103]tate(a)?)?|part)[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(jum([a\u0103]tate(a)?)?|(mij[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)|mj\\.)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/4)|(\u00bc)|(([i\u00ee]nc[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\. ]*)(de)?)|(primul\\s+sfert(\\s+a[l]?)?)|(prima treime a))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/4)|(al doile[a]? sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((3/4)|(\u00be)|(al treilea sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((4/4)|((ultimul\\s+sfert)(\\s+(a[l]?|de)*)?)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?)))|((((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/2)|(\u00bd)|((prim[a]*[\\. ]+(jum([a\u0103]tate(a)?)?|part))([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/2)|((a\\s+(doua|(ii[-a]*))[\\. ]+(jum([a\u0103]tate(a)?)?|part)[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(jum([a\u0103]tate(a)?)?|(mij[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)|mj\\.)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/4)|(\u00bc)|(([i\u00ee]nc[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\. ]*)(de)?)|(primul\\s+sfert(\\s+a[l]?)?)|(prima treime a))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/4)|(al doile[a]? sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((3/4)|(\u00be)|(al treilea sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((4/4)|((ultimul\\s+sfert)(\\s+(a[l]?|de)*)?)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))))\\s*(?:-|\u2013)\\s*((?iu)(((((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/2)|(\u00bd)|((prim[a]*[\\. ]+(jum([a\u0103]tate(a)?)?|part))([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/2)|((a\\s+(doua|(ii[-a]*))[\\. ]+(jum([a\u0103]tate(a)?)?|part)[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(jum([a\u0103]tate(a)?)?|(mij[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)|mj\\.)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/4)|(\u00bc)|(([i\u00ee]nc[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\. ]*)(de)?)|(primul\\s+sfert(\\s+a[l]?)?)|(prima treime a))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/4)|(al doile[a]? sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((3/4)|(\u00be)|(al treilea sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((4/4)|((ultimul\\s+sfert)(\\s+(a[l]?|de)*)?)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?)))|((((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/2)|(\u00bd)|((prim[a]*[\\. ]+(jum([a\u0103]tate(a)?)?|part))([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/2)|((a\\s+(doua|(ii[-a]*))[\\. ]+(jum([a\u0103]tate(a)?)?|part)[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(jum([a\u0103]tate(a)?)?|(mij[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)|mj\\.)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/4)|(\u00bc)|(([i\u00ee]nc[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\. ]*)(de)?)|(primul\\s+sfert(\\s+a[l]?)?)|(prima treime a))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/4)|(al doile[a]? sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((3/4)|(\u00be)|(al treilea sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((4/4)|((ultimul\\s+sfert)(\\s+(a[l]?|de)*)?)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))))|((((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?)|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?)))", "(?iu)(((((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/2)|(\u00bd)|((prim[a]*[\\. ]+(jum([a\u0103]tate(a)?)?|part))([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/2)|((a\\s+(doua|(ii[-a]*))[\\. ]+(jum([a\u0103]tate(a)?)?|part)[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(jum([a\u0103]tate(a)?)?|(mij[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)|mj\\.)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/4)|(\u00bc)|(([i\u00ee]nc[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\. ]*)(de)?)|(primul\\s+sfert(\\s+a[l]?)?)|(prima treime a))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/4)|(al doile[a]? sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((3/4)|(\u00be)|(al treilea sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((4/4)|((ultimul\\s+sfert)(\\s+(a[l]?|de)*)?)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?)))|((((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/2)|(\u00bd)|((prim[a]*[\\. ]+(jum([a\u0103]tate(a)?)?|part))([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/2)|((a\\s+(doua|(ii[-a]*))[\\. ]+(jum([a\u0103]tate(a)?)?|part)[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(jum([a\u0103]tate(a)?)?|(mij[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)|mj\\.)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/4)|(\u00bc)|(([i\u00ee]nc[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\. ]*)(de)?)|(primul\\s+sfert(\\s+a[l]?)?)|(prima treime a))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/4)|(al doile[a]? sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((3/4)|(\u00be)|(al treilea sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((4/4)|((ultimul\\s+sfert)(\\s+(a[l]?|de)*)?)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))))", "(?iu)(((((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/2)|(\u00bd)|((prim[a]*[\\. ]+(jum([a\u0103]tate(a)?)?|part))([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/2)|((a\\s+(doua|(ii[-a]*))[\\. ]+(jum([a\u0103]tate(a)?)?|part)[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(jum([a\u0103]tate(a)?)?|(mij[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)|mj\\.)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/4)|(\u00bc)|(([i\u00ee]nc[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\. ]*)(de)?)|(primul\\s+sfert(\\s+a[l]?)?)|(prima treime a))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/4)|(al doile[a]? sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((3/4)|(\u00be)|(al treilea sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((4/4)|((ultimul\\s+sfert)(\\s+(a[l]?|de)*)?)))[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?)))\\s*(?:-|\u2013)\\s*(((((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/2)|(\u00bd)|((prim[a]*[\\. ]+(jum([a\u0103]tate(a)?)?|part))([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/2)|((a\\s+(doua|(ii[-a]*))[\\. ]+(jum([a\u0103]tate(a)?)?|part)[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(jum([a\u0103]tate(a)?)?|(mij[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)|mj\\.)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/4)|(\u00bc)|(([i\u00ee]nc[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\. ]*)(de)?)|(primul\\s+sfert(\\s+a[l]?)?)|(prima treime a))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/4)|(al doile[a]? sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((3/4)|(\u00be)|(al treilea sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((4/4)|((ultimul\\s+sfert)(\\s+(a[l]?|de)*)?)))[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?)))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?)))", "((((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/2)|(\u00bd)|((prim[a]*[\\. ]+(jum([a\u0103]tate(a)?)?|part))([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/2)|((a\\s+(doua|(ii[-a]*))[\\. ]+(jum([a\u0103]tate(a)?)?|part)[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(jum([a\u0103]tate(a)?)?|(mij[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)|mj\\.)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/4)|(\u00bc)|(([i\u00ee]nc[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\. ]*)(de)?)|(primul\\s+sfert(\\s+a[l]?)?)|(prima treime a))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/4)|(al doile[a]? sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((3/4)|(\u00be)|(al treilea sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((4/4)|((ultimul\\s+sfert)(\\s+(a[l]?|de)*)?)))[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?)))", "(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(pleistocen)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))", "(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(epipaleolitic)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))", "(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(eneolitic)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))", "(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(neolitic[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))", "(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(bronz|bronzului|tarzii)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))", "(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((medieval|medievala))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))", "(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(moderna)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))", "(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(hallstatt)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))", "(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(aurignacian)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))", "(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(ptolem[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))", "(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(romana)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))", "(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(antoninian[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*|hadrian)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))", "(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(renastere)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))", "(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(perioada consulatului francez)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))", "(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(primul razboi mondial)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))", "(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(interbelica)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))", "(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(al (doilea|ii-lea) razboi mondial)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))", "(?iu)((.*((fara\\s*an)|(f\\.\\s*an)|(f\\.a)))|(((fara\\s*data)|(f\\.\\s*data)|(f\\.d))).*)", "(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))model\\s*\\d{4})(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))", "(?iu)(.*(nedatat|nedatabil|nu\\s*are).*)", "(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((dupa|post|postum)\\s*((?iu)(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(\\d{1,2}\\.\\d{1,2}\\.\\d{3,}|\\d{1,2}\\/\\d{2}\\/\\d{3,}|\\d{1,2}\\s+\\d{2}\\s+\\d{3,}|\\d{1,2}[,\\s]+((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)[,\\s]+\\d{3,})(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?iu)(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(\\d{3,}[-]{1}\\d{2}[-]{1}\\d{1,2}|\\d{3,}[,\\s]+((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)[,\\s]+\\d{1,2})(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d{1,4}(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))\\s*(?:-|\u2013)\\s*((?iu)(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(\\d{1,2}\\.\\d{1,2}\\.\\d{3,}|\\d{1,2}\\/\\d{2}\\/\\d{3,}|\\d{1,2}\\s+\\d{2}\\s+\\d{3,}|\\d{1,2}[,\\s]+((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)[,\\s]+\\d{3,})(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?iu)(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(\\d{3,}[-]{1}\\d{2}[-]{1}\\d{1,2}|\\d{3,}[,\\s]+((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)[,\\s]+\\d{1,2})(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d{1,4}(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))", "(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((ante|anterior\\s*lui|inainte\\s*de)\\s*((?iu)(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(\\d{1,2}\\.\\d{1,2}\\.\\d{3,}|\\d{1,2}\\/\\d{2}\\/\\d{3,}|\\d{1,2}\\s+\\d{2}\\s+\\d{3,}|\\d{1,2}[,\\s]+((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)[,\\s]+\\d{3,})(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?iu)(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(\\d{3,}[-]{1}\\d{2}[-]{1}\\d{1,2}|\\d{3,}[,\\s]+((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)[,\\s]+\\d{1,2})(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d{1,4}(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))\\s*(?:-|\u2013)\\s*((?iu)(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(\\d{1,2}\\.\\d{1,2}\\.\\d{3,}|\\d{1,2}\\/\\d{2}\\/\\d{3,}|\\d{1,2}\\s+\\d{2}\\s+\\d{3,}|\\d{1,2}[,\\s]+((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)[,\\s]+\\d{3,})(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?iu)(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(\\d{3,}[-]{1}\\d{2}[-]{1}\\d{1,2}|\\d{3,}[,\\s]+((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)[,\\s]+\\d{1,2})(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d{1,4}(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))", "(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(catre|probabil|aprox[\\.]*|aproximativ(\\s*anii)?|cca[\\.]*|c[a]?[\\.]?|circa)\\s*\\d+)([\\.,;\\?!\\-\\s]*(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?)*)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))\\s*(?:-|\u2013)\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(catre|probabil|aprox[\\.]*|aproximativ(\\s*anii)?|cca[\\.]*|c[a]?[\\.]?|circa)\\s*\\d+)([\\.,;\\?!\\-\\s]*(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?)*)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|((?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?)\\s*(?:-|\u2013)\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(catre|probabil|aprox[\\.]*|aproximativ(\\s*anii)?|cca[\\.]*|c[a]?[\\.]?|circa)\\s*\\d+)([\\.,;\\?!\\-\\s]*(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?)*)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))", "(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((dupa|post|postum)\\s*((?iu)(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(\\d{1,2}\\.\\d{1,2}\\.\\d{3,}|\\d{1,2}\\/\\d{2}\\/\\d{3,}|\\d{1,2}\\s+\\d{2}\\s+\\d{3,}|\\d{1,2}[,\\s]+((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)[,\\s]+\\d{3,})(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?iu)(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(\\d{3,}[-]{1}\\d{2}[-]{1}\\d{1,2}|\\d{3,}[,\\s]+((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)[,\\s]+\\d{1,2})(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d{1,4}(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))", "(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((ante|anterior\\s*lui|inainte\\s*de)\\s*((?iu)(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(\\d{1,2}\\.\\d{1,2}\\.\\d{3,}|\\d{1,2}\\/\\d{2}\\/\\d{3,}|\\d{1,2}\\s+\\d{2}\\s+\\d{3,}|\\d{1,2}[,\\s]+((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)[,\\s]+\\d{3,})(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?iu)(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(\\d{3,}[-]{1}\\d{2}[-]{1}\\d{1,2}|\\d{3,}[,\\s]+((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)[,\\s]+\\d{1,2})(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d{1,4}(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))", "(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(catre|probabil|aprox[\\.]*|aproximativ(\\s*anii)?|cca[\\.]*|c[a]?[\\.]?|circa)\\s*\\d+)([\\.,;\\?!\\-\\s]*(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?)*)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))", "(?iu)(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((?iu)((((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/2)|(\u00bd)|((prim[a]*[\\. ]+(jum([a\u0103]tate(a)?)?|part))([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/2)|((a\\s+(doua|(ii[-a]*))[\\. ]+(jum([a\u0103]tate(a)?)?|part)[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(jum([a\u0103]tate(a)?)?|(mij[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)|mj\\.)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/4)|(\u00bc)|(([i\u00ee]nc[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\. ]*)(de)?)|(primul\\s+sfert(\\s+a[l]?)?)|(prima treime a))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/4)|(al doile[a]? sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((3/4)|(\u00be)|(al treilea sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((4/4)|((ultimul\\s+sfert)(\\s+(a[l]?|de)*)?)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|((?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))))\\s*(?:-|\u2013)\\s*(?iu)((((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/2)|(\u00bd)|((prim[a]*[\\. ]+(jum([a\u0103]tate(a)?)?|part))([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/2)|((a\\s+(doua|(ii[-a]*))[\\. ]+(jum([a\u0103]tate(a)?)?|part)[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(jum([a\u0103]tate(a)?)?|(mij[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)|mj\\.)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/4)|(\u00bc)|(([i\u00ee]nc[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\. ]*)(de)?)|(primul\\s+sfert(\\s+a[l]?)?)|(prima treime a))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/4)|(al doile[a]? sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((3/4)|(\u00be)|(al treilea sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((4/4)|((ultimul\\s+sfert)(\\s+(a[l]?|de)*)?)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|((?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))))", "(?iu)(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((?:[i\u00ee]ntre|[i\u00ee]n\\s*interval(?:ul|u)?)\\s*(?iu)((((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/2)|(\u00bd)|((prim[a]*[\\. ]+(jum([a\u0103]tate(a)?)?|part))([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/2)|((a\\s+(doua|(ii[-a]*))[\\. ]+(jum([a\u0103]tate(a)?)?|part)[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(jum([a\u0103]tate(a)?)?|(mij[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)|mj\\.)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/4)|(\u00bc)|(([i\u00ee]nc[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\. ]*)(de)?)|(primul\\s+sfert(\\s+a[l]?)?)|(prima treime a))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/4)|(al doile[a]? sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((3/4)|(\u00be)|(al treilea sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((4/4)|((ultimul\\s+sfert)(\\s+(a[l]?|de)*)?)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|((?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))))\\s*(?:-|\u2013|([s\u015f\u0219]i))\\s*(?iu)((((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/2)|(\u00bd)|((prim[a]*[\\. ]+(jum([a\u0103]tate(a)?)?|part))([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/2)|((a\\s+(doua|(ii[-a]*))[\\. ]+(jum([a\u0103]tate(a)?)?|part)[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(jum([a\u0103]tate(a)?)?|(mij[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)|mj\\.)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/4)|(\u00bc)|(([i\u00ee]nc[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\. ]*)(de)?)|(primul\\s+sfert(\\s+a[l]?)?)|(prima treime a))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/4)|(al doile[a]? sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((3/4)|(\u00be)|(al treilea sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((4/4)|((ultimul\\s+sfert)(\\s+(a[l]?|de)*)?)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|((?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))))", "(?iu)(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(\\d{3,4}(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(\\s*(/|sau)\\s*)\\d{3,4}(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))", "(?iu)((((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/2)|(\u00bd)|((prim[a]*[\\. ]+(jum([a\u0103]tate(a)?)?|part))([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/2)|((a\\s+(doua|(ii[-a]*))[\\. ]+(jum([a\u0103]tate(a)?)?|part)[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(jum([a\u0103]tate(a)?)?|(mij[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)|mj\\.)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/4)|(\u00bc)|(([i\u00ee]nc[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\. ]*)(de)?)|(primul\\s+sfert(\\s+a[l]?)?)|(prima treime a))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/4)|(al doile[a]? sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((3/4)|(\u00be)|(al treilea sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((4/4)|((ultimul\\s+sfert)(\\s+(a[l]?|de)*)?)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|((?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))))", "(([\\[\\(\\]\\)\\?\\!\\d\\\u2026]{5,}))"};
        try {
            String readLine;
            BufferedReader br = new BufferedReader(new FileReader(filePath));
            while ((readLine = br.readLine()) != null) {
                boolean check;
                if (readLine.isEmpty() || (check = LidoXmlAnalysis.isMatching(readLine, list))) continue;
                System.out.println(readLine);
            }
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    public static void printUnknownTimeExpressions(String filePath) {
        String[] list = new String[]{"(?iu)^(-|4/4 sec\\.|17 nov\\. 375\\-9 aug\\. 378 a\\.chr\\.|1884 martie 28/aprilie 09|189-45|al doile afert al s1900|an[ ]?\\d{1,2}[\\?]?|cultura inca sau chachapoya\\?|datat|dinastia xxv|dinastia xxvi \\(dinastia saita\\)|dinastia xxvi \\(perioada saita\\)|dinastia xxvii \\(prima stapanire persana\\)|nesemnat|disparuta din uz si din zona; existenta in muzee|epoca severica tarzie|grupa a iv-a|grupa a v-a|grupa iii|grupa iv|grupa v|la tene|lama de secol xvi/xvii, garda si manerul ulterioare|leat 7208 \\(1699-1700\\)|mai, dni 15, leat 7232|mesiata.*|fev\\. dni 2 leat 7157|iulie 28|iunie 01|iunie 20, leat 7173 \\(1665\\)|iunie, dni 2, leat 7235|august 04|oct\\. 10 dni, leat 1730|octombrie 23, 1777|noiembrie 22|noiembrie 24|perioada lui carol x al frantei|perioada domniei regelui carol al ii-lea|perioada regelui carol al ii-lea|regatul nou\\?|21/2, sc\\.i, a\\.c\\.|21/2; sc i a\\.c\\.|286/5-282/1|286/5-282/1 a\\. chr|15\\(\u2026\\)4|154\\(\u2026\\)|158\\(\u2026\\)|162\\(\\?\\)|16\\[ \\])$", "(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(pleistocen)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))", "(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(epipaleolitic)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))", "(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(eneolitic)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))", "(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(neolitic[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))", "(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(bronz|bronzului|tarzii)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))", "(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((medieval|medievala))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))", "(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(moderna)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))", "(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(hallstatt)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))", "(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(aurignacian)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))", "(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(ptolem[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))", "(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(romana)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))", "(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(antoninian[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*|hadrian)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))", "(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(renastere)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))", "(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(perioada consulatului francez)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))", "(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(primul razboi mondial)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))", "(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(interbelica)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))", "(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(al (doilea|ii-lea) razboi mondial)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))", "(?iu)((.*((fara\\s*an)|(f\\.\\s*an)|(f\\.a)))|(((fara\\s*data)|(f\\.\\s*data)|(f\\.d))).*)", "(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))model\\s*\\d{4})(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))", "(?iu)(.*(nedatat|nedatabil|nu\\s*are).*)", "(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((dupa|post|postum)\\s*((?iu)(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(\\d{1,2}\\.\\d{1,2}\\.\\d{3,}|\\d{1,2}\\/\\d{2}\\/\\d{3,}|\\d{1,2}\\s+\\d{2}\\s+\\d{3,}|\\d{1,2}[,\\s]+((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)[,\\s]+\\d{3,})(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?iu)(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(\\d{3,}[-]{1}\\d{2}[-]{1}\\d{1,2}|\\d{3,}[,\\s]+((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)[,\\s]+\\d{1,2})(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d{1,4}(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))\\s*(?:-|\u2013)\\s*((?iu)(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(\\d{1,2}\\.\\d{1,2}\\.\\d{3,}|\\d{1,2}\\/\\d{2}\\/\\d{3,}|\\d{1,2}\\s+\\d{2}\\s+\\d{3,}|\\d{1,2}[,\\s]+((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)[,\\s]+\\d{3,})(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?iu)(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(\\d{3,}[-]{1}\\d{2}[-]{1}\\d{1,2}|\\d{3,}[,\\s]+((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)[,\\s]+\\d{1,2})(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d{1,4}(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))", "(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((ante|anterior\\s*lui|inainte\\s*de)\\s*((?iu)(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(\\d{1,2}\\.\\d{1,2}\\.\\d{3,}|\\d{1,2}\\/\\d{2}\\/\\d{3,}|\\d{1,2}\\s+\\d{2}\\s+\\d{3,}|\\d{1,2}[,\\s]+((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)[,\\s]+\\d{3,})(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?iu)(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(\\d{3,}[-]{1}\\d{2}[-]{1}\\d{1,2}|\\d{3,}[,\\s]+((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)[,\\s]+\\d{1,2})(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d{1,4}(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))\\s*(?:-|\u2013)\\s*((?iu)(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(\\d{1,2}\\.\\d{1,2}\\.\\d{3,}|\\d{1,2}\\/\\d{2}\\/\\d{3,}|\\d{1,2}\\s+\\d{2}\\s+\\d{3,}|\\d{1,2}[,\\s]+((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)[,\\s]+\\d{3,})(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?iu)(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(\\d{3,}[-]{1}\\d{2}[-]{1}\\d{1,2}|\\d{3,}[,\\s]+((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)[,\\s]+\\d{1,2})(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d{1,4}(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))", "(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(catre|probabil|aprox[\\.]*|aproximativ(\\s*anii)?|cca[\\.]*|c[a]?[\\.]?|circa)\\s*\\d+)([\\.,;\\?!\\-\\s]*(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?)*)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))\\s*(?:-|\u2013)\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(catre|probabil|aprox[\\.]*|aproximativ(\\s*anii)?|cca[\\.]*|c[a]?[\\.]?|circa)\\s*\\d+)([\\.,;\\?!\\-\\s]*(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?)*)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|((?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?)\\s*(?:-|\u2013)\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(catre|probabil|aprox[\\.]*|aproximativ(\\s*anii)?|cca[\\.]*|c[a]?[\\.]?|circa)\\s*\\d+)([\\.,;\\?!\\-\\s]*(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?)*)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))", "(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((dupa|post|postum)\\s*((?iu)(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(\\d{1,2}\\.\\d{1,2}\\.\\d{3,}|\\d{1,2}\\/\\d{2}\\/\\d{3,}|\\d{1,2}\\s+\\d{2}\\s+\\d{3,}|\\d{1,2}[,\\s]+((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)[,\\s]+\\d{3,})(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?iu)(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(\\d{3,}[-]{1}\\d{2}[-]{1}\\d{1,2}|\\d{3,}[,\\s]+((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)[,\\s]+\\d{1,2})(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d{1,4}(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))", "(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((ante|anterior\\s*lui|inainte\\s*de)\\s*((?iu)(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(\\d{1,2}\\.\\d{1,2}\\.\\d{3,}|\\d{1,2}\\/\\d{2}\\/\\d{3,}|\\d{1,2}\\s+\\d{2}\\s+\\d{3,}|\\d{1,2}[,\\s]+((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)[,\\s]+\\d{3,})(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?iu)(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(\\d{3,}[-]{1}\\d{2}[-]{1}\\d{1,2}|\\d{3,}[,\\s]+((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)[,\\s]+\\d{1,2})(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d{1,4}(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))", "(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(catre|probabil|aprox[\\.]*|aproximativ(\\s*anii)?|cca[\\.]*|c[a]?[\\.]?|circa)\\s*\\d+)([\\.,;\\?!\\-\\s]*(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?)*)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))"};
        try {
            String readLine;
            int count = 0;
            BufferedReader br = new BufferedReader(new FileReader(filePath));
            while ((readLine = br.readLine()) != null) {
                boolean check;
                if (readLine.isEmpty() || !(check = LidoXmlAnalysis.isMatching(readLine, list))) continue;
                ++count;
            }
            System.out.println("unknown time expressions: " + count);
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    private static boolean isMatching(String value, String[] regexList) {
        for (String regex : regexList) {
            if (!LidoXmlAnalysis.isMatching(value, regex)) continue;
            return true;
        }
        return false;
    }

    private static boolean isMatching(String value, String regex) {
        String preparedValue = TimeSanitizeUtils.clearJunks(value, regex);
        preparedValue = TimeSanitizeUtils.sanitizeValue(preparedValue);
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(preparedValue);
        return matcher.find();
    }
}

