/*
 * Decompiled with CFR 0.152.
 */
package ro.webdata.normalization.timespan.ro;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ro.webdata.normalization.timespan.ro.TimeSanitizeUtils;
import ro.webdata.normalization.timespan.ro.TimeUtils;
import ro.webdata.normalization.timespan.ro.model.AgeModel;
import ro.webdata.normalization.timespan.ro.model.TimePeriodModel;
import ro.webdata.normalization.timespan.ro.model.TimespanModel;
import ro.webdata.normalization.timespan.ro.model.YearModel;
import ro.webdata.normalization.timespan.ro.model.date.DateModel;
import ro.webdata.normalization.timespan.ro.model.date.LongDateModel;
import ro.webdata.normalization.timespan.ro.model.date.ShortDateModel;
import ro.webdata.normalization.timespan.ro.model.imprecise.DatelessModel;
import ro.webdata.normalization.timespan.ro.model.imprecise.InaccurateYearModel;
import ro.webdata.normalization.timespan.ro.model.timePeriod.CenturyModel;
import ro.webdata.normalization.timespan.ro.model.timePeriod.MillenniumModel;
import ro.webdata.normalization.timespan.ro.regex.AgeRegex;

public class TimespanUtils {
    private TimespanUtils() {
    }

    public static List<TimespanModel> prepareTimespanModels(String original, boolean historicalOnly, boolean sanitize) {
        String residualValue = TimeSanitizeUtils.sanitizeValue(original);
        ArrayList<TimespanModel> timespanModels = new ArrayList<TimespanModel>();
        residualValue = TimespanUtils.updateMatchedValues(residualValue, timespanModels, historicalOnly, sanitize, "(?iu)^(-|4/4 sec\\.|17 nov\\. 375\\-9 aug\\. 378 a\\.chr\\.|1884 martie 28/aprilie 09|189-45|al doile afert al s1900|an[ ]?\\d{1,2}[\\?]?|cultura inca sau chachapoya\\?|datat|dinastia xxv|dinastia xxvi \\(dinastia saita\\)|dinastia xxvi \\(perioada saita\\)|dinastia xxvii \\(prima stapanire persana\\)|nesemnat|disparuta din uz si din zona; existenta in muzee|epoca severica tarzie|grupa a iv-a|grupa a v-a|grupa iii|grupa iv|grupa v|la tene|lama de secol xvi/xvii, garda si manerul ulterioare|leat 7208 \\(1699-1700\\)|mai, dni 15, leat 7232|mesiata.*|fev\\. dni 2 leat 7157|iulie 28|iunie 01|iunie 20, leat 7173 \\(1665\\)|iunie, dni 2, leat 7235|august 04|oct\\. 10 dni, leat 1730|octombrie 23, 1777|noiembrie 22|noiembrie 24|perioada lui carol x al frantei|perioada domniei regelui carol al ii-lea|perioada regelui carol al ii-lea|regatul nou\\?|21/2, sc\\.i, a\\.c\\.|21/2; sc i a\\.c\\.|286/5-282/1|286/5-282/1 a\\. chr|15\\(\u2026\\)4|154\\(\u2026\\)|158\\(\u2026\\)|162\\(\\?\\)|16\\[ \\])$", "unknown");
        residualValue = TimespanUtils.updateMatchedValues(residualValue, timespanModels, historicalOnly, sanitize, "(?iu)(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(\\d{1,2}\\.\\d{2}(\\.\\d{3,})?|\\d{1,2}\\/\\d{2}(\\/\\d{3,})?|\\d{1,2}\\s+\\d{2}(\\s+\\d{3,})?|\\d{1,2}[, ]+((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)([,\\s]+\\d{3,})?|\\d{1,2}\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?)(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?\\s*(?:-|\u2013)\\s*(\\d{1,2}\\.\\d{1,2}\\.\\d{3,}|\\d{1,2}\\/\\d{2}\\/\\d{3,}|\\d{1,2}\\s+\\d{2}\\s+\\d{3,}|\\d{1,2}[,\\s]+((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)[,\\s]+\\d{3,})(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))", "date");
        residualValue = TimespanUtils.updateMatchedValues(residualValue, timespanModels, historicalOnly, sanitize, "(?iu)(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(\\d{3,}[-]{1}\\d{2}[-]{1}\\d{1,2}|\\d{3,}[,\\s]+((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)[,\\s]+\\d{1,2})(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?\\s*(?:-|\u2013)\\s*(\\d{3,}[-]{1}\\d{2}[-]{1}\\d{1,2}|\\d{3,}[,\\s]+((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)[,\\s]+\\d{1,2})(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))", "date");
        residualValue = TimespanUtils.updateMatchedValues(residualValue, timespanModels, historicalOnly, sanitize, "(?iu)^(?!\\s*[\\(\\[]?\\d+[\\)\\]]?\\s*\\s*(?:-|\u2013)\\s*\\s*[\\(\\[]?\\d+[\\)\\]]?\\s*$).*(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(((((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)\\s+\\d{3,})(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?)\\s*(?:-|\u2013)\\s*((((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)\\s+\\d{3,})(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|((((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)\\s+\\d{3,})(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?\\s*(?:-|\u2013)\\s*((((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)\\s+\\d{3,})|\\d{3,})(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?)|(((((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)\\s+\\d{3,})|\\d{3,})(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?\\s*(?:-|\u2013)\\s*(((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)\\s+\\d{3,})(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))", "date");
        residualValue = TimespanUtils.updateMatchedValues(residualValue, timespanModels, historicalOnly, sanitize, "(?iu)(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(\\d{1,2}\\.\\d{1,2}\\.\\d{3,}|\\d{1,2}\\/\\d{2}\\/\\d{3,}|\\d{1,2}\\s+\\d{2}\\s+\\d{3,}|\\d{1,2}[,\\s]+((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)[,\\s]+\\d{3,})(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))", "date");
        residualValue = TimespanUtils.updateMatchedValues(residualValue, timespanModels, historicalOnly, sanitize, "(?iu)(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(\\d{3,}[-]{1}\\d{2}[-]{1}\\d{1,2}|\\d{3,}[,\\s]+((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)[,\\s]+\\d{1,2})(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))", "date");
        residualValue = TimespanUtils.updateMatchedValues(residualValue, timespanModels, historicalOnly, sanitize, "(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)\\s+\\d{3,}(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))", "date");
        residualValue = TimespanUtils.updateMatchedValues(residualValue, timespanModels, historicalOnly, sanitize, "(?iu)(^s:[\\d]{1,2};a:[\\d]{1,4};l:[\\d]{1,2};z:[\\d]{1,2}$)", "date");
        residualValue = TimespanUtils.updateMatchedValues(residualValue, timespanModels, historicalOnly, sanitize, "(?iu)(?:[i\u00ee]ntre|[i\u00ee]n\\s*interval(?:ul|u)?)\\s*(?iu)(((((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/2)|(\u00bd)|((prim[a]*[\\. ]+(jum([a\u0103]tate(a)?)?|part))([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/2)|((a\\s+(doua|(ii[-a]*))[\\. ]+(jum([a\u0103]tate(a)?)?|part)[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(jum([a\u0103]tate(a)?)?|(mij[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)|mj\\.)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/4)|(\u00bc)|(([i\u00ee]nc[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\. ]*)(de)?)|(primul\\s+sfert(\\s+a[l]?)?)|(prima treime a))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/4)|(al doile[a]? sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((3/4)|(\u00be)|(al treilea sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((4/4)|((ultimul\\s+sfert)(\\s+(a[l]?|de)*)?)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?)))|((((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/2)|(\u00bd)|((prim[a]*[\\. ]+(jum([a\u0103]tate(a)?)?|part))([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/2)|((a\\s+(doua|(ii[-a]*))[\\. ]+(jum([a\u0103]tate(a)?)?|part)[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(jum([a\u0103]tate(a)?)?|(mij[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)|mj\\.)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/4)|(\u00bc)|(([i\u00ee]nc[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\. ]*)(de)?)|(primul\\s+sfert(\\s+a[l]?)?)|(prima treime a))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/4)|(al doile[a]? sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((3/4)|(\u00be)|(al treilea sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((4/4)|((ultimul\\s+sfert)(\\s+(a[l]?|de)*)?)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))))\\s*(?:-|\u2013|([s\u015f\u0219]i))\\s*(((?:al[\\.\\s]*)?((((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?)|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?)))|(?iu)(((((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/2)|(\u00bd)|((prim[a]*[\\. ]+(jum([a\u0103]tate(a)?)?|part))([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/2)|((a\\s+(doua|(ii[-a]*))[\\. ]+(jum([a\u0103]tate(a)?)?|part)[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(jum([a\u0103]tate(a)?)?|(mij[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)|mj\\.)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/4)|(\u00bc)|(([i\u00ee]nc[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\. ]*)(de)?)|(primul\\s+sfert(\\s+a[l]?)?)|(prima treime a))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/4)|(al doile[a]? sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((3/4)|(\u00be)|(al treilea sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((4/4)|((ultimul\\s+sfert)(\\s+(a[l]?|de)*)?)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?)))|((((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/2)|(\u00bd)|((prim[a]*[\\. ]+(jum([a\u0103]tate(a)?)?|part))([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/2)|((a\\s+(doua|(ii[-a]*))[\\. ]+(jum([a\u0103]tate(a)?)?|part)[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(jum([a\u0103]tate(a)?)?|(mij[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)|mj\\.)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/4)|(\u00bc)|(([i\u00ee]nc[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\. ]*)(de)?)|(primul\\s+sfert(\\s+a[l]?)?)|(prima treime a))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/4)|(al doile[a]? sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((3/4)|(\u00be)|(al treilea sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((4/4)|((ultimul\\s+sfert)(\\s+(a[l]?|de)*)?)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?)))))", "century");
        residualValue = TimespanUtils.updateMatchedValues(residualValue, timespanModels, historicalOnly, sanitize, "(?iu)(?iu)(((((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/2)|(\u00bd)|((prim[a]*[\\. ]+(jum([a\u0103]tate(a)?)?|part))([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/2)|((a\\s+(doua|(ii[-a]*))[\\. ]+(jum([a\u0103]tate(a)?)?|part)[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(jum([a\u0103]tate(a)?)?|(mij[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)|mj\\.)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/4)|(\u00bc)|(([i\u00ee]nc[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\. ]*)(de)?)|(primul\\s+sfert(\\s+a[l]?)?)|(prima treime a))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/4)|(al doile[a]? sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((3/4)|(\u00be)|(al treilea sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((4/4)|((ultimul\\s+sfert)(\\s+(a[l]?|de)*)?)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?)))|((((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/2)|(\u00bd)|((prim[a]*[\\. ]+(jum([a\u0103]tate(a)?)?|part))([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/2)|((a\\s+(doua|(ii[-a]*))[\\. ]+(jum([a\u0103]tate(a)?)?|part)[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(jum([a\u0103]tate(a)?)?|(mij[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)|mj\\.)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/4)|(\u00bc)|(([i\u00ee]nc[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\. ]*)(de)?)|(primul\\s+sfert(\\s+a[l]?)?)|(prima treime a))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/4)|(al doile[a]? sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((3/4)|(\u00be)|(al treilea sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((4/4)|((ultimul\\s+sfert)(\\s+(a[l]?|de)*)?)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))))\\s*(?:-|\u2013)\\s*((?iu)(((((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/2)|(\u00bd)|((prim[a]*[\\. ]+(jum([a\u0103]tate(a)?)?|part))([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/2)|((a\\s+(doua|(ii[-a]*))[\\. ]+(jum([a\u0103]tate(a)?)?|part)[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(jum([a\u0103]tate(a)?)?|(mij[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)|mj\\.)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/4)|(\u00bc)|(([i\u00ee]nc[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\. ]*)(de)?)|(primul\\s+sfert(\\s+a[l]?)?)|(prima treime a))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/4)|(al doile[a]? sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((3/4)|(\u00be)|(al treilea sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((4/4)|((ultimul\\s+sfert)(\\s+(a[l]?|de)*)?)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?)))|((((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/2)|(\u00bd)|((prim[a]*[\\. ]+(jum([a\u0103]tate(a)?)?|part))([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/2)|((a\\s+(doua|(ii[-a]*))[\\. ]+(jum([a\u0103]tate(a)?)?|part)[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(jum([a\u0103]tate(a)?)?|(mij[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)|mj\\.)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/4)|(\u00bc)|(([i\u00ee]nc[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\. ]*)(de)?)|(primul\\s+sfert(\\s+a[l]?)?)|(prima treime a))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/4)|(al doile[a]? sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((3/4)|(\u00be)|(al treilea sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((4/4)|((ultimul\\s+sfert)(\\s+(a[l]?|de)*)?)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))))|((((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?)|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?)))", "century");
        residualValue = TimespanUtils.updateMatchedValues(residualValue, timespanModels, historicalOnly, sanitize, "(?iu)(((((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/2)|(\u00bd)|((prim[a]*[\\. ]+(jum([a\u0103]tate(a)?)?|part))([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/2)|((a\\s+(doua|(ii[-a]*))[\\. ]+(jum([a\u0103]tate(a)?)?|part)[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(jum([a\u0103]tate(a)?)?|(mij[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)|mj\\.)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/4)|(\u00bc)|(([i\u00ee]nc[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\. ]*)(de)?)|(primul\\s+sfert(\\s+a[l]?)?)|(prima treime a))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/4)|(al doile[a]? sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((3/4)|(\u00be)|(al treilea sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((4/4)|((ultimul\\s+sfert)(\\s+(a[l]?|de)*)?)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?)))|((((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/2)|(\u00bd)|((prim[a]*[\\. ]+(jum([a\u0103]tate(a)?)?|part))([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/2)|((a\\s+(doua|(ii[-a]*))[\\. ]+(jum([a\u0103]tate(a)?)?|part)[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(jum([a\u0103]tate(a)?)?|(mij[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)|mj\\.)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/4)|(\u00bc)|(([i\u00ee]nc[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\. ]*)(de)?)|(primul\\s+sfert(\\s+a[l]?)?)|(prima treime a))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/4)|(al doile[a]? sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((3/4)|(\u00be)|(al treilea sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((4/4)|((ultimul\\s+sfert)(\\s+(a[l]?|de)*)?)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))))", "century");
        residualValue = TimespanUtils.updateMatchedValues(residualValue, timespanModels, historicalOnly, sanitize, "(?iu)(?:[i\u00ee]ntre|[i\u00ee]n\\s*interval(?:ul|u)?)\\s*(?iu)(((((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/2)|(\u00bd)|((prim[a]*[\\. ]+(jum([a\u0103]tate(a)?)?|part))([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/2)|((a\\s+(doua|(ii[-a]*))[\\. ]+(jum([a\u0103]tate(a)?)?|part)[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(jum([a\u0103]tate(a)?)?|(mij[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)|mj\\.)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/4)|(\u00bc)|(([i\u00ee]nc[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\. ]*)(de)?)|(primul\\s+sfert(\\s+a[l]?)?)|(prima treime a))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/4)|(al doile[a]? sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((3/4)|(\u00be)|(al treilea sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((4/4)|((ultimul\\s+sfert)(\\s+(a[l]?|de)*)?)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?)))|((((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/2)|(\u00bd)|((prim[a]*[\\. ]+(jum([a\u0103]tate(a)?)?|part))([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/2)|((a\\s+(doua|(ii[-a]*))[\\. ]+(jum([a\u0103]tate(a)?)?|part)[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(jum([a\u0103]tate(a)?)?|(mij[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)|mj\\.)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/4)|(\u00bc)|(([i\u00ee]nc[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\. ]*)(de)?)|(primul\\s+sfert(\\s+a[l]?)?)|(prima treime a))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/4)|(al doile[a]? sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((3/4)|(\u00be)|(al treilea sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((4/4)|((ultimul\\s+sfert)(\\s+(a[l]?|de)*)?)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))))\\s*(?:-|\u2013|([s\u015f\u0219]i))\\s*(((?:al[\\.\\s]*)?((((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?)|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?)))|(?iu)(((((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/2)|(\u00bd)|((prim[a]*[\\. ]+(jum([a\u0103]tate(a)?)?|part))([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/2)|((a\\s+(doua|(ii[-a]*))[\\. ]+(jum([a\u0103]tate(a)?)?|part)[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(jum([a\u0103]tate(a)?)?|(mij[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)|mj\\.)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/4)|(\u00bc)|(([i\u00ee]nc[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\. ]*)(de)?)|(primul\\s+sfert(\\s+a[l]?)?)|(prima treime a))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/4)|(al doile[a]? sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((3/4)|(\u00be)|(al treilea sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((4/4)|((ultimul\\s+sfert)(\\s+(a[l]?|de)*)?)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?)))|((((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/2)|(\u00bd)|((prim[a]*[\\. ]+(jum([a\u0103]tate(a)?)?|part))([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/2)|((a\\s+(doua|(ii[-a]*))[\\. ]+(jum([a\u0103]tate(a)?)?|part)[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(jum([a\u0103]tate(a)?)?|(mij[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)|mj\\.)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/4)|(\u00bc)|(([i\u00ee]nc[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\. ]*)(de)?)|(primul\\s+sfert(\\s+a[l]?)?)|(prima treime a))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/4)|(al doile[a]? sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((3/4)|(\u00be)|(al treilea sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((4/4)|((ultimul\\s+sfert)(\\s+(a[l]?|de)*)?)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?)))))", "millennium");
        residualValue = TimespanUtils.updateMatchedValues(residualValue, timespanModels, historicalOnly, sanitize, "(?iu)(?iu)(((((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/2)|(\u00bd)|((prim[a]*[\\. ]+(jum([a\u0103]tate(a)?)?|part))([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/2)|((a\\s+(doua|(ii[-a]*))[\\. ]+(jum([a\u0103]tate(a)?)?|part)[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(jum([a\u0103]tate(a)?)?|(mij[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)|mj\\.)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/4)|(\u00bc)|(([i\u00ee]nc[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\. ]*)(de)?)|(primul\\s+sfert(\\s+a[l]?)?)|(prima treime a))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/4)|(al doile[a]? sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((3/4)|(\u00be)|(al treilea sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((4/4)|((ultimul\\s+sfert)(\\s+(a[l]?|de)*)?)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?)))|((((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/2)|(\u00bd)|((prim[a]*[\\. ]+(jum([a\u0103]tate(a)?)?|part))([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/2)|((a\\s+(doua|(ii[-a]*))[\\. ]+(jum([a\u0103]tate(a)?)?|part)[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(jum([a\u0103]tate(a)?)?|(mij[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)|mj\\.)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/4)|(\u00bc)|(([i\u00ee]nc[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\. ]*)(de)?)|(primul\\s+sfert(\\s+a[l]?)?)|(prima treime a))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/4)|(al doile[a]? sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((3/4)|(\u00be)|(al treilea sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((4/4)|((ultimul\\s+sfert)(\\s+(a[l]?|de)*)?)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))))\\s*(?:-|\u2013)\\s*((?iu)(((((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/2)|(\u00bd)|((prim[a]*[\\. ]+(jum([a\u0103]tate(a)?)?|part))([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/2)|((a\\s+(doua|(ii[-a]*))[\\. ]+(jum([a\u0103]tate(a)?)?|part)[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(jum([a\u0103]tate(a)?)?|(mij[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)|mj\\.)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/4)|(\u00bc)|(([i\u00ee]nc[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\. ]*)(de)?)|(primul\\s+sfert(\\s+a[l]?)?)|(prima treime a))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/4)|(al doile[a]? sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((3/4)|(\u00be)|(al treilea sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((4/4)|((ultimul\\s+sfert)(\\s+(a[l]?|de)*)?)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?)))|((((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/2)|(\u00bd)|((prim[a]*[\\. ]+(jum([a\u0103]tate(a)?)?|part))([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/2)|((a\\s+(doua|(ii[-a]*))[\\. ]+(jum([a\u0103]tate(a)?)?|part)[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(jum([a\u0103]tate(a)?)?|(mij[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)|mj\\.)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/4)|(\u00bc)|(([i\u00ee]nc[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\. ]*)(de)?)|(primul\\s+sfert(\\s+a[l]?)?)|(prima treime a))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/4)|(al doile[a]? sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((3/4)|(\u00be)|(al treilea sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((4/4)|((ultimul\\s+sfert)(\\s+(a[l]?|de)*)?)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))))|((((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?)|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?)))", "millennium");
        residualValue = TimespanUtils.updateMatchedValues(residualValue, timespanModels, historicalOnly, sanitize, "(?iu)(((((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/2)|(\u00bd)|((prim[a]*[\\. ]+(jum([a\u0103]tate(a)?)?|part))([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/2)|((a\\s+(doua|(ii[-a]*))[\\. ]+(jum([a\u0103]tate(a)?)?|part)[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(jum([a\u0103]tate(a)?)?|(mij[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)|mj\\.)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/4)|(\u00bc)|(([i\u00ee]nc[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\. ]*)(de)?)|(primul\\s+sfert(\\s+a[l]?)?)|(prima treime a))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/4)|(al doile[a]? sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((3/4)|(\u00be)|(al treilea sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((4/4)|((ultimul\\s+sfert)(\\s+(a[l]?|de)*)?)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?)))|((((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/2)|(\u00bd)|((prim[a]*[\\. ]+(jum([a\u0103]tate(a)?)?|part))([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/2)|((a\\s+(doua|(ii[-a]*))[\\. ]+(jum([a\u0103]tate(a)?)?|part)[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(jum([a\u0103]tate(a)?)?|(mij[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)|mj\\.)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/4)|(\u00bc)|(([i\u00ee]nc[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\. ]*)(de)?)|(primul\\s+sfert(\\s+a[l]?)?)|(prima treime a))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/4)|(al doile[a]? sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((3/4)|(\u00be)|(al treilea sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((4/4)|((ultimul\\s+sfert)(\\s+(a[l]?|de)*)?)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))))", "millennium");
        residualValue = TimespanUtils.updateMatchedValues(residualValue, timespanModels, historicalOnly, sanitize, "(?iu)(((((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/2)|(\u00bd)|((prim[a]*[\\. ]+(jum([a\u0103]tate(a)?)?|part))([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/2)|((a\\s+(doua|(ii[-a]*))[\\. ]+(jum([a\u0103]tate(a)?)?|part)[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(jum([a\u0103]tate(a)?)?|(mij[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)|mj\\.)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/4)|(\u00bc)|(([i\u00ee]nc[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\. ]*)(de)?)|(primul\\s+sfert(\\s+a[l]?)?)|(prima treime a))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/4)|(al doile[a]? sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((3/4)|(\u00be)|(al treilea sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((4/4)|((ultimul\\s+sfert)(\\s+(a[l]?|de)*)?)))[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?)))\\s*(?:-|\u2013)\\s*(((((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/2)|(\u00bd)|((prim[a]*[\\. ]+(jum([a\u0103]tate(a)?)?|part))([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/2)|((a\\s+(doua|(ii[-a]*))[\\. ]+(jum([a\u0103]tate(a)?)?|part)[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(jum([a\u0103]tate(a)?)?|(mij[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)|mj\\.)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/4)|(\u00bc)|(([i\u00ee]nc[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\. ]*)(de)?)|(primul\\s+sfert(\\s+a[l]?)?)|(prima treime a))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/4)|(al doile[a]? sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((3/4)|(\u00be)|(al treilea sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((4/4)|((ultimul\\s+sfert)(\\s+(a[l]?|de)*)?)))[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?)))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?)))", "century");
        residualValue = TimespanUtils.updateMatchedValues(residualValue, timespanModels, historicalOnly, sanitize, "((((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/2)|(\u00bd)|((prim[a]*[\\. ]+(jum([a\u0103]tate(a)?)?|part))([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/2)|((a\\s+(doua|(ii[-a]*))[\\. ]+(jum([a\u0103]tate(a)?)?|part)[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(jum([a\u0103]tate(a)?)?|(mij[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)|mj\\.)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/4)|(\u00bc)|(([i\u00ee]nc[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\. ]*)(de)?)|(primul\\s+sfert(\\s+a[l]?)?)|(prima treime a))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/4)|(al doile[a]? sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((3/4)|(\u00be)|(al treilea sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((4/4)|((ultimul\\s+sfert)(\\s+(a[l]?|de)*)?)))[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?)))", "century");
        for (int i = 0; i < AgeRegex.AGE_OPTIONS.length; ++i) {
            residualValue = TimespanUtils.updateMatchedValues(residualValue, timespanModels, historicalOnly, sanitize, AgeRegex.AGE_OPTIONS[i], "epoch");
        }
        residualValue = TimespanUtils.updateMatchedValues(residualValue, timespanModels, historicalOnly, sanitize, "(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((dupa|post|postum)\\s*((?iu)(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(\\d{1,2}\\.\\d{1,2}\\.\\d{3,}|\\d{1,2}\\/\\d{2}\\/\\d{3,}|\\d{1,2}\\s+\\d{2}\\s+\\d{3,}|\\d{1,2}[,\\s]+((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)[,\\s]+\\d{3,})(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?iu)(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(\\d{3,}[-]{1}\\d{2}[-]{1}\\d{1,2}|\\d{3,}[,\\s]+((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)[,\\s]+\\d{1,2})(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d{1,4}(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))\\s*(?:-|\u2013)\\s*((?iu)(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(\\d{1,2}\\.\\d{1,2}\\.\\d{3,}|\\d{1,2}\\/\\d{2}\\/\\d{3,}|\\d{1,2}\\s+\\d{2}\\s+\\d{3,}|\\d{1,2}[,\\s]+((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)[,\\s]+\\d{3,})(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?iu)(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(\\d{3,}[-]{1}\\d{2}[-]{1}\\d{1,2}|\\d{3,}[,\\s]+((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)[,\\s]+\\d{1,2})(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d{1,4}(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))", "year");
        residualValue = TimespanUtils.updateMatchedValues(residualValue, timespanModels, historicalOnly, sanitize, "(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((ante|anterior\\s*lui|inainte\\s*de)\\s*((?iu)(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(\\d{1,2}\\.\\d{1,2}\\.\\d{3,}|\\d{1,2}\\/\\d{2}\\/\\d{3,}|\\d{1,2}\\s+\\d{2}\\s+\\d{3,}|\\d{1,2}[,\\s]+((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)[,\\s]+\\d{3,})(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?iu)(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(\\d{3,}[-]{1}\\d{2}[-]{1}\\d{1,2}|\\d{3,}[,\\s]+((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)[,\\s]+\\d{1,2})(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d{1,4}(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))\\s*(?:-|\u2013)\\s*((?iu)(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(\\d{1,2}\\.\\d{1,2}\\.\\d{3,}|\\d{1,2}\\/\\d{2}\\/\\d{3,}|\\d{1,2}\\s+\\d{2}\\s+\\d{3,}|\\d{1,2}[,\\s]+((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)[,\\s]+\\d{3,})(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?iu)(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(\\d{3,}[-]{1}\\d{2}[-]{1}\\d{1,2}|\\d{3,}[,\\s]+((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)[,\\s]+\\d{1,2})(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d{1,4}(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))", "year");
        residualValue = TimespanUtils.updateMatchedValues(residualValue, timespanModels, historicalOnly, sanitize, "(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(catre|probabil|aprox[\\.]*|aproximativ(\\s*anii)?|cca[\\.]*|c[a]?[\\.]?|circa)\\s*\\d+)([\\.,;\\?!\\-\\s]*(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?)*)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))\\s*(?:-|\u2013)\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(catre|probabil|aprox[\\.]*|aproximativ(\\s*anii)?|cca[\\.]*|c[a]?[\\.]?|circa)\\s*\\d+)([\\.,;\\?!\\-\\s]*(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?)*)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|((?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?)\\s*(?:-|\u2013)\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(catre|probabil|aprox[\\.]*|aproximativ(\\s*anii)?|cca[\\.]*|c[a]?[\\.]?|circa)\\s*\\d+)([\\.,;\\?!\\-\\s]*(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?)*)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))", "year");
        residualValue = TimespanUtils.updateMatchedValues(residualValue, timespanModels, historicalOnly, sanitize, "(?iu)(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((?:[i\u00ee]ntre|[i\u00ee]n\\s*interval(?:ul|u)?)\\s*(?iu)((((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/2)|(\u00bd)|((prim[a]*[\\. ]+(jum([a\u0103]tate(a)?)?|part))([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/2)|((a\\s+(doua|(ii[-a]*))[\\. ]+(jum([a\u0103]tate(a)?)?|part)[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(jum([a\u0103]tate(a)?)?|(mij[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)|mj\\.)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/4)|(\u00bc)|(([i\u00ee]nc[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\. ]*)(de)?)|(primul\\s+sfert(\\s+a[l]?)?)|(prima treime a))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/4)|(al doile[a]? sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((3/4)|(\u00be)|(al treilea sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((4/4)|((ultimul\\s+sfert)(\\s+(a[l]?|de)*)?)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|((?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))))\\s*(?:-|\u2013|([s\u015f\u0219]i))\\s*(?iu)((((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/2)|(\u00bd)|((prim[a]*[\\. ]+(jum([a\u0103]tate(a)?)?|part))([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/2)|((a\\s+(doua|(ii[-a]*))[\\. ]+(jum([a\u0103]tate(a)?)?|part)[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(jum([a\u0103]tate(a)?)?|(mij[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)|mj\\.)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/4)|(\u00bc)|(([i\u00ee]nc[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\. ]*)(de)?)|(primul\\s+sfert(\\s+a[l]?)?)|(prima treime a))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/4)|(al doile[a]? sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((3/4)|(\u00be)|(al treilea sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((4/4)|((ultimul\\s+sfert)(\\s+(a[l]?|de)*)?)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|((?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))))", "year");
        residualValue = TimespanUtils.updateMatchedValues(residualValue, timespanModels, historicalOnly, sanitize, "(?iu)(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((?iu)((((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/2)|(\u00bd)|((prim[a]*[\\. ]+(jum([a\u0103]tate(a)?)?|part))([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/2)|((a\\s+(doua|(ii[-a]*))[\\. ]+(jum([a\u0103]tate(a)?)?|part)[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(jum([a\u0103]tate(a)?)?|(mij[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)|mj\\.)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/4)|(\u00bc)|(([i\u00ee]nc[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\. ]*)(de)?)|(primul\\s+sfert(\\s+a[l]?)?)|(prima treime a))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/4)|(al doile[a]? sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((3/4)|(\u00be)|(al treilea sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((4/4)|((ultimul\\s+sfert)(\\s+(a[l]?|de)*)?)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|((?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))))\\s*(?:-|\u2013)\\s*(?iu)((((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/2)|(\u00bd)|((prim[a]*[\\. ]+(jum([a\u0103]tate(a)?)?|part))([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/2)|((a\\s+(doua|(ii[-a]*))[\\. ]+(jum([a\u0103]tate(a)?)?|part)[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(jum([a\u0103]tate(a)?)?|(mij[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)|mj\\.)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/4)|(\u00bc)|(([i\u00ee]nc[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\. ]*)(de)?)|(primul\\s+sfert(\\s+a[l]?)?)|(prima treime a))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/4)|(al doile[a]? sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((3/4)|(\u00be)|(al treilea sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((4/4)|((ultimul\\s+sfert)(\\s+(a[l]?|de)*)?)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|((?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))))", "year");
        residualValue = TimespanUtils.updateMatchedValues(residualValue, timespanModels, historicalOnly, sanitize, "(?iu)(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(\\d{3,4}(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(\\s*(/|sau)\\s*)\\d{3,4}(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))", "year");
        residualValue = TimespanUtils.updateMatchedValues(residualValue, timespanModels, historicalOnly, sanitize, "(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))model\\s*\\d{4})(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))", "year");
        residualValue = TimespanUtils.updateMatchedValues(residualValue, timespanModels, historicalOnly, sanitize, "(?iu)(.*(nedatat|nedatabil|nu\\s*are).*)", "year");
        residualValue = TimespanUtils.updateMatchedValues(residualValue, timespanModels, historicalOnly, sanitize, "(?iu)((.*((fara\\s*an)|(f\\.\\s*an)|(f\\.a)))|(((fara\\s*data)|(f\\.\\s*data)|(f\\.d))).*)", "unknown");
        residualValue = TimespanUtils.updateMatchedValues(residualValue, timespanModels, historicalOnly, sanitize, "(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((dupa|post|postum)\\s*((?iu)(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(\\d{1,2}\\.\\d{1,2}\\.\\d{3,}|\\d{1,2}\\/\\d{2}\\/\\d{3,}|\\d{1,2}\\s+\\d{2}\\s+\\d{3,}|\\d{1,2}[,\\s]+((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)[,\\s]+\\d{3,})(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?iu)(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(\\d{3,}[-]{1}\\d{2}[-]{1}\\d{1,2}|\\d{3,}[,\\s]+((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)[,\\s]+\\d{1,2})(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d{1,4}(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))", "year");
        residualValue = TimespanUtils.updateMatchedValues(residualValue, timespanModels, historicalOnly, sanitize, "(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((ante|anterior\\s*lui|inainte\\s*de)\\s*((?iu)(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(\\d{1,2}\\.\\d{1,2}\\.\\d{3,}|\\d{1,2}\\/\\d{2}\\/\\d{3,}|\\d{1,2}\\s+\\d{2}\\s+\\d{3,}|\\d{1,2}[,\\s]+((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)[,\\s]+\\d{3,})(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?iu)(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(\\d{3,}[-]{1}\\d{2}[-]{1}\\d{1,2}|\\d{3,}[,\\s]+((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)[,\\s]+\\d{1,2})(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d{1,4}(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))", "year");
        residualValue = TimespanUtils.updateMatchedValues(residualValue, timespanModels, historicalOnly, sanitize, "(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(catre|probabil|aprox[\\.]*|aproximativ(\\s*anii)?|cca[\\.]*|c[a]?[\\.]?|circa)\\s*\\d+)([\\.,;\\?!\\-\\s]*(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?)*)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))", "year");
        residualValue = TimespanUtils.updateMatchedValues(residualValue, timespanModels, historicalOnly, sanitize, "(?iu)((((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/2)|(\u00bd)|((prim[a]*[\\. ]+(jum([a\u0103]tate(a)?)?|part))([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/2)|((a\\s+(doua|(ii[-a]*))[\\. ]+(jum([a\u0103]tate(a)?)?|part)[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(jum([a\u0103]tate(a)?)?|(mij[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)|mj\\.)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/4)|(\u00bc)|(([i\u00ee]nc[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\. ]*)(de)?)|(primul\\s+sfert(\\s+a[l]?)?)|(prima treime a))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/4)|(al doile[a]? sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((3/4)|(\u00be)|(al treilea sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((4/4)|((ultimul\\s+sfert)(\\s+(a[l]?|de)*)?)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|((?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))))", "year");
        residualValue = TimespanUtils.updateMatchedValues(residualValue, timespanModels, historicalOnly, sanitize, "(([\\[\\(\\]\\)\\?\\!\\d\\\u2026]{5,}))", "unknown");
        return timespanModels;
    }

    private static String updateMatchedValues(String original, List<TimespanModel> timespanModels, boolean historicalOnly, boolean sanitize, String regex, String matchedType) {
        String residualValue = sanitize ? TimeSanitizeUtils.clearJunks(original, regex) : original;
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(residualValue);
        while (matcher.find()) {
            String matchedValue = matcher.group();
            if (matchedValue == null) continue;
            TimePeriodModel timePeriod = TimespanUtils.prepareTimePeriodModel(original, TimeUtils.normalizeChristumNotation(matchedValue = matchedValue.trim()), regex, historicalOnly);
            String matchedItems = timePeriod.toString();
            if (!matchedItems.isEmpty() && !matchedItems.equals(matchedValue)) {
                String[] matchedList = matchedItems.split(" ### ");
                timespanModels.add(new TimespanModel(timePeriod, matchedList, matchedValue, matchedType, residualValue));
                continue;
            }
            if (!matchedItems.equals(matchedValue)) continue;
            System.err.println("The following group has not been processed: \"" + matchedValue + "\"");
        }
        residualValue = residualValue.replaceAll(regex, "");
        return residualValue;
    }

    private static TimePeriodModel prepareTimePeriodModel(String original, String value, String regex, boolean historicalOnly) {
        TimePeriodModel prepared = TimespanUtils.prepareAges(original, value, regex, historicalOnly);
        if (prepared == null) {
            prepared = TimespanUtils.prepareDateTime(original, value, regex, historicalOnly);
        }
        if (prepared == null) {
            prepared = TimespanUtils.preparePeriod(original, value, regex, historicalOnly);
        }
        return prepared;
    }

    private static TimePeriodModel prepareAges(String original, String value, String regex, boolean historicalOnly) {
        switch (regex) {
            case "(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((dupa|post|postum)\\s*((?iu)(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(\\d{1,2}\\.\\d{1,2}\\.\\d{3,}|\\d{1,2}\\/\\d{2}\\/\\d{3,}|\\d{1,2}\\s+\\d{2}\\s+\\d{3,}|\\d{1,2}[,\\s]+((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)[,\\s]+\\d{3,})(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?iu)(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(\\d{3,}[-]{1}\\d{2}[-]{1}\\d{1,2}|\\d{3,}[,\\s]+((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)[,\\s]+\\d{1,2})(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d{1,4}(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))": 
            case "(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((dupa|post|postum)\\s*((?iu)(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(\\d{1,2}\\.\\d{1,2}\\.\\d{3,}|\\d{1,2}\\/\\d{2}\\/\\d{3,}|\\d{1,2}\\s+\\d{2}\\s+\\d{3,}|\\d{1,2}[,\\s]+((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)[,\\s]+\\d{3,})(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?iu)(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(\\d{3,}[-]{1}\\d{2}[-]{1}\\d{1,2}|\\d{3,}[,\\s]+((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)[,\\s]+\\d{1,2})(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d{1,4}(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))\\s*(?:-|\u2013)\\s*((?iu)(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(\\d{1,2}\\.\\d{1,2}\\.\\d{3,}|\\d{1,2}\\/\\d{2}\\/\\d{3,}|\\d{1,2}\\s+\\d{2}\\s+\\d{3,}|\\d{1,2}[,\\s]+((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)[,\\s]+\\d{3,})(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?iu)(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(\\d{3,}[-]{1}\\d{2}[-]{1}\\d{1,2}|\\d{3,}[,\\s]+((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)[,\\s]+\\d{1,2})(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d{1,4}(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))": 
            case "(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(catre|probabil|aprox[\\.]*|aproximativ(\\s*anii)?|cca[\\.]*|c[a]?[\\.]?|circa)\\s*\\d+)([\\.,;\\?!\\-\\s]*(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?)*)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))\\s*(?:-|\u2013)\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(catre|probabil|aprox[\\.]*|aproximativ(\\s*anii)?|cca[\\.]*|c[a]?[\\.]?|circa)\\s*\\d+)([\\.,;\\?!\\-\\s]*(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?)*)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|((?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?)\\s*(?:-|\u2013)\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(catre|probabil|aprox[\\.]*|aproximativ(\\s*anii)?|cca[\\.]*|c[a]?[\\.]?|circa)\\s*\\d+)([\\.,;\\?!\\-\\s]*(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?)*)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))": 
            case "(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(catre|probabil|aprox[\\.]*|aproximativ(\\s*anii)?|cca[\\.]*|c[a]?[\\.]?|circa)\\s*\\d+)([\\.,;\\?!\\-\\s]*(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?)*)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))": 
            case "(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((ante|anterior\\s*lui|inainte\\s*de)\\s*((?iu)(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(\\d{1,2}\\.\\d{1,2}\\.\\d{3,}|\\d{1,2}\\/\\d{2}\\/\\d{3,}|\\d{1,2}\\s+\\d{2}\\s+\\d{3,}|\\d{1,2}[,\\s]+((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)[,\\s]+\\d{3,})(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?iu)(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(\\d{3,}[-]{1}\\d{2}[-]{1}\\d{1,2}|\\d{3,}[,\\s]+((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)[,\\s]+\\d{1,2})(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d{1,4}(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))": 
            case "(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((ante|anterior\\s*lui|inainte\\s*de)\\s*((?iu)(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(\\d{1,2}\\.\\d{1,2}\\.\\d{3,}|\\d{1,2}\\/\\d{2}\\/\\d{3,}|\\d{1,2}\\s+\\d{2}\\s+\\d{3,}|\\d{1,2}[,\\s]+((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)[,\\s]+\\d{3,})(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?iu)(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(\\d{3,}[-]{1}\\d{2}[-]{1}\\d{1,2}|\\d{3,}[,\\s]+((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)[,\\s]+\\d{1,2})(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d{1,4}(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))\\s*(?:-|\u2013)\\s*((?iu)(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(\\d{1,2}\\.\\d{1,2}\\.\\d{3,}|\\d{1,2}\\/\\d{2}\\/\\d{3,}|\\d{1,2}\\s+\\d{2}\\s+\\d{3,}|\\d{1,2}[,\\s]+((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)[,\\s]+\\d{3,})(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?iu)(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(\\d{3,}[-]{1}\\d{2}[-]{1}\\d{1,2}|\\d{3,}[,\\s]+((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)[,\\s]+\\d{1,2})(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d{1,4}(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))": {
                return new InaccurateYearModel(original, value, historicalOnly);
            }
            case "(?iu)((.*((fara\\s*an)|(f\\.\\s*an)|(f\\.a)))|(((fara\\s*data)|(f\\.\\s*data)|(f\\.d))).*)": 
            case "(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))model\\s*\\d{4})(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))": 
            case "(?iu)(.*(nedatat|nedatabil|nu\\s*are).*)": 
            case "(([\\[\\(\\]\\)\\?\\!\\d\\\u2026]{5,}))": 
            case "(?iu)^(-|4/4 sec\\.|17 nov\\. 375\\-9 aug\\. 378 a\\.chr\\.|1884 martie 28/aprilie 09|189-45|al doile afert al s1900|an[ ]?\\d{1,2}[\\?]?|cultura inca sau chachapoya\\?|datat|dinastia xxv|dinastia xxvi \\(dinastia saita\\)|dinastia xxvi \\(perioada saita\\)|dinastia xxvii \\(prima stapanire persana\\)|nesemnat|disparuta din uz si din zona; existenta in muzee|epoca severica tarzie|grupa a iv-a|grupa a v-a|grupa iii|grupa iv|grupa v|la tene|lama de secol xvi/xvii, garda si manerul ulterioare|leat 7208 \\(1699-1700\\)|mai, dni 15, leat 7232|mesiata.*|fev\\. dni 2 leat 7157|iulie 28|iunie 01|iunie 20, leat 7173 \\(1665\\)|iunie, dni 2, leat 7235|august 04|oct\\. 10 dni, leat 1730|octombrie 23, 1777|noiembrie 22|noiembrie 24|perioada lui carol x al frantei|perioada domniei regelui carol al ii-lea|perioada regelui carol al ii-lea|regatul nou\\?|21/2, sc\\.i, a\\.c\\.|21/2; sc i a\\.c\\.|286/5-282/1|286/5-282/1 a\\. chr|15\\(\u2026\\)4|154\\(\u2026\\)|158\\(\u2026\\)|162\\(\\?\\)|16\\[ \\])$": {
                return new DatelessModel(original, value, regex, historicalOnly);
            }
            case "(?iu)(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((?iu)((((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/2)|(\u00bd)|((prim[a]*[\\. ]+(jum([a\u0103]tate(a)?)?|part))([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/2)|((a\\s+(doua|(ii[-a]*))[\\. ]+(jum([a\u0103]tate(a)?)?|part)[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(jum([a\u0103]tate(a)?)?|(mij[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)|mj\\.)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/4)|(\u00bc)|(([i\u00ee]nc[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\. ]*)(de)?)|(primul\\s+sfert(\\s+a[l]?)?)|(prima treime a))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/4)|(al doile[a]? sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((3/4)|(\u00be)|(al treilea sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((4/4)|((ultimul\\s+sfert)(\\s+(a[l]?|de)*)?)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|((?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))))\\s*(?:-|\u2013)\\s*(?iu)((((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/2)|(\u00bd)|((prim[a]*[\\. ]+(jum([a\u0103]tate(a)?)?|part))([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/2)|((a\\s+(doua|(ii[-a]*))[\\. ]+(jum([a\u0103]tate(a)?)?|part)[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(jum([a\u0103]tate(a)?)?|(mij[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)|mj\\.)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/4)|(\u00bc)|(([i\u00ee]nc[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\. ]*)(de)?)|(primul\\s+sfert(\\s+a[l]?)?)|(prima treime a))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/4)|(al doile[a]? sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((3/4)|(\u00be)|(al treilea sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((4/4)|((ultimul\\s+sfert)(\\s+(a[l]?|de)*)?)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|((?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))))": 
            case "(?iu)(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((?:[i\u00ee]ntre|[i\u00ee]n\\s*interval(?:ul|u)?)\\s*(?iu)((((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/2)|(\u00bd)|((prim[a]*[\\. ]+(jum([a\u0103]tate(a)?)?|part))([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/2)|((a\\s+(doua|(ii[-a]*))[\\. ]+(jum([a\u0103]tate(a)?)?|part)[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(jum([a\u0103]tate(a)?)?|(mij[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)|mj\\.)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/4)|(\u00bc)|(([i\u00ee]nc[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\. ]*)(de)?)|(primul\\s+sfert(\\s+a[l]?)?)|(prima treime a))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/4)|(al doile[a]? sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((3/4)|(\u00be)|(al treilea sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((4/4)|((ultimul\\s+sfert)(\\s+(a[l]?|de)*)?)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|((?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))))\\s*(?:-|\u2013|([s\u015f\u0219]i))\\s*(?iu)((((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/2)|(\u00bd)|((prim[a]*[\\. ]+(jum([a\u0103]tate(a)?)?|part))([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/2)|((a\\s+(doua|(ii[-a]*))[\\. ]+(jum([a\u0103]tate(a)?)?|part)[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(jum([a\u0103]tate(a)?)?|(mij[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)|mj\\.)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/4)|(\u00bc)|(([i\u00ee]nc[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\. ]*)(de)?)|(primul\\s+sfert(\\s+a[l]?)?)|(prima treime a))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/4)|(al doile[a]? sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((3/4)|(\u00be)|(al treilea sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((4/4)|((ultimul\\s+sfert)(\\s+(a[l]?|de)*)?)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|((?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))))": 
            case "(?iu)(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(\\d{3,4}(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(\\s*(/|sau)\\s*)\\d{3,4}(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))": 
            case "(?iu)((((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/2)|(\u00bd)|((prim[a]*[\\. ]+(jum([a\u0103]tate(a)?)?|part))([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/2)|((a\\s+(doua|(ii[-a]*))[\\. ]+(jum([a\u0103]tate(a)?)?|part)[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(jum([a\u0103]tate(a)?)?|(mij[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)|mj\\.)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/4)|(\u00bc)|(([i\u00ee]nc[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\. ]*)(de)?)|(primul\\s+sfert(\\s+a[l]?)?)|(prima treime a))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/4)|(al doile[a]? sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((3/4)|(\u00be)|(al treilea sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((4/4)|((ultimul\\s+sfert)(\\s+(a[l]?|de)*)?)))[\\.,;\\?!\\-\\s]*(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))|((?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?))?(?<!(?:lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103])\\s)(?<![\\d\\.])((?:\\d{1,3}\\.(?:\\d{3}\\.?)+|[\\[\\(]\\d{1,4}[\\]\\)]\\d{0,3}|\\d?[\\[\\(]\\d{1,3}[\\]\\)]\\d{0,2}|\\d{3,4})((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?|(?:\\d{2,3})(?!(\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12))|(\\.\\d))\\b)(?!\\s*(?:de\\s*)?(?:ani(lor)?|an(ului|ul)?|lunile|luni(i|[a\u0103]|lor)?|lun[a\u0103]|s[a\u0103]pt[a\u0103]m[a\u00e2]ni(i|le|lor)?|s[a\u0103]pt[a\u0103]m[a\u00e2]n[a\u0103]|zile(le|lor)?|ziu[a\u0103]|zi|ore(i|le|lor)?|or[a\u0103]|minute(le|lor)?|minut(ului|ul)?|secunde(i|le|lor)?|secund[a\u0103]|milisecunde(i|le|lor)?|milisecund[a\u0103]))(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))))": {
                return new YearModel(original, value, regex, historicalOnly);
            }
        }
        return null;
    }

    private static TimePeriodModel prepareDateTime(String original, String value, String regex, boolean historicalOnly) {
        switch (regex) {
            case "(?iu)(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(\\d{1,2}\\.\\d{2}(\\.\\d{3,})?|\\d{1,2}\\/\\d{2}(\\/\\d{3,})?|\\d{1,2}\\s+\\d{2}(\\s+\\d{3,})?|\\d{1,2}[, ]+((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)([,\\s]+\\d{3,})?|\\d{1,2}\\s*((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)?)(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?\\s*(?:-|\u2013)\\s*(\\d{1,2}\\.\\d{1,2}\\.\\d{3,}|\\d{1,2}\\/\\d{2}\\/\\d{3,}|\\d{1,2}\\s+\\d{2}\\s+\\d{3,}|\\d{1,2}[,\\s]+((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)[,\\s]+\\d{3,})(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))": 
            case "(?iu)(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(\\d{1,2}\\.\\d{1,2}\\.\\d{3,}|\\d{1,2}\\/\\d{2}\\/\\d{3,}|\\d{1,2}\\s+\\d{2}\\s+\\d{3,}|\\d{1,2}[,\\s]+((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)[,\\s]+\\d{3,})(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))": {
                return new DateModel(original, value, TimeUtils.DMY_PLACEHOLDER, historicalOnly);
            }
            case "(?iu)(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(\\d{3,}[-]{1}\\d{2}[-]{1}\\d{1,2}|\\d{3,}[,\\s]+((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)[,\\s]+\\d{1,2})(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?\\s*(?:-|\u2013)\\s*(\\d{3,}[-]{1}\\d{2}[-]{1}\\d{1,2}|\\d{3,}[,\\s]+((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)[,\\s]+\\d{1,2})(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))": 
            case "(?iu)(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(\\d{3,}[-]{1}\\d{2}[-]{1}\\d{1,2}|\\d{3,}[,\\s]+((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)[,\\s]+\\d{1,2})(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))": {
                return new DateModel(original, value, TimeUtils.YMD_PLACEHOLDER, historicalOnly);
            }
            case "(?iu)^(?!\\s*[\\(\\[]?\\d+[\\)\\]]?\\s*\\s*(?:-|\u2013)\\s*\\s*[\\(\\[]?\\d+[\\)\\]]?\\s*$).*(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(((((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)\\s+\\d{3,})(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?)\\s*(?:-|\u2013)\\s*((((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)\\s+\\d{3,})(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|((((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)\\s+\\d{3,})(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?\\s*(?:-|\u2013)\\s*((((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)\\s+\\d{3,})|\\d{3,})(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?)|(((((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)\\s+\\d{3,})|\\d{3,})(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?\\s*(?:-|\u2013)\\s*(((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)\\s+\\d{3,})(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))": 
            case "(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(((ianuarie|februarie|martie|aprilie|mai|iunie|iulie|august|septembrie|octombrie|noiembrie|decembrie|(ian|feb|mart|apr|iun|iul|aug|sept|oct|noi|dec)\\.|fevruarie|iumie|0ctombrie|noimbrie|decembre)|(january|february|march|april|may|june|july|august|september|october|november|december|(jan|feb|apr|jun|jul|aug|sep|oct|nov|dec)\\.)|(?:0?(?:1|2|3|4|5|6|7|8|9))|10|11|12)\\s+\\d{3,}(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))": {
                return new ShortDateModel(original, value, TimeUtils.MY_PLACEHOLDER, historicalOnly);
            }
            case "(?iu)(^s:[\\d]{1,2};a:[\\d]{1,4};l:[\\d]{1,2};z:[\\d]{1,2}$)": {
                return new LongDateModel(original, value, historicalOnly);
            }
        }
        return null;
    }

    private static TimePeriodModel preparePeriod(String original, String value, String regex, boolean historicalOnly) {
        switch (regex) {
            case "(?iu)(?iu)(((((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/2)|(\u00bd)|((prim[a]*[\\. ]+(jum([a\u0103]tate(a)?)?|part))([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/2)|((a\\s+(doua|(ii[-a]*))[\\. ]+(jum([a\u0103]tate(a)?)?|part)[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(jum([a\u0103]tate(a)?)?|(mij[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)|mj\\.)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/4)|(\u00bc)|(([i\u00ee]nc[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\. ]*)(de)?)|(primul\\s+sfert(\\s+a[l]?)?)|(prima treime a))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/4)|(al doile[a]? sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((3/4)|(\u00be)|(al treilea sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((4/4)|((ultimul\\s+sfert)(\\s+(a[l]?|de)*)?)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?)))|((((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/2)|(\u00bd)|((prim[a]*[\\. ]+(jum([a\u0103]tate(a)?)?|part))([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/2)|((a\\s+(doua|(ii[-a]*))[\\. ]+(jum([a\u0103]tate(a)?)?|part)[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(jum([a\u0103]tate(a)?)?|(mij[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)|mj\\.)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/4)|(\u00bc)|(([i\u00ee]nc[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\. ]*)(de)?)|(primul\\s+sfert(\\s+a[l]?)?)|(prima treime a))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/4)|(al doile[a]? sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((3/4)|(\u00be)|(al treilea sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((4/4)|((ultimul\\s+sfert)(\\s+(a[l]?|de)*)?)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))))\\s*(?:-|\u2013)\\s*((?iu)(((((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/2)|(\u00bd)|((prim[a]*[\\. ]+(jum([a\u0103]tate(a)?)?|part))([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/2)|((a\\s+(doua|(ii[-a]*))[\\. ]+(jum([a\u0103]tate(a)?)?|part)[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(jum([a\u0103]tate(a)?)?|(mij[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)|mj\\.)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/4)|(\u00bc)|(([i\u00ee]nc[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\. ]*)(de)?)|(primul\\s+sfert(\\s+a[l]?)?)|(prima treime a))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/4)|(al doile[a]? sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((3/4)|(\u00be)|(al treilea sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((4/4)|((ultimul\\s+sfert)(\\s+(a[l]?|de)*)?)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?)))|((((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/2)|(\u00bd)|((prim[a]*[\\. ]+(jum([a\u0103]tate(a)?)?|part))([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/2)|((a\\s+(doua|(ii[-a]*))[\\. ]+(jum([a\u0103]tate(a)?)?|part)[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(jum([a\u0103]tate(a)?)?|(mij[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)|mj\\.)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/4)|(\u00bc)|(([i\u00ee]nc[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\. ]*)(de)?)|(primul\\s+sfert(\\s+a[l]?)?)|(prima treime a))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/4)|(al doile[a]? sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((3/4)|(\u00be)|(al treilea sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((4/4)|((ultimul\\s+sfert)(\\s+(a[l]?|de)*)?)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))))|((((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?)|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?)))": 
            case "(?iu)(?:[i\u00ee]ntre|[i\u00ee]n\\s*interval(?:ul|u)?)\\s*(?iu)(((((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/2)|(\u00bd)|((prim[a]*[\\. ]+(jum([a\u0103]tate(a)?)?|part))([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/2)|((a\\s+(doua|(ii[-a]*))[\\. ]+(jum([a\u0103]tate(a)?)?|part)[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(jum([a\u0103]tate(a)?)?|(mij[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)|mj\\.)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/4)|(\u00bc)|(([i\u00ee]nc[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\. ]*)(de)?)|(primul\\s+sfert(\\s+a[l]?)?)|(prima treime a))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/4)|(al doile[a]? sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((3/4)|(\u00be)|(al treilea sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((4/4)|((ultimul\\s+sfert)(\\s+(a[l]?|de)*)?)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?)))|((((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/2)|(\u00bd)|((prim[a]*[\\. ]+(jum([a\u0103]tate(a)?)?|part))([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/2)|((a\\s+(doua|(ii[-a]*))[\\. ]+(jum([a\u0103]tate(a)?)?|part)[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(jum([a\u0103]tate(a)?)?|(mij[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)|mj\\.)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/4)|(\u00bc)|(([i\u00ee]nc[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\. ]*)(de)?)|(primul\\s+sfert(\\s+a[l]?)?)|(prima treime a))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/4)|(al doile[a]? sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((3/4)|(\u00be)|(al treilea sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((4/4)|((ultimul\\s+sfert)(\\s+(a[l]?|de)*)?)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))))\\s*(?:-|\u2013|([s\u015f\u0219]i))\\s*(((?:al[\\.\\s]*)?((((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?)|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?)))|(?iu)(((((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/2)|(\u00bd)|((prim[a]*[\\. ]+(jum([a\u0103]tate(a)?)?|part))([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/2)|((a\\s+(doua|(ii[-a]*))[\\. ]+(jum([a\u0103]tate(a)?)?|part)[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(jum([a\u0103]tate(a)?)?|(mij[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)|mj\\.)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/4)|(\u00bc)|(([i\u00ee]nc[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\. ]*)(de)?)|(primul\\s+sfert(\\s+a[l]?)?)|(prima treime a))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/4)|(al doile[a]? sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((3/4)|(\u00be)|(al treilea sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((4/4)|((ultimul\\s+sfert)(\\s+(a[l]?|de)*)?)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?)))|((((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/2)|(\u00bd)|((prim[a]*[\\. ]+(jum([a\u0103]tate(a)?)?|part))([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/2)|((a\\s+(doua|(ii[-a]*))[\\. ]+(jum([a\u0103]tate(a)?)?|part)[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(jum([a\u0103]tate(a)?)?|(mij[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)|mj\\.)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/4)|(\u00bc)|(([i\u00ee]nc[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\. ]*)(de)?)|(primul\\s+sfert(\\s+a[l]?)?)|(prima treime a))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/4)|(al doile[a]? sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((3/4)|(\u00be)|(al treilea sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((4/4)|((ultimul\\s+sfert)(\\s+(a[l]?|de)*)?)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?)))))": 
            case "(?iu)(((((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/2)|(\u00bd)|((prim[a]*[\\. ]+(jum([a\u0103]tate(a)?)?|part))([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/2)|((a\\s+(doua|(ii[-a]*))[\\. ]+(jum([a\u0103]tate(a)?)?|part)[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(jum([a\u0103]tate(a)?)?|(mij[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)|mj\\.)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/4)|(\u00bc)|(([i\u00ee]nc[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\. ]*)(de)?)|(primul\\s+sfert(\\s+a[l]?)?)|(prima treime a))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/4)|(al doile[a]? sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((3/4)|(\u00be)|(al treilea sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((4/4)|((ultimul\\s+sfert)(\\s+(a[l]?|de)*)?)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?)))|((((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/2)|(\u00bd)|((prim[a]*[\\. ]+(jum([a\u0103]tate(a)?)?|part))([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/2)|((a\\s+(doua|(ii[-a]*))[\\. ]+(jum([a\u0103]tate(a)?)?|part)[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(jum([a\u0103]tate(a)?)?|(mij[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)|mj\\.)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/4)|(\u00bc)|(([i\u00ee]nc[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\. ]*)(de)?)|(primul\\s+sfert(\\s+a[l]?)?)|(prima treime a))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/4)|(al doile[a]? sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((3/4)|(\u00be)|(al treilea sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((4/4)|((ultimul\\s+sfert)(\\s+(a[l]?|de)*)?)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))))": 
            case "(?iu)(((((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/2)|(\u00bd)|((prim[a]*[\\. ]+(jum([a\u0103]tate(a)?)?|part))([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/2)|((a\\s+(doua|(ii[-a]*))[\\. ]+(jum([a\u0103]tate(a)?)?|part)[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(jum([a\u0103]tate(a)?)?|(mij[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)|mj\\.)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/4)|(\u00bc)|(([i\u00ee]nc[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\. ]*)(de)?)|(primul\\s+sfert(\\s+a[l]?)?)|(prima treime a))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/4)|(al doile[a]? sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((3/4)|(\u00be)|(al treilea sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((4/4)|((ultimul\\s+sfert)(\\s+(a[l]?|de)*)?)))[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?)))\\s*(?:-|\u2013)\\s*(((((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/2)|(\u00bd)|((prim[a]*[\\. ]+(jum([a\u0103]tate(a)?)?|part))([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/2)|((a\\s+(doua|(ii[-a]*))[\\. ]+(jum([a\u0103]tate(a)?)?|part)[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(jum([a\u0103]tate(a)?)?|(mij[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)|mj\\.)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/4)|(\u00bc)|(([i\u00ee]nc[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\. ]*)(de)?)|(primul\\s+sfert(\\s+a[l]?)?)|(prima treime a))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/4)|(al doile[a]? sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((3/4)|(\u00be)|(al treilea sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((4/4)|((ultimul\\s+sfert)(\\s+(a[l]?|de)*)?)))[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?)))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?)))": 
            case "((((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/2)|(\u00bd)|((prim[a]*[\\. ]+(jum([a\u0103]tate(a)?)?|part))([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/2)|((a\\s+(doua|(ii[-a]*))[\\. ]+(jum([a\u0103]tate(a)?)?|part)[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(jum([a\u0103]tate(a)?)?|(mij[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)|mj\\.)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/4)|(\u00bc)|(([i\u00ee]nc[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\. ]*)(de)?)|(primul\\s+sfert(\\s+a[l]?)?)|(prima treime a))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/4)|(al doile[a]? sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((3/4)|(\u00be)|(al treilea sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((4/4)|((ultimul\\s+sfert)(\\s+(a[l]?|de)*)?)))[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?)))": {
                return new CenturyModel(original, value, regex, historicalOnly);
            }
            case "(?iu)(?iu)(((((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/2)|(\u00bd)|((prim[a]*[\\. ]+(jum([a\u0103]tate(a)?)?|part))([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/2)|((a\\s+(doua|(ii[-a]*))[\\. ]+(jum([a\u0103]tate(a)?)?|part)[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(jum([a\u0103]tate(a)?)?|(mij[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)|mj\\.)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/4)|(\u00bc)|(([i\u00ee]nc[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\. ]*)(de)?)|(primul\\s+sfert(\\s+a[l]?)?)|(prima treime a))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/4)|(al doile[a]? sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((3/4)|(\u00be)|(al treilea sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((4/4)|((ultimul\\s+sfert)(\\s+(a[l]?|de)*)?)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?)))|((((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/2)|(\u00bd)|((prim[a]*[\\. ]+(jum([a\u0103]tate(a)?)?|part))([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/2)|((a\\s+(doua|(ii[-a]*))[\\. ]+(jum([a\u0103]tate(a)?)?|part)[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(jum([a\u0103]tate(a)?)?|(mij[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)|mj\\.)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/4)|(\u00bc)|(([i\u00ee]nc[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\. ]*)(de)?)|(primul\\s+sfert(\\s+a[l]?)?)|(prima treime a))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/4)|(al doile[a]? sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((3/4)|(\u00be)|(al treilea sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((4/4)|((ultimul\\s+sfert)(\\s+(a[l]?|de)*)?)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))))\\s*(?:-|\u2013)\\s*((?iu)(((((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/2)|(\u00bd)|((prim[a]*[\\. ]+(jum([a\u0103]tate(a)?)?|part))([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/2)|((a\\s+(doua|(ii[-a]*))[\\. ]+(jum([a\u0103]tate(a)?)?|part)[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(jum([a\u0103]tate(a)?)?|(mij[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)|mj\\.)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/4)|(\u00bc)|(([i\u00ee]nc[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\. ]*)(de)?)|(primul\\s+sfert(\\s+a[l]?)?)|(prima treime a))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/4)|(al doile[a]? sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((3/4)|(\u00be)|(al treilea sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((4/4)|((ultimul\\s+sfert)(\\s+(a[l]?|de)*)?)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?)))|((((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/2)|(\u00bd)|((prim[a]*[\\. ]+(jum([a\u0103]tate(a)?)?|part))([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/2)|((a\\s+(doua|(ii[-a]*))[\\. ]+(jum([a\u0103]tate(a)?)?|part)[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(jum([a\u0103]tate(a)?)?|(mij[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)|mj\\.)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/4)|(\u00bc)|(([i\u00ee]nc[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\. ]*)(de)?)|(primul\\s+sfert(\\s+a[l]?)?)|(prima treime a))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/4)|(al doile[a]? sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((3/4)|(\u00be)|(al treilea sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((4/4)|((ultimul\\s+sfert)(\\s+(a[l]?|de)*)?)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))))|((((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?)|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?)))": 
            case "(?iu)(?:[i\u00ee]ntre|[i\u00ee]n\\s*interval(?:ul|u)?)\\s*(?iu)(((((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/2)|(\u00bd)|((prim[a]*[\\. ]+(jum([a\u0103]tate(a)?)?|part))([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/2)|((a\\s+(doua|(ii[-a]*))[\\. ]+(jum([a\u0103]tate(a)?)?|part)[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(jum([a\u0103]tate(a)?)?|(mij[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)|mj\\.)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/4)|(\u00bc)|(([i\u00ee]nc[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\. ]*)(de)?)|(primul\\s+sfert(\\s+a[l]?)?)|(prima treime a))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/4)|(al doile[a]? sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((3/4)|(\u00be)|(al treilea sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((4/4)|((ultimul\\s+sfert)(\\s+(a[l]?|de)*)?)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?)))|((((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/2)|(\u00bd)|((prim[a]*[\\. ]+(jum([a\u0103]tate(a)?)?|part))([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/2)|((a\\s+(doua|(ii[-a]*))[\\. ]+(jum([a\u0103]tate(a)?)?|part)[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(jum([a\u0103]tate(a)?)?|(mij[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)|mj\\.)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/4)|(\u00bc)|(([i\u00ee]nc[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\. ]*)(de)?)|(primul\\s+sfert(\\s+a[l]?)?)|(prima treime a))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/4)|(al doile[a]? sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((3/4)|(\u00be)|(al treilea sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((4/4)|((ultimul\\s+sfert)(\\s+(a[l]?|de)*)?)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))))\\s*(?:-|\u2013|([s\u015f\u0219]i))\\s*(((?:al[\\.\\s]*)?((((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?)|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?)))|(?iu)(((((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/2)|(\u00bd)|((prim[a]*[\\. ]+(jum([a\u0103]tate(a)?)?|part))([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/2)|((a\\s+(doua|(ii[-a]*))[\\. ]+(jum([a\u0103]tate(a)?)?|part)[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(jum([a\u0103]tate(a)?)?|(mij[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)|mj\\.)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/4)|(\u00bc)|(([i\u00ee]nc[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\. ]*)(de)?)|(primul\\s+sfert(\\s+a[l]?)?)|(prima treime a))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/4)|(al doile[a]? sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((3/4)|(\u00be)|(al treilea sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((4/4)|((ultimul\\s+sfert)(\\s+(a[l]?|de)*)?)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?)))|((((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/2)|(\u00bd)|((prim[a]*[\\. ]+(jum([a\u0103]tate(a)?)?|part))([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/2)|((a\\s+(doua|(ii[-a]*))[\\. ]+(jum([a\u0103]tate(a)?)?|part)[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(jum([a\u0103]tate(a)?)?|(mij[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)|mj\\.)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/4)|(\u00bc)|(([i\u00ee]nc[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\. ]*)(de)?)|(primul\\s+sfert(\\s+a[l]?)?)|(prima treime a))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/4)|(al doile[a]? sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((3/4)|(\u00be)|(al treilea sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((4/4)|((ultimul\\s+sfert)(\\s+(a[l]?|de)*)?)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?)))))": 
            case "(?iu)(((((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/2)|(\u00bd)|((prim[a]*[\\. ]+(jum([a\u0103]tate(a)?)?|part))([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/2)|((a\\s+(doua|(ii[-a]*))[\\. ]+(jum([a\u0103]tate(a)?)?|part)[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(jum([a\u0103]tate(a)?)?|(mij[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)|mj\\.)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/4)|(\u00bc)|(([i\u00ee]nc[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\. ]*)(de)?)|(primul\\s+sfert(\\s+a[l]?)?)|(prima treime a))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/4)|(al doile[a]? sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((3/4)|(\u00be)|(al treilea sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((4/4)|((ultimul\\s+sfert)(\\s+(a[l]?|de)*)?)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))\\d+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?)))|((((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/2)|(\u00bd)|((prim[a]*[\\. ]+(jum([a\u0103]tate(a)?)?|part))([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/2)|((a\\s+(doua|(ii[-a]*))[\\. ]+(jum([a\u0103]tate(a)?)?|part)[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(jum([a\u0103]tate(a)?)?|(mij[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)|mj\\.)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/4)|(\u00bc)|(([i\u00ee]nc[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\. ]*)(de)?)|(primul\\s+sfert(\\s+a[l]?)?)|(prima treime a))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/4)|(al doile[a]? sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((3/4)|(\u00be)|(al treilea sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((4/4)|((ultimul\\s+sfert)(\\s+(a[l]?|de)*)?)))[\\.,;\\?!\\-\\s]*(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))|((((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)[\\.,;\\?!\\-\\s]*(((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))[ivxlcdm]+(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))([- ]*lea)?([\\.,;\\?!\\-\\s]*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?))))": {
                return new MillenniumModel(original, value, regex, historicalOnly);
            }
            case "(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(aurignacian)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))": 
            case "(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(bronz|bronzului|tarzii)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))": 
            case "(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(eneolitic)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))": 
            case "(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(perioada consulatului francez)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))": 
            case "(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(hallstatt)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))": 
            case "(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(interbelica)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))": 
            case "(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(epipaleolitic)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))": 
            case "(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((medieval|medievala))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))": 
            case "(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(moderna)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))": 
            case "(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(neolitic[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))": 
            case "(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(antoninian[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*|hadrian)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))": 
            case "(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(pleistocen)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))": 
            case "(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(ptolem[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))": 
            case "(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(renastere)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))": 
            case "(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(romana)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))": 
            case "(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(primul razboi mondial)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))": 
            case "(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(al (doilea|ii-lea) razboi mondial)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))": {
                return new AgeModel(original, value, regex, historicalOnly);
            }
        }
        return null;
    }
}

