/*
 * Decompiled with CFR 0.152.
 */
package ro.webdata.normalization.timespan.ro;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TimeUtils {
    public static final String CHRISTUM_AD_LABEL = "AD";
    public static final String CHRISTUM_BC_LABEL = "BC";
    public static final String APPROXIMATE_PLACEHOLDER = "APPROXIMATE";
    public static final String UNKNOWN_DATE_PLACEHOLDER = "UNKNOWN";
    public static final String CHRISTUM_AD_PLACEHOLDER = "__AD__";
    public static final String CHRISTUM_BC_PLACEHOLDER = "__BC__";
    public static final String INTERVAL_SEPARATOR_PLACEHOLDER = " __TO__ ";
    public static String START_PLACEHOLDER = "START";
    public static String END_PLACEHOLDER = "END";
    public static String YMD_PLACEHOLDER = "YMD";
    public static String DMY_PLACEHOLDER = "DMY";
    public static String YM_PLACEHOLDER = "YM";
    public static String MY_PLACEHOLDER = "MY";
    private static final Map<Integer, String> arabicMap = new TreeMap(Collections.reverseOrder());
    private static final Map<Character, Integer> romanMap = new HashMap<Character, Integer>(7);

    public static String getEraLabel(String value) {
        return value.contains(CHRISTUM_BC_PLACEHOLDER) ? CHRISTUM_BC_LABEL : CHRISTUM_AD_LABEL;
    }

    public static String getEraName(String value) {
        return value.contains(CHRISTUM_BC_PLACEHOLDER) ? CHRISTUM_BC_PLACEHOLDER : CHRISTUM_AD_PLACEHOLDER;
    }

    public static String clearChristumNotation(String value) {
        return value.replaceAll(CHRISTUM_BC_PLACEHOLDER, "").replaceAll(CHRISTUM_AD_PLACEHOLDER, "").trim();
    }

    public static String clearDate(String value) {
        return value.replaceAll("(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(catre|probabil|aprox[\\.]*|aproximativ(\\s*anii)?|cca[\\.]*|c[a]?[\\.]?|circa)\\s*", "").replaceAll("[\\.\\(\\)\\[\\]\\s]*", "").trim();
    }

    public static String normalizeChristumNotation(String value) {
        return value.replaceAll("(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))", CHRISTUM_BC_PLACEHOLDER).replaceAll("(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))", CHRISTUM_AD_PLACEHOLDER);
    }

    public static String intToRoman(int num) {
        StringBuilder roman = new StringBuilder("");
        for (Integer i : arabicMap.keySet()) {
            for (int j = 1; j <= num / i; ++j) {
                roman.append(arabicMap.get(i));
            }
            num %= i.intValue();
        }
        return roman.toString();
    }

    public static Integer romanToInt(String string) {
        if (string == null || string.trim().isEmpty()) {
            return null;
        }
        String romanChar = string.toLowerCase();
        int length = romanChar.length() - 1;
        int sum = 0;
        Pattern pattern = Pattern.compile("^m{0,4}(cm|cd|d?c{0,3})(xc|xl|l?x{0,3})(ix|iv|v?i{0,3})$");
        Matcher matcher = pattern.matcher(romanChar);
        boolean isValid = matcher.find();
        if (!isValid) {
            return null;
        }
        for (int i = 0; i < length; ++i) {
            int nextValue;
            int crrValue = romanMap.get(Character.valueOf(romanChar.charAt(i)));
            if (crrValue < (nextValue = romanMap.get(Character.valueOf(romanChar.charAt(i + 1))).intValue())) {
                sum -= crrValue;
                continue;
            }
            sum += crrValue;
        }
        return sum += romanMap.get(Character.valueOf(romanChar.charAt(length))).intValue();
    }

    public static String getOrdinal(int value) {
        String[] suffixes = new String[]{"th", "st", "nd", "rd", "th", "th", "th", "th", "th", "th"};
        switch (value % 100) {
            case 11: 
            case 12: 
            case 13: {
                return value + "th";
            }
        }
        return value + suffixes[value % 10];
    }

    public static int centuryToMillennium(int century) {
        float division = (float)century / 10.0f;
        return (int)Math.ceil(division);
    }

    public static int yearToMillennium(int century) {
        float division = (float)century / 1000.0f;
        return (int)Math.ceil(division);
    }

    static {
        arabicMap.put(1000, "m");
        arabicMap.put(900, "cm");
        arabicMap.put(500, "d");
        arabicMap.put(400, "cd");
        arabicMap.put(100, "c");
        arabicMap.put(90, "xc");
        arabicMap.put(50, "l");
        arabicMap.put(40, "xl");
        arabicMap.put(10, "x");
        arabicMap.put(9, "ix");
        arabicMap.put(5, "v");
        arabicMap.put(4, "iv");
        arabicMap.put(1, "i");
        romanMap.put(Character.valueOf('i'), 1);
        romanMap.put(Character.valueOf('v'), 5);
        romanMap.put(Character.valueOf('x'), 10);
        romanMap.put(Character.valueOf('l'), 50);
        romanMap.put(Character.valueOf('c'), 100);
        romanMap.put(Character.valueOf('d'), 500);
        romanMap.put(Character.valueOf('m'), 1000);
    }
}

