/*
 * Decompiled with CFR 0.152.
 */
package ro.webdata.normalization.timespan.ro;

public class TimeSanitizeUtils {
    private TimeSanitizeUtils() {
    }

    public static String sanitizeValue(String value) {
        String sanitized = TimeSanitizeUtils.sanitizeDateTime(value);
        sanitized = TimeSanitizeUtils.sanitizeAges(sanitized);
        sanitized = TimeSanitizeUtils.sanitizeTimePeriods(sanitized);
        return sanitized;
    }

    public static String clearJunks(String value, String regex) {
        if (regex != null && regex.equals("(?iu)(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(\\d{3,4}(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?(\\s*(/|sau)\\s*)\\d{3,4}(\\s*((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)((e[\\.]?n[\\.]?)|([dp][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))|(?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(?iu)(([i\u00ee][\\.]?e[\\.]?n[\\.]?)|([abi\u00ee][\\. ]*(ch[r]?|hr|c)[\\. ]*))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))))?)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+))")) {
            return value.replaceAll("(anul\\s*\\d{1,2}=)", "");
        }
        return value;
    }

    private static String sanitizeDateTime(String value) {
        switch (value) {
            case "17 nov. 375-9 aug. 378 a.chr.": {
                return "17 nov. 375 - 9 aug. 378 a.chr.";
            }
            case "[11-13 martie] 1528": {
                return "11 martie 1528 - 13 martie 1528";
            }
            case "6 octombrie1904": {
                return "6 octombrie 1904";
            }
            case "30 mai \u0219i 5 august 1796": {
                return "30 mai 1796; 5 august 1796";
            }
            case "1861septembrie 25": {
                return "25 septembrie 1861";
            }
            case "1908 martie 27-28": {
                return "27 martie 1908 - 28 martie 1908";
            }
            case "1834, 1 - 10 aprilie": {
                return "1 aprilie 1834 - 10 aprilie 1834";
            }
        }
        return value;
    }

    private static String sanitizeAges(String value) {
        if (value.equals("1880 (proprietarul avea 90 de ani \u00een 1970)")) {
            return "1880";
        }
        return value;
    }

    private static String sanitizeTimePeriods(String value) {
        switch (value) {
            case "15(6)3": {
                return "1563";
            }
            case "1884 martie 28/aprilie 09": {
                return "1884";
            }
            case "octombrie 23, 1777": {
                return "23 octombrie 1777";
            }
            case "a doua jumatate a sec. i a.chr. (-43 - -29); a doua jum. a sec.xix (montur\u0103 inel)": {
                return "a doua jumatate a sec. i a.chr. (43 - 29 a.chr.); a doua jum. a sec.xix (montur\u0103 inel)";
            }
            case "instituit \u00een decembrie 1915 - desfiin\u021bat \u00een 1973": {
                return "1915 - 1973";
            }
            case "prima jum\u0103tate a secolului xviii (rest de datare 174...)": {
                return "prima jum\u0103tate a secolului xviii";
            }
            case "sec. xviii - xix 18(40)": {
                return "sec. xviii - xix";
            }
            case "281-222 (232?) p. chr.": {
                return "281-222 p. chr.";
            }
            case "0803": {
                return "unknown";
            }
            case "13 (1805)": {
                return "1805";
            }
            case "1/4 mil. 5 - sec. i al mil. 4 a.chr.": {
                return "1/4 mil. 5 - mil. 4 a.chr.";
            }
            case "2/2 mil. 5 - sec. i al mil. 4 a.chr.": {
                return "2/2 mil. 5 - mil. 4 a.chr.";
            }
            case "1/2 mil. 5 - sec. i al mil. 4 a.chr.": {
                return "1/2 mil. 5 - mil. 4 a.chr";
            }
            case "34 sec. xx": {
                return "sec. xx";
            }
            case "i p. chr.": {
                return "sec. i p.ch.";
            }
            case "i a. chr.-i p. chr.": {
                return "sec. i a.ch. - sec. i p.ch.";
            }
            case "ii-i a.chr.": {
                return "sec. ii - sec. i a.ch.";
            }
            case "iii i. hr.": {
                return "sec. iii a.ch.";
            }
            case "iv - ii i. hr.": {
                return "sec. iv - sec. ii a.ch.";
            }
            case "xiii i.e.n": {
                return "sec. xiii i.e.n";
            }
            case "xvii": 
            case "s: xvii": {
                return "sec. xvii";
            }
            case "prima jum. se. xix": {
                return "prima jum. sec. xix";
            }
            case "s:20; 1/4": 
            case "s: xx; a: 1/4": 
            case "s: xx; 1/4": {
                return "1/4 sec. xx";
            }
            case "s: xviii; 1/4": {
                return "1/4 sec. xviii";
            }
            case "se. iv-vp.ch.": {
                return "sec. iv - sec. v p.ch.";
            }
            case "sec. va. chr.": {
                return "sec. v a.chr.";
            }
            case "sec.vp.ch.": {
                return "sec. v p.ch.";
            }
            case "secolele xix/xx": {
                return "sec. xix - sec. xx";
            }
            case "secolul iv/v": {
                return "sec. iv - sec. v";
            }
            case "sex. xvii - a ii jumatate": {
                return "a doua jumatate a sec. xvii";
            }
            case "xix": 
            case "sec: xix": 
            case "sex. xix": 
            case "secolul al-xix -lea": {
                return "sec. xix";
            }
            case "sex. xvii - a ii jum\u0103tate": {
                return "a doua jum\u0103tate a sec. xvii";
            }
            case "sec. xix/2/2": {
                return "2/2 sec. xix";
            }
            case "xi - ix a.hr.": {
                return "sec. xi - sec. ix a.hr.";
            }
            case "sec. -4 - -2": {
                return "sec. 4 - 2 a.ch.";
            }
            case "sec. -7 - -5": {
                return "sec. 7 - 5 a.ch.";
            }
            case "inc. sex. xx": {
                return "inceputul sec. xx";
            }
            case "3/4 ec. xix": {
                return "3/4 sec. xix";
            }
            case "s:19; 4/4": 
            case "4/4ec. xix": 
            case "4/4 secolul al xix/lea": {
                return "4/4 sec. xix";
            }
            case "sf\u00e2r\u0219itul sexc. xix": {
                return "sf\u00e2r\u0219itul sec. xix";
            }
            case "xx": 
            case "anii 30-40 secolul xx": 
            case "anii 30 ai secolului xx": 
            case "prima jum\u0103tate a anului '30": 
            case "mijlocul anilor '20": 
            case "a doua jum\u0103tate a anilor '20": 
            case "a doua jum\u0103tate a anilor '30": {
                return "sec. xx";
            }
            case "mijlocul secolului al doilea a.chr.": {
                return "mijlocul sec. ii a.ch.";
            }
            case "mileniile v-iva. chr.": {
                return "mileniile v-iv a. chr.";
            }
            case "decembrie 01 fara an": 
            case "mesia\u021ba dec., dni 10, leat 7156": 
            case "mesia\u021ba ghen., dni 18, leat 7158": 
            case "mesia\u021ba iolie, 20 dni, leat 7156": 
            case "mesia\u021ba iunie, dni 12, v leat 7105 (1597)": 
            case "mesia\u021ba mr., dni 22, leat 7189": 
            case "mesia\u021ba oct., dni 28, vleat 7152": {
                return "";
            }
        }
        return value;
    }
}

