/*
 * Decompiled with CFR 0.152.
 */
package ro.webdata.normalization.timespan.ro;

import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import ro.webdata.normalization.timespan.ro.TimeUtils;

public class TimePeriodUtils {
    private static final String SPECIAL_CHARS_REGEX = "[\\.,;\\?!]*\\s*";
    private static final String[] REGEX_LIST = new String[]{"(?iu)((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?", "(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/2)|(\u00bd)|((prim[a]*[\\. ]+(jum([a\u0103]tate(a)?)?|part))([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))", "(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/2)|((a\\s+(doua|(ii[-a]*))[\\. ]+(jum([a\u0103]tate(a)?)?|part)[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)([\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\.]*([\\. ]+(a|al))*)))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))", "(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))(jum([a\u0103]tate(a)?)?|(mij[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*)|mj\\.)(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))", "(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((1/4)|(\u00bc)|(([i\u00ee]nc[\\w\u0103\u00e2\u00ee\u015f\u0219\u0163\u021b\u0102\u00c2\u00ce\u015e\u0218\u0162\u021a]*[\\. ]*)(de)?)|(primul\\s+sfert(\\s+a[l]?)?)|(prima treime a))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))", "(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((2/4)|(al doile[a]? sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))", "(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((3/4)|(\u00be)|(al treilea sfert al))(?=($|\\z|[\\.,;\\?!\\-)\\] ]+)))", "(?iu)((?<=(^|\\A|[\\.,;\\?!\\-(\\[= ]+))((4/4)|((ultimul\\s+sfert)(\\s+(a[l]?|de)*)?)))", "(?iu)(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:(secol|secoi)(?:ele|ului|ul)?|sec)[\\.\\s]*(?:al[\\.\\s]*)?)", "(?iu)(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:mileni(?:ile|ului|ul)?|mil)[\\.\\s]*(?:al[\\.\\s]*)?)", "(?iu)(((?:sf[a\u00e2]r[s\u0219\u015f]it(?:u(?:l)?)?|sf[\\.\\s]{0,6})(?:\\s+de)?)?((?:[i\u00ee]nceput(?:u(?:l)?|ului)?|[i\u00ee]nc\\.?)(?:\\s+de)?)?\\s*(?:ani+(?:lor)?|an(?:ului|ulu|ul|u)?)\\s*(?:al[\\.\\s]*)?)", "(?iu)([- ]*lea)?", "(?iu)(?:al[\\.\\s]*)?", "[\\.,;\\?!]*\\s*"};

    public static String sanitizeTimePeriod(String value) {
        String preparedValue = value;
        List<String> groups = TimePeriodUtils.getGroupList(preparedValue);
        for (int i = groups.size() - 1; i >= 0; --i) {
            String group = groups.get(i);
            if (group.isEmpty()) continue;
            if (TimePeriodUtils.specialCharsOnly(group) && group.contains(".")) {
                group = group.replaceAll("\\.", "");
                preparedValue = preparedValue.replaceAll("\\.", "");
            }
            preparedValue = preparedValue.replaceAll(group, "");
        }
        preparedValue = preparedValue.replaceAll("\\s*", "");
        return preparedValue;
    }

    private static List<String> getGroupList(String value) {
        HashSet<String> set = new HashSet<String>();
        for (String regex : REGEX_LIST) {
            Pattern suffixPattern = Pattern.compile(regex);
            Matcher suffixMatcher = suffixPattern.matcher(value);
            while (suffixMatcher.find()) {
                String group = suffixMatcher.group();
                if (group.isEmpty() || TimePeriodUtils.isSpace(group)) continue;
                set.add(group.trim());
            }
        }
        return set.stream().sorted(Comparator.comparingInt(String::length)).collect(Collectors.toList());
    }

    private static boolean isSpace(String regex) {
        return regex.matches("\\s\\s*");
    }

    private static boolean specialCharsOnly(String regex) {
        for (int i = 0; i < regex.length(); ++i) {
            char item = regex.charAt(i);
            if (SPECIAL_CHARS_REGEX.contains(String.valueOf(item))) continue;
            return false;
        }
        return true;
    }

    public static Integer timePeriodToNumber(String timePeriod, boolean isDate) {
        if (timePeriod == null || timePeriod.trim().isEmpty()) {
            return null;
        }
        String clearedTimePeriod = isDate ? TimeUtils.clearDate(timePeriod) : timePeriod;
        clearedTimePeriod = TimeUtils.clearChristumNotation(clearedTimePeriod);
        try {
            return Integer.parseInt(clearedTimePeriod);
        }
        catch (Exception e2) {
            try {
                return TimeUtils.romanToInt(clearedTimePeriod);
            }
            catch (Exception e22) {
                e22.printStackTrace();
                return null;
            }
        }
    }

    public static Integer getStartTime(String[] intervalValues, String eraStart, boolean isDate) {
        boolean isAD;
        Integer first = TimePeriodUtils.timePeriodToNumber(intervalValues[0], isDate);
        Integer second = TimePeriodUtils.timePeriodToNumber(intervalValues[1], isDate);
        if (first == null || second == null) {
            return null;
        }
        boolean bl = isAD = eraStart != null && eraStart.equals("__AD__");
        if (isAD && first > second) {
            return second;
        }
        return first;
    }

    public static Integer getEndTime(String[] intervalValues, String eraStart, boolean isDate) {
        boolean isAD;
        Integer first = TimePeriodUtils.timePeriodToNumber(intervalValues[0], isDate);
        Integer second = TimePeriodUtils.timePeriodToNumber(intervalValues[1], isDate);
        if (first == null || second == null) {
            return null;
        }
        boolean bl = isAD = eraStart != null && eraStart.equals("__AD__");
        if (isAD && first > second) {
            return first;
        }
        return second;
    }
}

