/*
 * Decompiled with CFR 0.152.
 */
package ro.webdata.normalization.timespan.ro;

import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.webdata.normalization.timespan.ro.TimeSanitizeUtils;
import ro.webdata.normalization.timespan.ro.TimeUtils;
import ro.webdata.normalization.timespan.ro.TimespanUtils;
import ro.webdata.normalization.timespan.ro.model.DBpediaModel;
import ro.webdata.normalization.timespan.ro.model.TimespanModel;

public class TimeExpression {
    private static final Gson GSON = new Gson();
    private static final String SEPARATOR = "|";
    private transient String preparedValue;
    @SerializedName(value="inputValue")
    private String inputValue;
    @SerializedName(value="timeSeries")
    private List<TimespanModel> timespanModels;

    public static String getHeaders() {
        ArrayList<String> headers = new ArrayList<String>(){
            {
                this.add("input value");
                this.add("prepared value");
                this.add("normalized edge values");
                this.add("normalized values");
            }
        };
        return String.join((CharSequence)SEPARATOR, (Iterable<? extends CharSequence>)headers);
    }

    public TimeExpression(String inputValue) {
        this(inputValue, false, false);
    }

    public TimeExpression(String inputValue, boolean historicalOnly, boolean sanitize) {
        try {
            String sanitizedValue = sanitize ? TimeSanitizeUtils.sanitizeValue(inputValue) : inputValue;
            this.inputValue = inputValue;
            this.preparedValue = TimeUtils.normalizeChristumNotation(sanitizedValue);
            this.timespanModels = TimespanUtils.prepareTimespanModels(inputValue, historicalOnly, sanitize);
        }
        catch (Exception e2) {
            System.err.println("Something went wrong while creating the \"TimeExpression\" object with the following parameters:\n\tinputValue = " + inputValue + "\n\t historicalOnly = " + historicalOnly + "\n\t sanitize = " + sanitize);
            e2.printStackTrace();
            this.timespanModels = new ArrayList<TimespanModel>();
        }
    }

    public String toString() {
        return this.inputValue + SEPARATOR + this.preparedValue + SEPARATOR + this.getDBpediaEdges() + SEPARATOR + this.getDBpediaItems();
    }

    public String serialize() {
        return GSON.toJson(this);
    }

    private List<Map<String, DBpediaModel>> getDBpediaEdges() {
        ArrayList<Map<String, DBpediaModel>> edges = new ArrayList<Map<String, DBpediaModel>>();
        for (TimespanModel timespanModel : this.timespanModels) {
            edges.add(timespanModel.getDBpediaEdges());
        }
        return edges;
    }

    private Set<DBpediaModel> getDBpediaItems() {
        LinkedHashSet<DBpediaModel> items = new LinkedHashSet<DBpediaModel>();
        for (TimespanModel timespanModel : this.timespanModels) {
            items.addAll(timespanModel.getDBpediaItems());
        }
        return items;
    }
}

