/*
 * Decompiled with CFR 0.152.
 */
package ro.webdata.normalization.timespan;

import java.util.Arrays;
import java.util.List;
import py4j.GatewayServer;
import ro.webdata.echo.commons.File;
import ro.webdata.normalization.timespan.Demo;
import ro.webdata.normalization.timespan.commons.ParamsUtils;
import ro.webdata.normalization.timespan.ro.analysis.TimespanAnalysis;

public class Main {
    private static final String LIDO_DATASET_PATH = File.PATH_DATASET_DIR + File.FILE_SEPARATOR + "lido/";
    private static final String PATH_OUTPUT_ADDITIONAL_TIMESPAN_FILE = File.PATH_OUTPUT_DIR + File.FILE_SEPARATOR + "timespan_additional.txt";
    private static final String PATH_OUTPUT_ALL_TIMESPAN_FILE = File.PATH_OUTPUT_DIR + File.FILE_SEPARATOR + "timespan_all.txt";
    private static final String PATH_OUTPUT_UNIQUE_TIMESPAN_FILE = File.PATH_OUTPUT_DIR + File.FILE_SEPARATOR + "timespan_unique.txt";
    private final GatewayServer server = new GatewayServer(this);

    public void startServer() {
        this.server.start();
        System.out.println("Gateway Server Started...");
    }

    public void stopServer(int ms) {
        new Thread(() -> {
            try {
                Thread.sleep(ms);
            }
            catch (InterruptedException e2) {
                e2.printStackTrace();
            }
            System.out.println("Shutting down Gateway Server...");
            this.server.shutdown();
        }).start();
    }

    public static void main(String[] args) {
        List<String> list = Arrays.asList(args);
        boolean python = ParamsUtils.python(list);
        if (python) {
            Main app = new Main();
            app.startServer();
        }
        if (ParamsUtils.contains(list, "--expression")) {
            Demo.main(args);
        } else if (ParamsUtils.contains(list, "--analysis")) {
            boolean historicalOnly = ParamsUtils.historicalOnly(list);
            boolean sanitize = ParamsUtils.sanitize(list);
            TimespanAnalysis.write(LIDO_DATASET_PATH, PATH_OUTPUT_ALL_TIMESPAN_FILE, true, false, historicalOnly, sanitize);
            TimespanAnalysis.write(LIDO_DATASET_PATH, PATH_OUTPUT_UNIQUE_TIMESPAN_FILE, true, true, historicalOnly, sanitize);
            TimespanAnalysis.writeAdditionalData(PATH_OUTPUT_ADDITIONAL_TIMESPAN_FILE, historicalOnly, sanitize);
        }
    }
}

