/*
 * Decompiled with CFR 0.152.
 */
package ro.webdata.normalization.timespan;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import ro.webdata.echo.commons.File;
import ro.webdata.normalization.timespan.commons.ParamsUtils;
import ro.webdata.normalization.timespan.ro.TimeExpression;
import ro.webdata.normalization.timespan.ro.analysis.LidoXmlAnalysis;

public class Demo {
    private static final String PATH_OUTPUT_ALL_TIMESPAN_FILE = File.PATH_OUTPUT_DIR + File.FILE_SEPARATOR + "timespan_all.txt";

    public static void main(String[] args) {
        List<String> list = Arrays.asList(args);
        String value = ParamsUtils.getValue(list, "--expression");
        boolean historicalOnly = ParamsUtils.historicalOnly(list);
        boolean sanitize = ParamsUtils.sanitize(list);
        TimeExpression timeExpression = new TimeExpression(value, historicalOnly, sanitize);
        System.out.println(timeExpression.serialize());
    }

    public static void printUnknownTimeExpressions(String inputFullPath) {
        LidoXmlAnalysis.printUnknownTimeExpressions(inputFullPath);
    }

    public static void printFullTimespan(String inputFullPath, boolean historicalOnly, boolean sanitize) {
        try {
            String readLine;
            BufferedReader br = new BufferedReader(new FileReader(inputFullPath));
            while ((readLine = br.readLine()) != null) {
                if (readLine.isEmpty()) continue;
                System.out.println(new TimeExpression(readLine, historicalOnly, sanitize));
            }
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }
}

