/*
 * Decompiled with CFR 0.152.
 */
package ro.webdata.echo.commons.http;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;

final class HttpConnection {
    private static final String HTTP_GET = "GET";
    private static final int TIMEOUT = 5000;

    private HttpConnection() {
    }

    static HttpURLConnection sendGetRequest(String address) {
        HttpURLConnection connection = null;
        try {
            connection = HttpConnection.initializeConnection(address);
            connection.setRequestMethod(HTTP_GET);
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(5000);
        }
        catch (ProtocolException e2) {
            e2.printStackTrace();
        }
        return connection;
    }

    static int getResponseCode(HttpURLConnection connection, String address) {
        int code = 408;
        try {
            code = connection.getResponseCode();
        }
        catch (IOException e2) {
            System.err.println("Read timed out: " + address);
        }
        return code;
    }

    static StringBuilder getResponseContent(HttpURLConnection connection) {
        InputStreamReader is = null;
        BufferedReader br = null;
        StringBuilder response = null;
        try {
            String inputLine;
            is = new InputStreamReader(connection.getInputStream());
            br = new BufferedReader(is);
            response = new StringBuilder();
            while ((inputLine = br.readLine()) != null) {
                response.append(inputLine);
                response.append("\n");
            }
            br.close();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        return response;
    }

    private static HttpURLConnection initializeConnection(String address) {
        URL url = null;
        HttpURLConnection connection = null;
        try {
            url = new URL(address);
            connection = (HttpURLConnection)url.openConnection();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        return connection;
    }
}

