/*
 * Decompiled with CFR 0.152.
 */
package ro.webdata.echo.commons;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.CaseUtils;
import ro.webdata.echo.commons.Const;

public final class Text {
    public static final String REGEX_TEXT_SEPARATORS = "[;,]";
    private static final boolean CAPITALIZE_FIRST_LETTER = false;

    private Text() {
    }

    public static String attachesSchemaToValue(String schema, String value) {
        return "##" + schema + "## " + value;
    }

    public static String prepareCamelCaseText(String input) {
        String langSeparator = input.substring(input.length() - 3, input.length() - 2);
        if (langSeparator.equals("@")) {
            String text = input.substring(0, input.length() - 3);
            return CaseUtils.toCamelCase(text, false, Const.CHAR_DELIMITER);
        }
        return CaseUtils.toCamelCase(input, false, Const.CHAR_DELIMITER);
    }

    public static String toCamelCase(String value) {
        return CaseUtils.toCamelCase(value, false, Const.CHAR_DELIMITER);
    }

    public static String toCamelCase(String value, boolean capitalizeFirstLetter, char[] delimiters) {
        return CaseUtils.toCamelCase(value, capitalizeFirstLetter, delimiters);
    }

    public static List<String> toList(String text, String regexSeparator) {
        String separator = regexSeparator != null ? regexSeparator : REGEX_TEXT_SEPARATORS;
        return Arrays.stream(text.split(separator)).map(String::trim).collect(Collectors.toList());
    }

    public static String sanitizeString(String value, boolean stripAccents) {
        if (value == null) {
            return null;
        }
        String regex = "(?U)[^\\p{Alnum}]+";
        String replacement = "_";
        String preparedValue = value.replaceAll(regex, replacement);
        if (stripAccents) {
            return StringUtils.stripAccents(preparedValue);
        }
        return preparedValue;
    }

    public static String encodeURI(String uri) {
        try {
            String encodingName = StandardCharsets.UTF_8.displayName();
            return URLEncoder.encode(uri, encodingName);
        }
        catch (UnsupportedEncodingException e2) {
            e2.printStackTrace();
            return uri;
        }
    }

    public static String encodeSpace(String uri) {
        if (uri == null) {
            return null;
        }
        return uri.replaceAll(" ", "%20");
    }
}

