/*
 * Decompiled with CFR 0.152.
 */
package ro.webdata.echo.commons;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import ro.webdata.echo.commons.File;
import ro.webdata.echo.commons.accessor.MuseumAccessors;

public class Json {
    private static final Gson gson = new Gson();
    private static final JsonParser parser = new JsonParser();

    public static JsonArray getJsonArray(String path) {
        StringBuilder sb = File.read(path);
        JsonElement json = parser.parse(sb.toString());
        return json.getAsJsonArray();
    }

    public static JsonElement getJsonElement(Object value) {
        String jsonStr = gson.toJson(value);
        JsonElement json = parser.parse(jsonStr);
        return json;
    }

    public static JsonElement getJsonElement(String value) {
        String jsonStr = gson.toJson(value);
        JsonElement json = parser.parse(jsonStr);
        return json;
    }

    public static JsonObject getJsonObject(JsonElement element) {
        String jsonStr = gson.toJson(element);
        JsonElement json = parser.parse(jsonStr);
        return json.getAsJsonObject();
    }

    public static JsonObject getJsonObject(Object objectMap) {
        String jsonStr = gson.toJson(objectMap);
        JsonElement json = parser.parse(jsonStr);
        return json.getAsJsonObject();
    }

    public static Object getAccessorValue(JsonObject jsonObject, String accessor) {
        String[] keys = accessor.split("\\.");
        JsonObject crrObject = jsonObject;
        for (int i = 0; i < keys.length; ++i) {
            if (crrObject == null) continue;
            String key = keys[i];
            JsonElement crrElement = crrObject.get(key);
            if (crrElement == null) {
                return null;
            }
            if (i < keys.length - 1) {
                crrObject = Json.getJsonObject(crrElement);
                continue;
            }
            return MuseumAccessors.DOUBLE_VALUE_ACCESSORS.contains(key) ? Double.valueOf(crrElement.getAsDouble()) : crrElement.getAsString();
        }
        return null;
    }
}

