/*
 * Decompiled with CFR 0.152.
 */
package ro.webdata.echo.commons;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class File {
    public static final String EXTENSION_ASP = "asp";
    public static final String EXTENSION_CSV = "csv";
    public static final String EXTENSION_JSON = "json";
    public static final String EXTENSION_RDF = "rdf";
    public static final String EXTENSION_TXT = "txt";
    public static final String EXTENSION_XML = "xml";
    public static final String EXTENSION_SEPARATOR = ".";
    public static final String FILE_SEPARATOR = System.getProperty("file.separator");
    public static final String USER_HOME = System.getProperty("user.home");
    public static final String WORKSPACE_DIR = System.getProperty("user.dir");
    public static final String PATH_FILES_DIR = WORKSPACE_DIR + FILE_SEPARATOR + "files";
    public static final String PATH_DATASET_DIR = PATH_FILES_DIR + FILE_SEPARATOR + "dataset";
    public static final String PATH_INPUT_DIR = PATH_FILES_DIR + FILE_SEPARATOR + "input";
    public static final String PATH_OUTPUT_DIR = PATH_FILES_DIR + FILE_SEPARATOR + "output";

    private File() {
    }

    public static void createDirectory(String filePath) {
        String directoryName;
        java.io.File directory;
        if (filePath != null && !(directory = new java.io.File(directoryName = filePath.substring(0, filePath.lastIndexOf(FILE_SEPARATOR)))).exists()) {
            directory.mkdir();
        }
    }

    public static List<String> getSubDirectoryNames(String directoryPath) {
        ArrayList<String> directoryNames = new ArrayList<String>();
        java.io.File directory = new java.io.File(directoryPath);
        java.io.File[] subDirectories = directory.listFiles();
        if (subDirectories != null) {
            for (java.io.File file : subDirectories) {
                if (!file.isDirectory()) continue;
                String fileName = file.getName();
                directoryNames.add(fileName);
            }
        } else {
            System.err.println(directoryPath + " does not contain any directories!");
        }
        Collections.sort(directoryNames);
        return directoryNames;
    }

    public static boolean exists(String filePath) {
        if (filePath == null) {
            return false;
        }
        java.io.File file = new java.io.File(filePath);
        return file.exists() && !file.isDirectory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(StringWriter sw, String filePath, boolean append) {
        File.createDirectory(filePath);
        FileWriter fw = null;
        try {
            fw = new FileWriter(filePath, append);
            fw.write(sw.toString());
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        finally {
            try {
                if (fw != null) {
                    fw.close();
                }
            }
            catch (IOException e3) {
                System.err.println("The 'FileWriter' could not be closed.\nError: " + e3.getMessage());
            }
        }
    }

    public static void write(String str2, String filePath, boolean append) {
        StringWriter sw = new StringWriter();
        sw.write(str2);
        File.write(sw, filePath, append);
    }

    public static void write(List<String> list, String filePath, boolean append) {
        StringWriter writer = new StringWriter();
        for (String string : list) {
            writer.append(string).append("\n");
        }
        File.write(writer, filePath, append);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StringBuilder read(String fileName) {
        BufferedReader br = null;
        StringBuilder sb = null;
        try {
            String readLine;
            br = new BufferedReader(new FileReader(fileName));
            sb = new StringBuilder();
            while ((readLine = br.readLine()) != null) {
                if (readLine.length() <= 0) continue;
                sb.append(readLine).append("\n");
            }
            sb.delete(sb.lastIndexOf("\n"), sb.length());
        }
        catch (FileNotFoundException e2) {
            System.err.println("The file " + fileName + " have not been found.\nError: " + e2.getMessage());
        }
        catch (IOException e3) {
            e3.printStackTrace();
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException e4) {
                System.err.println("The file 'BufferedReader' could not be closed.\nError: " + e4.getMessage());
            }
        }
        return sb;
    }

    public static List<String> getFileNames(String directoryPath, String extension, boolean excludeDemo) {
        ArrayList<String> fileNames = new ArrayList<String>();
        List<String> allFileNames = File.getFileNames(directoryPath, extension);
        for (String fullName : allFileNames) {
            int dotIndex = fullName.lastIndexOf(EXTENSION_SEPARATOR);
            String fileName = fullName.substring(0, dotIndex);
            boolean isDemoFile = fileName.startsWith("demo");
            if ((!excludeDemo || isDemoFile) && (excludeDemo || !isDemoFile)) continue;
            fileNames.add(fileName + EXTENSION_SEPARATOR + extension);
        }
        return fileNames;
    }

    public static List<String> getFileNames(String directoryPath, String extension) {
        ArrayList<String> fileNames = new ArrayList<String>();
        java.io.File directory = new java.io.File(directoryPath);
        java.io.File[] subDirectories = directory.listFiles();
        if (subDirectories != null) {
            for (java.io.File file : subDirectories) {
                String fileName = file.getName();
                String fileExtension = File.getFileExtension(fileName);
                if (extension != null && !extension.equals(fileExtension)) continue;
                fileNames.add(fileName);
            }
        } else {
            System.err.println(directoryPath + " does not contain any directories!");
        }
        Collections.sort(fileNames);
        return fileNames;
    }

    public static String getFileExtension(String fileName) {
        return fileName.substring(fileName.lastIndexOf(EXTENSION_SEPARATOR) + 1).toLowerCase();
    }
}

