/*
 * Decompiled with CFR 0.152.
 */
package ro.webdata.echo.commons;

import java.text.DateFormatSymbols;
import java.util.Locale;
import ro.webdata.echo.commons.error.UnknownMonthException;

public final class Date {
    public static final int LAST_UPDATE_CENTURY = 21;
    public static final int LAST_UPDATE_MILLENNIUM = 3;
    public static final int LAST_UPDATE_YEAR = 2014;
    private static final String UNKNOWN_MONTH = "Unknown";

    private Date() {
    }

    public static String prepareDate(String value) {
        return value.replaceAll(",", "").trim();
    }

    public static String getMonthName(String month) {
        int monthNumber = -1;
        try {
            monthNumber = Integer.parseInt(month);
        }
        catch (NumberFormatException ignored) {
            monthNumber = Date.mapMonthToNumber(month);
        }
        return Date.mapNumberToMonth(monthNumber, month);
    }

    private static String mapNumberToMonth(int monthNumber, String monthName) {
        DateFormatSymbols dateFormatSymbols = new DateFormatSymbols(Locale.ENGLISH);
        String month = UNKNOWN_MONTH;
        try {
            month = dateFormatSymbols.getMonths()[monthNumber - 1];
        }
        catch (Exception ignored) {
            UnknownMonthException.printMessage(monthNumber, monthName);
        }
        return month;
    }

    private static int mapMonthToNumber(String month) {
        String value;
        switch (value = month.replaceAll("\\.", "").toLowerCase().trim()) {
            case "ianuarie": 
            case "ian": {
                return 1;
            }
            case "februarie": 
            case "fevruarie": 
            case "feb": {
                return 2;
            }
            case "martie": 
            case "mart": {
                return 3;
            }
            case "aprilie": 
            case "apr": {
                return 4;
            }
            case "mai": {
                return 5;
            }
            case "iunie": 
            case "iumie": 
            case "iun": {
                return 6;
            }
            case "iulie": 
            case "iul": {
                return 7;
            }
            case "august": 
            case "aug": {
                return 8;
            }
            case "septembrie": 
            case "sept": {
                return 9;
            }
            case "octombrie": 
            case "0ctombrie": 
            case "oct": {
                return 10;
            }
            case "noiembrie": 
            case "noimbrie": 
            case "nov": {
                return 11;
            }
            case "decembrie": 
            case "decembre": 
            case "dec": {
                return 12;
            }
        }
        return -1;
    }
}

