/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.algebra;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.apache.jena.atlas.lib.NotImplemented;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.SortCondition;
import org.apache.jena.query.Syntax;
import org.apache.jena.sparql.ARQInternalErrorException;
import org.apache.jena.sparql.ARQNotImplemented;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.OpVisitor;
import org.apache.jena.sparql.algebra.op.OpAssign;
import org.apache.jena.sparql.algebra.op.OpBGP;
import org.apache.jena.sparql.algebra.op.OpConditional;
import org.apache.jena.sparql.algebra.op.OpDatasetNames;
import org.apache.jena.sparql.algebra.op.OpDiff;
import org.apache.jena.sparql.algebra.op.OpDisjunction;
import org.apache.jena.sparql.algebra.op.OpDistinct;
import org.apache.jena.sparql.algebra.op.OpExt;
import org.apache.jena.sparql.algebra.op.OpExtend;
import org.apache.jena.sparql.algebra.op.OpFilter;
import org.apache.jena.sparql.algebra.op.OpGraph;
import org.apache.jena.sparql.algebra.op.OpGroup;
import org.apache.jena.sparql.algebra.op.OpJoin;
import org.apache.jena.sparql.algebra.op.OpLabel;
import org.apache.jena.sparql.algebra.op.OpLeftJoin;
import org.apache.jena.sparql.algebra.op.OpList;
import org.apache.jena.sparql.algebra.op.OpMinus;
import org.apache.jena.sparql.algebra.op.OpNull;
import org.apache.jena.sparql.algebra.op.OpOrder;
import org.apache.jena.sparql.algebra.op.OpPath;
import org.apache.jena.sparql.algebra.op.OpProcedure;
import org.apache.jena.sparql.algebra.op.OpProject;
import org.apache.jena.sparql.algebra.op.OpPropFunc;
import org.apache.jena.sparql.algebra.op.OpQuad;
import org.apache.jena.sparql.algebra.op.OpQuadBlock;
import org.apache.jena.sparql.algebra.op.OpQuadPattern;
import org.apache.jena.sparql.algebra.op.OpReduced;
import org.apache.jena.sparql.algebra.op.OpSequence;
import org.apache.jena.sparql.algebra.op.OpService;
import org.apache.jena.sparql.algebra.op.OpSlice;
import org.apache.jena.sparql.algebra.op.OpTable;
import org.apache.jena.sparql.algebra.op.OpTopN;
import org.apache.jena.sparql.algebra.op.OpTriple;
import org.apache.jena.sparql.algebra.op.OpUnion;
import org.apache.jena.sparql.core.BasicPattern;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprAggregator;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.ExprTransform;
import org.apache.jena.sparql.expr.ExprTransformCopy;
import org.apache.jena.sparql.expr.ExprTransformer;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.expr.aggregate.Aggregator;
import org.apache.jena.sparql.pfunction.PropFuncArg;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementAssign;
import org.apache.jena.sparql.syntax.ElementBind;
import org.apache.jena.sparql.syntax.ElementData;
import org.apache.jena.sparql.syntax.ElementFilter;
import org.apache.jena.sparql.syntax.ElementGroup;
import org.apache.jena.sparql.syntax.ElementMinus;
import org.apache.jena.sparql.syntax.ElementNamedGraph;
import org.apache.jena.sparql.syntax.ElementOptional;
import org.apache.jena.sparql.syntax.ElementPathBlock;
import org.apache.jena.sparql.syntax.ElementService;
import org.apache.jena.sparql.syntax.ElementSubQuery;
import org.apache.jena.sparql.syntax.ElementTriplesBlock;
import org.apache.jena.sparql.syntax.ElementUnion;
import org.apache.jena.sparql.syntax.syntaxtransform.ElementTransformCleanGroupsOfOne;
import org.apache.jena.sparql.syntax.syntaxtransform.ElementTransformer;
import org.apache.jena.sparql.syntax.syntaxtransform.ExprTransformApplyElementTransform;
import org.apache.jena.sparql.util.graph.GraphList;
import org.apache.jena.vocabulary.RDF;

public class OpAsQuery {
    public static Op processExtend(Op op, List<OpExtend> assignments) {
        while (op instanceof OpExtend) {
            OpExtend opExtend = (OpExtend)op;
            assignments.add(opExtend);
            op = opExtend.getSubOp();
        }
        return op;
    }

    private static OpGroup getGroup(Op op) {
        while (true) {
            if (op instanceof OpGroup) {
                return (OpGroup)op;
            }
            if (op instanceof OpFilter) {
                OpFilter opFilter = (OpFilter)op;
                op = opFilter.getSubOp();
                continue;
            }
            if (!(op instanceof OpExtend)) break;
            OpExtend opExtend = (OpExtend)op;
            op = opExtend.getSubOp();
        }
        return null;
    }

    public static Query asQuery(Op op) {
        Converter converter = new Converter(op);
        return converter.convert();
    }

    public static class Converter
    implements OpVisitor {
        private Query query = null;
        private Op queryOp;
        private Element element = null;
        private ElementGroup currentGroup = null;
        private Deque<ElementGroup> stack = new ArrayDeque<ElementGroup>();
        private boolean hasRun = false;

        public Converter(Op op) {
            this.queryOp = op;
            this.currentGroup = new ElementGroup();
        }

        Query convert() {
            if (!this.hasRun) {
                try {
                    this.query = this.convertInner();
                }
                finally {
                    this.hasRun = true;
                }
            }
            return this.query;
        }

        Query convertInner() {
            this.query = QueryFactory.create();
            if (this.queryOp instanceof OpExtend) {
                ArrayList<OpExtend> assignments = new ArrayList<OpExtend>();
                Op op = OpAsQuery.processExtend(this.queryOp, assignments);
                this.processQueryPattern(op, assignments);
                this.query.setQueryResultStar(true);
                this.query.setResultVars();
                return this.query;
            }
            QueryLevelDetails level = QueryLevelDetails.analyse(this.queryOp);
            this.processQueryPattern(level);
            final HashMap aggVarExprMap = new HashMap();
            if (level.opGroup != null) {
                this.query.getGroupBy().addAll(level.opGroup.getGroupVars());
                level.opGroup.getAggregators().forEach(eAgg -> {
                    ExprVar v = eAgg.getAggVar();
                    Aggregator agg = eAgg.getAggregator();
                    aggVarExprMap.put(v, eAgg);
                });
                this.query.getAggregators().addAll(level.opGroup.getAggregators());
            }
            ExprTransformCopy varToExpr = new ExprTransformCopy(){

                @Override
                public Expr transform(ExprVar nv) {
                    if (aggVarExprMap.containsKey(nv)) {
                        return (Expr)aggVarExprMap.get(nv);
                    }
                    return nv;
                }
            };
            HashMap assignments = new HashMap();
            if (level.opExtends != null) {
                Converter.processExtends(level.opExtends, (var, expr) -> {
                    expr = Converter.rewrite(expr, varToExpr);
                    assignments.put(var, expr);
                });
            }
            if (level.opHaving != null) {
                level.opHaving.getExprs().getList().forEach(expr -> {
                    expr = Converter.rewrite(expr, varToExpr);
                    this.query.getHavingExprs().add((Expr)expr);
                });
            }
            if (level.opOrder != null) {
                level.opOrder.getConditions().forEach(sc -> {
                    Expr expr = sc.getExpression();
                    if ((expr = Converter.rewrite(expr, varToExpr)) == sc.getExpression()) {
                        this.query.addOrderBy((SortCondition)sc);
                    } else {
                        this.query.addOrderBy(new SortCondition(expr, sc.getDirection()));
                    }
                });
            }
            if (level.opProject != null) {
                level.opProject.getVars().forEach(v -> {
                    if (assignments.containsKey(v)) {
                        this.query.addResultVar((Node)v, (Expr)assignments.get(v));
                    } else {
                        this.query.getProjectVars().add((Var)v);
                    }
                });
            } else {
                this.query.setQueryResultStar(true);
            }
            if (level.opDistinct != null) {
                this.query.setDistinct(true);
            }
            if (level.opReduced != null) {
                this.query.setReduced(true);
            }
            if (level.opSlice != null) {
                this.query.setOffset(level.opSlice.getStart());
                this.query.setLimit(level.opSlice.getLength());
            }
            this.query.setResultVars();
            return this.query;
        }

        private static void processExtends(List<OpExtend> ext, BiConsumer<Var, Expr> action) {
            ext.forEach(extend -> extend.getVarExprList().forEachExpr(action));
        }

        private static void processAssigns(List<OpAssign> assigns, BiConsumer<Var, Expr> action) {
            assigns.forEach(assign2 -> assign2.getVarExprList().forEachExpr(action));
        }

        private static Expr rewrite(Expr expr, ExprTransform transform) {
            return ExprTransformer.transform(transform, expr);
        }

        private void processQueryPattern(QueryLevelDetails level) {
            Op op = level.pattern;
            op.visit(this);
            ElementGroup eg = this.currentGroup;
            Element e2 = this.fixupGroupsOfOne(eg);
            this.query.setQueryPattern(e2);
            this.query.setQuerySelectType();
        }

        private void processQueryPattern(Op op, List<OpExtend> assignments) {
            op.visit(this);
            ElementGroup eg = this.currentGroup;
            Converter.processExtends(assignments, (v, e2) -> eg.addElement(new ElementBind((Var)v, (Expr)e2)));
            Element e3 = this.fixupGroupsOfOne(eg);
            this.query.setQueryPattern(e3);
            this.query.setQuerySelectType();
        }

        private Element fixupGroupsOfOne(ElementGroup eg) {
            ElementTransformCleanGroupsOfOne transform = new ElementTransformCleanGroupsOfOne();
            ExprTransformApplyElementTransform exprTransform = new ExprTransformApplyElementTransform(transform);
            Element el2 = ElementTransformer.transform(eg, transform, exprTransform);
            if (!(el2 instanceof ElementGroup) && !(el2 instanceof ElementSubQuery)) {
                ElementGroup eg2 = new ElementGroup();
                eg2.addElement(el2);
                el2 = eg2;
            }
            return el2;
        }

        private Element asElement(Op op) {
            ElementGroup g = this.asElementGroup(op);
            if (g.size() == 1) {
                return g.get(0);
            }
            return g;
        }

        private ElementGroup asElementGroup(Op op) {
            this.startSubGroup();
            op.visit(this);
            return this.endSubGroup();
        }

        @Override
        public void visit(OpBGP opBGP) {
            this.currentGroup().addElement(this.process(opBGP.getPattern()));
        }

        @Override
        public void visit(OpTriple opTriple) {
            this.currentGroup().addElement(this.process(opTriple.getTriple()));
        }

        @Override
        public void visit(OpQuad opQuad) {
            throw new ARQNotImplemented("OpQuad");
        }

        @Override
        public void visit(OpProcedure opProcedure) {
            throw new ARQNotImplemented("OpProcedure");
        }

        @Override
        public void visit(OpPropFunc opPropFunc) {
            Node s = this.processPropFuncArg(opPropFunc.getSubjectArgs());
            Node o = this.processPropFuncArg(opPropFunc.getObjectArgs());
            Triple t = new Triple(s, opPropFunc.getProperty(), o);
            this.currentGroup().addElement(this.process(t));
        }

        private Node processPropFuncArg(PropFuncArg args) {
            if (args.isNode()) {
                return args.getArg();
            }
            List<Node> list = args.getArgList();
            if (list.size() == 0) {
                return RDF.Nodes.nil;
            }
            BasicPattern bgp = new BasicPattern();
            Node head = GraphList.listToTriples(list, bgp);
            this.currentGroup().addElement(this.process(bgp));
            return head;
        }

        @Override
        public void visit(OpSequence opSequence) {
            boolean nestGroup;
            ElementGroup g = this.currentGroup();
            boolean bl = nestGroup = !g.isEmpty();
            if (nestGroup) {
                this.startSubGroup();
                g = this.currentGroup();
            }
            for (Op op : opSequence.getElements()) {
                Element e2 = this.asElement(op);
                Converter.insertIntoGroup(g, e2);
            }
            if (nestGroup) {
                this.endSubGroup();
            }
        }

        @Override
        public void visit(OpDisjunction opDisjunction) {
            throw new ARQNotImplemented("OpDisjunction");
        }

        private Element process(BasicPattern pattern) {
            if (this.query.getSyntax() == Syntax.syntaxSPARQL_10) {
                ElementTriplesBlock e2 = new ElementTriplesBlock();
                for (Triple t : pattern) {
                    e2.addTriple(t);
                }
                return e2;
            }
            if (this.query.getSyntax() == Syntax.syntaxSPARQL_11 || this.query.getSyntax() == Syntax.syntaxARQ) {
                ElementPathBlock e3 = new ElementPathBlock();
                for (Triple t : pattern) {
                    e3.addTriple(t);
                }
                return e3;
            }
            throw new ARQInternalErrorException("Unrecognized syntax: " + this.query.getSyntax());
        }

        private ElementTriplesBlock process(Triple triple) {
            ElementTriplesBlock e2 = new ElementTriplesBlock();
            e2.addTriple(triple);
            return e2;
        }

        @Override
        public void visit(OpQuadPattern quadPattern) {
            Node graphNode = quadPattern.getGraphNode();
            if (graphNode.equals(Quad.defaultGraphNodeGenerated)) {
                this.currentGroup().addElement(this.process(quadPattern.getBasicPattern()));
            } else {
                this.startSubGroup();
                Element e2 = this.asElement(new OpBGP(quadPattern.getBasicPattern()));
                this.endSubGroup();
                if (!(e2 instanceof ElementGroup)) {
                    ElementGroup g = new ElementGroup();
                    g.addElement(e2);
                    e2 = g;
                }
                ElementNamedGraph graphElt = new ElementNamedGraph(graphNode, e2);
                this.currentGroup().addElement(graphElt);
            }
        }

        @Override
        public void visit(OpQuadBlock quadBlock) {
            throw new NotImplemented("OpQuadBlock");
        }

        @Override
        public void visit(OpPath opPath) {
            ElementPathBlock epb = new ElementPathBlock();
            epb.addTriplePath(opPath.getTriplePath());
            ElementGroup g = this.currentGroup();
            g.addElement(epb);
        }

        @Override
        public void visit(OpJoin opJoin) {
            ElementGroup eRightGroup;
            Element eLeft = this.asElement(opJoin.getLeft());
            Element eRight = eRightGroup = this.asElementGroup(opJoin.getRight());
            if (eRightGroup.size() == 1 && eRightGroup.get(0) instanceof ElementSubQuery) {
                eRight = eRightGroup.get(0);
            }
            ElementGroup g = this.currentGroup();
            Converter.insertIntoGroup(g, eLeft);
            Converter.insertIntoGroup(g, eRight);
        }

        @Override
        public void visit(OpLeftJoin opLeftJoin) {
            Element eLeft = this.asElement(opLeftJoin.getLeft());
            Object eRight = this.asElementGroup(opLeftJoin.getRight());
            boolean mustProtect = ((ElementGroup)eRight).getElements().stream().anyMatch(el -> el instanceof ElementFilter);
            if (mustProtect) {
                ElementGroup eRight2 = new ElementGroup();
                eRight2.addElement((Element)eRight);
                eRight = eRight2;
            }
            if (opLeftJoin.getExprs() != null) {
                for (Expr expr : opLeftJoin.getExprs()) {
                    ElementFilter f = new ElementFilter(expr);
                    ((ElementGroup)eRight).addElement(f);
                }
            }
            ElementGroup g = this.currentGroup();
            if (!Converter.emptyGroup(eLeft)) {
                if (eLeft instanceof ElementGroup) {
                    g.getElements().addAll(((ElementGroup)eLeft).getElements());
                } else {
                    g.addElement(eLeft);
                }
            }
            ElementOptional opt = new ElementOptional((Element)eRight);
            g.addElement(opt);
        }

        @Override
        public void visit(OpDiff opDiff) {
            throw new ARQNotImplemented("OpDiff");
        }

        @Override
        public void visit(OpMinus opMinus) {
            Element eLeft = this.asElement(opMinus.getLeft());
            ElementGroup eRight = this.asElementGroup(opMinus.getRight());
            ElementMinus elMinus = new ElementMinus(eRight);
            ElementGroup g = this.currentGroup();
            if (!Converter.emptyGroup(eLeft)) {
                g.addElement(eLeft);
            }
            g.addElement(elMinus);
        }

        @Override
        public void visit(OpUnion opUnion) {
            ElementGroup eLeft = this.asElementGroup(opUnion.getLeft());
            ElementGroup eRight = this.asElementGroup(opUnion.getRight());
            if (eLeft instanceof ElementUnion) {
                ElementUnion elUnion = (ElementUnion)((Object)eLeft);
                elUnion.addElement(eRight);
                return;
            }
            ElementUnion elUnion = new ElementUnion();
            elUnion.addElement(eLeft);
            elUnion.addElement(eRight);
            this.currentGroup().addElement(elUnion);
        }

        @Override
        public void visit(OpConditional opCondition) {
            throw new ARQNotImplemented("OpCondition");
        }

        @Override
        public void visit(OpFilter opFilter) {
            Element e2 = this.asElement(opFilter.getSubOp());
            if (this.currentGroup() != e2) {
                this.currentGroup().addElement(e2);
            }
            this.element = this.currentGroup();
            ExprList exprs = opFilter.getExprs();
            for (Expr expr : exprs) {
                ElementFilter f = new ElementFilter(expr);
                this.currentGroup().addElement(f);
            }
        }

        @Override
        public void visit(OpGraph opGraph) {
            this.startSubGroup();
            Element e2 = this.asElement(opGraph.getSubOp());
            this.endSubGroup();
            if (!(e2 instanceof ElementGroup)) {
                ElementGroup g = new ElementGroup();
                g.addElement(e2);
                e2 = g;
            }
            ElementNamedGraph graphElt = new ElementNamedGraph(opGraph.getNode(), e2);
            this.currentGroup().addElement(graphElt);
        }

        @Override
        public void visit(OpService opService) {
            Op op = opService.getSubOp();
            Element x = this.asElement(opService.getSubOp());
            ElementService elt = new ElementService(opService.getService(), x, opService.getSilent());
            this.currentGroup().addElement(elt);
        }

        @Override
        public void visit(OpDatasetNames dsNames) {
            throw new ARQNotImplemented("OpDatasetNames");
        }

        @Override
        public void visit(OpTable opTable) {
            if (opTable.isJoinIdentity()) {
                return;
            }
            ElementData el = new ElementData();
            el.getVars().addAll(opTable.getTable().getVars());
            QueryIterator qIter = opTable.getTable().iterator(null);
            while (qIter.hasNext()) {
                el.getRows().add((Binding)qIter.next());
            }
            qIter.close();
            this.currentGroup().addElement(el);
        }

        @Override
        public void visit(OpExt opExt) {
            throw new ARQNotImplemented("OpExt");
        }

        @Override
        public void visit(OpNull opNull) {
            throw new ARQNotImplemented("OpNull");
        }

        @Override
        public void visit(OpLabel opLabel) {
            if (opLabel.hasSubOp()) {
                opLabel.getSubOp().visit(this);
            }
        }

        @Override
        public void visit(OpAssign opAssign) {
            Element e2 = this.asElement(opAssign.getSubOp());
            Converter.insertIntoGroup(this.currentGroup(), e2);
            Converter.processAssigns(Arrays.asList(opAssign), (var, expr) -> this.currentGroup().addElement(new ElementAssign((Var)var, (Expr)expr)));
        }

        @Override
        public void visit(OpExtend opExtend) {
            Element e2 = this.asElement(opExtend.getSubOp());
            Converter.insertIntoGroup(this.currentGroup(), e2);
            Converter.processExtends(Arrays.asList(opExtend), (var, expr) -> this.currentGroup().addElement(new ElementBind((Var)var, (Expr)expr)));
        }

        @Override
        public void visit(OpList opList) {
            opList.getSubOp().visit(this);
        }

        private void newLevel(Op op) {
            this.convertAsSubQuery(op);
        }

        private void convertAsSubQuery(Op op) {
            Converter subConverter = new Converter(op);
            ElementSubQuery subQuery = new ElementSubQuery(subConverter.convert());
            ElementGroup g = this.currentGroup();
            g.addElement(subQuery);
        }

        @Override
        public void visit(OpOrder opOrder) {
            this.newLevel(opOrder);
        }

        @Override
        public void visit(OpProject opProject) {
            this.newLevel(opProject);
        }

        @Override
        public void visit(OpReduced opReduced) {
            this.newLevel(opReduced);
        }

        @Override
        public void visit(OpDistinct opDistinct) {
            this.newLevel(opDistinct);
        }

        @Override
        public void visit(OpSlice opSlice) {
            this.newLevel(opSlice);
        }

        @Override
        public void visit(OpGroup opGroup) {
            this.newLevel(opGroup);
        }

        @Override
        public void visit(OpTopN opTop) {
            throw new ARQNotImplemented("OpTopN");
        }

        private static boolean emptyGroup(Element element) {
            if (!(element instanceof ElementGroup)) {
                return false;
            }
            ElementGroup eg = (ElementGroup)element;
            return eg.isEmpty();
        }

        private static boolean groupOfOne(Element element) {
            if (!(element instanceof ElementGroup)) {
                return false;
            }
            ElementGroup eg = (ElementGroup)element;
            return eg.size() == 1;
        }

        private static void insertIntoGroup(ElementGroup eg, Element e2) {
            if (Converter.emptyGroup(e2) && eg.isEmpty()) {
                return;
            }
            if (eg.isEmpty()) {
                eg.addElement(e2);
                return;
            }
            Element eltTop = eg.getLast();
            if (!(eltTop instanceof ElementPathBlock)) {
                e2 = Converter.unwrapGroupOfOnePathBlock(e2);
                eg.addElement(e2);
                return;
            }
            if (!(e2 instanceof ElementPathBlock)) {
                eg.addElement(e2);
                return;
            }
            ElementPathBlock currentPathBlock = (ElementPathBlock)eltTop;
            ElementPathBlock newPathBlock = (ElementPathBlock)e2;
            currentPathBlock.getPattern().addAll(newPathBlock.getPattern());
        }

        private static Element unwrapGroupOfOnePathBlock(Element e2) {
            Element e22 = Converter.getElementOfGroupOfOne(e2);
            if (e22 != null) {
                return e22;
            }
            return e2;
        }

        private static Element getElementOfGroupOfOne(Element e2) {
            if (Converter.groupOfOne(e2)) {
                ElementGroup eg = (ElementGroup)e2;
                return eg.get(0);
            }
            return null;
        }

        private Element lastElement() {
            ElementGroup g = this.currentGroup;
            return g.getLast();
        }

        private void startSubGroup() {
            ElementGroup g;
            this.push(this.currentGroup);
            this.currentGroup = g = new ElementGroup();
        }

        private ElementGroup endSubGroup() {
            ElementGroup g = this.pop();
            ElementGroup r = this.currentGroup;
            this.currentGroup = g;
            return r;
        }

        private ElementGroup currentGroup() {
            return this.currentGroup;
        }

        private ElementGroup peek() {
            if (this.stack.size() == 0) {
                return null;
            }
            return this.stack.peek();
        }

        private ElementGroup pop() {
            return this.stack.pop();
        }

        private void push(ElementGroup el) {
            this.stack.push(el);
        }
    }

    static class QueryLevelDetails {
        OpSlice opSlice = null;
        OpDistinct opDistinct = null;
        OpReduced opReduced = null;
        OpProject opProject = null;
        OpOrder opOrder = null;
        OpFilter opHaving = null;
        List<OpExtend> opExtends = new ArrayList<OpExtend>();
        OpGroup opGroup = null;
        Op pattern = null;

        private QueryLevelDetails() {
        }

        void info() {
            if (this.opSlice != null) {
                System.out.printf("slice: (%d, %d)\n", this.opSlice.getStart(), this.opSlice.getLength());
            }
            if (this.opDistinct != null) {
                System.out.printf("distinct\n", new Object[0]);
            }
            if (this.opReduced != null) {
                System.out.printf("reduced\n", new Object[0]);
            }
            if (this.opProject != null) {
                System.out.printf("project: %s\n", this.opProject.getVars());
            }
            if (this.opOrder != null) {
                System.out.printf("order: %s\n", this.opOrder.getConditions());
            }
            if (this.opHaving != null) {
                System.out.printf("having: %s\n", this.opHaving.getExprs());
            }
            if (this.opExtends != null && !this.opExtends.isEmpty()) {
                List z = this.opExtends.stream().map(x -> x.getVarExprList()).collect(Collectors.toList());
                System.out.printf("assigns: %s\n", z);
            }
            if (this.opGroup != null) {
                List<ExprAggregator> aggregators = this.opGroup.getAggregators();
                List aggVars = aggregators.stream().map(x -> x.getAggVar().asVar()).collect(Collectors.toList());
                System.out.printf("group: %s |-| %s\n", this.opGroup.getGroupVars(), this.opGroup.getAggregators());
                System.out.printf("group agg vars: %s\n", aggVars);
            }
        }

        static QueryLevelDetails analyse(Op operation) {
            QueryLevelDetails details = new QueryLevelDetails();
            Op op = operation;
            if (op instanceof OpSlice) {
                details.opSlice = (OpSlice)op;
                op = details.opSlice.getSubOp();
            }
            if (op instanceof OpDistinct) {
                details.opDistinct = (OpDistinct)op;
                op = details.opDistinct.getSubOp();
            }
            if (op instanceof OpReduced) {
                details.opReduced = (OpReduced)op;
                op = details.opReduced.getSubOp();
            }
            if (op instanceof OpProject) {
                details.opProject = (OpProject)op;
                op = details.opProject.getSubOp();
            }
            if (op instanceof OpOrder) {
                details.opOrder = (OpOrder)op;
                op = details.opOrder.getSubOp();
            }
            details.opGroup = OpAsQuery.getGroup(op);
            if (details.opGroup == null) {
                details.pattern = op = OpAsQuery.processExtend(op, details.opExtends);
                return details;
            }
            details.pattern = details.opGroup.getSubOp();
            if (op instanceof OpFilter) {
                details.opHaving = (OpFilter)op;
                op = details.opHaving.getSubOp();
            }
            if (!((op = OpAsQuery.processExtend(op, details.opExtends)) instanceof OpGroup)) {
                System.out.println("Expected (group), got " + op.getName());
            }
            return details;
        }
    }
}

