/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.json.JsonObject;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.query.Query;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.resultset.ResultSetLang;
import org.apache.jena.riot.resultset.rw.ResultsWriter;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.ARQException;
import org.apache.jena.sparql.ARQNotImplemented;
import org.apache.jena.sparql.core.Prologue;
import org.apache.jena.sparql.resultset.RDFOutput;
import org.apache.jena.sparql.resultset.ResultsFormat;
import org.apache.jena.sparql.resultset.TextOutput;
import org.apache.jena.sparql.resultset.XMLOutput;
import org.apache.jena.sparql.serializer.SerializationContext;
import org.apache.jena.sys.JenaSystem;

public class ResultSetFormatter {
    private ResultSetFormatter() {
    }

    public static void out(ResultSet qresults) {
        ResultSetFormatter.out((OutputStream)System.out, qresults);
    }

    public static void out(OutputStream out, ResultSet qresults) {
        ResultSetFormatter.out(out, qresults, (PrefixMapping)null);
    }

    public static void out(ResultSet qresults, Query query) {
        ResultSetFormatter.out((OutputStream)System.out, qresults, query);
    }

    public static void out(ResultSet qresults, Prologue prologue) {
        ResultSetFormatter.out((OutputStream)System.out, qresults, prologue);
    }

    public static void out(ResultSet qresults, PrefixMapping pmap) {
        ResultSetFormatter.out((OutputStream)System.out, qresults, pmap);
    }

    public static void out(OutputStream out, ResultSet qresults, PrefixMapping pmap) {
        TextOutput tFmt = new TextOutput(pmap);
        tFmt.format(out, qresults);
    }

    public static void out(OutputStream out, ResultSet qresults, Prologue prologue) {
        TextOutput tFmt = new TextOutput(prologue);
        tFmt.format(out, qresults);
    }

    public static void out(boolean answer) {
        ResultSetFormatter.out((OutputStream)System.out, answer);
    }

    public static void out(OutputStream out, boolean answer) {
        TextOutput tFmt = new TextOutput((SerializationContext)null);
        tFmt.format(out, answer);
    }

    public static String asText(ResultSet qresults) {
        ByteArrayOutputStream arr = new ByteArrayOutputStream();
        ResultSetFormatter.out((OutputStream)arr, qresults);
        return new String(arr.toByteArray(), StandardCharsets.UTF_8);
    }

    public static String asText(ResultSet qresults, Prologue prologue) {
        ByteArrayOutputStream arr = new ByteArrayOutputStream();
        ResultSetFormatter.out((OutputStream)arr, qresults, prologue);
        try {
            return new String(arr.toByteArray(), "UTF-8");
        }
        catch (UnsupportedEncodingException e2) {
            Log.warn(ResultSetFormatter.class, "UnsupportedEncodingException");
            return null;
        }
    }

    public static int consume(ResultSet resultSet) {
        int count = 0;
        while (resultSet.hasNext()) {
            QuerySolution result = resultSet.nextSolution();
            ResultSetFormatter.materialize(result);
            ++count;
        }
        return count;
    }

    public static List<QuerySolution> toList(ResultSet resultSet) {
        ArrayList<QuerySolution> list = new ArrayList<QuerySolution>();
        while (resultSet.hasNext()) {
            QuerySolution result = resultSet.nextSolution();
            ResultSetFormatter.materialize(result);
            list.add(result);
        }
        return list;
    }

    private static void materialize(QuerySolution qs) {
        Iterator<String> iter = qs.varNames();
        while (iter.hasNext()) {
            String vn = iter.next();
            RDFNode rDFNode = qs.get(vn);
        }
    }

    public static void output(ResultSet resultSet, ResultsFormat rFmt) {
        ResultSetFormatter.output((OutputStream)System.out, resultSet, rFmt);
    }

    public static void output(OutputStream outStream, ResultSet resultSet, ResultsFormat rFmt) {
        Lang lang = ResultsFormat.convert(rFmt);
        if (lang != null) {
            ResultSetFormatter.output(outStream, resultSet, lang);
            return;
        }
        if (rFmt.equals(ResultsFormat.FMT_RDF_XML)) {
            RDFOutput.outputAsRDF(outStream, "RDF/XML-ABBREV", resultSet);
            return;
        }
        if (rFmt.equals(ResultsFormat.FMT_RDF_TTL)) {
            RDFOutput.outputAsRDF(outStream, "TTL", resultSet);
            return;
        }
        if (rFmt.equals(ResultsFormat.FMT_RDF_NT)) {
            RDFOutput.outputAsRDF(outStream, "N-TRIPLES", resultSet);
            return;
        }
        throw new ARQException("Unknown ResultSet format: " + rFmt);
    }

    public static void output(ResultSet resultSet, Lang resultFormat) {
        ResultSetFormatter.output((OutputStream)System.out, resultSet, resultFormat);
    }

    public static void output(OutputStream outStream, ResultSet resultSet, Lang resultFormat) {
        ResultsWriter.create().lang(resultFormat).write(outStream, resultSet);
    }

    public static void output(boolean result, Lang resultFormat) {
        ResultSetFormatter.output((OutputStream)System.out, result, resultFormat);
    }

    public static void output(OutputStream outStream, boolean result, Lang resultFormat) {
        ResultsWriter.create().lang(resultFormat).build().write(outStream, result);
    }

    public static void output(OutputStream outStream, Iterator<JsonObject> jsonItems) {
        IndentedWriter out = new IndentedWriter(outStream);
        out.println("[");
        out.incIndent();
        while (jsonItems.hasNext()) {
            JsonObject jsonItem = jsonItems.next();
            jsonItem.output(out);
            if (jsonItems.hasNext()) {
                out.println(" ,");
                continue;
            }
            out.println();
        }
        out.decIndent();
        out.println("]");
        out.flush();
    }

    public static void outputAsXML(ResultSet qresults) {
        ResultSetFormatter.outputAsXML((OutputStream)System.out, qresults);
    }

    public static void outputAsXML(OutputStream outStream, ResultSet qresults) {
        ResultSetFormatter.output(outStream, qresults, ResultSetLang.SPARQLResultSetXML);
    }

    public static void outputAsXML(ResultSet qresults, String stylesheet) {
        ResultSetFormatter.outputAsXML((OutputStream)System.out, qresults, stylesheet);
    }

    public static void outputAsXML(OutputStream outStream, ResultSet qresults, String stylesheet) {
        XMLOutput xOut = new XMLOutput(stylesheet);
        xOut.format(outStream, qresults);
    }

    public static void outputAsXML(boolean booleanResult) {
        ResultSetFormatter.outputAsXML((OutputStream)System.out, booleanResult);
    }

    public static void outputAsXML(OutputStream outStream, boolean booleanResult) {
        ResultSetFormatter.output(outStream, booleanResult, ResultSetLang.SPARQLResultSetXML);
    }

    public static void outputAsXML(boolean booleanResult, String stylesheet) {
        ResultSetFormatter.outputAsXML((OutputStream)System.out, booleanResult, stylesheet);
    }

    public static void outputAsXML(OutputStream outStream, boolean booleanResult, String stylesheet) {
        XMLOutput xOut = new XMLOutput(stylesheet);
        xOut.format(outStream, booleanResult);
    }

    public static String asXMLString(ResultSet qresults) {
        return ResultSetFormatter.asXMLString(qresults, null);
    }

    public static String asXMLString(ResultSet qresults, String stylesheet) {
        XMLOutput xOut = new XMLOutput(stylesheet);
        return xOut.asString(qresults);
    }

    public static String asXMLString(boolean booleanResult) {
        return ResultSetFormatter.asXMLString(booleanResult, null);
    }

    public static String asXMLString(boolean booleanResult, String stylesheet) {
        XMLOutput xOut = new XMLOutput(stylesheet);
        return xOut.asString(booleanResult);
    }

    public static void outputAsJSON(ResultSet resultSet) {
        ResultSetFormatter.outputAsJSON((OutputStream)System.out, resultSet);
    }

    public static void outputAsJSON(OutputStream outStream, ResultSet resultSet) {
        ResultSetFormatter.output(outStream, resultSet, ResultSetLang.SPARQLResultSetJSON);
    }

    public static void outputAsJSON(boolean booleanResult) {
        ResultSetFormatter.outputAsJSON((OutputStream)System.out, booleanResult);
    }

    public static void outputAsJSON(OutputStream outStream, boolean booleanResult) {
        ResultSetFormatter.output(outStream, booleanResult, ResultSetLang.SPARQLResultSetJSON);
    }

    public static void outputAsSSE(boolean booleanResult) {
        ResultSetFormatter.outputAsSSE((OutputStream)System.out, booleanResult);
    }

    public static void outputAsSSE(OutputStream outStream, boolean booleanResult) {
        throw new ARQNotImplemented("outputAsSSE");
    }

    public static void outputAsSSE(ResultSet resultSet) {
        ResultSetFormatter.outputAsSSE((OutputStream)System.out, resultSet);
    }

    public static void outputAsSSE(ResultSet resultSet, Prologue prologue) {
        ResultSetFormatter.outputAsSSE(System.out, resultSet, prologue);
    }

    public static void outputAsSSE(OutputStream outStream, ResultSet resultSet) {
        ResultSetFormatter.outputAsSSE(outStream, resultSet, null);
    }

    public static void outputAsSSE(OutputStream outStream, ResultSet resultSet, Prologue prologue) {
        throw new ARQNotImplemented("outputAsSSE");
    }

    public static void outputAsCSV(boolean booleanResult) {
        ResultSetFormatter.outputAsCSV((OutputStream)System.out, booleanResult);
    }

    public static void outputAsCSV(OutputStream outStream, boolean booleanResult) {
        ResultSetFormatter.output(outStream, booleanResult, ResultSetLang.SPARQLResultSetCSV);
    }

    public static void outputAsCSV(ResultSet resultSet) {
        ResultSetFormatter.outputAsCSV((OutputStream)System.out, resultSet);
    }

    public static void outputAsCSV(OutputStream outStream, ResultSet resultSet) {
        ResultSetFormatter.output(outStream, resultSet, ResultSetLang.SPARQLResultSetCSV);
    }

    public static void outputAsTSV(boolean booleanResult) {
        ResultSetFormatter.outputAsTSV((OutputStream)System.out, booleanResult);
    }

    public static void outputAsTSV(OutputStream outStream, boolean booleanResult) {
        ResultSetFormatter.output(outStream, booleanResult, ResultSetLang.SPARQLResultSetTSV);
    }

    public static void outputAsTSV(ResultSet resultSet) {
        ResultSetFormatter.outputAsTSV((OutputStream)System.out, resultSet);
    }

    public static void outputAsTSV(OutputStream outStream, ResultSet resultSet) {
        ResultSetFormatter.output(outStream, resultSet, ResultSetLang.SPARQLResultSetTSV);
    }

    static {
        JenaSystem.init();
    }
}

